/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.IgniteComputeImpl;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformBalancingMultiClosureTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformBalancingSingleClosureAffinityTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformBalancingSingleClosureTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformBroadcastingMultiClosureTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformBroadcastingSingleClosureTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformFullTask;
import org.apache.ignite.internal.processors.platform.compute.PlatformJob;
import org.apache.ignite.internal.processors.platform.utils.PlatformFutureUtils;
import org.apache.ignite.internal.processors.platform.utils.PlatformListenable;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;

public class PlatformCompute
extends PlatformAbstractTarget {
    private static final int OP_AFFINITY = 1;
    private static final int OP_BROADCAST = 2;
    private static final int OP_EXEC = 3;
    private static final int OP_EXEC_ASYNC = 4;
    private static final int OP_UNICAST = 5;
    private static final int OP_WITH_NO_FAILOVER = 6;
    private static final int OP_WITH_TIMEOUT = 7;
    private static final int OP_EXEC_NATIVE = 8;
    private final IgniteComputeImpl compute;
    private final IgniteComputeImpl computeForPlatform;

    public PlatformCompute(PlatformContext platformCtx, ClusterGroup grp, String platformAttr) {
        super(platformCtx);
        assert (grp != null);
        assert (platformAttr != null);
        this.compute = (IgniteComputeImpl)grp.ignite().compute(grp);
        ClusterGroup platformGrp = grp.forAttribute(platformAttr, platformCtx.platform());
        this.computeForPlatform = (IgniteComputeImpl)grp.ignite().compute(platformGrp);
    }

    @Override
    public PlatformTarget processInStreamOutObject(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 5: {
                return this.processClosures(reader.readLong(), reader, false, false);
            }
            case 2: {
                return this.processClosures(reader.readLong(), reader, true, false);
            }
            case 1: {
                return this.processClosures(reader.readLong(), reader, false, true);
            }
            case 8: {
                long taskPtr = reader.readLong();
                long topVer = reader.readLong();
                PlatformFullTask task = new PlatformFullTask(this.platformCtx, this.computeForPlatform, taskPtr, topVer);
                return this.executeNative0(task);
            }
            case 4: {
                return this.wrapListenable((PlatformListenable)this.executeJavaTask(reader, true));
            }
        }
        return super.processInStreamOutObject(type, reader);
    }

    @Override
    public long processInLongOutLong(int type, long val) throws IgniteCheckedException {
        switch (type) {
            case 7: {
                this.compute.withTimeout(val);
                this.computeForPlatform.withTimeout(val);
                return 1L;
            }
            case 6: {
                this.compute.withNoFailover();
                this.computeForPlatform.withNoFailover();
                return 1L;
            }
        }
        return super.processInLongOutLong(type, val);
    }

    private PlatformTarget processClosures(long taskPtr, BinaryRawReaderEx reader, boolean broadcast, boolean affinity) {
        PlatformAbstractTask task;
        int size = reader.readInt();
        if (size == 1) {
            if (broadcast) {
                PlatformBroadcastingSingleClosureTask task0 = new PlatformBroadcastingSingleClosureTask(this.platformCtx, taskPtr);
                task0.job(this.nextClosureJob(task0, reader));
                task = task0;
            } else if (affinity) {
                PlatformBalancingSingleClosureAffinityTask task0 = new PlatformBalancingSingleClosureAffinityTask(this.platformCtx, taskPtr);
                task0.job(this.nextClosureJob(task0, reader));
                task0.affinity(reader.readString(), reader.readObjectDetached(), this.platformCtx.kernalContext());
                task = task0;
            } else {
                PlatformBalancingSingleClosureTask task0 = new PlatformBalancingSingleClosureTask(this.platformCtx, taskPtr);
                task0.job(this.nextClosureJob(task0, reader));
                task = task0;
            }
        } else {
            task = broadcast ? new PlatformBroadcastingMultiClosureTask(this.platformCtx, taskPtr) : new PlatformBalancingMultiClosureTask(this.platformCtx, taskPtr);
            ArrayList<PlatformJob> jobs = new ArrayList<PlatformJob>(size);
            for (int i = 0; i < size; ++i) {
                jobs.add(this.nextClosureJob(task, reader));
            }
            if (broadcast) {
                ((PlatformBroadcastingMultiClosureTask)task).jobs(jobs);
            } else {
                ((PlatformBalancingMultiClosureTask)task).jobs(jobs);
            }
        }
        this.platformCtx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, this.computeForPlatform.clusterGroup().nodes());
        return this.executeNative0(task);
    }

    private PlatformJob nextClosureJob(PlatformAbstractTask task, BinaryRawReaderEx reader) {
        return this.platformCtx.createClosureJob(task, reader.readLong(), reader.readObjectDetached());
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                writer.writeObjectDetached(this.executeJavaTask(reader, false));
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    private PlatformTarget executeNative0(final PlatformAbstractTask task) {
        ComputeTaskInternalFuture<Void> fut = this.computeForPlatform.executeAsync0(task, null);
        fut.listen((IgniteInClosure<IgniteInternalFuture<Void>>)new IgniteInClosure<IgniteInternalFuture>(){
            private static final long serialVersionUID = 0L;

            @Override
            public void apply(IgniteInternalFuture fut) {
                try {
                    fut.get();
                    task.onDone(null);
                }
                catch (IgniteCheckedException e) {
                    task.onDone(e);
                }
            }
        });
        return this.wrapListenable(PlatformFutureUtils.getListenable(fut));
    }

    protected Object executeJavaTask(BinaryRawReaderEx reader, boolean async) throws IgniteCheckedException {
        String taskName = reader.readString();
        boolean keepBinary = reader.readBoolean();
        Object arg = reader.readObjectDetached();
        Collection<UUID> nodeIds = this.readNodeIds(reader);
        IgniteCompute compute0 = this.computeForTask(nodeIds);
        if (!keepBinary && arg instanceof BinaryObjectImpl) {
            arg = ((BinaryObject)arg).deserialize();
        }
        if (async) {
            return this.readAndListenFuture((BinaryRawReader)reader, new ComputeConvertingFuture(compute0.executeAsync(taskName, arg)));
        }
        return this.toBinary(compute0.execute(taskName, arg));
    }

    private Object toBinary(Object src) {
        return this.platformCtx.kernalContext().grid().binary().toBinary(src);
    }

    protected Collection<UUID> readNodeIds(BinaryRawReaderEx reader) {
        if (reader.readBoolean()) {
            int len = reader.readInt();
            ArrayList<UUID> res = new ArrayList<UUID>(len);
            for (int i = 0; i < len; ++i) {
                res.add(reader.readUuid());
            }
            return res;
        }
        return null;
    }

    protected IgniteCompute computeForTask(Collection<UUID> nodeIds) {
        return nodeIds == null ? this.compute : this.platformCtx.kernalContext().grid().compute(this.compute.clusterGroup().forNodeIds(nodeIds));
    }

    protected class ComputeConvertingFuture
    implements IgniteInternalFuture {
        private final IgniteInternalFuture fut;

        public ComputeConvertingFuture(ComputeTaskFuture fut) {
            this.fut = ((IgniteFutureImpl)((Object)fut)).internalFuture();
        }

        public Object get() throws IgniteCheckedException {
            return this.convertResult(this.fut.get());
        }

        public Object get(long timeout) throws IgniteCheckedException {
            return this.convertResult(this.fut.get(timeout));
        }

        public Object get(long timeout, TimeUnit unit) throws IgniteCheckedException {
            return this.convertResult(this.fut.get(timeout, unit));
        }

        public Object getUninterruptibly() throws IgniteCheckedException {
            return this.convertResult(this.fut.get());
        }

        @Override
        public boolean cancel() throws IgniteCheckedException {
            return this.fut.cancel();
        }

        @Override
        public boolean isDone() {
            return this.fut.isDone();
        }

        @Override
        public boolean isCancelled() {
            return this.fut.isCancelled();
        }

        public void listen(final IgniteInClosure lsnr) {
            this.fut.listen(new IgniteInClosure<IgniteInternalFuture>(){
                private static final long serialVersionUID = 0L;

                @Override
                public void apply(IgniteInternalFuture fut0) {
                    lsnr.apply(ComputeConvertingFuture.this);
                }
            });
        }

        public IgniteInternalFuture chain(IgniteClosure doneCb) {
            throw new UnsupportedOperationException("Chain operation is not supported.");
        }

        public IgniteInternalFuture chain(IgniteClosure doneCb, Executor exec) {
            throw new UnsupportedOperationException("Chain operation is not supported.");
        }

        @Override
        public Throwable error() {
            return this.fut.error();
        }

        public Object result() {
            return this.convertResult(this.fut.result());
        }

        protected Object convertResult(Object obj) {
            return PlatformCompute.this.toBinary(obj);
        }
    }
}

