/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcMetaColumnsRequest
extends JdbcRequest {
    private String schemaName;
    private String tblName;
    private String colName;

    JdbcMetaColumnsRequest() {
        super((byte)8);
    }

    public JdbcMetaColumnsRequest(String schemaName, String tblName, String colName) {
        super((byte)8);
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.colName = colName;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String columnName() {
        return this.colName;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        writer.writeString(this.colName);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        this.colName = reader.readString();
    }

    public String toString() {
        return S.toString(JdbcMetaColumnsRequest.class, this);
    }
}

