/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcBulkLoadAckResult
extends JdbcResult {
    private long qryId;
    private BulkLoadAckClientParameters params;

    public JdbcBulkLoadAckResult() {
        super((byte)16);
        this.qryId = 0L;
        this.params = null;
    }

    public JdbcBulkLoadAckResult(long qryId, BulkLoadAckClientParameters params) {
        super((byte)16);
        this.qryId = qryId;
        this.params = params;
    }

    public long queryId() {
        return this.qryId;
    }

    public BulkLoadAckClientParameters params() {
        return this.params;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        writer.writeLong(this.qryId);
        writer.writeString(this.params.localFileName());
        writer.writeInt(this.params.packetSize());
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        this.qryId = reader.readLong();
        String locFileName = reader.readString();
        int batchSize = reader.readInt();
        if (!BulkLoadAckClientParameters.isValidPacketSize(batchSize)) {
            throw new BinaryObjectException(BulkLoadAckClientParameters.packetSizeErrorMesssage(batchSize));
        }
        this.params = new BulkLoadAckClientParameters(locFileName, batchSize);
    }

    public String toString() {
        return S.toString(JdbcBulkLoadAckResult.class, this);
    }
}

