/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.igfs.mapreduce.IgfsTaskArgs;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgfsTaskArgsImpl<T>
implements IgfsTaskArgs<T>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private String igfsName;
    private Collection<IgfsPath> paths;
    private IgfsRecordResolver recRslvr;
    private boolean skipNonExistentFiles;
    private long maxRangeLen;
    private T usrArg;

    public IgfsTaskArgsImpl() {
    }

    public IgfsTaskArgsImpl(String igfsName, Collection<IgfsPath> paths, IgfsRecordResolver recRslvr, boolean skipNonExistentFiles, long maxRangeLen, T usrArg) {
        this.igfsName = igfsName;
        this.paths = paths;
        this.recRslvr = recRslvr;
        this.skipNonExistentFiles = skipNonExistentFiles;
        this.maxRangeLen = maxRangeLen;
        this.usrArg = usrArg;
    }

    @Override
    public String igfsName() {
        return this.igfsName;
    }

    @Override
    public Collection<IgfsPath> paths() {
        return this.paths;
    }

    @Override
    public IgfsRecordResolver recordResolver() {
        return this.recRslvr;
    }

    @Override
    public boolean skipNonExistentFiles() {
        return this.skipNonExistentFiles;
    }

    @Override
    public long maxRangeLength() {
        return this.maxRangeLen;
    }

    @Override
    public T userArgument() {
        return this.usrArg;
    }

    public String toString() {
        return S.toString(IgfsTaskArgsImpl.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.igfsName);
        U.writeCollection(out, this.paths);
        out.writeObject(this.recRslvr);
        out.writeBoolean(this.skipNonExistentFiles);
        out.writeLong(this.maxRangeLen);
        out.writeObject(this.usrArg);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.igfsName = U.readString(in);
        this.paths = U.readCollection(in);
        this.recRslvr = (IgfsRecordResolver)in.readObject();
        this.skipNonExistentFiles = in.readBoolean();
        this.maxRangeLen = in.readLong();
        this.usrArg = in.readObject();
    }
}

