/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointWriteProgressSupplier;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottlePolicy;

public class PagesWriteThrottle
implements PagesWriteThrottlePolicy {
    private final PageMemoryImpl pageMemory;
    private final CheckpointWriteProgressSupplier cpProgress;
    private final boolean throttleOnlyPagesInCheckpoint;
    private CheckpointLockStateChecker stateChecker;
    private static final long STARTING_THROTTLE_NANOS = 4000L;
    private static final double BACKOFF_RATIO = 1.05;
    private final AtomicInteger notInCheckpointBackoffCntr = new AtomicInteger(0);
    private final AtomicInteger inCheckpointBackoffCntr = new AtomicInteger(0);

    public PagesWriteThrottle(PageMemoryImpl pageMemory, CheckpointWriteProgressSupplier cpProgress, CheckpointLockStateChecker stateChecker, boolean throttleOnlyPagesInCheckpoint) {
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.stateChecker = stateChecker;
        this.throttleOnlyPagesInCheckpoint = throttleOnlyPagesInCheckpoint;
        if (!throttleOnlyPagesInCheckpoint) assert (cpProgress != null) : "cpProgress must be not null if ratio based throttling mode is used";
    }

    @Override
    public void onMarkDirty(boolean isPageInCheckpoint) {
        AtomicInteger cntr;
        assert (this.stateChecker.checkpointLockIsHeldByThread());
        boolean shouldThrottle = false;
        if (isPageInCheckpoint) {
            int checkpointBufLimit = this.pageMemory.checkpointBufferPagesSize() * 2 / 3;
            boolean bl = shouldThrottle = this.pageMemory.checkpointBufferPagesCount() > checkpointBufLimit;
        }
        if (!shouldThrottle && !this.throttleOnlyPagesInCheckpoint) {
            int cpTotalPages;
            AtomicInteger writtenPagesCntr = this.cpProgress.writtenPagesCounter();
            if (writtenPagesCntr == null) {
                return;
            }
            int cpWrittenPages = writtenPagesCntr.get();
            if (cpWrittenPages == (cpTotalPages = this.cpProgress.currentCheckpointPagesCount())) {
                shouldThrottle = this.pageMemory.shouldThrottle(0.75);
            } else {
                double dirtyRatioThreshold = (double)cpWrittenPages / (double)cpTotalPages;
                dirtyRatioThreshold = (dirtyRatioThreshold * 0.95 + 0.05) * 7.0 / 12.0;
                shouldThrottle = this.pageMemory.shouldThrottle(dirtyRatioThreshold);
            }
        }
        AtomicInteger atomicInteger = cntr = isPageInCheckpoint ? this.inCheckpointBackoffCntr : this.notInCheckpointBackoffCntr;
        if (shouldThrottle) {
            int throttleLevel = cntr.getAndIncrement();
            LockSupport.parkNanos((long)(4000.0 * Math.pow(1.05, throttleLevel)));
        } else {
            cntr.set(0);
        }
    }

    @Override
    public void onBeginCheckpoint() {
    }

    @Override
    public void onFinishCheckpoint() {
        this.inCheckpointBackoffCntr.set(0);
        this.notInCheckpointBackoffCntr.set(0);
    }
}

