/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class AsyncFileIO
implements FileIO {
    private final AsynchronousFileChannel ch;
    private volatile long position;
    private final ThreadLocal<ChannelOpFuture> holder;
    private GridConcurrentHashSet<ChannelOpFuture> asyncFuts = new GridConcurrentHashSet();

    public AsyncFileIO(File file, ThreadLocal<ChannelOpFuture> holder, OpenOption ... modes) throws IOException {
        this.ch = AsynchronousFileChannel.open(file.toPath(), modes);
        this.holder = holder;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.position = newPosition;
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.read(destBuf, this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.read(destBuf, position, null, fut);
        try {
            int n = (Integer)fut.getUninterruptibly();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
        finally {
            this.asyncFuts.remove(fut);
        }
    }

    @Override
    public int read(byte[] buf, int off, int length) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.read(ByteBuffer.wrap(buf, off, length), this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.write(srcBuf, this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.asyncFuts.add(fut);
        this.ch.write(srcBuf, position, null, fut);
        try {
            int n = (Integer)fut.getUninterruptibly();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
        finally {
            this.asyncFuts.remove(fut);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.write(ByteBuffer.wrap(buf, off, len), this.position, this, fut);
        try {
            fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MappedByteBuffer map(int maxWalSegmentSize) throws IOException {
        throw new UnsupportedOperationException("AsynchronousFileChannel doesn't support mmap.");
    }

    @Override
    public void force() throws IOException {
        this.ch.force(false);
    }

    @Override
    public long size() throws IOException {
        return this.ch.size();
    }

    @Override
    public void clear() throws IOException {
        this.ch.truncate(0L);
        this.position = 0L;
    }

    @Override
    public void close() throws IOException {
        for (ChannelOpFuture asyncFut : this.asyncFuts) {
            try {
                asyncFut.getUninterruptibly();
            }
            catch (IgniteCheckedException e) {
                throw new IOException(e);
            }
        }
        this.ch.close();
    }

    static class ChannelOpFuture
    extends GridFutureAdapter<Integer>
    implements CompletionHandler<Integer, AsyncFileIO> {
        ChannelOpFuture() {
        }

        @Override
        public void completed(Integer res, AsyncFileIO attach) {
            if (attach != null && res != -1) {
                AsyncFileIO asyncFileIO = attach;
                asyncFileIO.position = asyncFileIO.position + (long)res.intValue();
            }
            super.onDone(res, null);
        }

        @Override
        public void failed(Throwable exc, AsyncFileIO attach) {
            super.onDone(exc);
        }
    }
}

