/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import org.apache.ignite.binary.BinaryObjectException;

final class MetadataUpdateResult {
    private final ResultType resType;
    private final BinaryObjectException error;

    private MetadataUpdateResult(ResultType resType, BinaryObjectException error) {
        this.resType = resType;
        this.error = error;
    }

    boolean rejected() {
        return this.resType == ResultType.REJECT;
    }

    BinaryObjectException error() {
        return this.error;
    }

    static MetadataUpdateResult createSuccessfulResult() {
        return new MetadataUpdateResult(ResultType.SUCCESS, null);
    }

    static MetadataUpdateResult createFailureResult(BinaryObjectException err) {
        assert (err != null);
        return new MetadataUpdateResult(ResultType.REJECT, err);
    }

    static MetadataUpdateResult createUpdateDisabledResult() {
        return new MetadataUpdateResult(ResultType.UPDATE_DISABLED, null);
    }

    private static enum ResultType {
        SUCCESS,
        REJECT,
        UPDATE_DISABLED;

    }
}

