/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;

public class LazyDataEntry
extends DataEntry {
    private GridCacheSharedContext cctx;
    private byte keyType;
    private byte[] keyBytes;
    private byte valType;
    private byte[] valBytes;

    public LazyDataEntry(GridCacheSharedContext cctx, int cacheId, byte keyType, byte[] keyBytes, byte valType, byte[] valBytes, GridCacheOperation op, GridCacheVersion nearXidVer, GridCacheVersion writeVer, long expireTime, int partId, long partCnt) {
        super(cacheId, null, null, op, nearXidVer, writeVer, expireTime, partId, partCnt);
        this.cctx = cctx;
        this.keyType = keyType;
        this.keyBytes = keyBytes;
        this.valType = valType;
        this.valBytes = valBytes;
    }

    @Override
    public KeyCacheObject key() {
        try {
            if (this.key == null) {
                GridCacheContext cacheCtx = this.cctx.cacheContext(this.cacheId);
                if (cacheCtx == null) {
                    throw new IgniteException("Failed to find cache context for the given cache ID: " + this.cacheId);
                }
                IgniteCacheObjectProcessor co = this.cctx.kernalContext().cacheObjects();
                this.key = co.toKeyCacheObject(cacheCtx.cacheObjectContext(), this.keyType, this.keyBytes);
            }
            return this.key;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public CacheObject value() {
        if (this.val == null && this.valBytes != null) {
            GridCacheContext cacheCtx = this.cctx.cacheContext(this.cacheId);
            if (cacheCtx == null) {
                throw new IgniteException("Failed to find cache context for the given cache ID: " + this.cacheId);
            }
            IgniteCacheObjectProcessor co = this.cctx.kernalContext().cacheObjects();
            this.val = co.toCacheObject(cacheCtx.cacheObjectContext(), this.valType, this.valBytes);
        }
        return this.val;
    }

    public byte getKeyType() {
        return this.keyType;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public byte getValType() {
        return this.valType;
    }

    public byte[] getValBytes() {
        return this.valBytes;
    }
}

