/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryAbstractLazyValue;
import org.apache.ignite.internal.binary.builder.BinaryBuilderEnum;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;
import org.apache.ignite.internal.util.typedef.internal.U;

class BinaryEnumArrayLazyValue
extends BinaryAbstractLazyValue {
    private final int len;
    private final int compTypeId;
    private final String clsName;

    protected BinaryEnumArrayLazyValue(BinaryBuilderReader reader) {
        super(reader, reader.position() - 1);
        int typeId = reader.readInt();
        if (typeId == 0) {
            Class<?> cls;
            this.clsName = reader.readString();
            try {
                cls = U.forName(reader.readString(), reader.binaryContext().configuration().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new BinaryInvalidTypeException("Failed to load the class: " + this.clsName, e);
            }
            this.compTypeId = reader.binaryContext().descriptorForClass(cls, true).typeId();
        } else {
            this.compTypeId = typeId;
            this.clsName = null;
        }
        int size = reader.readInt();
        for (int i = 0; i < size; ++i) {
            reader.skipValue();
        }
        this.len = reader.position() - this.valOff;
    }

    @Override
    protected Object init() {
        this.reader.position(this.valOff + 1);
        this.reader.readInt();
        int size = this.reader.readInt();
        BinaryBuilderEnum[] res = new BinaryBuilderEnum[size];
        for (int i = 0; i < size; ++i) {
            byte flag = this.reader.readByte();
            if (flag == 101) continue;
            if (flag != 28) {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
            res[i] = new BinaryBuilderEnum(this.reader);
        }
        return res;
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        if (this.val != null) {
            if (this.clsName != null) {
                ctx.writeArray(writer, (byte)29, (Object[])this.val, this.clsName);
            } else {
                ctx.writeArray(writer, (byte)29, (Object[])this.val, this.compTypeId);
            }
            return;
        }
        writer.write(this.reader.array(), this.valOff, this.len);
    }
}

