/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.mapreduce;

import java.io.EOFException;
import java.io.IOException;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.mapreduce.IgfsFileRange;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public final class IgfsRangeInputStream
extends IgfsInputStream {
    private final IgfsInputStream is;
    private final long start;
    private final long maxLen;
    private long pos;

    public IgfsRangeInputStream(IgfsInputStream is, long start, long maxLen) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (start < 0L) {
            throw new IllegalArgumentException("Start position cannot be negative.");
        }
        if (start >= is.length()) {
            throw new IllegalArgumentException("Start position cannot be greater that file length.");
        }
        if (maxLen < 0L) {
            throw new IllegalArgumentException("Length cannot be negative.");
        }
        if (start + maxLen > is.length()) {
            throw new IllegalArgumentException("Sum of start position and length cannot be greater than file length.");
        }
        this.is = is;
        this.start = start;
        this.maxLen = maxLen;
        is.seek(start);
    }

    @Override
    public long length() {
        return this.is.length();
    }

    public IgfsRangeInputStream(IgfsInputStream is, IgfsFileRange range) throws IOException {
        this(is, range.start(), range.length());
    }

    @Override
    public int read() throws IOException {
        if (this.pos < this.maxLen) {
            int res = this.is.read();
            if (res != -1) {
                ++this.pos;
            }
            return res;
        }
        return -1;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (this.pos < this.maxLen) {
            int res = this.is.read(b, off, len = (int)Math.min((long)len, this.maxLen - this.pos));
            if (res != -1) {
                this.pos += (long)res;
            }
            return res;
        }
        return -1;
    }

    @Override
    public int read(long pos, byte[] buf, int off, int len) throws IOException {
        this.seek(pos);
        return this.read(buf, off, len);
    }

    @Override
    public void readFully(long pos, byte[] buf) throws IOException {
        this.readFully(pos, buf, 0, buf.length);
    }

    @Override
    public void readFully(long pos, byte[] buf, int off, int len) throws IOException {
        int read;
        this.seek(pos);
        for (int readBytes = 0; readBytes < len; readBytes += read) {
            read = this.read(buf, off + readBytes, len - readBytes);
            if (read != -1) continue;
            throw new EOFException("Failed to read stream fully (stream ends unexpectedly) [pos=" + pos + ", buf.length=" + buf.length + ", off=" + off + ", len=" + len + ']');
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position cannot be negative: " + pos);
        }
        this.is.seek(this.start + pos);
        this.pos = pos;
    }

    @Override
    public long position() {
        return this.pos;
    }

    public long startOffset() {
        return this.start;
    }

    @Override
    public int available() {
        long l = this.maxLen - this.pos;
        if (l < 0L) {
            return 0;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public String toString() {
        return S.toString(IgfsRangeInputStream.class, this);
    }
}

