/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.alibaba.fastjson.JSONObject;
import com.sagacloud.extend.dao_data.ImplDao_fjd_0;
import com.sagacloud.extend.dao_data.ImplDao_fjd_near;
import com.sagacloud.extend.dao_data.ImplDao_ori;
import com.sagacloud.extend.dao_data.ImplDao_servicedata;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.DateUtil;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_fjd_near;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zillion.util.log.LogUtil;
import test.Check_servicedata;

public class Check_servicedata_Thread
extends Thread {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
    ZillionAgent agent;
    String database_name;

    public Check_servicedata_Thread(ZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
    }

    @Override
    public void run() {
        JSONObject item;
        ImplDao_ori dao_ori = new ImplDao_ori();
        dao_ori.Initialize((IZillionAgent)this.agent, this.database_name);
        ImplDao_fjd_0 dao_fjd_0 = new ImplDao_fjd_0();
        dao_fjd_0.Initialize((IZillionAgent)this.agent, this.database_name);
        ImplDao_fjd_near dao_fjd_near = new ImplDao_fjd_near();
        dao_fjd_near.Initialize((IZillionAgent)this.agent, this.database_name);
        ImplDao_servicedata dao_servicedata = new ImplDao_servicedata();
        dao_servicedata.Initialize((IZillionAgent)this.agent, this.database_name);
        while ((item = Check_servicedata.Pop()) != null) {
            try {
                this.meterdata(item, dao_ori, dao_fjd_0);
                this.servicedata(item, dao_fjd_near, dao_servicedata);
            }
            catch (Exception e) {
                LogUtil.error((Exception)e);
            }
        }
    }

    private void meterdata(JSONObject item, ImplDao_ori dao_ori, ImplDao_fjd_0 dao_fjd_0) throws Exception {
        String time_period = "15min";
        long interval = DateUtil.Instance().get_about(time_period);
        int seek_period_count = 2;
        Date timefrom = this.sdf.parse(Check_servicedata.time_from);
        Date timeto = this.sdf.parse(Check_servicedata.time_to);
        String building = (String)item.get((Object)"building");
        String meter = (String)item.get((Object)"meter");
        Long funcid = (Long)item.get((Object)"funcid");
        List<DoubleTimeObject> dataList_ori = dao_ori.GetDataListGteLte(item, time_period, DateUtil.Instance().GetDate_offset(timefrom, time_period, -seek_period_count), DateUtil.Instance().GetDate_offset(timeto, time_period, seek_period_count), true);
        List<DoubleTimeObject> dataList_fjd_0 = dao_fjd_0.GetDataListGteLte(item, time_period, timefrom, timeto, false);
        List<DoubleTimeObject> inputDataList = dataList_ori;
        int index_tmp = 0;
        ArrayList<DoubleTimeObject> outputDataList = new ArrayList<DoubleTimeObject>();
        Date tmpDate = timefrom;
        while (tmpDate.compareTo(timeto) < 0) {
            DoubleTimeObject data_best = null;
            DoubleTimeObject data_before = null;
            DoubleTimeObject data_after = null;
            for (int index_data = index_tmp; index_data < inputDataList.size(); ++index_data) {
                DoubleTimeObject data = inputDataList.get(index_data);
                if (data.data_time.getTime() == tmpDate.getTime()) {
                    index_tmp = index_data;
                    data_best = data;
                    break;
                }
                if (data.data_time.getTime() < tmpDate.getTime()) {
                    index_tmp = index_data;
                    if (tmpDate.getTime() - data.data_time.getTime() > interval * (long)seek_period_count) continue;
                    data_before = data;
                    continue;
                }
                if (data.data_time.getTime() - tmpDate.getTime() > interval * (long)seek_period_count) break;
                data_after = data;
                break;
            }
            if (data_best != null) {
                DoubleTimeObject outputData = new DoubleTimeObject();
                outputData.data_time = tmpDate;
                outputData.data_value = data_best.data_value;
                outputDataList.add(outputData);
            } else if (data_before != null && data_after != null) {
                double data_value = data_before.data_value + 1.0 * (double)(tmpDate.getTime() - data_before.data_time.getTime()) / (double)(data_after.data_time.getTime() - data_before.data_time.getTime()) * (data_after.data_value - data_before.data_value);
                DoubleTimeObject outputData = new DoubleTimeObject();
                outputData.data_time = tmpDate;
                outputData.data_value = data_value;
                outputDataList.add(outputData);
            }
            tmpDate = DateUtil.Instance().GetDate_offset(tmpDate, time_period, 1);
        }
        Date error_from = null;
        Date error_to = null;
        int index_des = 0;
        for (int index_out = 0; index_out < outputDataList.size(); ++index_out) {
            DoubleTimeObject outputData = (DoubleTimeObject)outputDataList.get(index_out);
            DoubleTimeObject fjd_0 = null;
            for (int i = index_des; i < dataList_fjd_0.size(); ++i) {
                index_des = i;
                DoubleTimeObject data = dataList_fjd_0.get(i);
                if (data.data_time.getTime() > outputData.data_time.getTime()) break;
                if (data.data_time.getTime() != outputData.data_time.getTime()) continue;
                fjd_0 = data;
                break;
            }
            if (fjd_0 != null) continue;
            if (error_from == null) {
                error_from = outputData.data_time;
            }
            error_to = outputData.data_time;
        }
        if (error_from != null) {
            Constant.warn(building + "\t" + meter + "\t" + funcid + "\tori!=meter\t" + this.sdf.format(error_from) + "\t" + this.sdf.format(error_to));
        }
    }

    private void servicedata(JSONObject item, ImplDao_fjd_near dao_fjd_near, ImplDao_servicedata dao_servicedata) throws Exception {
        boolean check_stat;
        String building = (String)item.get((Object)"building");
        String meter = (String)item.get((Object)"meter");
        Long funcid = (Long)item.get((Object)"funcid");
        List<DoubleTimeObject_fjd_near> dataList_fjd = dao_fjd_near.GetDataListGteLte_fjd_near(item, "15min", this.sdf.parse(Check_servicedata.time_from), this.sdf.parse(Check_servicedata.time_to), true);
        List<DoubleTimeObject> dataList_servicedata_15min = dao_servicedata.GetDataListGteLte(item, "15min", this.sdf.parse(Check_servicedata.time_from), this.sdf.parse(Check_servicedata.time_to), false);
        Date error_from = null;
        Date error_to = null;
        int index_des = 0;
        for (int index_fjd = 0; index_fjd < dataList_fjd.size() - 1; ++index_fjd) {
            DoubleTimeObject_fjd_near data = dataList_fjd.get(index_fjd);
            DoubleTimeObject_fjd_near data_next = dataList_fjd.get(index_fjd + 1);
            if (data_next.data_time.getTime() - data.data_time.getTime() != 900000L) continue;
            DoubleTimeObject data_servicedata = null;
            for (int i = index_des; i < dataList_servicedata_15min.size(); ++i) {
                index_des = i;
                DoubleTimeObject servicedata = dataList_servicedata_15min.get(i);
                if (servicedata.data_time.getTime() > data.data_time.getTime()) break;
                if (servicedata.data_time.getTime() != data.data_time.getTime()) continue;
                data_servicedata = servicedata;
                break;
            }
            if (data_servicedata != null) continue;
            if (error_from == null) {
                error_from = data.data_time;
            }
            error_to = data.data_time;
        }
        if (error_from != null) {
            Constant.warn(building + "\t" + meter + "\t" + funcid + "\tmeter!=service\t" + this.sdf.format(error_from) + "\t" + this.sdf.format(error_to));
        }
        if (check_stat = true) {
            List<DoubleTimeObject> dataList_servicedata_1h = dao_servicedata.GetDataListGteLte(item, "1h", this.sdf.parse(Check_servicedata.time_from), this.sdf.parse(Check_servicedata.time_to), false);
            List<DoubleTimeObject> dataList_servicedata_1d = dao_servicedata.GetDataListGteLte(item, "1d", this.sdf.parse(Check_servicedata.time_from), this.sdf.parse(Check_servicedata.time_to), false);
            if (dataList_servicedata_15min.size() > 0) {
                DoubleTimeObject data_first = dataList_servicedata_15min.get(0);
                DoubleTimeObject data_final = dataList_servicedata_15min.get(dataList_servicedata_15min.size() - 1);
                Date time_from_1h = DateUtil.Instance().get_floor(data_first.data_time, "1h");
                Date time_to_1h = DateUtil.Instance().get_floor(data_final.data_time, "1h");
                Date time_from_1d = DateUtil.Instance().get_floor(data_first.data_time, "1d");
                Date time_to_1d = DateUtil.Instance().get_floor(data_final.data_time, "1d");
                this.Match(building, meter, funcid, "1h", time_from_1h, time_to_1h, dataList_servicedata_15min, dataList_servicedata_1h);
                this.Match(building, meter, funcid, "1d", time_from_1d, time_to_1d, dataList_servicedata_15min, dataList_servicedata_1d);
            }
        }
    }

    private void Match(String building, String meter, Long funcid, String time_period, Date time_from, Date time_to, List<DoubleTimeObject> dataList_servicedata_src, List<DoubleTimeObject> dataList_servicedata_des) {
        long interval = DateUtil.Instance().get_about(time_period);
        Date error_from = null;
        Date error_to = null;
        int index_src = 0;
        int index_des = 0;
        Date time_tmp = time_from;
        while (time_tmp.getTime() <= time_to.getTime()) {
            Date time_tmp_next = new Date(time_tmp.getTime() + interval);
            ArrayList<DoubleTimeObject> dataList_tmp = new ArrayList<DoubleTimeObject>();
            for (int i = index_src; i < dataList_servicedata_src.size(); ++i) {
                index_src = i;
                DoubleTimeObject data = dataList_servicedata_src.get(i);
                if (data.data_time.getTime() >= time_tmp_next.getTime()) break;
                if (data.data_time.getTime() < time_tmp.getTime()) continue;
                dataList_tmp.add(data);
            }
            DoubleTimeObject data_des = null;
            for (int i = index_des; i < dataList_servicedata_des.size(); ++i) {
                index_des = i;
                DoubleTimeObject data = dataList_servicedata_des.get(i);
                if (data.data_time.getTime() > time_tmp.getTime()) break;
                if (data.data_time.getTime() != time_tmp.getTime()) continue;
                data_des = data;
                break;
            }
            if (dataList_tmp.size() > 0) {
                double sum = 0.0;
                for (DoubleTimeObject data : dataList_tmp) {
                    sum += data.data_value.doubleValue();
                }
                if (data_des == null || Math.abs(data_des.data_value - sum) >= 0.001) {
                    if (error_from == null) {
                        error_from = time_tmp;
                    }
                    error_to = time_tmp;
                }
            }
            time_tmp = time_tmp_next;
        }
        if (error_from != null) {
            Constant.warn(building + "\t" + meter + "\t" + funcid + "\t" + time_period + "\t" + this.sdf.format(error_from) + "\t" + this.sdf.format(error_to));
        }
    }
}

