/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.util.QueryLogUtil;
import com.zillion.database.agent.IZillionAgent;

public class QueryUtil {
    public static void ClearTable(IZillionAgent agent, String database_name, String table_name, boolean is_clear) throws Exception {
        JSONObject Criteria = new JSONObject();
        JSONObject wrapperObject = new JSONObject();
        if (is_clear) {
            wrapperObject.put("QueryType", (Object)"table_clear");
        } else {
            wrapperObject.put("QueryType", (Object)"delete");
        }
        wrapperObject.put("Criteria", (Object)Criteria);
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)table_name);
        agent.Query(wrapperObject);
    }

    public static void insert(IZillionAgent agent, String database_name, String table_name, JSONObject InsertObject) throws Exception {
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"insert");
        wrapperObject.put("InsertObject", (Object)InsertObject);
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)table_name);
        if (QueryLogUtil.loggerMap.containsKey(table_name)) {
            QueryLogUtil.loggerMap.get(table_name).info((Object)wrapperObject.toJSONString());
        }
        agent.Query(wrapperObject);
    }

    public static void batch_insert(IZillionAgent agent, String database_name, String table_name, JSONArray InsertObjects) throws Exception {
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"batch_insert");
        wrapperObject.put("InsertObjects", (Object)InsertObjects);
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)table_name);
        if (QueryLogUtil.loggerMap.containsKey(table_name)) {
            QueryLogUtil.loggerMap.get(table_name).info((Object)wrapperObject.toJSONString());
        }
        agent.Query(wrapperObject);
    }

    public static JSONArray select(IZillionAgent agent, String database_name, String table_name, JSONObject Criteria) throws Exception {
        JSONArray resultContent = QueryUtil.select(agent, database_name, table_name, Criteria, null, null);
        return resultContent;
    }

    public static JSONArray select(IZillionAgent agent, String database_name, String table_name, JSONObject Criteria, JSONArray OrderBy, JSONObject Limit) throws Exception {
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"select");
        wrapperObject.put("Criteria", (Object)Criteria);
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)table_name);
        if (OrderBy != null) {
            wrapperObject.put("OrderBy", (Object)OrderBy);
        }
        if (Limit != null) {
            wrapperObject.put("Limit", (Object)Limit);
        }
        JSONObject queryResult = agent.Query(wrapperObject);
        JSONArray resultContent = (JSONArray)queryResult.get((Object)"Content");
        return resultContent;
    }

    public static long delete(IZillionAgent agent, String database_name, String table_name, JSONObject Criteria) throws Exception {
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"delete");
        wrapperObject.put("Criteria", (Object)Criteria);
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)table_name);
        if (QueryLogUtil.loggerMap.containsKey(table_name)) {
            QueryLogUtil.loggerMap.get(table_name).info((Object)wrapperObject.toJSONString());
        }
        JSONObject queryResult = agent.Query(wrapperObject);
        Long Count = (Long)queryResult.get((Object)"Count");
        return Count;
    }

    public static void update(IZillionAgent agent, String database_name, String table_name, JSONObject Criteria, JSONObject Set2) throws Exception {
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"update");
        wrapperObject.put("Criteria", (Object)Criteria);
        wrapperObject.put("Set", (Object)Set2);
        wrapperObject.put("Database", (Object)database_name);
        wrapperObject.put("Datatable", (Object)table_name);
        if (QueryLogUtil.loggerMap.containsKey(table_name)) {
            QueryLogUtil.loggerMap.get(table_name).info((Object)wrapperObject.toJSONString());
        }
        agent.Query(wrapperObject);
    }

    public static boolean database_exist(IZillionAgent agent, String database_name) throws Exception {
        boolean result = false;
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"database_list");
        JSONObject queryResult = agent.Query(wrapperObject);
        JSONArray resultContent = (JSONArray)queryResult.get((Object)"Content");
        for (int i = 0; i < resultContent.size(); ++i) {
            String item = (String)resultContent.get(i);
            if (!item.equals(database_name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean table_exist(IZillionAgent agent, String database_name, String table_name) throws Exception {
        boolean result = false;
        JSONObject wrapperObject = new JSONObject();
        wrapperObject.put("QueryType", (Object)"table_list");
        wrapperObject.put("Database", (Object)database_name);
        JSONObject queryResult = agent.Query(wrapperObject);
        JSONArray resultContent = (JSONArray)queryResult.get((Object)"Content");
        for (int ii = 0; ii < resultContent.size(); ++ii) {
            String item = (String)resultContent.get(ii);
            if (!item.equals(table_name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static JSONObject OrderByItem(String Column, boolean Asc) {
        JSONObject result = new JSONObject();
        result.put("Column", (Object)Column);
        result.put("Asc", (Object)Asc);
        return result;
    }
}

