/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.util;

import com.sagacloud.util.compute_engine.util.StepSpan;
import com.sagacloud.util.compute_engine.util.TimeSpan;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtil {
    private static DateUtil instance = new DateUtil();

    public static DateUtil Instance() {
        return instance;
    }

    private DateUtil() {
    }

    public void ConvertAndMergeTo(List<TimeSpan> timeSpanList, StepSpan step_span, String time_period, String type, List<TimeSpan> result) {
        if (timeSpanList == null) {
            return;
        }
        if (step_span == null) {
            step_span = new StepSpan(0, 0);
        }
        for (TimeSpan timeSpan : timeSpanList) {
            TimeSpan timeSpanInner = this.Convert(timeSpan, time_period, type);
            if (timeSpanInner == null) continue;
            this.Merge(result, this.GetDate_offset(timeSpanInner.timefrom, time_period, -step_span.forward), this.GetDate_offset(timeSpanInner.timeto, time_period, -step_span.backward), time_period);
        }
    }

    public void ConvertAndMergeTo(List<TimeSpan> timeSpanList, String time_period, String type, List<TimeSpan> result) {
        if (timeSpanList == null) {
            return;
        }
        for (TimeSpan timeSpan : timeSpanList) {
            TimeSpan timeSpanInner = this.Convert(timeSpan, time_period, type);
            if (timeSpanInner == null) continue;
            this.Merge(result, timeSpanInner.timefrom, timeSpanInner.timeto, time_period);
        }
    }

    public TimeSpan Convert(TimeSpan timeSpan, String time_period, String type) {
        Date timeto;
        Date timefrom;
        if (type.equals("near")) {
            timefrom = this.get_ceiling(timeSpan.timefrom, time_period);
            timeto = this.get_floor(timeSpan.timeto, time_period);
        } else {
            timefrom = this.get_floor(timeSpan.timefrom, time_period);
            timeto = this.get_floor(timeSpan.timeto, time_period);
        }
        if (timefrom.compareTo(timeto) > 0) {
            return null;
        }
        return new TimeSpan(timefrom, timeto);
    }

    public int compare(String time_period_1, String time_period_2) {
        Long mill_1 = this.get_about(time_period_1);
        Long mill_2 = this.get_about(time_period_2);
        return mill_1.compareTo(mill_2);
    }

    public long get_about(String time_period) {
        long result = 0L;
        if (time_period.equals("1min")) {
            result = 60000L;
        } else if (time_period.equals("5min")) {
            result = 300000L;
        } else if (time_period.equals("10min")) {
            result = 600000L;
        } else if (time_period.equals("15min")) {
            result = 900000L;
        } else if (time_period.equals("1h")) {
            result = 3600000L;
        } else if (time_period.equals("1d")) {
            result = 86400000L;
        } else if (time_period.equals("1m")) {
            result = 2592000000L;
        } else if (time_period.equals("1y")) {
            result = 31536000000L;
        }
        return result;
    }

    public Date get_floor(Date time, String time_period) {
        Date result = null;
        if (time_period.equals("1min")) {
            long milliseconds_to = 60000L;
            result = new Date(time.getTime() / milliseconds_to * milliseconds_to);
        } else if (time_period.equals("5min")) {
            long milliseconds_to = 300000L;
            result = new Date(time.getTime() / milliseconds_to * milliseconds_to);
        } else if (time_period.equals("10min")) {
            long milliseconds_to = 600000L;
            result = new Date(time.getTime() / milliseconds_to * milliseconds_to);
        } else if (time_period.equals("15min")) {
            long milliseconds_to = 900000L;
            result = new Date(time.getTime() / milliseconds_to * milliseconds_to);
        } else if (time_period.equals("1h")) {
            long milliseconds_to = 3600000L;
            result = new Date(time.getTime() / milliseconds_to * milliseconds_to);
        } else if (time_period.equals("1d")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            result = calendar.getTime();
        } else if (time_period.equals("1m")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            result = calendar.getTime();
        } else if (time_period.equals("1y")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            result = calendar.getTime();
        }
        return result;
    }

    public Date get_ceiling(Date time, String time_period) {
        Date floor = this.get_floor(time, time_period);
        if (floor.compareTo(time) == 0) {
            return floor;
        }
        return this.GetDate_offset(floor, time_period, 1);
    }

    public void Limit(List<TimeSpan> timeSpanList, Date timefrom, Date timeto) {
        if (timeSpanList.size() == 0) {
            return;
        }
        int timefrom_index = 0;
        int timeto_index = 0;
        for (int i = 0; i < timeSpanList.size(); ++i) {
            TimeSpan timeSpanInner = timeSpanList.get(i);
            if (timefrom.compareTo(timeSpanInner.timeto) <= 0) {
                if (timefrom.compareTo(timeSpanInner.timefrom) >= 0) {
                    timefrom_index = i * 2 + 1;
                }
            } else {
                timefrom_index = i * 2 + 2;
            }
            if (timeto.compareTo(timeSpanInner.timeto) <= 0) {
                if (timeto.compareTo(timeSpanInner.timefrom) < 0) continue;
                timeto_index = i * 2 + 1;
                continue;
            }
            timeto_index = i * 2 + 2;
        }
        int index_del_left = timefrom_index / 2;
        for (int i = index_del_left - 1; i >= 0; --i) {
            timeSpanList.remove(i);
        }
        int index_del_right = (timeto_index + 1) / 2;
        for (int i = timeSpanList.size() - 1; i >= index_del_right; --i) {
            timeSpanList.remove(i);
        }
        if (timeSpanList.size() == 0) {
            return;
        }
        TimeSpan timeSpan_first = timeSpanList.get(0);
        TimeSpan timeSpan_last = timeSpanList.get(timeSpanList.size() - 1);
        if (timeSpan_first.timefrom.compareTo(timefrom) < 0) {
            timeSpan_first.timefrom = timefrom;
        }
        if (timeSpan_last.timeto.compareTo(timeto) > 0) {
            timeSpan_last.timeto = timeto;
        }
    }

    public void MergeTo(List<TimeSpan> timeSpanList, String time_period, StepSpan step_span, List<TimeSpan> result) {
        if (step_span == null) {
            step_span = new StepSpan(0, 0);
        }
        for (TimeSpan timeSpan : timeSpanList) {
            this.Merge(result, this.GetDate_offset(timeSpan.timefrom, time_period, step_span.backward), this.GetDate_offset(timeSpan.timeto, time_period, step_span.forward), time_period);
        }
    }

    public List<TimeSpan> Merge(List<TimeSpan> timeSpanList, Date timefrom, Date timeto, String time_period) {
        ArrayList<TimeSpan> result = new ArrayList<TimeSpan>();
        if (timeSpanList.size() == 0) {
            timeSpanList.add(new TimeSpan(timefrom, timeto));
            result.add(new TimeSpan(timefrom, timeto));
            return result;
        }
        int timefrom_index = 0;
        int timeto_index = 0;
        for (int i = 0; i < timeSpanList.size(); ++i) {
            TimeSpan timeSpanInner = timeSpanList.get(i);
            if (timefrom.compareTo(timeSpanInner.timeto) <= 0) {
                if (timefrom.compareTo(timeSpanInner.timefrom) >= 0) {
                    timefrom_index = i * 2 + 1;
                }
            } else {
                timefrom_index = i * 2 + 2;
            }
            if (timeto.compareTo(timeSpanInner.timeto) <= 0) {
                if (timeto.compareTo(timeSpanInner.timefrom) < 0) continue;
                timeto_index = i * 2 + 1;
                continue;
            }
            timeto_index = i * 2 + 2;
        }
        if (timefrom_index == timeto_index) {
            if (timefrom_index % 2 == 0) {
                TimeSpan timeSpan_left = null;
                TimeSpan timeSpan_right = null;
                Date time_close_left = null;
                Date time_close_right = null;
                int index_right = timefrom_index / 2;
                int index_left = index_right - 1;
                if (index_left >= 0) {
                    timeSpan_left = timeSpanList.get(index_left);
                    time_close_left = this.GetDate_offset(timeSpan_left.timeto, time_period, 1);
                }
                if (index_right < timeSpanList.size()) {
                    timeSpan_right = timeSpanList.get(index_right);
                    time_close_right = this.GetDate_offset(timeSpan_right.timefrom, time_period, -1);
                }
                if (time_close_left != null && time_close_left.compareTo(timefrom) == 0) {
                    if (time_close_right != null && time_close_right.compareTo(timeto) == 0) {
                        timeSpan_left.timeto = timeSpan_right.timeto;
                        timeSpanList.remove(timeSpan_right);
                    } else {
                        timeSpan_left.timeto = timeto;
                    }
                } else if (time_close_right != null && time_close_right.compareTo(timeto) == 0) {
                    timeSpan_right.timefrom = timefrom;
                } else {
                    timeSpanList.add(index_right, new TimeSpan(timefrom, timeto));
                }
                result.add(new TimeSpan(timefrom, timeto));
                return result;
            }
            return result;
        }
        ArrayList<TimeSpan> result_left = new ArrayList<TimeSpan>();
        ArrayList<TimeSpan> result_right = new ArrayList<TimeSpan>();
        int index_from_right = timefrom_index / 2;
        int index_to_left = (timeto_index - 1) / 2;
        int index_merge_from = index_from_right;
        int index_merge_to = index_to_left;
        TimeSpan timeSpan_from_right = timeSpanList.get(index_from_right);
        TimeSpan timeSpan_to_left = timeSpanList.get(index_to_left);
        Date time_close_from_right = this.GetDate_offset(timeSpan_from_right.timefrom, time_period, -1);
        Date time_close_to_left = this.GetDate_offset(timeSpan_to_left.timeto, time_period, 1);
        if (timefrom_index % 2 == 0) {
            TimeSpan timeSpan_left = null;
            Date time_close_left = null;
            int index_left = index_from_right - 1;
            if (index_left >= 0) {
                timeSpan_left = timeSpanList.get(index_left);
                time_close_left = this.GetDate_offset(timeSpan_left.timeto, time_period, 1);
            }
            if (time_close_left != null && time_close_left.compareTo(timefrom) == 0) {
                index_merge_from = index_left;
            } else {
                timeSpan_from_right.timefrom = timefrom;
            }
            result_left.add(new TimeSpan(timefrom, time_close_from_right));
        }
        if (timeto_index % 2 == 0) {
            TimeSpan timeSpan_right = null;
            Date time_close_right = null;
            int index_right = index_to_left + 1;
            if (index_right < timeSpanList.size()) {
                timeSpan_right = timeSpanList.get(index_right);
                time_close_right = this.GetDate_offset(timeSpan_right.timefrom, time_period, -1);
            }
            if (time_close_right != null && time_close_right.compareTo(timeto) == 0) {
                index_merge_to = index_right;
            } else {
                timeSpan_to_left.timeto = timeto;
            }
            result_right.add(new TimeSpan(time_close_to_left, timeto));
        }
        result.addAll(result_left);
        for (int i = index_from_right; i < index_to_left; ++i) {
            TimeSpan timeSpan0 = timeSpanList.get(i);
            TimeSpan timeSpan1 = timeSpanList.get(i + 1);
            Date time0 = this.GetDate_offset(timeSpan0.timeto, time_period, 1);
            Date time1 = this.GetDate_offset(timeSpan1.timefrom, time_period, -1);
            result.add(new TimeSpan(time0, time1));
        }
        result.addAll(result_right);
        TimeSpan timeSpan_merge_from = timeSpanList.get(index_merge_from);
        TimeSpan timeSpan_merge_to = timeSpanList.get(index_merge_to);
        timeSpan_merge_from.timeto = timeSpan_merge_to.timeto;
        for (int i = index_merge_to; i > index_merge_from; --i) {
            timeSpanList.remove(i);
        }
        return result;
    }

    public Date GetDate_offset(Date currentDate, String time_period, int count) {
        Date nextDate = null;
        if (time_period.equals("1min")) {
            nextDate = new Date(currentDate.getTime() + 60000L * (long)count);
        } else if (time_period.equals("5min")) {
            nextDate = new Date(currentDate.getTime() + 300000L * (long)count);
        } else if (time_period.equals("10min")) {
            nextDate = new Date(currentDate.getTime() + 600000L * (long)count);
        } else if (time_period.equals("15min")) {
            nextDate = new Date(currentDate.getTime() + 900000L * (long)count);
        } else if (time_period.equals("1h")) {
            nextDate = new Date(currentDate.getTime() + 3600000L * (long)count);
        } else if (time_period.equals("1d")) {
            nextDate = new Date(currentDate.getTime() + 86400000L * (long)count);
        } else if (time_period.equals("1m")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            calendar.add(2, count);
            nextDate = calendar.getTime();
        } else if (time_period.equals("1y")) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            calendar.add(1, count);
            nextDate = calendar.getTime();
        }
        return nextDate;
    }

    public List<TimeSpan> Clone(List<TimeSpan> timeSpanList) {
        ArrayList<TimeSpan> result = new ArrayList<TimeSpan>();
        for (TimeSpan ts : timeSpanList) {
            TimeSpan timeSpan = new TimeSpan(ts.timefrom, ts.timeto);
            result.add(timeSpan);
        }
        return result;
    }

    public String TimeSpanList2String(List<TimeSpan> timeSpanList) {
        StringBuffer sb = new StringBuffer();
        for (TimeSpan timeSpan : timeSpanList) {
            if (sb.length() > 0) {
                sb.append("    ");
            }
            sb.append(this.TimeSpan2String(timeSpan));
        }
        return sb.toString();
    }

    public String TimeSpan2String(TimeSpan span) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(span.timefrom) + " ~ " + sdf.format(span.timeto);
    }

    public String StepSpan2String(StepSpan span) {
        return span.backward + " ~ " + span.forward;
    }

    public static void main(String[] args) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<TimeSpan> timeSpanList_1 = new ArrayList<TimeSpan>();
        timeSpanList_1.add(new TimeSpan(sdf.parse("2017-01-01 02:00:00"), sdf.parse("2017-01-01 03:00:00")));
        timeSpanList_1.add(new TimeSpan(sdf.parse("2017-01-01 04:00:00"), sdf.parse("2017-01-01 05:00:00")));
        timeSpanList_1.add(new TimeSpan(sdf.parse("2017-01-01 06:00:00"), sdf.parse("2017-01-01 07:00:00")));
        timeSpanList_1.add(new TimeSpan(sdf.parse("2017-01-01 08:00:00"), sdf.parse("2017-01-01 09:00:00")));
    }
}

