/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.core;

import com.sagacloud.parser.simulator.String2Grammar;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreInstance;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.core.GrammarTreeNode;
import com.sagacloud.util.compute_engine.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoreComputeUtilUtil {
    public static void main(String[] args) throws Exception {
        String expression = "servicedata_1001_10101+servicedata_1002_10101-servicedata_1003_10101-servicedata_1004_10101";
        GrammarTreeNode node = String2Grammar.Generate(expression);
        HashMap<String, Double> dataMap = new HashMap<String, Double>();
        dataMap.put("servicedata_1001_10101", null);
        dataMap.put("servicedata_1002_10101", 0.0);
        dataMap.put("servicedata_1003_10101", 0.0);
        dataMap.put("servicedata_1003_10101", null);
        boolean rrr = CoreComputeUtilUtil.CantCompute(node, dataMap);
        System.out.println(rrr);
    }

    public static void BuildNetwork(CoreInstance instance) throws Exception {
        int size1;
        int size2;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        ArrayList<CoreOutput> outputListOrdered = new ArrayList<CoreOutput>();
        List<CoreInput> inputList = instance.inputList;
        List<CoreOutput> outputList = instance.outputList;
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput coreInput : inputList) {
            coreInput.successorList = new ArrayList<CoreOutput>();
            inputMap.put(coreInput.input_sign, coreInput);
        }
        HashMap<String, CoreOutput> outputMap = new HashMap<String, CoreOutput>();
        for (CoreOutput output : outputList) {
            output.predecessorList = new ArrayList<Object>();
            output.successorList = new ArrayList<CoreOutput>();
            output.all_input = new HashMap<String, Boolean>();
            outputMap.put(output.output_sign, output);
        }
        for (CoreOutput output : outputList) {
            ArrayList<CoreInput> tmpInputList = new ArrayList<CoreInput>();
            ArrayList<CoreOutput> tmpOutputList = new ArrayList<CoreOutput>();
            for (String input_sign : output.var_signMap.keySet()) {
                if (inputMap.containsKey(input_sign)) {
                    CoreInput input = (CoreInput)inputMap.get(input_sign);
                    tmpInputList.add(input);
                    continue;
                }
                CoreOutput tmp_output = (CoreOutput)outputMap.get(input_sign);
                tmpOutputList.add(tmp_output);
            }
            for (CoreInput tmpInput : tmpInputList) {
                tmpInput.successorList.add(output);
                output.predecessorList.add(tmpInput);
            }
            for (CoreOutput tmpOutput : tmpOutputList) {
                tmpOutput.successorList.add(output);
                output.predecessorList.add(tmpOutput);
            }
        }
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        do {
            size1 = hashMap.size();
            for (CoreOutput output : outputList) {
                if (hashMap.containsKey(output.output_sign + "_" + sdf.format(output.time_begin))) continue;
                ArrayList<CoreOutput> tmpOutputList = new ArrayList<CoreOutput>();
                for (Object predecessor : output.predecessorList) {
                    if (!(predecessor instanceof CoreOutput)) continue;
                    tmpOutputList.add((CoreOutput)predecessor);
                }
                boolean children_ok = true;
                for (CoreOutput tmpOutput : tmpOutputList) {
                    if (hashMap.containsKey(tmpOutput.output_sign + "_" + sdf.format(tmpOutput.time_begin))) continue;
                    children_ok = false;
                    break;
                }
                if (!children_ok) continue;
                for (Object predecessor : output.predecessorList) {
                    if (predecessor instanceof CoreInput) {
                        CoreInput input = (CoreInput)predecessor;
                        output.all_input.putIfAbsent(input.input_sign, true);
                        if (output.time_period_intialized || DateUtil.Instance().compare(output.time_period, input.time_period) >= 0) continue;
                        output.time_period = input.time_period;
                        continue;
                    }
                    if (!(predecessor instanceof CoreOutput)) continue;
                    CoreOutput tmpOutput = (CoreOutput)predecessor;
                    if (output.time_period_intialized || DateUtil.Instance().compare(output.time_period, tmpOutput.time_period) >= 0) continue;
                    output.time_period = tmpOutput.time_period;
                }
                for (CoreOutput tmpOutput : tmpOutputList) {
                    for (String tmpkey : tmpOutput.all_input.keySet()) {
                        output.all_input.putIfAbsent(tmpkey, true);
                    }
                }
                hashMap.put(output.output_sign + "_" + sdf.format(output.time_begin), true);
                outputListOrdered.add(output);
            }
        } while ((size2 = hashMap.size()) != size1);
        if (hashMap.size() != outputList.size()) {
            StringBuffer sb = new StringBuffer();
            for (CoreOutput output : outputList) {
                if (hashMap.containsKey(output.output_sign + "_" + sdf.format(output.time_begin))) continue;
                sb.append("\t" + output.output_sign + "_" + sdf.format(output.time_begin));
            }
            throw new Exception("CoreInstance network cant build:" + sb.toString());
        }
        instance.outputList = outputListOrdered;
    }

    public static boolean CantCompute(GrammarTreeNode node, Map<String, Double> dataMap) {
        HashMap<String, Boolean> jiashuMap = new HashMap<String, Boolean>();
        boolean jiahao = CoreComputeUtilUtil.jiahao(node, jiashuMap);
        if (jiahao) {
            boolean exist_data = false;
            for (String key : jiashuMap.keySet()) {
                if (dataMap.get(key) == null) continue;
                exist_data = true;
                break;
            }
            return !exist_data;
        }
        return false;
    }

    private static boolean jiahao(GrammarTreeNode node, Map<String, Boolean> jiashuMap) {
        if (node.type.equals("evaluate")) {
            if (node.evaluate.equals("+")) {
                boolean all_true = true;
                for (int i = 0; i < node.evaluateItemList.size(); ++i) {
                    GrammarTreeNode jia_node = node.evaluateItemList.get(i);
                    if (jia_node.type.equals("evaluate")) {
                        boolean tmp = CoreComputeUtilUtil.jiahao(jia_node, jiashuMap);
                        if (tmp) continue;
                        all_true = false;
                        continue;
                    }
                    if (jia_node.type.equals("const")) continue;
                    if (jia_node.type.equals("var")) {
                        jiashuMap.put(jia_node.var_original, true);
                        continue;
                    }
                    all_true = false;
                }
                return all_true;
            }
            if (node.evaluate.equals("-")) {
                GrammarTreeNode jia_node = node.evaluateItemList.get(0);
                if (jia_node.type.equals("evaluate")) {
                    return CoreComputeUtilUtil.jiahao(jia_node, jiashuMap);
                }
                if (jia_node.type.equals("const")) {
                    return true;
                }
                if (jia_node.type.equals("var")) {
                    jiashuMap.put(jia_node.var_original, true);
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

