/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.extend.dao_data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.core.AnnotationDescription;
import com.sagacloud.util.compute_engine.core.IDao_data;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@AnnotationDescription(value="dao_data")
public class ImplDao_tenantbalance
implements IDao_data {
    IZillionAgent agent;
    String database_name;
    String table_name;
    String dao_type = "tenantbalance";

    @Override
    public void Initialize(IZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
        this.table_name = "data_" + this.dao_type;
    }

    @Override
    public String GetName() {
        return this.dao_type;
    }

    @Override
    public List<DoubleTimeObject> GetDataListGteLte(JSONObject dao_key, String time_period, Date time_from, Date time_to, boolean GteLte) throws Exception {
        ArrayList<DoubleTimeObject> result = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("tenant", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time_from));
        if (time_to != null) {
            if (GteLte) {
                range.put("$lte", (Object)sdf.format(time_to));
            } else {
                range.put("$lt", (Object)sdf.format(time_to));
            }
        }
        Criteria.put("data_time", (Object)range);
        String table_name_query = this.table_name;
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
        ArrayList<DoubleTimeObject> dataList = new ArrayList<DoubleTimeObject>();
        for (int ii = 0; ii < resultContent.size(); ++ii) {
            JSONObject computelog = (JSONObject)resultContent.get(ii);
            DoubleTimeObject data = new DoubleTimeObject();
            data.data_time = sdf.parse((String)computelog.get((Object)"data_time"));
            data.data_value = (Double)computelog.get((Object)"data_value");
            dataList.add(data);
        }
        result = dataList;
        return result;
    }

    @Override
    public void InsertDataListGteLte(JSONObject dao_key, String time_period, List<DoubleTimeObject> outputDataList) throws Exception {
        if (ConstantCE.time_period_seperate_save_two || !ConstantCE.time_period_seperate) {
            this.InsertDataListGteLte(false, dao_key, time_period, outputDataList);
        }
        if (ConstantCE.time_period_seperate_save_two || ConstantCE.time_period_seperate) {
            this.InsertDataListGteLte(true, dao_key, time_period, outputDataList);
        }
    }

    @Override
    public void DeleteDataListGteLte(JSONObject dao_key, String time_period, Date time_from, Date time_to) throws Exception {
        if (ConstantCE.time_period_seperate_save_two || !ConstantCE.time_period_seperate) {
            this.DeleteDataListGteLte(false, dao_key, time_period, time_from, time_to);
        }
        if (ConstantCE.time_period_seperate_save_two || ConstantCE.time_period_seperate) {
            this.DeleteDataListGteLte(true, dao_key, time_period, time_from, time_to);
        }
    }

    private void DeleteDataListGteLte(boolean time_period_seperate, JSONObject dao_key, String time_period, Date time_from, Date time_to) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("tenant", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time_from));
        if (time_to != null) {
            range.put("$lte", (Object)sdf.format(time_to));
        }
        Criteria.put("data_time", (Object)range);
        String table_name_query = this.table_name;
        QueryUtil.delete(this.agent, this.database_name, table_name_query, Criteria);
    }

    private void InsertDataListGteLte(boolean time_period_seperate, JSONObject dao_key, String time_period, List<DoubleTimeObject> outputDataList) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONArray InsertObjects = new JSONArray();
        for (DoubleTimeObject data : outputDataList) {
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)building);
            InsertObject.put("tenant", (Object)tenant);
            InsertObject.put("energy_type", (Object)energy_type);
            InsertObject.put("data_time", (Object)sdf.format(data.data_time));
            InsertObject.put("data_value", (Object)data.data_value);
            InsertObjects.add((Object)InsertObject);
        }
        String table_name_query = this.table_name;
        QueryUtil.batch_insert(this.agent, this.database_name, table_name_query, InsertObjects);
    }

    public DoubleTimeObject GetData_last(JSONObject dao_key, Date time) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("tenant", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        JSONObject range = new JSONObject();
        range.put("$lte", (Object)sdf.format(time));
        Criteria.put("data_time", (Object)range);
        JSONArray OrderBy = new JSONArray();
        OrderBy.add((Object)QueryUtil.OrderByItem("building", true));
        OrderBy.add((Object)QueryUtil.OrderByItem("tenant", true));
        OrderBy.add((Object)QueryUtil.OrderByItem("energy_type", true));
        OrderBy.add((Object)QueryUtil.OrderByItem("data_time", false));
        JSONObject Limit = new JSONObject();
        Limit.put("Skip", (Object)0L);
        Limit.put("Count", (Object)1L);
        String table_name_query = this.table_name;
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria, OrderBy, Limit);
        if (resultContent.size() > 0) {
            JSONObject computelog = (JSONObject)resultContent.get(0);
            DoubleTimeObject data = new DoubleTimeObject();
            data.data_time = sdf.parse((String)computelog.get((Object)"data_time"));
            data.data_value = (Double)computelog.get((Object)"data_value");
            return data;
        }
        return null;
    }

    public DoubleTimeObject GetBalance_initial(JSONObject dao_key) throws Exception {
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        if (energy_type == null) {
            JSONObject Criteria = new JSONObject();
            Criteria.put("building", (Object)building);
            Criteria.put("sign", (Object)tenant);
            String table_name_query = "tenant";
            JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
            if (resultContent.size() > 0) {
                JSONObject computelog = (JSONObject)resultContent.get(0);
                DoubleTimeObject data = new DoubleTimeObject();
                data.data_time = null;
                data.data_value = (Double)computelog.get((Object)"soft_initial_yuer");
                return data;
            }
            return null;
        }
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("sign", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        String table_name_query = "tenant_energy";
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
        if (resultContent.size() > 0) {
            JSONObject computelog = (JSONObject)resultContent.get(0);
            DoubleTimeObject data = new DoubleTimeObject();
            data.data_time = null;
            data.data_value = (Double)computelog.get((Object)"soft_initial_yuer");
            return data;
        }
        return null;
    }

    public List<DoubleTimeObject> GetRechargeList(JSONObject dao_key, Date time) throws Exception {
        ArrayList<DoubleTimeObject> result = new ArrayList<DoubleTimeObject>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("sign", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time));
        Criteria.put("operate_time", (Object)range);
        String table_name_query = "tenant_recharge";
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
        for (int i = 0; i < resultContent.size(); ++i) {
            JSONObject computelog = (JSONObject)resultContent.get(i);
            DoubleTimeObject data = new DoubleTimeObject();
            data.data_time = sdf.parse((String)computelog.get((Object)"operate_time"));
            data.data_value = (Double)computelog.get((Object)"amount");
            result.add(data);
        }
        return result;
    }

    public void SetRecharge_used(JSONObject dao_key, Date time) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("sign", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        Criteria.put("operate_time", (Object)sdf.format(time));
        String table_name_query = "tenant_recharge";
        JSONObject Set2 = new JSONObject();
        Set2.put("is_used", (Object)1L);
        QueryUtil.update(this.agent, this.database_name, table_name_query, Criteria, Set2);
    }

    public DoubleTimeObject GetBalance_present(JSONObject dao_key) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("tenant", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        String table_name_query = "data_tenantbalance_present";
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
        if (resultContent.size() > 0) {
            JSONObject computelog = (JSONObject)resultContent.get(0);
            DoubleTimeObject data = new DoubleTimeObject();
            data.data_time = sdf.parse((String)computelog.get((Object)"data_time"));
            data.data_value = (Double)computelog.get((Object)"data_value");
            return data;
        }
        return null;
    }

    public void InsertDataBalance_present(JSONObject dao_key, DoubleTimeObject data) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject InsertObject = new JSONObject();
        InsertObject.put("building", (Object)building);
        InsertObject.put("tenant", (Object)tenant);
        InsertObject.put("energy_type", (Object)energy_type);
        InsertObject.put("data_time", (Object)sdf.format(data.data_time));
        InsertObject.put("data_value", (Object)data.data_value);
        String table_name_query = "data_tenantbalance_present";
        QueryUtil.insert(this.agent, this.database_name, table_name_query, InsertObject);
    }

    public void UpdateBalance_present(JSONObject dao_key, DoubleTimeObject data) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String tenant = (String)dao_key.get((Object)"tenant");
        String energy_type = (String)dao_key.get((Object)"energy_type");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("tenant", (Object)tenant);
        Criteria.put("energy_type", (Object)energy_type);
        JSONObject Set2 = new JSONObject();
        Set2.put("data_time", (Object)sdf.format(data.data_time));
        Set2.put("data_value", (Object)data.data_value);
        String table_name_query = "data_tenantbalance_present";
        QueryUtil.update(this.agent, this.database_name, table_name_query, Criteria, Set2);
    }
}

