/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.common;

import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.HashObject;

public class HashUtil {
    public static byte[] merge_hash_code(byte[] hash_code, byte[] row_key_bytes) {
        if (hash_code.length < row_key_bytes.length) {
            byte[] tmp = new byte[row_key_bytes.length];
            System.arraycopy(hash_code, 0, tmp, 0, hash_code.length);
            hash_code = tmp;
        }
        int i = 0;
        while (i < row_key_bytes.length) {
            hash_code[i] = (byte)(hash_code[i] & 0xFF ^ row_key_bytes[i] & 0xFF);
            ++i;
        }
        return hash_code;
    }

    public static byte[] merge_hash(byte[] hash1, byte[] hash2) {
        long insert_count1 = ByteToObject.toLong(hash1, 0);
        long delete_count1 = ByteToObject.toLong(hash1, 8);
        long insert_count2 = ByteToObject.toLong(hash2, 0);
        long delete_count2 = ByteToObject.toLong(hash2, 8);
        long insert_count = insert_count1 + insert_count2;
        long delete_count = delete_count1 + delete_count2;
        if (hash1.length < hash2.length) {
            byte[] tmp = new byte[hash2.length];
            System.arraycopy(hash1, 0, tmp, 0, hash1.length);
            hash1 = tmp;
        }
        ByteToObject.putLong(hash1, 0, insert_count);
        ByteToObject.putLong(hash1, 8, delete_count);
        int i = 16;
        while (i < hash2.length) {
            hash1[i] = (byte)(hash1[i] & 0xFF ^ hash2[i] & 0xFF);
            ++i;
        }
        return hash1;
    }

    public static HashObject Parse(byte[] hash) {
        HashObject result = new HashObject();
        result.insert_count = ByteToObject.toLong(hash, 0);
        result.delete_count = ByteToObject.toLong(hash, 8);
        result.hash_code = new byte[hash.length - 16];
        System.arraycopy(hash, 16, result.hash_code, 0, result.hash_code.length);
        return result;
    }
}

