/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.ZillionAgent;
import com.zillion.database.util.DatabaseImpl_HBase;
import com.zillion.database.util.DatabaseImpl_Mix;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.SplitUtil;
import com.zillion.util.common.SplitWrapper;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class ZillionMonitorUtil {
    public static void process(ZillionAgent agent, JSONObject queryJSON, JSONObject result) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String QueryType = (String)queryJSON.get((Object)"QueryType");
        DatabaseImpl_HBase impl = null;
        if (agent.container.DatabaseImpl instanceof DatabaseImpl_HBase) {
            impl = (DatabaseImpl_HBase)agent.container.DatabaseImpl;
        } else if (agent.container.DatabaseImpl instanceof DatabaseImpl_Mix) {
            impl = ((DatabaseImpl_Mix)agent.container.DatabaseImpl).hbase;
        }
        if (impl == null) {
            result.put("Reason", (Object)"monitor can't support MySQL");
            return;
        }
        String Database = (String)queryJSON.get((Object)"Database");
        String TimeFrom = (String)queryJSON.get((Object)"TimeFrom");
        String TimeTo = (String)queryJSON.get((Object)"TimeTo");
        String Caliber = (String)queryJSON.get((Object)"Caliber");
        Date time_from = sdf.parse(TimeFrom);
        Date time_to = sdf.parse(TimeTo);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time_from);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        ArrayList<String> monthList = new ArrayList<String>();
        Date tmp_time = calendar.getTime();
        while (tmp_time.getTime() < time_to.getTime()) {
            monthList.add(sdf.format(tmp_time).substring(0, 6));
            calendar.setTime(tmp_time);
            calendar.add(2, 1);
            tmp_time = calendar.getTime();
        }
        if (QueryType.equals("monitor_sum_curve") || QueryType.equals("monitor_table_total")) {
            ZillionMonitorUtil.stat_2(agent.container, impl, QueryType, Caliber, Database, TimeFrom, TimeTo, monthList, result);
        } else if (QueryType.equals("monitor_table_curve")) {
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            ZillionMonitorUtil.stat_1(agent.container, impl, QueryType, Caliber, Database, Datatable, TimeFrom, TimeTo, monthList, result);
        }
        result.remove((Object)"Result");
        result.put("Result", (Object)"success");
    }

    private static void stat_1(SchemaRepositoryContainer container, DatabaseImpl_HBase impl, String QueryType, String Caliber, String Database, String Datatable, String TimeFrom, String TimeTo, List<String> monthList, JSONObject result) throws Exception {
        JSONObject content = new JSONObject();
        int index_out = Caliber.indexOf(95);
        String c1 = Caliber.substring(0, index_out);
        String c2 = Caliber.substring(index_out + 1);
        ArrayList<String> columnList = new ArrayList<String>();
        if (c2.equals("lines") || c2.equals("bytes")) {
            ArrayList<String> c1List = new ArrayList<String>();
            if (c1.equals("total")) {
                c1List.add("read");
                c1List.add("insert");
                c1List.add("update");
                c1List.add("delete");
            } else if (c1.equals("write")) {
                c1List.add("insert");
                c1List.add("update");
                c1List.add("delete");
            } else if (c1.equals("read")) {
                c1List.add("read");
            } else {
                columnList.add(Caliber);
            }
            for (String cc : c1List) {
                columnList.add(String.valueOf(cc) + "_" + c2);
            }
        } else {
            columnList.add(Caliber);
        }
        ZillionTableSchema schema = container.repositoryMap.get(Database).GetTable(Datatable);
        String tableName = Datatable;
        String query_month = null;
        if (schema == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            int index_ = Datatable.lastIndexOf("_");
            if (index_ != -1) {
                String prefix = Datatable.substring(0, index_);
                String suffix = Datatable.substring(index_ + 1);
                boolean is_split_table = false;
                SplitWrapper sw = new SplitWrapper(tableName, is_split_table, query_month, schema);
                SplitUtil.SplitParse(sdf, container.repositoryMap.get(Database), prefix, suffix, sw);
                tableName = sw.tableName;
                is_split_table = sw.is_split_table;
                query_month = sw.query_month;
                schema = sw.schema;
            }
        }
        if (query_month != null) {
            String child_name = query_month;
            JSONObject child_item = content;
            JSONArray split_curve = new JSONArray();
            child_item.put("total_curve", (Object)split_curve);
            String table_real = "zillion_data_" + tableName + "_" + child_name;
            Object data_curve = null;
            if (schema.Indexes.size() > 0) {
                data_curve = new JSONArray();
                child_item.put("data_curve", data_curve);
            }
            ZillionMonitorUtil.stat_1_add(container, impl, Database, table_real, TimeFrom, TimeTo, monthList, columnList, null, split_curve, (JSONArray)data_curve);
            for (ZillionTableIndex schema_index : schema.Indexes) {
                String indexName = schema_index.index_name;
                String table_real2 = "zillion_index_" + tableName + "." + (String)indexName + "_" + child_name;
                JSONArray index_curve = new JSONArray();
                child_item.put("index_" + (String)indexName + "_curve", (Object)index_curve);
                ZillionMonitorUtil.stat_1_add(container, impl, Database, table_real2, TimeFrom, TimeTo, monthList, columnList, null, split_curve, index_curve);
            }
        } else {
            JSONArray total_curve = new JSONArray();
            content.put("total_curve", (Object)total_curve);
            if (schema.table_type != null && schema.table_type.startsWith("split_")) {
                String zkpath_namespace = "/zillion/ns/" + Database;
                List<String> child_nameList = container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, false);
                Collections.sort(child_nameList);
                JSONArray splitArray = new JSONArray();
                content.put("splitArray", (Object)splitArray);
                for (String child_name : child_nameList) {
                    JSONObject child_item = new JSONObject();
                    child_item.put("split", (Object)child_name);
                    splitArray.add((Object)child_item);
                    JSONArray split_curve = new JSONArray();
                    child_item.put("total_curve", (Object)split_curve);
                    String table_real = "zillion_data_" + Datatable + "_" + child_name;
                    JSONArray data_curve = null;
                    if (schema.Indexes.size() > 0) {
                        data_curve = new JSONArray();
                        child_item.put("data_curve", (Object)data_curve);
                    }
                    ZillionMonitorUtil.stat_1_add(container, impl, Database, table_real, TimeFrom, TimeTo, monthList, columnList, total_curve, split_curve, data_curve);
                    for (ZillionTableIndex schema_index : schema.Indexes) {
                        String indexName = schema_index.index_name;
                        String table_real3 = "zillion_index_" + Datatable + "." + indexName + "_" + child_name;
                        JSONArray index_curve = new JSONArray();
                        child_item.put("index_" + indexName + "_curve", (Object)index_curve);
                        ZillionMonitorUtil.stat_1_add(container, impl, Database, table_real3, TimeFrom, TimeTo, monthList, columnList, total_curve, split_curve, index_curve);
                    }
                }
            } else {
                String table_real = "zillion_data_" + Datatable;
                JSONArray data_curve = null;
                if (schema.Indexes.size() > 0) {
                    data_curve = new JSONArray();
                    content.put("data_curve", (Object)data_curve);
                }
                ZillionMonitorUtil.stat_1_add(container, impl, Database, table_real, TimeFrom, TimeTo, monthList, columnList, total_curve, null, data_curve);
                for (ZillionTableIndex schema_index : schema.Indexes) {
                    String indexName = schema_index.index_name;
                    String table_real4 = "zillion_index_" + Datatable + "." + indexName;
                    JSONArray index_curve = new JSONArray();
                    content.put("index_" + indexName + "_curve", (Object)index_curve);
                    ZillionMonitorUtil.stat_1_add(container, impl, Database, table_real4, TimeFrom, TimeTo, monthList, columnList, total_curve, null, index_curve);
                }
            }
        }
        result.put("Content", (Object)content);
    }

    private static void stat_1_add(SchemaRepositoryContainer container, DatabaseImpl_HBase impl, String Database, String table_real, String TimeFrom, String TimeTo, List<String> monthList, List<String> columnList, JSONArray curve1, JSONArray curve2, JSONArray curve3) throws Exception {
        ArrayList<JSONArray> curveList = new ArrayList<JSONArray>();
        if (curve1 != null) {
            curveList.add(curve1);
        }
        if (curve2 != null) {
            curveList.add(curve2);
        }
        if (curve3 != null) {
            curveList.add(curve3);
        }
        for (String month : monthList) {
            Result res;
            TableName tableName = TableName.valueOf((String)Database, (String)("zillion_meta_stat_1_" + month));
            if (!impl.admin.tableExists(tableName)) continue;
            HTable table = (HTable)impl.connection.getTable(tableName);
            Scan scan = new Scan();
            for (String column : columnList) {
                scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column));
            }
            ArrayList<MultiRowRangeFilter.RowRange> rangeList = new ArrayList<MultiRowRangeFilter.RowRange>();
            rangeList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)(String.valueOf(table_real) + "," + TimeFrom)), false, Bytes.toBytes((String)(String.valueOf(table_real) + "," + TimeTo)), false));
            MultiRowRangeFilter filter = new MultiRowRangeFilter(rangeList);
            scan.setFilter((Filter)filter);
            ResultScanner scanner = table.getScanner(scan);
            while ((res = scanner.next()) != null) {
                String rowkey = Bytes.toString((byte[])res.getRow());
                int index_r1 = rowkey.indexOf(44);
                int index_r2 = rowkey.indexOf(44, index_r1 + 1);
                String time = rowkey.substring(index_r1 + 1, index_r2);
                List cellList = res.listCells();
                long row_long_value = 0L;
                for (Cell cell : cellList) {
                    byte[] cell_bytes = CellUtil.cloneValue((Cell)cell);
                    row_long_value += Bytes.toLong((byte[])cell_bytes);
                }
                for (JSONArray curve : curveList) {
                    int insert_index = ZillionMonitorUtil.FindInsertIndex(curve, time);
                    JSONObject last_item = null;
                    if (insert_index < 0) {
                        last_item = (JSONObject)curve.get(-250 - insert_index);
                    }
                    if (last_item == null) {
                        last_item = new JSONObject();
                        last_item.put("time", (Object)time);
                        last_item.put("count", (Object)row_long_value);
                        curve.add(insert_index, (Object)last_item);
                        continue;
                    }
                    long count = (Long)last_item.get((Object)"count");
                    last_item.remove((Object)"count");
                    last_item.put("count", (Object)(count + row_long_value));
                }
            }
            scanner.close();
        }
    }

    public static int FindInsertIndex(JSONArray dataList, String time) {
        int beginIndex = 0;
        int endIndex = dataList.size() - 1;
        boolean lastMoveLeft = true;
        boolean find = false;
        int find_index = -1;
        while (beginIndex <= endIndex) {
            int tempIndex = (beginIndex + endIndex) / 2;
            JSONObject tmpData = (JSONObject)dataList.get(tempIndex);
            String tmpDate = (String)tmpData.get((Object)"time");
            int compareResult = tmpDate.compareTo(time);
            if (compareResult == 0) {
                find = true;
                find_index = tempIndex;
                break;
            }
            if (compareResult < 0) {
                beginIndex = tempIndex + 1;
                lastMoveLeft = false;
                continue;
            }
            endIndex = tempIndex - 1;
            lastMoveLeft = true;
        }
        int insertIndex = 0;
        insertIndex = !find ? (lastMoveLeft ? endIndex + 1 : beginIndex) : -250 - find_index;
        return insertIndex;
    }

    private static void stat_2(SchemaRepositoryContainer container, DatabaseImpl_HBase impl, String QueryType, String Caliber, String Database, String TimeFrom, String TimeTo, List<String> monthList, JSONObject result) throws Exception {
        JSONArray content = new JSONArray();
        int index_ = Caliber.indexOf(95);
        String c1 = Caliber.substring(0, index_);
        String c2 = Caliber.substring(index_ + 1);
        ArrayList<String> columnList = new ArrayList<String>();
        if (c2.equals("lines") || c2.equals("bytes")) {
            ArrayList<String> c1List = new ArrayList<String>();
            if (c1.equals("total")) {
                c1List.add("read");
                c1List.add("insert");
                c1List.add("update");
                c1List.add("delete");
            } else if (c1.equals("write")) {
                c1List.add("insert");
                c1List.add("update");
                c1List.add("delete");
            } else if (c1.equals("read")) {
                c1List.add("read");
            } else {
                columnList.add(Caliber);
            }
            for (String cc : c1List) {
                columnList.add(String.valueOf(cc) + "_" + c2);
            }
        } else {
            columnList.add(Caliber);
        }
        JSONObject last_item = null;
        HashMap<String, JSONObject> tableMap = new HashMap<String, JSONObject>();
        for (String month : monthList) {
            Result res;
            TableName tableName = TableName.valueOf((String)Database, (String)("zillion_meta_stat_2_" + month));
            if (!impl.admin.tableExists(tableName)) continue;
            HTable table = (HTable)impl.connection.getTable(tableName);
            Scan scan = new Scan();
            for (String column : columnList) {
                scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column));
            }
            ArrayList<MultiRowRangeFilter.RowRange> rangeList = new ArrayList<MultiRowRangeFilter.RowRange>();
            rangeList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((String)TimeFrom), false, Bytes.toBytes((String)TimeTo), false));
            MultiRowRangeFilter filter = new MultiRowRangeFilter(rangeList);
            scan.setFilter((Filter)filter);
            ResultScanner scanner = table.getScanner(scan);
            while ((res = scanner.next()) != null) {
                String name2;
                String rowkey = Bytes.toString((byte[])res.getRow());
                int index_r1 = rowkey.indexOf(44);
                int index_r2 = rowkey.indexOf(44, index_r1 + 1);
                String time = rowkey.substring(0, index_r1);
                String table_real = rowkey.substring(index_r1 + 1, index_r2);
                String table_name = null;
                String index_name = null;
                String split = null;
                ZillionTableSchema schema = null;
                if (table_real.startsWith("zillion_data_")) {
                    name2 = table_real.substring("zillion_data_".length());
                    schema = container.repositoryMap.get(Database).GetTable(name2);
                    if (schema != null) {
                        table_name = name2;
                    } else {
                        int indexInner = name2.lastIndexOf(95);
                        String main_table = name2.substring(0, indexInner);
                        String suffix = name2.substring(indexInner + 1);
                        schema = container.repositoryMap.get(Database).GetTable(main_table);
                        if (schema != null && schema.table_type != null && schema.table_type.startsWith("split_")) {
                            table_name = main_table;
                            split = suffix;
                        }
                    }
                } else {
                    name2 = table_real.substring("zillion_index_".length());
                    int index_dot = name2.indexOf(46);
                    String table_nameInner = name2.substring(0, index_dot);
                    String index_split = name2.substring(index_dot + 1);
                    schema = container.repositoryMap.get(Database).GetTable(table_nameInner);
                    if (schema != null) {
                        table_name = table_nameInner;
                        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
                            int index_2 = index_split.lastIndexOf(95);
                            index_name = index_split.substring(0, index_2);
                            split = index_split.substring(index_2 + 1);
                        } else {
                            index_name = index_split;
                        }
                    }
                }
                if (table_name == null) continue;
                List cellList = res.listCells();
                long row_long_value = 0L;
                for (Cell cell : cellList) {
                    byte[] cell_bytes = CellUtil.cloneValue((Cell)cell);
                    row_long_value += Bytes.toLong((byte[])cell_bytes);
                }
                if (QueryType.equals("monitor_sum_curve")) {
                    String time_last;
                    boolean time_change = false;
                    if (last_item != null && !(time_last = (String)last_item.get((Object)"time")).equals(time)) {
                        time_change = true;
                    }
                    if (last_item == null || time_change) {
                        last_item = new JSONObject();
                        last_item.put("time", (Object)time);
                        last_item.put("count", (Object)row_long_value);
                        content.add((Object)last_item);
                        continue;
                    }
                    long count = (Long)last_item.get((Object)"count");
                    last_item.remove((Object)"count");
                    last_item.put("count", (Object)(count + row_long_value));
                    continue;
                }
                if (!QueryType.equals("monitor_table_total")) continue;
                ZillionMonitorUtil.add2Map(tableMap, table_name, split, index_name, row_long_value);
            }
            scanner.close();
        }
        if (QueryType.equals("monitor_table_total")) {
            Object[] table_nameArray = tableMap.keySet().toArray(new String[0]);
            Arrays.sort(table_nameArray);
            Object[] objectArray = table_nameArray;
            int n = table_nameArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object table_name = objectArray[n2];
                content.add(tableMap.get(table_name));
                ++n2;
            }
        }
        result.put("Content", (Object)content);
    }

    private static void add2Map(Map<String, JSONObject> tableMap, String table_name, String split, String index_name, long row_long_value) {
        JSONObject table_item;
        if (!tableMap.containsKey(table_name)) {
            table_item = new JSONObject();
            table_item.put("table_name", (Object)table_name);
            tableMap.put(table_name, table_item);
        } else {
            table_item = tableMap.get(table_name);
        }
        if (split != null) {
            JSONObject split_item;
            JSONObject splits;
            if (!table_item.containsKey((Object)"splits")) {
                table_item.put("splits", (Object)new JSONObject());
            }
            if (!(splits = (JSONObject)table_item.get((Object)"splits")).containsKey((Object)split)) {
                split_item = new JSONObject();
                splits.put(split, (Object)split_item);
            } else {
                split_item = (JSONObject)splits.get((Object)split);
            }
            String key = index_name != null ? "index_" + index_name : "data";
            ZillionMonitorUtil.add2key(split_item, key, row_long_value);
            ZillionMonitorUtil.add2key(split_item, "total", row_long_value);
            ZillionMonitorUtil.add2key(table_item, key, row_long_value);
            ZillionMonitorUtil.add2key(table_item, "total", row_long_value);
        } else {
            String key = index_name != null ? "index_" + index_name : "data";
            ZillionMonitorUtil.add2key(table_item, key, row_long_value);
            ZillionMonitorUtil.add2key(table_item, "total", row_long_value);
        }
    }

    private static void add2key(JSONObject item, String key, long row_long_value) {
        if (item.containsKey((Object)key)) {
            long exist_count = (Long)item.get((Object)key);
            item.remove((Object)key);
            item.put(key, (Object)(exist_count + row_long_value));
        } else {
            item.put(key, (Object)row_long_value);
        }
    }
}

