/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.jetbrains.annotations.Nullable;

public class H2RowCacheRegistry {
    private final Object mux = new Object();
    private volatile Map<Integer, H2RowCache> caches;

    @Nullable
    public H2RowCache forGroup(int grpId) {
        return this.caches != null ? this.caches.get(grpId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheRegistered(GridCacheContext cctx) {
        if (!cctx.config().isSqlOnheapCacheEnabled()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            H2RowCache cache;
            int grpId = cctx.groupId();
            if (this.caches != null && (cache = this.caches.get(grpId)) != null) {
                cache.onCacheRegistered();
                return;
            }
            HashMap<Integer, H2RowCache> caches0 = this.copy();
            H2RowCache rowCache = new H2RowCache(cctx.group(), cctx.config().getSqlOnheapCacheMaxSize());
            caches0.put(grpId, rowCache);
            this.caches = caches0;
            for (IgniteCacheOffheapManager.CacheDataStore ds : cctx.offheap().cacheDataStores()) {
                ds.setRowCacheCleaner((GridQueryRowCacheCleaner)rowCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCacheUnregistered(GridCacheContext cctx) {
        if (!cctx.config().isSqlOnheapCacheEnabled()) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            int grpId = cctx.groupId();
            assert (this.caches != null);
            H2RowCache cache = this.caches.get(grpId);
            assert (cache != null);
            if (cache.onCacheUnregistered(cctx)) {
                HashMap<Integer, H2RowCache> caches0 = this.copy();
                caches0.remove(grpId);
                this.caches = caches0;
            }
        }
    }

    private HashMap<Integer, H2RowCache> copy() {
        assert (Thread.holdsLock(this.mux));
        if (this.caches == null) {
            return new HashMap<Integer, H2RowCache>();
        }
        return new HashMap<Integer, H2RowCache>(this.caches);
    }
}

