/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.util.LocalDateTimeUtils;
import org.h2.value.DataType;

public enum H2DatabaseType {
    INT("INT"),
    BOOL("BOOL"),
    TINYINT("TINYINT"),
    SMALLINT("SMALLINT"),
    BIGINT("BIGINT"),
    DECIMAL("DECIMAL"),
    DOUBLE("DOUBLE"),
    REAL("REAL"),
    TIME("TIME"),
    TIMESTAMP("TIMESTAMP"),
    DATE("DATE"),
    VARCHAR("VARCHAR"),
    CHAR("CHAR"),
    BINARY("BINARY"),
    UUID("UUID"),
    ARRAY("ARRAY"),
    GEOMETRY("GEOMETRY"),
    OTHER("OTHER");

    private static final Map<Class<?>, H2DatabaseType> map;
    private final String dbType;

    private H2DatabaseType(String dbType) {
        this.dbType = dbType;
    }

    public static H2DatabaseType fromClass(Class<?> cls) {
        H2DatabaseType res = map.get(cls);
        if (res != null) {
            return res;
        }
        if (DataType.isGeometryClass(cls)) {
            return GEOMETRY;
        }
        if (LocalDateTimeUtils.isJava8DateApiPresent()) {
            if (LocalDateTimeUtils.isLocalDate(cls)) {
                return DATE;
            }
            if (LocalDateTimeUtils.isLocalTime(cls)) {
                return TIME;
            }
            if (LocalDateTimeUtils.isLocalDateTime(cls)) {
                return TIMESTAMP;
            }
        }
        return cls.isArray() && !cls.getComponentType().isPrimitive() ? ARRAY : OTHER;
    }

    public String dBTypeAsString() {
        return this.dbType;
    }

    public String toString() {
        return S.toString(H2DatabaseType.class, (Object)((Object)this));
    }

    static {
        map = new HashMap();
        map.put(Integer.TYPE, INT);
        map.put(Integer.class, INT);
        map.put(Boolean.TYPE, BOOL);
        map.put(Boolean.class, BOOL);
        map.put(Byte.TYPE, TINYINT);
        map.put(Byte.class, TINYINT);
        map.put(Short.TYPE, SMALLINT);
        map.put(Short.class, SMALLINT);
        map.put(Long.TYPE, BIGINT);
        map.put(Long.class, BIGINT);
        map.put(BigDecimal.class, DECIMAL);
        map.put(Double.TYPE, DOUBLE);
        map.put(Double.class, DOUBLE);
        map.put(Float.TYPE, REAL);
        map.put(Float.class, REAL);
        map.put(Time.class, TIME);
        map.put(Timestamp.class, TIMESTAMP);
        map.put(Date.class, TIMESTAMP);
        map.put(java.sql.Date.class, DATE);
        map.put(String.class, VARCHAR);
        map.put(UUID.class, UUID);
        map.put(byte[].class, BINARY);
    }
}

