/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;

@InterfaceAudience.Private
public class MetaUtils {
    private static final Log LOG = LogFactory.getLog(MetaUtils.class);
    private final Configuration conf;
    private final FSTableDescriptors descriptors;
    private FileSystem fs;
    private WALFactory walFactory;
    private HRegion metaRegion;
    private Map<byte[], HRegion> metaRegions = Collections.synchronizedSortedMap(new TreeMap(Bytes.BYTES_COMPARATOR));

    public MetaUtils() throws IOException {
        this(HBaseConfiguration.create());
    }

    public MetaUtils(Configuration conf) throws IOException {
        this.conf = conf;
        conf.setInt("hbase.client.retries.number", 1);
        this.metaRegion = null;
        this.descriptors = new FSTableDescriptors(conf);
        this.initialize();
    }

    private void initialize() throws IOException {
        this.fs = FileSystem.get((Configuration)this.conf);
    }

    public synchronized WAL getLog(HRegionInfo info) throws IOException {
        if (this.walFactory == null) {
            String logName = "WALs_" + System.currentTimeMillis();
            Configuration walConf = new Configuration(this.conf);
            FSUtils.setRootDir(walConf, this.fs.getHomeDirectory());
            this.walFactory = new WALFactory(walConf, null, logName);
        }
        byte[] region = info.getEncodedNameAsBytes();
        return info.isMetaRegion() ? this.walFactory.getMetaWAL(region) : this.walFactory.getWAL(region);
    }

    public synchronized HRegion getMetaRegion() throws IOException {
        return this.metaRegion == null ? this.openMetaRegion() : this.metaRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.metaRegion != null) {
            try {
                this.metaRegion.close();
            }
            catch (IOException e) {
                LOG.error((Object)"closing meta region", (Throwable)e);
            }
            finally {
                this.metaRegion = null;
            }
        }
        try {
            for (HRegion r : this.metaRegions.values()) {
                LOG.info((Object)("CLOSING hbase:meta " + r.toString()));
                r.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"closing meta region", (Throwable)e);
        }
        finally {
            this.metaRegions.clear();
        }
        try {
            if (this.walFactory != null) {
                this.walFactory.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"closing WAL", (Throwable)e);
        }
    }

    private synchronized HRegion openMetaRegion() throws IOException {
        if (this.metaRegion != null) {
            return this.metaRegion;
        }
        this.metaRegion = HRegion.openHRegion(HRegionInfo.FIRST_META_REGIONINFO, this.descriptors.get(TableName.META_TABLE_NAME), this.getLog(HRegionInfo.FIRST_META_REGIONINFO), this.conf);
        this.metaRegion.compactStores();
        return this.metaRegion;
    }
}

