/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.zk;

import com.zillion.util.zk.ZKWrapper;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.log.LogUtil;

public class ZKHelper {
    public static void recursive(ZKWrapper zk, String path) throws Exception {
        ZKHelper.recursive(zk, path, true);
    }

    public static void recursiveChildren(ZKWrapper zk, String path) throws Exception {
        List<String> children = zk.getChildren(path, false);
        for (String child : children) {
            String parentPath = path.length() == 1 ? "/" : String.valueOf(path) + "/";
            String childPath = String.valueOf(parentPath) + child;
            ZKHelper.recursive(zk, childPath, false);
        }
    }

    private static void recursive(ZKWrapper zk, String path, boolean not_exist_throw) throws Exception {
        Stat stat = zk.exists(path, false);
        if (stat == null) {
            return;
        }
        List<String> children = zk.getChildren(path, false);
        for (String child : children) {
            String parentPath = path.length() == 1 ? "/" : String.valueOf(path) + "/";
            String childPath = String.valueOf(parentPath) + child;
            ZKHelper.recursive(zk, childPath, false);
        }
        try {
            zk.delete(path, -1);
        }
        catch (KeeperException.NoNodeException e) {
            if (not_exist_throw) {
                LogUtil.warn(e.getMessage());
                throw e;
            }
        }
        catch (KeeperException.NotEmptyException e) {
            Thread.sleep(500L);
            try {
                zk.delete(path, -1);
            }
            catch (Exception e1) {
                LogUtil.warn(e.getMessage());
                throw e;
            }
        }
        catch (Exception e) {
            LogUtil.warn(e.getMessage());
            throw e;
        }
    }
}

