/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.ZillionCriteriaMatchItem;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.table.HTableUtil;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableSchema;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;

public class ZillionCriteriaMatchUtil {
    public static ZillionCriteriaMatchItem CriteriaMatch(ZillionTableSchema schema, String[] ColumnNames, JSONObject Criteria) throws IOException {
        byte[] bytes;
        byte[] bytes_lt;
        byte[] bytes_gte;
        int bytes_count;
        byte[] bytes2;
        int equalCount = 0;
        boolean lastRange = false;
        ZillionTableColumn lastRangeColumn = null;
        JSONObject lastRangeJSON = null;
        int i = 0;
        while (i < ColumnNames.length) {
            String ColumnName = ColumnNames[i];
            ZillionTableColumn column = schema.ColumnMap.get(ColumnName);
            if (!Criteria.containsKey((Object)ColumnName)) break;
            Object columnObject = Criteria.get((Object)ColumnName);
            if (columnObject == null) {
                ++equalCount;
            } else {
                if (columnObject instanceof JSONObject) {
                    JSONObject columnJSON = (JSONObject)columnObject;
                    if (columnJSON.containsKey((Object)"$regex")) break;
                    lastRange = true;
                    lastRangeColumn = column;
                    lastRangeJSON = columnJSON;
                    break;
                }
                ++equalCount;
            }
            ++i;
        }
        int keyMatchCount = equalCount;
        if (lastRange) {
            ++keyMatchCount;
        }
        JSONObject otherCriteria = new JSONObject();
        for (String key : Criteria.keySet()) {
            Object value = Criteria.get((Object)key);
            boolean key_match = false;
            int i2 = 0;
            while (i2 < keyMatchCount) {
                String ColumnName = ColumnNames[i2];
                if (ColumnName.equals(key)) {
                    key_match = true;
                    break;
                }
                ++i2;
            }
            if (key_match) continue;
            otherCriteria.put(key, value);
        }
        boolean match = false;
        if (schema.table_type.equals("all_column")) {
            match = true;
        } else {
            boolean other_bad = false;
            int i3 = 0;
            while (i3 < ColumnNames.length) {
                String ColumnName = ColumnNames[i3];
                if (otherCriteria.containsKey((Object)ColumnName)) {
                    other_bad = true;
                    break;
                }
                ++i3;
            }
            if (!other_bad) {
                match = true;
            }
        }
        if (!match) {
            return null;
        }
        ZillionCriteriaMatchItem result = new ZillionCriteriaMatchItem();
        ArrayList<byte[]> bytess = new ArrayList<byte[]>();
        int i4 = 0;
        while (i4 < equalCount) {
            String ColumnName = ColumnNames[i4];
            ZillionTableColumn column = schema.ColumnMap.get(ColumnName);
            Object columnObject = Criteria.get((Object)ColumnName);
            bytes2 = HTableUtil.GenerateKeyBytes(column, columnObject);
            bytess.add(bytes2);
            ++i4;
        }
        if (lastRange) {
            bytes_count = 0;
            int i5 = 0;
            while (i5 < equalCount) {
                bytes_count += ((byte[])bytess.get(i5)).length;
                ++i5;
            }
            bytes_gte = new byte[bytes_count + 1];
            bytes_lt = new byte[bytes_count + 1];
            int bytes_index = 0;
            int i6 = 0;
            while (i6 < equalCount) {
                bytes = (byte[])bytess.get(i6);
                System.arraycopy(bytes, 0, bytes_gte, bytes_index, bytes.length);
                System.arraycopy(bytes, 0, bytes_lt, bytes_index, bytes.length);
                bytes_index += bytes.length;
                ++i6;
            }
            bytes_gte[bytes_gte.length - 1] = 0;
            bytes_lt[bytes_lt.length - 1] = 2;
            result.matched = keyMatchCount;
            result.bytes_gt = ByteToObject.lastBytes(bytes_gte);
            result.bytes_gt_include = false;
            result.bytes_lt = bytes_lt;
            result.bytes_lt_include = false;
            for (String fuhao : lastRangeJSON.keySet()) {
                Object columnObject = lastRangeJSON.get((Object)fuhao);
                byte[] bytes_object = HTableUtil.GenerateKeyBytes(lastRangeColumn, columnObject);
                byte[] bytes_inner = keyMatchCount == ColumnNames.length ? new byte[bytes_count + bytes_object.length] : new byte[bytes_count + bytes_object.length + 1];
                int bytes_index2 = 0;
                int i7 = 0;
                while (i7 < equalCount) {
                    byte[] bytes3 = (byte[])bytess.get(i7);
                    System.arraycopy(bytes3, 0, bytes_inner, bytes_index2, bytes3.length);
                    bytes_index2 += bytes3.length;
                    ++i7;
                }
                System.arraycopy(bytes_object, 0, bytes_inner, bytes_index2, bytes_object.length);
                if (keyMatchCount == ColumnNames.length) {
                    if (fuhao.equals("$lt")) {
                        result.bytes_lt = ByteToObject.lastBytes(bytes_inner);
                        result.bytes_lt_include = true;
                        continue;
                    }
                    if (fuhao.equals("$lte")) {
                        result.bytes_lt = bytes_inner;
                        result.bytes_lt_include = true;
                        continue;
                    }
                    if (fuhao.equals("$gt")) {
                        result.bytes_gt = bytes_inner;
                        result.bytes_gt_include = false;
                        continue;
                    }
                    if (!fuhao.equals("$gte")) continue;
                    result.bytes_gt = ByteToObject.lastBytes(bytes_inner);
                    result.bytes_gt_include = false;
                    continue;
                }
                if (fuhao.equals("$lt")) {
                    byte[] bbbbb = new byte[bytes_inner.length];
                    System.arraycopy(bytes_inner, 0, bbbbb, 0, bytes_inner.length);
                    bytes_inner[bytes_inner.length - 1] = 0;
                    result.bytes_lt = ByteToObject.lastBytes(bbbbb);
                    result.bytes_lt_include = true;
                    continue;
                }
                if (fuhao.equals("$lte")) {
                    bytes_inner[bytes_inner.length - 1] = 2;
                    result.bytes_lt = bytes_inner;
                    result.bytes_lt_include = false;
                    continue;
                }
                if (fuhao.equals("$gt")) {
                    bytes_inner[bytes_inner.length - 1] = 2;
                    result.bytes_gt = bytes_inner;
                    result.bytes_gt_include = false;
                    continue;
                }
                if (!fuhao.equals("$gte")) continue;
                byte[] bbbbb = new byte[bytes_inner.length];
                System.arraycopy(bytes_inner, 0, bbbbb, 0, bytes_inner.length);
                bytes_inner[bytes_inner.length - 1] = 0;
                result.bytes_gt = ByteToObject.lastBytes(bbbbb);
                result.bytes_gt_include = false;
            }
        } else {
            bytes_count = 0;
            int i8 = 0;
            while (i8 < equalCount) {
                bytes_count += ((byte[])bytess.get(i8)).length;
                ++i8;
            }
            result.matched = equalCount;
            if (equalCount == ColumnNames.length) {
                byte[] get_key = new byte[bytes_count];
                int bytes_index = 0;
                int i9 = 0;
                while (i9 < equalCount) {
                    bytes2 = (byte[])bytess.get(i9);
                    System.arraycopy(bytes2, 0, get_key, bytes_index, bytes2.length);
                    bytes_index += bytes2.length;
                    ++i9;
                }
                result.bytes_gt = ByteToObject.lastBytes(get_key);
                result.bytes_gt_include = false;
                result.bytes_lt = get_key;
                result.bytes_lt_include = true;
            } else {
                bytes_gte = new byte[bytes_count + 1];
                bytes_lt = new byte[bytes_count + 1];
                int bytes_index = 0;
                int i10 = 0;
                while (i10 < equalCount) {
                    bytes = (byte[])bytess.get(i10);
                    System.arraycopy(bytes, 0, bytes_gte, bytes_index, bytes.length);
                    System.arraycopy(bytes, 0, bytes_lt, bytes_index, bytes.length);
                    bytes_index += bytes.length;
                    ++i10;
                }
                bytes_gte[bytes_gte.length - 1] = 0;
                bytes_lt[bytes_lt.length - 1] = 2;
                result.bytes_gt = ByteToObject.lastBytes(bytes_gte);
                result.bytes_gt_include = true;
                result.bytes_lt = bytes_lt;
                result.bytes_lt_include = false;
            }
        }
        result.otherCriteria = otherCriteria;
        for (String key : otherCriteria.keySet()) {
            Object columnObject = otherCriteria.get((Object)key);
            ZillionTableColumn column = schema.ColumnMap.get(key);
            if (columnObject == null) {
                SingleColumnValueFilter filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.EQUAL, new byte[0]);
                filter.setFilterIfMissing(true);
                result.valueFilterList.add((Filter)filter);
                continue;
            }
            if (columnObject instanceof JSONObject) {
                JSONObject columnJSON = (JSONObject)columnObject;
                if (columnJSON.containsKey((Object)"in")) {
                    JSONArray inArray = (JSONArray)columnJSON.get((Object)"in");
                    FilterList.Operator operator = FilterList.Operator.MUST_PASS_ONE;
                    ArrayList<SingleColumnValueFilter> rowFilters = new ArrayList<SingleColumnValueFilter>();
                    int i11 = 0;
                    while (i11 < inArray.size()) {
                        Object inValue = inArray.get(i11);
                        byte[] bytes_object = HTableUtil.GenerateBytes(column, inValue);
                        if ((column.Type == ZillionTableColumnEnum.STRING || column.Type == ZillionTableColumnEnum.COMPRESSSTRING) && bytes_object != null && bytes_object.length == 0) {
                            byte[] column_bytesInner = new byte[]{0};
                            bytes_object = column_bytesInner;
                        }
                        rowFilters.add(new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.EQUAL, bytes_object));
                        ++i11;
                    }
                    FilterList filter = new FilterList(operator, rowFilters);
                    result.valueFilterList.add((Filter)filter);
                    continue;
                }
                if (columnJSON.containsKey((Object)"$regex")) {
                    String regex = (String)columnJSON.get((Object)"$regex");
                    RegexStringComparator comp = new RegexStringComparator(regex);
                    SingleColumnValueFilter filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)comp);
                    filter.setFilterIfMissing(true);
                    result.valueFilterList.add((Filter)filter);
                    continue;
                }
                for (String fuhao : columnJSON.keySet()) {
                    SingleColumnValueFilter filter;
                    byte[] bytes_object = HTableUtil.GenerateBytes(column, columnJSON.get((Object)fuhao));
                    if ((column.Type == ZillionTableColumnEnum.STRING || column.Type == ZillionTableColumnEnum.COMPRESSSTRING) && bytes_object != null && bytes_object.length == 0) {
                        byte[] column_bytesInner = new byte[]{0};
                        bytes_object = column_bytesInner;
                    }
                    if (fuhao.equals("$lt")) {
                        filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.LESS, bytes_object);
                        filter.setFilterIfMissing(true);
                        result.valueFilterList.add((Filter)filter);
                        continue;
                    }
                    if (fuhao.equals("$lte")) {
                        filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.LESS_OR_EQUAL, bytes_object);
                        filter.setFilterIfMissing(true);
                        result.valueFilterList.add((Filter)filter);
                        continue;
                    }
                    if (fuhao.equals("$gt")) {
                        filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.GREATER, bytes_object);
                        filter.setFilterIfMissing(true);
                        result.valueFilterList.add((Filter)filter);
                        continue;
                    }
                    if (!fuhao.equals("$gte")) continue;
                    filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.GREATER_OR_EQUAL, bytes_object);
                    filter.setFilterIfMissing(true);
                    result.valueFilterList.add((Filter)filter);
                }
                continue;
            }
            byte[] bytes_object = HTableUtil.GenerateBytes(column, columnObject);
            if ((column.Type == ZillionTableColumnEnum.STRING || column.Type == ZillionTableColumnEnum.COMPRESSSTRING) && bytes_object != null && bytes_object.length == 0) {
                byte[] column_bytesInner = new byte[]{0};
                bytes_object = column_bytesInner;
            }
            SingleColumnValueFilter filter = new SingleColumnValueFilter(ByteToObject.toBytes("f"), ByteToObject.toBytes(key), CompareFilter.CompareOp.EQUAL, bytes_object);
            filter.setFilterIfMissing(true);
            result.valueFilterList.add((Filter)filter);
        }
        return result;
    }
}

