/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.SqlStrictParseException;
import org.apache.ignite.internal.sql.command.SqlAlterTableCommand;
import org.apache.ignite.internal.sql.command.SqlAlterUserCommand;
import org.apache.ignite.internal.sql.command.SqlBulkLoadCommand;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlCreateIndexCommand;
import org.apache.ignite.internal.sql.command.SqlCreateUserCommand;
import org.apache.ignite.internal.sql.command.SqlDropIndexCommand;
import org.apache.ignite.internal.sql.command.SqlDropUserCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.jetbrains.annotations.Nullable;

public class SqlParser {
    private final String schemaName;
    private final SqlLexer lex;

    public SqlParser(@Nullable String schemaName, String sql) {
        this.schemaName = schemaName;
        this.lex = new SqlLexer(sql);
    }

    public SqlCommand nextCommand() {
        SqlCommand cmd = this.nextCommand0();
        if (cmd != null && cmd.schemaName() == null) {
            cmd.schemaName(this.schemaName);
        }
        return cmd;
    }

    private SqlCommand nextCommand0() {
        block20: while (true) {
            if (!this.lex.shift()) {
                return null;
            }
            switch (this.lex.tokenType()) {
                case SEMICOLON: {
                    continue block20;
                }
                case DEFAULT: {
                    SqlCommand cmd = null;
                    switch (this.lex.token()) {
                        case "CREATE": {
                            cmd = this.processCreate();
                            break;
                        }
                        case "DROP": {
                            cmd = this.processDrop();
                            break;
                        }
                        case "COPY": {
                            try {
                                cmd = this.processCopy();
                                break;
                            }
                            catch (SqlParseException e) {
                                throw new SqlStrictParseException(e);
                            }
                        }
                        case "SET": {
                            cmd = this.processSet();
                            break;
                        }
                        case "ALTER": {
                            cmd = this.processAlter();
                        }
                    }
                    if (cmd != null) {
                        if (this.lex.shift() && this.lex.tokenType() != SqlLexerTokenType.SEMICOLON) {
                            throw SqlParserUtils.errorUnexpectedToken(this.lex);
                        }
                        return cmd;
                    }
                    throw SqlParserUtils.errorUnexpectedToken(this.lex, "CREATE", "DROP", "ALTER", "COPY", "SET");
                }
            }
            break;
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex);
    }

    private SqlCommand processSet() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            switch (this.lex.token()) {
                case "STREAMING": {
                    return new SqlSetStreamingCommand().parse(this.lex);
                }
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "STREAMING");
    }

    private SqlCommand processCopy() {
        return new SqlBulkLoadCommand().parse(this.lex);
    }

    private SqlCommand processCreate() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            SqlCommand cmd = null;
            switch (this.lex.token()) {
                case "INDEX": {
                    cmd = new SqlCreateIndexCommand();
                    break;
                }
                case "SPATIAL": {
                    if (this.lex.shift() && SqlParserUtils.matchesKeyword(this.lex, "INDEX")) {
                        cmd = new SqlCreateIndexCommand().spatial(true);
                        break;
                    }
                    throw SqlParserUtils.errorUnexpectedToken(this.lex, "INDEX");
                }
                case "USER": {
                    cmd = new SqlCreateUserCommand();
                }
            }
            if (cmd != null) {
                return cmd.parse(this.lex);
            }
            SqlParserUtils.errorUnsupportedIfMatchesKeyword((SqlLexerToken)this.lex, "HASH", "PRIMARY", "UNIQUE");
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "INDEX", "SPATIAL");
    }

    private SqlCommand processDrop() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            SqlCommand cmd = null;
            switch (this.lex.token()) {
                case "INDEX": {
                    cmd = new SqlDropIndexCommand();
                    break;
                }
                case "USER": {
                    cmd = new SqlDropUserCommand();
                }
            }
            if (cmd != null) {
                return cmd.parse(this.lex);
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "INDEX");
    }

    private SqlCommand processAlter() {
        if (this.lex.shift() && this.lex.tokenType() == SqlLexerTokenType.DEFAULT) {
            SqlCommand cmd = null;
            switch (this.lex.token()) {
                case "TABLE": {
                    cmd = new SqlAlterTableCommand();
                    break;
                }
                case "USER": {
                    cmd = new SqlAlterUserCommand();
                }
            }
            if (cmd != null) {
                return cmd.parse(this.lex);
            }
        }
        throw SqlParserUtils.errorUnexpectedToken(this.lex, "TABLE");
    }
}

