/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql;

import org.apache.ignite.internal.sql.SqlLexerLookAheadToken;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParseException;

public class SqlLexer
implements SqlLexerToken {
    private final String sql;
    private final char[] inputChars;
    private int pos;
    private int tokenPos;
    private String token;
    private SqlLexerTokenType tokenTyp;

    public SqlLexer(String sql) {
        assert (sql != null);
        this.sql = sql;
        this.inputChars = new char[sql.length() + 1];
        for (int i = 0; i < sql.length(); ++i) {
            this.inputChars[i] = sql.charAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlLexerToken lookAhead() {
        int pos0 = this.pos;
        String token0 = this.token;
        int tokenPos0 = this.tokenPos;
        SqlLexerTokenType tokenTyp0 = this.tokenTyp;
        try {
            if (this.shift()) {
                SqlLexerLookAheadToken sqlLexerLookAheadToken = new SqlLexerLookAheadToken(this.sql, this.token, this.tokenPos, this.tokenTyp);
                return sqlLexerLookAheadToken;
            }
            SqlLexerLookAheadToken sqlLexerLookAheadToken = new SqlLexerLookAheadToken(this.sql, null, this.tokenPos, SqlLexerTokenType.EOF);
            return sqlLexerLookAheadToken;
        }
        finally {
            this.pos = pos0;
            this.token = token0;
            this.tokenPos = tokenPos0;
            this.tokenTyp = tokenTyp0;
        }
    }

    public boolean shift() {
        block6: while (!this.eod()) {
            int tokenStartPos0 = this.pos;
            String token0 = null;
            SqlLexerTokenType tokenTyp0 = null;
            char c = this.inputChars[this.pos++];
            switch (c) {
                case '-': {
                    char c1;
                    if (this.inputChars[this.pos] == '-') {
                        ++this.pos;
                        while (!this.eod() && (c1 = this.inputChars[this.pos]) != '\n' && c1 != '\r') {
                            ++this.pos;
                        }
                        break;
                    }
                    token0 = "-";
                    tokenTyp0 = SqlLexerTokenType.MINUS;
                    break;
                }
                case '\"': {
                    char c1;
                    do {
                        if (this.eod()) {
                            throw new SqlParseException(this.sql, tokenStartPos0, 1001, "Unclosed quoted identifier.");
                        }
                        c1 = this.inputChars[this.pos];
                        ++this.pos;
                    } while (c1 != '\"');
                    token0 = this.sql.substring(tokenStartPos0 + 1, this.pos - 1);
                    tokenTyp0 = SqlLexerTokenType.QUOTED;
                    break;
                }
                case '\'': {
                    char c1;
                    while (true) {
                        if (this.eod()) {
                            throw new SqlParseException(this.sql, tokenStartPos0, 1001, "Unclosed string constant.");
                        }
                        c1 = this.inputChars[this.pos];
                        ++this.pos;
                        if (c1 != '\'') continue;
                        char c2 = this.inputChars[this.pos];
                        if (c2 != '\'') break;
                        ++this.pos;
                    }
                    token0 = this.sql.substring(tokenStartPos0 + 1, this.pos - 1).replaceAll("''", "'");
                    tokenTyp0 = SqlLexerTokenType.STRING;
                    break;
                }
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case ';': {
                    token0 = Character.toString(c);
                    tokenTyp0 = SqlLexerTokenType.forChar(c);
                    break;
                }
                default: {
                    char c1;
                    if (c <= ' ' || Character.isSpaceChar(c)) continue block6;
                    while (!this.eod() && Character.isJavaIdentifierPart(c1 = this.inputChars[this.pos])) {
                        ++this.pos;
                    }
                    token0 = this.sql.substring(tokenStartPos0, this.pos).toUpperCase();
                    tokenTyp0 = SqlLexerTokenType.DEFAULT;
                }
            }
            if (tokenTyp0 == null) continue;
            this.token = token0;
            this.tokenPos = tokenStartPos0;
            this.tokenTyp = tokenTyp0;
            return true;
        }
        this.token = null;
        this.tokenPos = this.pos;
        this.tokenTyp = SqlLexerTokenType.EOF;
        return false;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public String token() {
        return this.token;
    }

    @Override
    public char tokenFirstChar() {
        assert (this.tokenTyp != SqlLexerTokenType.EOF);
        return this.token.charAt(0);
    }

    @Override
    public int tokenPosition() {
        return this.tokenPos;
    }

    @Override
    public SqlLexerTokenType tokenType() {
        return this.tokenTyp;
    }

    private boolean eod() {
        return this.pos == this.inputChars.length - 1;
    }
}

