/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class IgfsModeResolver
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private static final int MAX_PATH_CACHE = 1000;
    private IgfsMode dfltMode;
    private List<T2<IgfsPath, IgfsMode>> modes;
    private Map<IgfsPath, IgfsMode> modesCache;
    private Set<IgfsPath> dualParentsWithPrimaryChildren;

    public IgfsModeResolver() {
    }

    public IgfsModeResolver(IgfsMode dfltMode, @Nullable ArrayList<T2<IgfsPath, IgfsMode>> modes) throws IgniteCheckedException {
        assert (dfltMode != null);
        this.dfltMode = dfltMode;
        this.dualParentsWithPrimaryChildren = new HashSet<IgfsPath>();
        this.modes = IgfsUtils.preparePathModes(dfltMode, modes, this.dualParentsWithPrimaryChildren);
        if (modes != null) {
            this.modesCache = new GridBoundedConcurrentLinkedHashMap<IgfsPath, IgfsMode>(1000);
        }
    }

    public IgfsMode resolveMode(IgfsPath path) {
        assert (path != null);
        if (this.modes == null) {
            return this.dfltMode;
        }
        IgfsMode mode = this.modesCache.get(path);
        if (mode == null) {
            for (T2<IgfsPath, IgfsMode> entry : this.modes) {
                if (!F.eq(path, entry.getKey()) && !path.isSubDirectoryOf((IgfsPath)entry.getKey())) continue;
                mode = (IgfsMode)((Object)entry.getValue());
                break;
            }
            if (mode == null) {
                mode = this.dfltMode;
            }
            this.modesCache.put(path, mode);
        }
        return mode;
    }

    public boolean hasPrimaryChild(IgfsPath path) {
        return this.dualParentsWithPrimaryChildren.contains(path);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.dfltMode);
        if (this.modes != null) {
            out.writeBoolean(true);
            out.writeInt(this.modes.size());
            for (T2<IgfsPath, IgfsMode> pathMode : this.modes) {
                assert (pathMode.getKey() != null);
                ((IgfsPath)pathMode.getKey()).writeExternal(out);
                U.writeEnum(out, (Enum)pathMode.getValue());
            }
        } else {
            out.writeBoolean(false);
        }
        if (!F.isEmpty(this.dualParentsWithPrimaryChildren)) {
            out.writeBoolean(true);
            out.writeInt(this.dualParentsWithPrimaryChildren.size());
            for (IgfsPath p : this.dualParentsWithPrimaryChildren) {
                p.writeExternal(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size;
        this.dfltMode = IgfsMode.fromOrdinal(in.readByte());
        if (in.readBoolean()) {
            size = in.readInt();
            this.modes = new ArrayList<T2<IgfsPath, IgfsMode>>(size);
            for (i = 0; i < size; ++i) {
                IgfsPath path = IgfsUtils.readPath(in);
                this.modes.add(new T2<IgfsPath, IgfsMode>(path, IgfsMode.fromOrdinal(in.readByte())));
            }
            this.modesCache = new GridBoundedConcurrentLinkedHashMap<IgfsPath, IgfsMode>(1000);
        }
        this.dualParentsWithPrimaryChildren = new HashSet<IgfsPath>();
        if (in.readBoolean()) {
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                this.dualParentsWithPrimaryChildren.add(IgfsUtils.readPath(in));
            }
        }
    }
}

