/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.internal.processors.hadoop.HadoopLocations;
import org.apache.ignite.internal.util.typedef.F;

public class HadoopClasspathUtils {
    public static final String PREFIX = "HADOOP_PREFIX";
    public static final String HOME = "HADOOP_HOME";
    public static final String COMMON_HOME = "HADOOP_COMMON_HOME";
    public static final String HDFS_HOME = "HADOOP_HDFS_HOME";
    public static final String MAPRED_HOME = "HADOOP_MAPRED_HOME";
    public static final String HADOOP_USER_LIBS = "HADOOP_USER_LIBS";
    private static final String EMPTY_STR = "";

    public static List<URL> classpathForClassLoader() throws IOException {
        ArrayList<URL> res = new ArrayList<URL>();
        for (SearchDirectory dir : HadoopClasspathUtils.classpathDirectories()) {
            for (File file : dir.files()) {
                try {
                    res.add(file.toURI().toURL());
                }
                catch (MalformedURLException ignored) {
                    throw new IOException("Failed to convert file path to URL: " + file.getPath());
                }
            }
        }
        return res;
    }

    public static HadoopLocations locations() throws IOException {
        String hadoopHome = HadoopClasspathUtils.systemOrEnv(PREFIX, HadoopClasspathUtils.systemOrEnv(HOME, EMPTY_STR));
        String commonHome = HadoopClasspathUtils.systemOrEnv(COMMON_HOME, EMPTY_STR);
        String hdfsHome = HadoopClasspathUtils.systemOrEnv(HDFS_HOME, EMPTY_STR);
        String mapredHome = HadoopClasspathUtils.systemOrEnv(MAPRED_HOME, EMPTY_STR);
        if (!(HadoopClasspathUtils.isEmpty(commonHome) && HadoopClasspathUtils.isEmpty(hdfsHome) && HadoopClasspathUtils.isEmpty(mapredHome))) {
            HadoopLocations res = new HadoopLocations(hadoopHome, commonHome, hdfsHome, mapredHome);
            if (res.valid()) {
                return res;
            }
            throw new IOException("Failed to resolve Hadoop classpath because some environment variables are either undefined or point to nonexistent directories [[env=HADOOP_COMMON_HOME, value=" + commonHome + ", exists=" + res.commonExists() + "], " + "[env=" + HDFS_HOME + ", value=" + hdfsHome + ", exists=" + res.hdfsExists() + "], " + "[env=" + MAPRED_HOME + ", value=" + mapredHome + ", exists=" + res.mapredExists() + "]]");
        }
        if (!HadoopClasspathUtils.isEmpty(hadoopHome)) {
            if (!HadoopClasspathUtils.exists(hadoopHome)) {
                throw new IOException("Failed to resolve Hadoop classpath because HADOOP_HOME environment variable points to nonexistent directory: " + hadoopHome);
            }
            HadoopLocations res = new HadoopLocations(hadoopHome, hadoopHome + "/share/hadoop/common", hadoopHome + "/share/hadoop/hdfs", hadoopHome + "/share/hadoop/mapreduce");
            if (res.valid()) {
                return res;
            }
            res = new HadoopLocations(hadoopHome, hadoopHome, hadoopHome + "/../hadoop-hdfs", hadoopHome + "/../hadoop-mapreduce");
            if (res.valid()) {
                return res;
            }
            res = new HadoopLocations(hadoopHome, hadoopHome, hadoopHome + "/../hadoop-hdfs-client", hadoopHome + "/../hadoop-mapreduce-client");
            if (res.valid()) {
                return res;
            }
            throw new IOException("Failed to resolve Hadoop classpath because HADOOP_HOME environment variable is either invalid or points to non-standard Hadoop distribution: " + hadoopHome);
        }
        throw new IOException("Failed to resolve Hadoop classpath (please define HADOOP_HOME environment variable and point it to your Hadoop distribution).");
    }

    private static Collection<SearchDirectory> classpathDirectories() throws IOException {
        HadoopLocations loc = HadoopClasspathUtils.locations();
        ArrayList<SearchDirectory> res = new ArrayList<SearchDirectory>();
        res.add(new SearchDirectory(new File(loc.common(), "lib"), (DirectoryFilter)AcceptAllDirectoryFilter.INSTANCE));
        res.add(new SearchDirectory(new File(loc.hdfs(), "lib"), (DirectoryFilter)AcceptAllDirectoryFilter.INSTANCE));
        res.add(new SearchDirectory(new File(loc.mapred(), "lib"), (DirectoryFilter)AcceptAllDirectoryFilter.INSTANCE));
        res.add(new SearchDirectory(new File(loc.common()), (DirectoryFilter)new PrefixDirectoryFilter("hadoop-common-")));
        res.add(new SearchDirectory(new File(loc.common()), (DirectoryFilter)new PrefixDirectoryFilter("hadoop-auth-")));
        res.add(new SearchDirectory(new File(loc.hdfs()), (DirectoryFilter)new PrefixDirectoryFilter("hadoop-hdfs-")));
        res.add(new SearchDirectory(new File(loc.mapred()), (DirectoryFilter)new PrefixDirectoryFilter("hadoop-mapreduce-client-common")));
        res.add(new SearchDirectory(new File(loc.mapred()), (DirectoryFilter)new PrefixDirectoryFilter("hadoop-mapreduce-client-core")));
        res.addAll(HadoopClasspathUtils.parseUserLibs());
        return res;
    }

    public static Collection<SearchDirectory> parseUserLibs() throws IOException {
        return HadoopClasspathUtils.parseUserLibs(HadoopClasspathUtils.systemOrEnv(HADOOP_USER_LIBS, null));
    }

    public static Collection<SearchDirectory> parseUserLibs(String str) throws IOException {
        LinkedList<SearchDirectory> res = new LinkedList<SearchDirectory>();
        if (!HadoopClasspathUtils.isEmpty(str)) {
            String[] tokens;
            for (String token : tokens = HadoopClasspathUtils.normalize(str).split(File.pathSeparator)) {
                if (HadoopClasspathUtils.isEmpty(token)) continue;
                File file = new File(token);
                File dir = file.getParentFile();
                if (token.endsWith("*")) {
                    assert (dir != null);
                    res.add(new SearchDirectory(dir, AcceptAllDirectoryFilter.INSTANCE, false));
                    continue;
                }
                if (dir == null) continue;
                res.add(new SearchDirectory(dir, new ExactDirectoryFilter(file.getName()), false));
            }
        }
        return res;
    }

    private static String systemOrEnv(String name, String dflt) {
        String res = System.getProperty(name);
        if (res == null) {
            res = System.getenv(name);
        }
        return res != null ? res : dflt;
    }

    public static boolean exists(String path) {
        if (F.isEmpty(path)) {
            return false;
        }
        Path p = Paths.get(path, new String[0]);
        return Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0]) && Files.isReadable(p);
    }

    private static boolean isEmpty(String val) {
        return val == null || val.isEmpty();
    }

    private static String normalize(String str) {
        assert (str != null);
        return str.trim().toLowerCase();
    }

    public static class ExactDirectoryFilter
    implements DirectoryFilter {
        private final String name;

        public ExactDirectoryFilter(String name) {
            this.name = HadoopClasspathUtils.normalize(name);
        }

        @Override
        public boolean test(String name) {
            return HadoopClasspathUtils.normalize(name).equals(this.name);
        }
    }

    public static class PrefixDirectoryFilter
    implements DirectoryFilter {
        private final String prefix;

        public PrefixDirectoryFilter(String prefix) {
            assert (prefix != null);
            this.prefix = HadoopClasspathUtils.normalize(prefix);
        }

        @Override
        public boolean test(String name) {
            return HadoopClasspathUtils.normalize(name).startsWith(this.prefix);
        }
    }

    public static class AcceptAllDirectoryFilter
    implements DirectoryFilter {
        public static final AcceptAllDirectoryFilter INSTANCE = new AcceptAllDirectoryFilter();

        @Override
        public boolean test(String name) {
            return true;
        }
    }

    public static interface DirectoryFilter {
        public boolean test(String var1);
    }

    public static class SearchDirectory {
        private final File dir;
        private final DirectoryFilter filter;
        private final boolean strict;

        private SearchDirectory(File dir, DirectoryFilter filter) throws IOException {
            this(dir, filter, true);
        }

        private SearchDirectory(File dir, DirectoryFilter filter, boolean strict) throws IOException {
            this.dir = dir;
            this.filter = filter;
            this.strict = strict;
            if (strict && !HadoopClasspathUtils.exists(dir.getAbsolutePath())) {
                throw new IOException("Directory cannot be read: " + dir.getAbsolutePath());
            }
        }

        public File[] files() throws IOException {
            File[] files = this.dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return filter.test(name);
                }
            });
            if (files == null) {
                if (this.strict) {
                    throw new IOException("Failed to get directory files [dir=" + this.dir + ']');
                }
                return new File[0];
            }
            return files;
        }
    }
}

