/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.ratemetrics;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;

public class HitRateMetrics {
    private static final int TAG_OFFSET = 56;
    private static final long NO_TAG_MASK = 0xFFFFFFFFFFFFFFL;
    private final int rateTimeInterval;
    private final int size;
    private volatile AtomicLongArray taggedCounters;
    private volatile AtomicLongArray lastHitTimes;

    public HitRateMetrics(int rateTimeInterval, int size) {
        A.ensure(rateTimeInterval > 0, "should be positive");
        A.ensure(size > 1, "minimum is 2");
        this.rateTimeInterval = rateTimeInterval;
        this.size = size;
        this.taggedCounters = new AtomicLongArray(size);
        this.lastHitTimes = new AtomicLongArray(size);
    }

    public void onHit() {
        this.onHits(1L);
    }

    public void onHits(long hits) {
        long curTs = U.currentTimeMillis();
        int curPos = this.position(curTs);
        this.clearIfObsolete(curTs, curPos);
        this.lastHitTimes.set(curPos, curTs);
        this.taggedCounters.addAndGet(curPos, hits);
    }

    public long getRate() {
        long curTs = U.currentTimeMillis();
        long sum = 0L;
        for (int i = 0; i < this.size; ++i) {
            this.clearIfObsolete(curTs, i);
            sum += HitRateMetrics.untag(this.taggedCounters.get(i));
        }
        return sum;
    }

    public void clear() {
        this.taggedCounters = new AtomicLongArray(this.size);
        this.lastHitTimes = new AtomicLongArray(this.size);
    }

    private void clearIfObsolete(long curTs, int i) {
        long cur = this.taggedCounters.get(i);
        byte curTag = HitRateMetrics.getTag(cur);
        long lastTs = this.lastHitTimes.get(i);
        if (this.isObsolete(curTs, lastTs) && this.taggedCounters.compareAndSet(i, cur, HitRateMetrics.taggedLongZero(curTag = (byte)(curTag + 1)))) {
            this.lastHitTimes.set(i, curTs);
        }
    }

    private boolean isObsolete(long curTs, long lastHitTime) {
        return curTs - lastHitTime > (long)(this.rateTimeInterval * (this.size - 1) / this.size);
    }

    private int position(long time) {
        return (int)(time % (long)this.rateTimeInterval * (long)this.size) / this.rateTimeInterval;
    }

    private static long taggedLongZero(byte tag) {
        return (long)tag << 56;
    }

    private static long untag(long l) {
        return l & 0xFFFFFFFFFFFFFFL;
    }

    private static byte getTag(long taggedLong) {
        return (byte)(taggedLong >> 56);
    }
}

