/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONObject;
import com.sagacloud.extend.dao_data.ImplDao_fjd_statinst;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.core.Dao_dataManager;
import com.sagacloud.util.compute_engine.core.IDao_data;
import com.sagacloud.util.compute_engine.core.IDao_log;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DateUtil;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_statinst;
import com.sagacloud.util.compute_engine.util.Parser_time_period;
import com.sagacloud.util.compute_engine.util.TimeSpan;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Compute_stat_Inst {
    public static Map<String, List<TimeSpan>> Compute(String object_sign, String instance_name, List<CoreInput> inputList, List<CoreOutput> outputList, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        CoreOutput output;
        int i;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput input : inputList) {
            inputMap.put(input.input_sign, input);
        }
        HashMap inputIntervalTimeSpanMap = new HashMap();
        HashMap<String, List<TimeSpan>> outputTimeSpanMap = new HashMap<String, List<TimeSpan>>();
        for (i = 0; i < outputList.size(); ++i) {
            output = outputList.get(i);
            ArrayList<TimeSpan> timeSpanList = new ArrayList<TimeSpan>();
            for (String input_sign : output.var_signMap.keySet()) {
                CoreInput input = (CoreInput)inputMap.get(input_sign);
                if (!inputTimeSpanMap.containsKey(input_sign)) continue;
                List<TimeSpan> timeSpanList_input = inputTimeSpanMap.get(input_sign);
                DateUtil.Instance().ConvertAndMergeTo(timeSpanList_input, output.var_stepSpanMap.get(input_sign), output.time_period, input.data_class, timeSpanList);
            }
            DateUtil.Instance().Limit(timeSpanList, output.time_begin, DateUtil.Instance().GetDate_offset(output.time_end, output.time_period, -1));
            List<TimeSpan> timeSpanList_finish = outputdetailListMap.get(output.output_sign);
            for (int ii = timeSpanList.size() - 1; ii >= 0; --ii) {
                TimeSpan timeSpan = (TimeSpan)timeSpanList.get(ii);
                boolean finish = false;
                if (timeSpanList_finish != null) {
                    for (TimeSpan timeSpanInner : timeSpanList_finish) {
                        if (timeSpanInner.timefrom.getTime() != timeSpan.timefrom.getTime()) continue;
                        finish = true;
                        break;
                    }
                }
                if (!finish) continue;
                timeSpanList.remove(ii);
            }
            outputTimeSpanMap.put(output.output_sign + "_" + sdf.format(output.time_begin), timeSpanList);
            for (String input_sign : output.var_signMap.keySet()) {
                Map IntervalTimeSpanMap;
                if (!inputIntervalTimeSpanMap.containsKey(input_sign)) {
                    inputIntervalTimeSpanMap.put(input_sign, new HashMap());
                }
                if (!(IntervalTimeSpanMap = (Map)inputIntervalTimeSpanMap.get(input_sign)).containsKey(output.time_period)) {
                    IntervalTimeSpanMap.put(output.time_period, new ArrayList());
                }
                List timeSpanList_input = (List)IntervalTimeSpanMap.get(output.time_period);
                DateUtil.Instance().MergeTo(timeSpanList, output.time_period, output.var_stepSpanMap.get(input_sign), timeSpanList_input);
            }
        }
        for (i = 0; i < outputList.size(); ++i) {
            output = outputList.get(i);
            String time_period = output.time_period;
            List timeSpanList = (List)outputTimeSpanMap.get(output.output_sign + "_" + sdf.format(output.time_begin));
            IDao_data dao_fjd_near_or_ori = ConstantCE.stat_inst_use_ori ? Dao_dataManager.Instance().Get("ori") : Dao_dataManager.Instance().Get("fjd_near");
            ImplDao_fjd_statinst dao_fjd_statinst = (ImplDao_fjd_statinst)Dao_dataManager.Instance().Get("fjd_statinst");
            Compute_stat_Inst.Stat_inst(dao_fjd_near_or_ori, dao_fjd_statinst, output.dao_key, timeSpanList, time_period);
            for (TimeSpan timeSpan : timeSpanList) {
                JSONObject InsertObject = new JSONObject();
                InsertObject.put("object_sign", (Object)object_sign);
                InsertObject.put("instance_name", (Object)instance_name);
                InsertObject.put("compute_round", (Object)compute_round);
                InsertObject.put("output_sign", (Object)output.output_sign);
                InsertObject.put("valid_time_from", (Object)sdf.format(timeSpan.timefrom));
                InsertObject.put("valid_time_to", (Object)sdf.format(timeSpan.timeto));
                InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
                dao_log.InsertData(InsertObject);
            }
        }
        return outputTimeSpanMap;
    }

    private static void Stat_inst(IDao_data dao_fjd_near_or_ori, ImplDao_fjd_statinst dao_fjd_statinst, JSONObject dao_key, List<TimeSpan> timeSpanList, String time_period) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (timeSpanList.size() == 0) {
            return;
        }
        List<String> biggerList = Parser_time_period.getBigger("1y", time_period);
        for (int i = biggerList.size() - 1; i >= 2; --i) {
            biggerList.remove(i);
        }
        ArrayList<ArrayList<TimeSpan>> biggerTimeSpanList = new ArrayList<ArrayList<TimeSpan>>();
        for (String bigger : biggerList) {
            ArrayList<TimeSpan> bts = new ArrayList<TimeSpan>();
            DateUtil.Instance().ConvertAndMergeTo(timeSpanList, bigger, "consumption", bts);
            biggerTimeSpanList.add(bts);
        }
        List biggestTimeSpanList = (List)biggerTimeSpanList.get(biggerTimeSpanList.size() - 1);
        String biggest = biggerList.get(biggerList.size() - 1);
        Date stat_from = ((TimeSpan)biggestTimeSpanList.get((int)0)).timefrom;
        Date stat_to = DateUtil.Instance().GetDate_offset(((TimeSpan)biggestTimeSpanList.get((int)(biggestTimeSpanList.size() - 1))).timeto, biggest, 1);
        List<DoubleTimeObject> dataList = dao_fjd_near_or_ori.GetDataListGteLte(dao_key, time_period, stat_from, stat_to, false);
        for (int index = 0; index < biggerList.size(); ++index) {
            String bigger = biggerList.get(index);
            List bts = (List)biggerTimeSpanList.get(index);
            for (TimeSpan biggerTimeSpan : bts) {
                ArrayList<DoubleTimeObject_statinst> outputDataList = new ArrayList<DoubleTimeObject_statinst>();
                int tmp_data_index = 0;
                Date tmpDate = biggerTimeSpan.timefrom;
                while (tmpDate.getTime() <= biggerTimeSpan.timeto.getTime()) {
                    Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, bigger, 1);
                    ArrayList<DoubleTimeObject> valueList = new ArrayList<DoubleTimeObject>();
                    for (int index_data = tmp_data_index; index_data < dataList.size(); ++index_data) {
                        tmp_data_index = index_data;
                        DoubleTimeObject data = dataList.get(index_data);
                        if (data.data_time.getTime() < tmpDate.getTime()) continue;
                        if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                        valueList.add(data);
                    }
                    if (valueList.size() > 0) {
                        DoubleTimeObject value_max = null;
                        DoubleTimeObject value_min = null;
                        double value_total = 0.0;
                        int value_count = 0;
                        for (DoubleTimeObject value : valueList) {
                            if (value.data_value != null) {
                                value_total += value.data_value.doubleValue();
                                ++value_count;
                            }
                            if (value_max == null) {
                                value_max = value;
                            } else if (value.data_value != null && (value_max.data_value == null || value_max.data_value < value.data_value)) {
                                value_max = value;
                            }
                            if (value_min == null) {
                                value_min = value;
                                continue;
                            }
                            if (value.data_value == null || value_min.data_value != null && !(value_min.data_value > value.data_value)) continue;
                            value_min = value;
                        }
                        DoubleTimeObject_statinst rate = new DoubleTimeObject_statinst();
                        rate.data_time = tmpDate;
                        rate.data_flag = 0L;
                        rate.data_count = value_count;
                        rate.data_avg = value_count > 0 ? Double.valueOf(value_total / (double)value_count) : null;
                        rate.data_max = value_max.data_value;
                        rate.time_max = sdf.format(value_max.data_time);
                        rate.data_min = value_min.data_value;
                        rate.time_min = sdf.format(value_min.data_time);
                        outputDataList.add(rate);
                    }
                    tmpDate = tmpDateNext;
                }
                dao_fjd_statinst.DeleteDataListGteLte_statinst(dao_key, bigger, biggerTimeSpan.timefrom, biggerTimeSpan.timeto);
                ConstantCE.SleepBetweenDeleteAndInsert();
                dao_fjd_statinst.InsertDataListGteLte_statinst(dao_key, bigger, outputDataList);
            }
        }
    }
}

