/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.extend.dao_data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.core.AnnotationDescription;
import com.sagacloud.util.compute_engine.core.IDao_data;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zillion.util.json.FastJsonUtil;

@AnnotationDescription(value="dao_data")
public class ImplDao_fjd_1
implements IDao_data {
    IZillionAgent agent;
    String database_name;
    String table_name;
    String dao_type = "fjd_1";

    @Override
    public void Initialize(IZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
        this.table_name = "fjd_1_near";
    }

    @Override
    public String GetName() {
        return this.dao_type;
    }

    @Override
    public List<DoubleTimeObject> GetDataListGteLte(JSONObject dao_key, String time_period, Date time_from, Date time_to, boolean GteLte) throws Exception {
        ArrayList<DoubleTimeObject> result = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String meter = (String)dao_key.get((Object)"meter");
        long funcid = FastJsonUtil.getLong((JSONObject)dao_key, (String)"funcid");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("meter", (Object)meter);
        Criteria.put("funcid", (Object)funcid);
        if (!ConstantCE.time_period_seperate) {
            Criteria.put("time_period", (Object)time_period);
        }
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time_from));
        if (GteLte) {
            range.put("$lte", (Object)sdf.format(time_to));
        } else {
            range.put("$lt", (Object)sdf.format(time_to));
        }
        Criteria.put("data_time", (Object)range);
        String table_name_query = ConstantCE.time_period_seperate ? this.table_name + "_" + time_period : this.table_name;
        JSONArray resultContent = QueryUtil.select(this.agent, this.database_name, table_name_query, Criteria);
        ArrayList<DoubleTimeObject> dataList = new ArrayList<DoubleTimeObject>();
        for (int ii = 0; ii < resultContent.size(); ++ii) {
            JSONObject computelog = (JSONObject)resultContent.get(ii);
            DoubleTimeObject data = new DoubleTimeObject();
            data.data_time = sdf.parse((String)computelog.get((Object)"data_time"));
            data.data_value = (Double)computelog.get((Object)"data_value");
            dataList.add(data);
        }
        result = dataList;
        return result;
    }

    @Override
    public void InsertDataListGteLte(JSONObject dao_key, String time_period, List<DoubleTimeObject> outputDataList) throws Exception {
        if (ConstantCE.time_period_seperate_save_two || !ConstantCE.time_period_seperate) {
            this.InsertDataListGteLte(false, dao_key, time_period, outputDataList);
        }
        if (ConstantCE.time_period_seperate_save_two || ConstantCE.time_period_seperate) {
            this.InsertDataListGteLte(true, dao_key, time_period, outputDataList);
        }
    }

    @Override
    public void DeleteDataListGteLte(JSONObject dao_key, String time_period, Date time_from, Date time_to) throws Exception {
        if (ConstantCE.time_period_seperate_save_two || !ConstantCE.time_period_seperate) {
            this.DeleteDataListGteLte(false, dao_key, time_period, time_from, time_to);
        }
        if (ConstantCE.time_period_seperate_save_two || ConstantCE.time_period_seperate) {
            this.DeleteDataListGteLte(true, dao_key, time_period, time_from, time_to);
        }
    }

    private void DeleteDataListGteLte(boolean time_period_seperate, JSONObject dao_key, String time_period, Date time_from, Date time_to) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String meter = (String)dao_key.get((Object)"meter");
        long funcid = FastJsonUtil.getLong((JSONObject)dao_key, (String)"funcid");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("meter", (Object)meter);
        Criteria.put("funcid", (Object)funcid);
        if (!time_period_seperate) {
            Criteria.put("time_period", (Object)time_period);
        }
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)sdf.format(time_from));
        range.put("$lte", (Object)sdf.format(time_to));
        Criteria.put("data_time", (Object)range);
        String table_name_query = time_period_seperate ? this.table_name + "_" + time_period : this.table_name;
        QueryUtil.delete(this.agent, this.database_name, table_name_query, Criteria);
    }

    private void InsertDataListGteLte(boolean time_period_seperate, JSONObject dao_key, String time_period, List<DoubleTimeObject> outputDataList) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = (String)dao_key.get((Object)"building");
        String meter = (String)dao_key.get((Object)"meter");
        long funcid = FastJsonUtil.getLong((JSONObject)dao_key, (String)"funcid");
        JSONArray InsertObjects = new JSONArray();
        for (DoubleTimeObject data : outputDataList) {
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)building);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            if (!time_period_seperate) {
                InsertObject.put("time_period", (Object)time_period);
            }
            InsertObject.put("data_time", (Object)sdf.format(data.data_time));
            InsertObject.put("data_value", (Object)data.data_value);
            InsertObject.put("data_flag", (Object)0L);
            InsertObjects.add((Object)InsertObject);
        }
        String table_name_query = time_period_seperate ? this.table_name + "_" + time_period : this.table_name;
        QueryUtil.batch_insert(this.agent, this.database_name, table_name_query, InsertObjects);
    }
}

