/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.sagacloud.json.JSONArray;
import com.sagacloud.json.JSONObject;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionHashUtil;
import com.zillion.database.agent.ZillionMonitorUtil;
import com.zillion.database.agent.ZillionQueryCheckUtil;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryUtil;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.util.Configuration_MySQL;
import com.zillion.database.util.DataSourceConfig_c3p0;
import com.zillion.database.util.DatabaseImpl_Mix;
import com.zillion.database.util.DatabaseImpl_MySQL;
import com.zillion.database.util.ITableWrapper;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.HashObject;
import com.zillion.util.common.HashUtil;
import com.zillion.util.common.SplitUtil;
import com.zillion.util.common.SplitWrapper;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.coprocessor.ObserverCheck;
import com.zillion.util.table.SchemaParser;
import com.zillion.util.table.SchemaRepository;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaRepositoryHelper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import com.zillion.util.zk.ZKHelper;
import com.zillion.util.zk.ZKLockCEDU;
import com.zillion.util.zk.ZKLockRW;
import com.zillion.util.zk.ZKWrapper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.common.HexToByte;
import org.zillion.util.common.MemoryQueryUtil;
import org.zillion.util.common.MyException;
import org.zillion.util.json.Convertor_JSON;
import org.zillion.util.json.FastJsonReaderUtil;
import org.zillion.util.json.FastJsonUtil;
import org.zillion.util.log.LogUtil;

public class ZillionAgent
implements IZillionAgent {
    String database_type = "HBase";
    Configuration configuration;
    Configuration configuration_bak;
    Configuration_MySQL configuration_MySQL;
    String full_name = "undefined";
    SchemaRepositoryHelper helper;
    public SchemaRepositoryContainer container = new SchemaRepositoryContainer();
    public boolean print = true;
    public boolean observer = true;

    private static String generateName() {
        String result = "null";
        try {
            Random rand = new Random();
            result = String.valueOf(InetAddress.getLocalHost().getHostAddress()) + ":" + rand.nextInt(65536);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String generateName(String name) {
        String result = "null";
        try {
            result = String.valueOf(InetAddress.getLocalHost().getHostAddress()) + ":" + name;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ZillionAgent(Configuration configuration) {
        this.configuration = configuration;
        this.configuration_bak = null;
        this.full_name = ZillionAgent.generateName();
        this.CheckConfig(configuration);
    }

    public ZillionAgent(Configuration configuration, String name) {
        this.configuration = configuration;
        this.configuration_bak = null;
        this.full_name = ZillionAgent.generateName(name);
        this.CheckConfig(configuration);
    }

    public ZillionAgent(Configuration configuration, Configuration configuration_bak) {
        this.configuration = configuration;
        this.configuration_bak = configuration_bak;
        this.full_name = ZillionAgent.generateName();
        this.CheckConfig(configuration);
    }

    public ZillionAgent(Configuration configuration, Configuration configuration_bak, String name) {
        this.configuration = configuration;
        this.configuration_bak = configuration_bak;
        this.full_name = ZillionAgent.generateName(name);
        this.CheckConfig(configuration);
    }

    private void CheckConfig(Configuration configuration) {
        String database_type = configuration.get("zillion.database_type");
        if (database_type != null) {
            this.database_type = database_type;
        }
        if (this.database_type.equals("MySQL") || this.database_type.equals("Mix")) {
            Configuration_MySQL configuration_MySQL;
            DataSourceConfig_c3p0 DataSourceConfig_c3p02 = new DataSourceConfig_c3p0();
            DataSourceConfig_c3p02.jdbcUrl = configuration.get("MySQL.c3p0.jdbcUrl");
            DataSourceConfig_c3p02.user = configuration.get("MySQL.c3p0.user");
            DataSourceConfig_c3p02.password = configuration.get("MySQL.c3p0.password");
            DataSourceConfig_c3p02.acquireIncrement = configuration.getInt("MySQL.c3p0.acquireIncrement", 3);
            DataSourceConfig_c3p02.idleConnectionTestPeriod = configuration.getInt("MySQL.c3p0.idleConnectionTestPeriod", 60);
            DataSourceConfig_c3p02.initialPoolSize = configuration.getInt("MySQL.c3p0.initialPoolSize", 10);
            DataSourceConfig_c3p02.maxIdleTime = configuration.getInt("MySQL.c3p0.maxIdleTime", 60);
            DataSourceConfig_c3p02.maxPoolSize = configuration.getInt("MySQL.c3p0.maxPoolSize", 50);
            DataSourceConfig_c3p02.maxStatements = configuration.getInt("MySQL.c3p0.maxStatements", 100);
            DataSourceConfig_c3p02.minPoolSize = configuration.getInt("MySQL.c3p0.minPoolSize", 10);
            String zookeeper_connectionAddress = configuration.get("MySQL.zookeeper.quorum");
            int zookeeper_sessionTimeout = configuration.getInt("MySQL.zookeeper.session.timeout", 30000);
            this.configuration_MySQL = configuration_MySQL = new Configuration_MySQL(DataSourceConfig_c3p02, zookeeper_connectionAddress, zookeeper_sessionTimeout);
        }
    }

    public String getFull_name() {
        return this.full_name;
    }

    public void setFull_name(String full_name) {
        this.full_name = full_name;
    }

    @Override
    public void Start() throws Exception {
        boolean without_lock = false;
        this.Start(without_lock);
    }

    public void Start(boolean without_lock) throws Exception {
        if (!this.container.initialized) {
            this.container.agent = this;
            this.container.without_lock = without_lock;
            this.helper = new SchemaRepositoryHelper(this.full_name);
            this.helper.Initialize(this.container, this.database_type, this.configuration, this.configuration_bak, this.configuration_MySQL, this.print, this.observer);
        }
    }

    @Override
    public void Stop() {
        if (this.container.initialized) {
            try {
                this.container.thread.RequestStop();
                this.container.thread.join();
                this.container.DatabaseImpl.Stop();
                this.container.ZK.close();
                this.container.initialized = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JSONObject Query(JSONObject queryJSON) throws Exception {
        JSONObject result = this.Query(queryJSON, false);
        return result;
    }

    public JSONObject Query(JSONObject queryJSON_Saga, boolean unuse) throws Exception {
        com.alibaba.fastjson.JSONObject queryJSON = (com.alibaba.fastjson.JSONObject)Convertor_JSON.SagaJson2FastJson(queryJSON_Saga);
        com.alibaba.fastjson.JSONObject result = this.Query(queryJSON, unuse);
        JSONObject result_Saga = (JSONObject)Convertor_JSON.FastJson2SagaJson(result);
        return result_Saga;
    }

    @Override
    public com.alibaba.fastjson.JSONObject Query(com.alibaba.fastjson.JSONObject queryJSON) throws Exception {
        return this.Query(queryJSON, false);
    }

    public com.alibaba.fastjson.JSONObject Query(com.alibaba.fastjson.JSONObject queryJSON, boolean unuse) throws Exception {
        String uuid = UUID.randomUUID().toString();
        AsyncJob job = new AsyncJob(uuid, queryJSON);
        com.alibaba.fastjson.JSONObject result = this.Query(queryJSON, unuse, job);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public com.alibaba.fastjson.JSONObject Query(com.alibaba.fastjson.JSONObject queryJSON, boolean unuse, AsyncJob job) throws Exception {
        com.alibaba.fastjson.JSONArray OrderBy;
        if (!this.container.initialized) {
            throw new MyException("ZillionAgent: container not initialized");
        }
        com.alibaba.fastjson.JSONObject result = new com.alibaba.fastjson.JSONObject();
        result.put("Result", (Object)"failure");
        String QueryType = (String)queryJSON.get((Object)"QueryType");
        if (QueryType.startsWith("monitor_")) {
            ZillionMonitorUtil.process(this, queryJSON, result);
            return result;
        }
        if (QueryType.equals("admin_password_clear")) {
            Stat stat = this.container.ZK.exists("/zillion/password", false);
            if (stat != null) {
                this.container.ZK.delete("/zillion/password", -1);
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("admin_password_set")) {
            String Password = (String)queryJSON.get((Object)"Password");
            Stat stat = this.container.ZK.exists("/zillion/password", false);
            if (stat == null) {
                this.container.ZK.create("/zillion/password", Password.getBytes(), CreateMode.PERSISTENT);
            } else {
                this.container.ZK.setData("/zillion/password", Password.getBytes(), -1);
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("admin_password_get")) {
            String Content;
            Stat stat = this.container.ZK.exists("/zillion/password", false);
            if (stat == null) {
                Content = null;
            } else {
                byte[] bytes = this.container.ZK.getData("/zillion/password", false, stat);
                Content = new String(bytes);
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Content", (Object)Content);
            return result;
        }
        if (QueryType.equals("database_list")) {
            ArrayList<String> itemList = new ArrayList<String>();
            itemList.addAll(this.container.namespaceList);
            Collections.sort(itemList);
            com.alibaba.fastjson.JSONArray content = new com.alibaba.fastjson.JSONArray();
            for (String item : itemList) {
                content.add((Object)item);
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Count", (Object)itemList.size());
            result.put("Content", (Object)content);
            return result;
        }
        if (QueryType.equals("database_create")) {
            String Database = (String)queryJSON.get((Object)"Database");
            boolean success = this.NDL_AddDatabase(Database);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("database_drop")) {
            String Database = (String)queryJSON.get((Object)"Database");
            boolean success = this.NDL_DropDatabase(Database);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("table_list_strict")) {
            String Database = (String)queryJSON.get((Object)"Database");
            List<String> itemList = this.container.repositoryMap.get(Database).TableList();
            Collections.sort(itemList);
            com.alibaba.fastjson.JSONArray content = new com.alibaba.fastjson.JSONArray();
            for (String item : itemList) {
                content.add((Object)item);
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Count", (Object)content.size());
            result.put("Content", (Object)content);
            return result;
        }
        if (QueryType.equals("table_list")) {
            String Database = (String)queryJSON.get((Object)"Database");
            List<String> itemList = this.container.repositoryMap.get(Database).TableList();
            Collections.sort(itemList);
            com.alibaba.fastjson.JSONArray content = new com.alibaba.fastjson.JSONArray();
            for (String item : itemList) {
                content.add((Object)item);
                ZillionTableSchema table_schema = this.container.repositoryMap.get(Database).GetTable(item);
                String zkpath_namespace = "/zillion/ns/" + table_schema.Namespace;
                List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + table_schema.table_name, false);
                Collections.sort(child_nameList);
                for (String child_name : child_nameList) {
                    content.add((Object)(String.valueOf(item) + "_" + child_name));
                }
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Count", (Object)content.size());
            result.put("Content", (Object)content);
            return result;
        }
        if (QueryType.equals("split_list")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            ZillionTableSchema table_schema = this.container.repositoryMap.get(Database).GetTable(Datatable);
            com.alibaba.fastjson.JSONArray content = new com.alibaba.fastjson.JSONArray();
            String zkpath_namespace = "/zillion/ns/" + table_schema.Namespace;
            List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + table_schema.table_name, false);
            Collections.sort(child_nameList);
            for (String child_name : child_nameList) {
                content.add((Object)child_name);
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Count", (Object)content.size());
            result.put("Content", (Object)content);
            return result;
        }
        if (QueryType.equals("table_detail")) {
            String Datatable;
            String Database = (String)queryJSON.get((Object)"Database");
            String tableName = Datatable = (String)queryJSON.get((Object)"Datatable");
            ZillionTableSchema table_schema = this.container.repositoryMap.get(Database).GetTable(tableName);
            if (table_schema == null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                int index_ = tableName.lastIndexOf("_");
                if (index_ != -1) {
                    String prefix = tableName.substring(0, index_);
                    String suffix = tableName.substring(index_ + 1);
                    try {
                        boolean is_split_table = false;
                        String query_month = null;
                        SplitWrapper sw = new SplitWrapper(tableName, is_split_table, query_month, table_schema);
                        SplitUtil.SplitParse(sdf, this.container.repositoryMap.get(Database), prefix, suffix, sw);
                        tableName = sw.tableName;
                        is_split_table = sw.is_split_table;
                        query_month = sw.query_month;
                        table_schema = sw.schema;
                    }
                    catch (ParseException is_split_table) {
                        // empty catch block
                    }
                }
            }
            List<ZillionTableIndex> index_schemaList = this.container.repositoryMap.get(Database).GetIndex(tableName);
            com.alibaba.fastjson.JSONArray Indexes = new com.alibaba.fastjson.JSONArray();
            for (ZillionTableIndex index_schema : index_schemaList) {
                com.alibaba.fastjson.JSONObject indexJSON = new com.alibaba.fastjson.JSONObject();
                indexJSON.put("Name", (Object)index_schema.index_name);
                com.alibaba.fastjson.JSONArray indexColumns = new com.alibaba.fastjson.JSONArray();
                String[] stringArray = index_schema.Key;
                int n = index_schema.Key.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    indexColumns.add((Object)column);
                    ++n2;
                }
                indexJSON.put("Columns", (Object)indexColumns);
                Indexes.add((Object)indexJSON);
            }
            com.alibaba.fastjson.JSONObject content = (com.alibaba.fastjson.JSONObject)FastJsonReaderUtil.Instance().parse(JSON.toJSONString((Object)table_schema.JSON, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            content.put("Indexes", (Object)Indexes);
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Content", (Object)content);
            return result;
        }
        if (QueryType.equals("table_create")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            com.alibaba.fastjson.JSONObject Definition = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Definition");
            com.alibaba.fastjson.JSONObject table_schema = (com.alibaba.fastjson.JSONObject)FastJsonReaderUtil.Instance().parse(JSON.toJSONString((Object)Definition, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            com.alibaba.fastjson.JSONArray Indexes = (com.alibaba.fastjson.JSONArray)table_schema.get((Object)"Indexes");
            table_schema.remove((Object)"Indexes");
            boolean success = this.DDL_AddTable(Database, Datatable, table_schema, Indexes);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("table_clear")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            String zkpath_namespace = "/zillion/ns/" + Database;
            ZillionTableSchema schema = this.container.repositoryMap.get(Database).GetTable(Datatable);
            boolean is_split_table = false;
            String selected_query_month = null;
            if (schema == null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                int index_ = Datatable.lastIndexOf("_");
                if (index_ != -1) {
                    String prefix = Datatable.substring(0, index_);
                    String suffix = Datatable.substring(index_ + 1);
                    String tableName = null;
                    SplitWrapper sw = new SplitWrapper(tableName, is_split_table, selected_query_month, schema);
                    SplitUtil.SplitParse(sdf, this.container.repositoryMap.get(Database), prefix, suffix, sw);
                    tableName = sw.tableName;
                    is_split_table = sw.is_split_table;
                    selected_query_month = sw.query_month;
                    schema = sw.schema;
                }
            }
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + schema.table_name;
            String lock_type_meta = "w";
            String node_path_meta = ZKLockRW.Create(this.container.ZK, parent_path_meta, lock_type_meta, this.full_name);
            try {
                int count;
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                boolean wait_success = ZKLockRW.WaitFor(this.container.ZK, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + parent_path_meta);
                }
                if (schema.table_type.startsWith("split_")) {
                    ArrayList<String> query_monthList = new ArrayList<String>();
                    if (is_split_table) {
                        query_monthList.add(selected_query_month);
                    } else {
                        List<String> children = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, false);
                        query_monthList.addAll(children);
                    }
                    count = this.container.DatabaseImpl.clear_table_split(Database, schema, query_monthList, this.container.ZK);
                } else {
                    count = this.container.DatabaseImpl.clear_table_not_split(Database, schema, this.container.ZK);
                }
                result.remove((Object)"Result");
                result.put("Result", (Object)"success");
                result.put("Count", (Object)count);
                return result;
            }
            finally {
                ZKLockRW.Finish(this.container.ZK, node_path_meta);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
            }
        }
        if (QueryType.equals("table_drop")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            String zkpath_namespace = "/zillion/ns/" + Database;
            ZillionTableSchema schema = this.container.repositoryMap.get(Database).GetTable(Datatable);
            boolean is_split_table = false;
            String query_month = null;
            if (schema == null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                int index_ = Datatable.lastIndexOf("_");
                if (index_ != -1) {
                    String prefix = Datatable.substring(0, index_);
                    String suffix = Datatable.substring(index_ + 1);
                    String tableName = null;
                    SplitWrapper sw = new SplitWrapper(tableName, is_split_table, query_month, schema);
                    SplitUtil.SplitParse(sdf, this.container.repositoryMap.get(Database), prefix, suffix, sw);
                    tableName = sw.tableName;
                    is_split_table = sw.is_split_table;
                    query_month = sw.query_month;
                    schema = sw.schema;
                }
            }
            Stat stat = new Stat();
            if (is_split_table) {
                String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
                String parent_path_meta = String.valueOf(zkpath_namespace) + "/splitlocks" + "/" + schema.table_name;
                String lock_type_meta = "w";
                String node_path_meta = ZKLockRW.Create(this.container.ZK, parent_path_meta, lock_type_meta, this.full_name);
                try {
                    String indexName;
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                    boolean wait_success = ZKLockRW.WaitFor(this.container.ZK, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                    if (!wait_success) {
                        throw new MyException("ZillionAgent: WaitFor fail " + parent_path_meta);
                    }
                    byte[] hash = this.container.ZK.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "/" + query_month, false, stat);
                    HashObject hashObject = HashUtil.Parse(hash);
                    hashObject.delete_count = hashObject.insert_count - hashObject.delete_count;
                    hashObject.insert_count = 0L;
                    this.container.ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + query_month + "/" + "tmp-", hashObject.toBytes(), CreateMode.PERSISTENT_SEQUENTIAL);
                    for (ZillionTableIndex schema_index : schema.Indexes) {
                        indexName = schema_index.index_name;
                        this.container.ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName + "/" + query_month + "/" + "tmp-", hashObject.toBytes(), CreateMode.PERSISTENT_SEQUENTIAL);
                    }
                    int index_wait = 0;
                    while (index_wait < 15) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        boolean hash_tmp_finish = true;
                        List<String> children = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + query_month, false);
                        if (children.size() > 0) {
                            hash_tmp_finish = false;
                        }
                        for (ZillionTableIndex schema_index : schema.Indexes) {
                            String indexName2 = schema_index.index_name;
                            children = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName2 + "/" + query_month, false);
                            if (children.size() <= 0) continue;
                            hash_tmp_finish = false;
                            break;
                        }
                        if (hash_tmp_finish) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        ++index_wait;
                    }
                    this.container.ZK.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "/" + query_month, -1);
                    ZKHelper.recursive(this.container.ZK, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "/" + query_month);
                    this.container.DatabaseImpl.meta_query_delete_split(Database, String.valueOf(schema.table_name) + "_" + query_month);
                    this.container.DatabaseImpl.ori_drop_table(Database, "zillion_data_" + schema.table_name + "_" + query_month);
                    for (ZillionTableIndex schema_index : schema.Indexes) {
                        indexName = schema_index.index_name;
                        this.container.ZK.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name + "." + indexName + "/" + query_month, -1);
                        ZKHelper.recursive(this.container.ZK, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + schema.table_name + "." + indexName + "/" + query_month);
                        this.container.DatabaseImpl.meta_query_delete_split(Database, String.valueOf(schema.table_name) + "." + indexName + "_" + query_month);
                        this.container.DatabaseImpl.ori_drop_table(Database, "zillion_index_" + schema.table_name + "." + indexName + "_" + query_month);
                    }
                    hashObject = HashUtil.Parse(hash);
                    long count = hashObject.insert_count - hashObject.delete_count;
                    result.remove((Object)"Result");
                    result.put("Result", (Object)"success");
                    result.put("Count", (Object)count);
                    return result;
                }
                finally {
                    ZKLockRW.Finish(this.container.ZK, node_path_meta);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
                }
            }
            boolean success = this.DDL_DropTable(Database, Datatable);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("index_create")) {
            boolean success;
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            String Name = (String)queryJSON.get((Object)"Name");
            com.alibaba.fastjson.JSONArray Columns = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Columns");
            com.alibaba.fastjson.JSONArray indexArray = new com.alibaba.fastjson.JSONArray();
            com.alibaba.fastjson.JSONObject index_schema = new com.alibaba.fastjson.JSONObject();
            index_schema.put("Name", (Object)Name);
            index_schema.put("Columns", (Object)Columns);
            indexArray.add((Object)index_schema);
            if (queryJSON.containsKey((Object)"thread_count")) {
                long thread_count = (Long)queryJSON.get((Object)"thread_count");
                success = this.DDL_AddIndex(Database, Datatable, indexArray, (int)thread_count, job);
            } else {
                success = this.DDL_AddIndex(Database, Datatable, indexArray, job);
            }
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("index_drop")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            com.alibaba.fastjson.JSONArray indexArray = new com.alibaba.fastjson.JSONArray();
            String Name = (String)queryJSON.get((Object)"Name");
            indexArray.add((Object)Name);
            boolean success = this.DDL_DropIndex(Database, Datatable, indexArray);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("indexs_create")) {
            boolean success;
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            com.alibaba.fastjson.JSONArray indexArray = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Indexs");
            if (queryJSON.containsKey((Object)"thread_count")) {
                long thread_count = (Long)queryJSON.get((Object)"thread_count");
                success = this.DDL_AddIndex(Database, Datatable, indexArray, (int)thread_count, job);
            } else {
                success = this.DDL_AddIndex(Database, Datatable, indexArray, job);
            }
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("indexs_drop")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            com.alibaba.fastjson.JSONArray Names = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Names");
            boolean success = this.DDL_DropIndex(Database, Datatable, Names);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("split_table_create")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            int index_ = Datatable.lastIndexOf(95);
            String tableName = Datatable.substring(0, index_);
            String splitName = Datatable.substring(index_ + 1);
            ZillionTableSchema table_schema = this.container.repositoryMap.get(Database).GetTable(tableName);
            boolean exist_split = false;
            String zkpath_namespace = "/zillion/ns/" + table_schema.Namespace;
            List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + table_schema.table_name, false);
            Collections.sort(child_nameList);
            for (String child_name : child_nameList) {
                if (!child_name.equals(splitName)) continue;
                exist_split = true;
                break;
            }
            if (!exist_split) {
                ITableWrapper dataWrapper = table_schema.connect(this.container, splitName, true);
                dataWrapper.unuse();
            }
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("table_alter")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            String AlterType = (String)queryJSON.get((Object)"AlterType");
            com.alibaba.fastjson.JSONObject AlterContent = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"AlterContent");
            boolean success = this.DDL_AlterTable(Database, Datatable, AlterType, AlterContent);
            if (!success) return result;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            return result;
        }
        if (QueryType.equals("table_count")) {
            String Database = (String)queryJSON.get((Object)"Database");
            String Datatable = (String)queryJSON.get((Object)"Datatable");
            String namespace = Database;
            String tableName = Datatable;
            String zkpath_namespace = "/zillion/ns/" + namespace;
            ZillionTableSchema schema = this.container.repositoryMap.get(Database).GetTable(Datatable);
            boolean is_split_table = false;
            String query_month = null;
            if (schema == null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                int index_ = Datatable.lastIndexOf("_");
                if (index_ != -1) {
                    String prefix = Datatable.substring(0, index_);
                    String suffix = Datatable.substring(index_ + 1);
                    try {
                        SplitWrapper sw = new SplitWrapper(tableName, is_split_table, query_month, schema);
                        SplitUtil.SplitParse(sdf, this.container.repositoryMap.get(Database), prefix, suffix, sw);
                        tableName = sw.tableName;
                        is_split_table = sw.is_split_table;
                        query_month = sw.query_month;
                        schema = sw.schema;
                    }
                    catch (ParseException sw) {
                        // empty catch block
                    }
                }
            }
            if (!(this.database_type.equals("HBase") || this.database_type.equals("Mix") && !schema.store_in_minor_db)) {
                DatabaseImpl_MySQL mysql = this.container.DatabaseImpl instanceof DatabaseImpl_MySQL ? (DatabaseImpl_MySQL)this.container.DatabaseImpl : ((DatabaseImpl_Mix)this.container.DatabaseImpl).mysql;
                if (is_split_table) {
                    String ori_tableName = "zillion_data_" + tableName + "_" + query_month;
                    int count = mysql.ori_table_count(namespace, ori_tableName);
                    result.remove((Object)"Result");
                    result.put("Result", (Object)"success");
                    result.put("Count", (Object)count);
                    return result;
                }
                if (schema.table_type != null && schema.table_type.startsWith("split_")) {
                    List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, false);
                    Collections.sort(child_nameList);
                    int count = 0;
                    for (String child_name : child_nameList) {
                        String ori_tableName = "zillion_data_" + tableName + "_" + child_name;
                        count += mysql.ori_table_count(namespace, ori_tableName);
                    }
                    result.remove((Object)"Result");
                    result.put("Result", (Object)"success");
                    result.put("Count", (Object)count);
                    return result;
                }
                String ori_tableName = "zillion_data_" + tableName;
                int count = mysql.ori_table_count(namespace, ori_tableName);
                result.remove((Object)"Result");
                result.put("Result", (Object)"success");
                result.put("Count", (Object)count);
                return result;
            }
            Stat stat = new Stat();
            if (is_split_table) {
                String split_hash_exist = String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "/" + query_month;
                stat = this.container.ZK.exists(split_hash_exist, false);
                if (stat != null) {
                    stat = new Stat();
                    byte[] hash = this.container.ZK.getData(split_hash_exist, false, stat);
                    HashObject hashObject = HashUtil.Parse(hash);
                    long count = hashObject.insert_count - hashObject.delete_count;
                    result.remove((Object)"Result");
                    result.put("Result", (Object)"success");
                    result.put("Count", (Object)count);
                    return result;
                }
                result.remove((Object)"Result");
                result.put("Result", (Object)"failure");
                result.put("Reason", (Object)"split_table not exist");
                return result;
            }
            stat = new Stat();
            byte[] hash = this.container.ZK.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName, false, stat);
            HashObject hashObject = HashUtil.Parse(hash);
            long count = hashObject.insert_count - hashObject.delete_count;
            result.remove((Object)"Result");
            result.put("Result", (Object)"success");
            result.put("Count", (Object)count);
            if (schema.table_type == null || !schema.table_type.startsWith("split_")) return result;
            List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema.table_name, false);
            Collections.sort(child_nameList);
            com.alibaba.fastjson.JSONArray Content = new com.alibaba.fastjson.JSONArray();
            for (String child_name : child_nameList) {
                stat = new Stat();
                byte[] hashInner = this.container.ZK.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "/" + child_name, false, stat);
                HashObject hashObjectInner = HashUtil.Parse(hashInner);
                long countInner = hashObjectInner.insert_count - hashObjectInner.delete_count;
                com.alibaba.fastjson.JSONObject month = new com.alibaba.fastjson.JSONObject();
                month.put("Child", (Object)child_name);
                month.put("Count", (Object)countInner);
                Content.add((Object)month);
            }
            result.put("Content", (Object)Content);
            return result;
        }
        if (queryJSON.containsKey((Object)"OrderBy") && ((OrderBy = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"OrderBy")) == null || OrderBy.size() == 0)) {
            queryJSON.remove((Object)"OrderBy");
        }
        if ((QueryType.equals("select") || QueryType.equals("combine_select")) && queryJSON.containsKey((Object)"QueryTarget")) {
            com.alibaba.fastjson.JSONObject QueryTarget = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"QueryTarget");
            com.alibaba.fastjson.JSONObject QueryResultInner = this.Query(QueryTarget);
            com.alibaba.fastjson.JSONArray resultContentInner = (com.alibaba.fastjson.JSONArray)QueryResultInner.get((Object)"Content");
            ArrayList<com.alibaba.fastjson.JSONObject> objectList = new ArrayList<com.alibaba.fastjson.JSONObject>();
            int i = 0;
            while (i < resultContentInner.size()) {
                objectList.add((com.alibaba.fastjson.JSONObject)resultContentInner.get(i));
                ++i;
            }
            com.alibaba.fastjson.JSONArray OrderBy2 = null;
            com.alibaba.fastjson.JSONObject Limit = null;
            if (queryJSON.containsKey((Object)"OrderBy")) {
                OrderBy2 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"OrderBy");
            }
            if (queryJSON.containsKey((Object)"Limit")) {
                Limit = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Limit");
            }
            com.alibaba.fastjson.JSONArray Content = new com.alibaba.fastjson.JSONArray();
            if (QueryType.equals("select")) {
                com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Criteria");
                Content = MemoryQueryUtil.Instance().Select(objectList, Criteria, OrderBy2);
            } else if (QueryType.equals("combine_select")) {
                com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                Content = MemoryQueryUtil.Instance().Select(objectList, Criterias, OrderBy2);
            }
            long Final_Limit_Skip = 0L;
            long Final_Limit_Count = Integer.MAX_VALUE;
            if (Limit != null) {
                Long Skip_tmp = FastJsonUtil.getLong(Limit, "Skip");
                Long Count_tmp = FastJsonUtil.getLong(Limit, "Count");
                if (Skip_tmp != null) {
                    Final_Limit_Skip = Skip_tmp;
                }
                if (Count_tmp != null) {
                    Final_Limit_Count = Count_tmp;
                }
            }
            if (Final_Limit_Skip != 0L || Final_Limit_Count != Integer.MAX_VALUE) {
                com.alibaba.fastjson.JSONArray LimitContent = new com.alibaba.fastjson.JSONArray();
                int i2 = (int)Final_Limit_Skip;
                while ((long)i2 < Final_Limit_Skip + Final_Limit_Count && i2 < Content.size()) {
                    LimitContent.add(Content.get(i2));
                    ++i2;
                }
                Content = LimitContent;
            }
            String UniqueReturnColumn = null;
            if (queryJSON.containsKey((Object)"UniqueReturnColumn")) {
                UniqueReturnColumn = (String)queryJSON.get((Object)"UniqueReturnColumn");
            }
            com.alibaba.fastjson.JSONArray ReturnColumns = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"ReturnColumns");
            Content = ZillionQueryUtil.cut(Content, UniqueReturnColumn, ReturnColumns);
            result.put("Result", (Object)"success");
            result.put("Content", (Object)Content);
            result.put("Count", (Object)Content.size());
            return result;
        }
        String Database = (String)queryJSON.get((Object)"Database");
        String Datatable = (String)queryJSON.get((Object)"Datatable");
        ZillionTableSchema schema = this.container.repositoryMap.get(Database).GetTable(Datatable);
        String namespace = Database;
        String tableName = Datatable;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        String query_month = null;
        if (schema == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            int index_ = Datatable.lastIndexOf("_");
            if (index_ != -1) {
                String prefix = Datatable.substring(0, index_);
                String suffix = Datatable.substring(index_ + 1);
                boolean is_split_table = false;
                SplitWrapper sw = new SplitWrapper(tableName, is_split_table, query_month, schema);
                SplitUtil.SplitParse(sdf, this.container.repositoryMap.get(Database), prefix, suffix, sw);
                tableName = sw.tableName;
                is_split_table = sw.is_split_table;
                query_month = sw.query_month;
                schema = sw.schema;
            }
        }
        Stat stat = new Stat();
        if (query_month != null) {
            String split_hash_exist = String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "/" + query_month;
            stat = this.container.ZK.exists(split_hash_exist, false);
            if (stat == null) {
                throw new MyException("ZillionAgent: " + namespace + " " + tableName + " is split_table, and not exist");
            }
            if (QueryType.equals("put") || QueryType.equals("batch_put") || QueryType.equals("insert") || QueryType.equals("batch_insert") || QueryType.equals("get") || QueryType.equals("batch_get") || QueryType.equals("remove") || QueryType.equals("batch_remove")) {
                throw new MyException("ZillionAgent: " + namespace + " " + tableName + " is split_table, so can't put or insert");
            }
        }
        if (this.container.without_lock && (QueryType.contains("insert") || QueryType.contains("update") || QueryType.contains("delete") || QueryType.contains("import") || QueryType.contains("put") || QueryType.contains("remove"))) {
            throw new MyException("ZillionAgent: " + namespace + " " + tableName + " without mode can't " + QueryType);
        }
        boolean use = this.container.without_lock ? true : schema.useTable(this.container.ZK, this.full_name);
        if (!use) throw new MyException("ZillionAgent: " + namespace + " " + tableName + " useTable fail");
        schema.usingAdd();
        try {
            try {
                com.alibaba.fastjson.JSONArray InsertObjects;
                String ExportZip;
                com.alibaba.fastjson.JSONObject Set2;
                com.alibaba.fastjson.JSONArray ReturnColumns;
                com.alibaba.fastjson.JSONArray batch_results;
                ZillionQueryResult query_result;
                com.alibaba.fastjson.JSONArray content = new com.alibaba.fastjson.JSONArray();
                com.alibaba.fastjson.JSONArray SecondCriteria2 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"SecondCriteria");
                if (QueryType.equals("select_count")) {
                    com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Criteria");
                    query_result = ZillionQueryUtil.query(this.container, schema, query_month, "select_count", null, Criteria, null, SecondCriteria2, null, null, null, null, job);
                    result.put("Count", (Object)query_result.count);
                } else if (QueryType.equals("batch_select_count")) {
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    batch_results = new com.alibaba.fastjson.JSONArray();
                    int i = 0;
                    while (i < Criterias.size()) {
                        com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)Criterias.get(i);
                        ZillionQueryResult query_result2 = ZillionQueryUtil.query(this.container, schema, query_month, "select_count", null, Criteria, null, SecondCriteria2, null, null, null, null, job);
                        com.alibaba.fastjson.JSONObject batch_result = new com.alibaba.fastjson.JSONObject();
                        batch_result.put("Count", (Object)query_result2.count);
                        batch_results.add((Object)batch_result);
                        ++i;
                    }
                    result.put("Count", (Object)batch_results.size());
                    result.put("Content", (Object)batch_results);
                } else if (QueryType.equals("combine_select_count")) {
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    query_result = ZillionQueryUtil.query(this.container, schema, query_month, "select_count", null, null, Criterias, SecondCriteria2, null, null, null, null, job);
                    result.put("Count", (Object)query_result.count);
                } else if (QueryType.equals("select")) {
                    String UniqueReturnColumn = null;
                    if (queryJSON.containsKey((Object)"UniqueReturnColumn")) {
                        UniqueReturnColumn = (String)queryJSON.get((Object)"UniqueReturnColumn");
                    }
                    ReturnColumns = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"ReturnColumns");
                    com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Criteria");
                    com.alibaba.fastjson.JSONArray OrderBy3 = null;
                    com.alibaba.fastjson.JSONObject Limit = null;
                    if (queryJSON.containsKey((Object)"OrderBy")) {
                        OrderBy3 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"OrderBy");
                    }
                    if (queryJSON.containsKey((Object)"Limit")) {
                        Limit = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Limit");
                    }
                    ZillionQueryResult query_result3 = ZillionQueryUtil.query(this.container, schema, query_month, "select", UniqueReturnColumn, ReturnColumns, Criteria, null, SecondCriteria2, OrderBy3, Limit, null, null, job);
                    result.put("Count", (Object)query_result3.count);
                    result.put("Content", (Object)query_result3.content);
                } else if (QueryType.equals("combine_select") || QueryType.equals("batch_select_merge")) {
                    String UniqueReturnColumn = null;
                    if (queryJSON.containsKey((Object)"UniqueReturnColumn")) {
                        UniqueReturnColumn = (String)queryJSON.get((Object)"UniqueReturnColumn");
                    }
                    ReturnColumns = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"ReturnColumns");
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    com.alibaba.fastjson.JSONArray OrderBy4 = null;
                    com.alibaba.fastjson.JSONObject Limit = null;
                    if (queryJSON.containsKey((Object)"OrderBy")) {
                        OrderBy4 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"OrderBy");
                    }
                    if (queryJSON.containsKey((Object)"Limit")) {
                        Limit = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Limit");
                    }
                    ZillionQueryResult query_result4 = ZillionQueryUtil.query(this.container, schema, query_month, "select", UniqueReturnColumn, ReturnColumns, null, Criterias, SecondCriteria2, OrderBy4, Limit, null, null, job);
                    result.put("Count", (Object)query_result4.count);
                    result.put("Content", (Object)query_result4.content);
                } else if (QueryType.equals("batch_select")) {
                    String UniqueReturnColumn = null;
                    if (queryJSON.containsKey((Object)"UniqueReturnColumn")) {
                        UniqueReturnColumn = (String)queryJSON.get((Object)"UniqueReturnColumn");
                    }
                    ReturnColumns = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"ReturnColumns");
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    com.alibaba.fastjson.JSONArray batch_results2 = new com.alibaba.fastjson.JSONArray();
                    int i = 0;
                    while (i < Criterias.size()) {
                        com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)Criterias.get(i);
                        ZillionQueryResult query_result5 = ZillionQueryUtil.query(this.container, schema, query_month, "select", UniqueReturnColumn, ReturnColumns, Criteria, null, SecondCriteria2, null, null, null, null, job);
                        com.alibaba.fastjson.JSONObject batch_result = new com.alibaba.fastjson.JSONObject();
                        batch_result.put("Count", (Object)query_result5.count);
                        batch_result.put("Content", (Object)query_result5.content);
                        batch_results2.add((Object)batch_result);
                        ++i;
                    }
                    result.put("Count", (Object)batch_results2.size());
                    result.put("Content", (Object)batch_results2);
                } else if (QueryType.equals("delete")) {
                    com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Criteria");
                    query_result = ZillionQueryUtil.query(this.container, schema, query_month, "delete", null, Criteria, null, SecondCriteria2, null, null, null, null, job);
                    result.put("Count", (Object)query_result.count);
                } else if (QueryType.equals("combine_delete")) {
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    query_result = ZillionQueryUtil.query(this.container, schema, query_month, "delete", null, null, Criterias, SecondCriteria2, null, null, null, null, job);
                    result.put("Count", (Object)query_result.count);
                } else if (QueryType.equals("batch_delete")) {
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    batch_results = new com.alibaba.fastjson.JSONArray();
                    int i = 0;
                    while (i < Criterias.size()) {
                        com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)Criterias.get(i);
                        ZillionQueryResult query_result6 = ZillionQueryUtil.query(this.container, schema, query_month, "delete", null, Criteria, null, SecondCriteria2, null, null, null, null, job);
                        com.alibaba.fastjson.JSONObject batch_result = new com.alibaba.fastjson.JSONObject();
                        batch_result.put("Count", (Object)query_result6.count);
                        batch_results.add((Object)batch_result);
                        ++i;
                    }
                    result.put("Count", (Object)batch_results.size());
                    result.put("Content", (Object)batch_results);
                } else if (QueryType.equals("update")) {
                    com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Criteria");
                    Set2 = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Set");
                    ZillionQueryResult query_result7 = ZillionQueryUtil.query(this.container, schema, query_month, "update", null, Criteria, null, SecondCriteria2, null, null, Set2, null, job);
                    result.put("Count", (Object)query_result7.count);
                    if (query_result7.reason != null) {
                        result.put("Reason", (Object)query_result7.reason);
                    }
                } else if (QueryType.equals("combine_update")) {
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    Set2 = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Set");
                    ZillionQueryResult query_result8 = ZillionQueryUtil.query(this.container, schema, query_month, "update", null, null, Criterias, SecondCriteria2, null, null, Set2, null, job);
                    result.put("Count", (Object)query_result8.count);
                    if (query_result8.reason != null) {
                        result.put("Reason", (Object)query_result8.reason);
                    }
                } else if (QueryType.equals("batch_update")) {
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    Set2 = null;
                    com.alibaba.fastjson.JSONArray Sets = null;
                    if (queryJSON.containsKey((Object)"Set")) {
                        Set2 = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Set");
                    }
                    if (queryJSON.containsKey((Object)"Sets")) {
                        Sets = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Sets");
                    }
                    com.alibaba.fastjson.JSONArray batch_results3 = new com.alibaba.fastjson.JSONArray();
                    int i = 0;
                    while (i < Criterias.size()) {
                        com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)Criterias.get(i);
                        com.alibaba.fastjson.JSONObject SetInner = Set2 != null ? Set2 : (com.alibaba.fastjson.JSONObject)Sets.get(i);
                        ZillionQueryResult query_result9 = ZillionQueryUtil.query(this.container, schema, query_month, "update", null, Criteria, null, SecondCriteria2, null, null, SetInner, null, job);
                        com.alibaba.fastjson.JSONObject batch_result = new com.alibaba.fastjson.JSONObject();
                        batch_result.put("Count", (Object)query_result9.count);
                        if (query_result9.reason != null) {
                            batch_result.put("Reason", (Object)query_result9.reason);
                        }
                        batch_results3.add((Object)batch_result);
                        ++i;
                    }
                    result.put("Count", (Object)batch_results3.size());
                    result.put("Content", (Object)batch_results3);
                } else if (QueryType.equals("export")) {
                    if (schema.table_type != null && schema.table_type.startsWith("split_") && query_month == null) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " export must use child_name");
                    }
                    com.alibaba.fastjson.JSONObject Criteria = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Criteria");
                    ExportZip = (String)queryJSON.get((Object)"ExportZip");
                    ZillionQueryResult query_result10 = ZillionQueryUtil.query(this.container, schema, query_month, "export", null, Criteria, null, SecondCriteria2, null, null, null, ExportZip, job);
                    result.put("Count", (Object)query_result10.count);
                } else if (QueryType.equals("combine_export")) {
                    if (schema.table_type != null && schema.table_type.startsWith("split_") && query_month == null) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " export must use child_name");
                    }
                    com.alibaba.fastjson.JSONArray Criterias = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Criterias");
                    ExportZip = (String)queryJSON.get((Object)"ExportZip");
                    ZillionQueryResult query_result11 = ZillionQueryUtil.query(this.container, schema, query_month, "export", null, null, Criterias, SecondCriteria2, null, null, null, ExportZip, job);
                    result.put("Count", (Object)query_result11.count);
                } else if (QueryType.equals("import")) {
                    ArchiveEntry entry;
                    if (schema.table_type != null && schema.table_type.startsWith("split_") && query_month != null) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " import can't use child_name");
                    }
                    String ImportZip = (String)queryJSON.get((Object)"ImportZip");
                    int scanned_count = 0;
                    int exist_count = 0;
                    ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)new FileInputStream(ImportZip));
                    while ((entry = zis.getNextEntry()) != null) {
                        int b;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        BufferedOutputStream Bout = new BufferedOutputStream(out);
                        while ((b = zis.read()) != -1) {
                            Bout.write(b);
                        }
                        Bout.close();
                        out.close();
                        String JSONString = new String(out.toByteArray(), "UTF-8");
                        com.alibaba.fastjson.JSONArray Content = (com.alibaba.fastjson.JSONArray)FastJsonReaderUtil.Instance().parse(JSONString);
                        int i = 0;
                        while (i < (Content.size() - 1) / ZillionConstant.import_batch_size + 1) {
                            com.alibaba.fastjson.JSONArray InsertObjects2 = new com.alibaba.fastjson.JSONArray();
                            int ii = i * ZillionConstant.import_batch_size;
                            while (ii < (i + 1) * ZillionConstant.import_batch_size && ii < Content.size()) {
                                InsertObjects2.add(Content.get(ii));
                                ++ii;
                            }
                            com.alibaba.fastjson.JSONObject wrapperObject = new com.alibaba.fastjson.JSONObject();
                            wrapperObject.put("QueryType", (Object)"batch_insert");
                            wrapperObject.put("InsertObjects", (Object)InsertObjects2);
                            wrapperObject.put("Database", (Object)Database);
                            wrapperObject.put("Datatable", (Object)Datatable);
                            com.alibaba.fastjson.JSONObject resultJSON = this.Query(wrapperObject);
                            exist_count = (int)((long)exist_count + (Long)resultJSON.get((Object)"Count"));
                            scanned_count += InsertObjects2.size();
                            ++i;
                        }
                    }
                    zis.close();
                    com.alibaba.fastjson.JSONObject Content = new com.alibaba.fastjson.JSONObject();
                    Content.put("Count_total", (Object)scanned_count);
                    Content.put("Count_insert", (Object)(scanned_count - exist_count));
                    Content.put("Count_exist", (Object)exist_count);
                    result.put("Content", (Object)Content);
                    result.put("Count", (Object)scanned_count);
                } else if (QueryType.equals("put")) {
                    com.alibaba.fastjson.JSONObject InsertObject = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"InsertObject");
                    InsertObjects = new com.alibaba.fastjson.JSONArray();
                    InsertObjects.add((Object)InsertObject);
                    ZillionQueryUtil.batch_put_insert(this.container, schema, InsertObjects, true);
                } else if (QueryType.equals("batch_put")) {
                    com.alibaba.fastjson.JSONArray InsertObjects3 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"InsertObjects");
                    ZillionQueryUtil.batch_put_insert(this.container, schema, InsertObjects3, true);
                } else if (QueryType.equals("insert")) {
                    com.alibaba.fastjson.JSONObject InsertObject = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"InsertObject");
                    com.alibaba.fastjson.JSONObject InsertObject_real = ZillionQueryUtil.getData(this.container, schema, InsertObject, content, null);
                    if (InsertObject_real != null) {
                        com.alibaba.fastjson.JSONArray InsertObjects_real = new com.alibaba.fastjson.JSONArray();
                        InsertObjects_real.add((Object)InsertObject_real);
                        ZillionQueryUtil.batch_put_insert(this.container, schema, InsertObjects_real, false);
                    }
                } else if (QueryType.equals("batch_insert")) {
                    com.alibaba.fastjson.JSONArray InsertObjects_real;
                    com.alibaba.fastjson.JSONArray InsertObjects4 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"InsertObjects");
                    if (ZillionConstant.check_query) {
                        ZillionQueryCheckUtil.Check_batch(schema, InsertObjects4);
                    }
                    if ((InsertObjects_real = ZillionQueryUtil.getDatas(this.container, schema, InsertObjects4, content, null)).size() > 0) {
                        ZillionQueryUtil.batch_put_insert(this.container, schema, InsertObjects_real, false);
                    }
                } else if (QueryType.equals("get")) {
                    com.alibaba.fastjson.JSONArray ReturnColumns2 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"ReturnColumns");
                    com.alibaba.fastjson.JSONObject InsertObject = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Key");
                    com.alibaba.fastjson.JSONArray InsertObjects5 = new com.alibaba.fastjson.JSONArray();
                    InsertObjects5.add((Object)InsertObject);
                    ZillionQueryUtil.getDatas(this.container, schema, InsertObjects5, content, ReturnColumns2);
                } else if (QueryType.equals("batch_get")) {
                    com.alibaba.fastjson.JSONArray ReturnColumns3 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"ReturnColumns");
                    InsertObjects = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Keys");
                    if (ZillionConstant.check_query) {
                        ZillionQueryCheckUtil.Check_batch(schema, InsertObjects);
                    }
                    ZillionQueryUtil.getDatas(this.container, schema, InsertObjects, content, ReturnColumns3);
                } else if (QueryType.equals("remove")) {
                    com.alibaba.fastjson.JSONObject InsertObject = (com.alibaba.fastjson.JSONObject)queryJSON.get((Object)"Key");
                    ZillionQueryUtil.getData(this.container, schema, InsertObject, content, null);
                    ZillionQueryUtil.batch_remove(this.container, schema, content);
                } else if (QueryType.equals("batch_remove")) {
                    com.alibaba.fastjson.JSONArray InsertObjects6 = (com.alibaba.fastjson.JSONArray)queryJSON.get((Object)"Keys");
                    if (ZillionConstant.check_query) {
                        ZillionQueryCheckUtil.Check_batch(schema, InsertObjects6);
                    }
                    ZillionQueryUtil.getDatas(this.container, schema, InsertObjects6, content, null);
                    ZillionQueryUtil.batch_remove(this.container, schema, content);
                }
                result.remove((Object)"Result");
                result.put("Result", (Object)"success");
                if (!QueryType.equals("insert") && !QueryType.equals("batch_insert") && !QueryType.equals("get") && !QueryType.equals("batch_get") && !QueryType.equals("remove") && !QueryType.equals("batch_remove")) return result;
                result.put("Count", (Object)content.size());
                result.put("Content", (Object)content);
                if (!QueryType.equals("insert") && !QueryType.equals("batch_insert") || content.size() <= 0) return result;
                result.remove((Object)"Result");
                result.put("Result", (Object)"failure");
                return result;
            }
            catch (Exception e) {
                e.printStackTrace();
                schema.usingDel();
                if (!unuse || this.container.without_lock) return result;
                schema.unuseTable(this.container.ZK);
            }
            return result;
        }
        finally {
            schema.usingDel();
            if (unuse && !this.container.without_lock) {
                schema.unuseTable(this.container.ZK);
            }
        }
    }

    public synchronized boolean NDL_AddDatabase(String namespace) throws Exception {
        String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
        boolean result = false;
        if (!this.container.initialized) {
            throw new MyException("ZillionAgent: container not initialized");
        }
        if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
            throw new MyException("ZillionAgent: database can't be " + namespace);
        }
        boolean exist = false;
        for (String namespaceInner : this.container.namespaceList) {
            if (!namespaceInner.equals(namespace)) continue;
            exist = true;
        }
        if (exist) {
            throw new MyException("ZillionAgent: database already exist " + namespace);
        }
        ZKWrapper zookeeper = this.container.ZK;
        String parent_path_ns = "/zillion/nslock";
        String lock_type_ns = "w";
        String node_path_me = ZKLockRW.Create(zookeeper, parent_path_ns, lock_type_ns, this.full_name);
        try {
            LogUtil.info(" ********************************** " + method_name + " nslock:" + " WaitFor " + node_path_me);
            boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_ns, node_path_me, ZillionConstant.WaitFor_seconds);
            LogUtil.info(" ********************************** " + method_name + " nslock:" + " WaitFor " + wait_success + " " + node_path_me);
            if (!wait_success) {
                throw new MyException("ZillionAgent: WaitFor fail " + node_path_me);
            }
            boolean exist_namespace = false;
            List<String> namespaceList = this.container.DatabaseImpl.ori_namespaceList();
            for (String namespace_name : namespaceList) {
                if (!namespace_name.equals(namespace)) continue;
                List<String> tableList = this.container.DatabaseImpl.ori_tableList(namespace);
                if (tableList.size() > 0) {
                    throw new MyException("ZillionAgent: namespace already exist:" + namespace);
                }
                exist_namespace = true;
                break;
            }
            if (!exist_namespace) {
                this.container.DatabaseImpl.namespace_create(namespace);
            }
            this.container.DatabaseImpl.meta_manage_create_data(namespace);
            this.container.DatabaseImpl.meta_manage_create_index(namespace);
            this.helper.InitializeNamespace(this.container.ZK, this.container.DatabaseImpl, namespace);
            result = true;
        }
        finally {
            ZKLockRW.Finish(zookeeper, node_path_me);
            LogUtil.info(" ********************************** " + method_name + " nslock:" + " finish " + node_path_me);
        }
        Thread.sleep(3000L);
        return result;
    }

    public synchronized boolean NDL_DropDatabase(String namespace) throws Exception {
        boolean result;
        block20: {
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            result = false;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
                throw new MyException("ZillionAgent: database can't be " + namespace);
            }
            boolean exist = false;
            for (String namespaceInner : this.container.namespaceList) {
                if (!namespaceInner.equals(namespace)) continue;
                exist = true;
            }
            if (!exist) {
                throw new MyException("ZillionAgent: database not exist " + namespace);
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            if (repository.TableList().size() > 0) {
                throw new MyException("ZillionAgent: database not empty " + namespace);
            }
            ZKWrapper zookeeper = this.container.ZK;
            String parent_path_ns = "/zillion/nslock";
            String lock_type_ns = "w";
            String node_path_me = ZKLockRW.Create(zookeeper, parent_path_ns, lock_type_ns, this.full_name);
            try {
                LogUtil.info(" ********************************** " + method_name + " nslock:" + " WaitFor " + node_path_me);
                boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_ns, node_path_me, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " nslock:" + " WaitFor " + wait_success + " " + node_path_me);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + node_path_me);
                }
                String zkpath_namespace = "/zillion/ns/" + namespace;
                String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
                String lock_type_meta = "w";
                String node_path_meta = ZKLockRW.Create(zookeeper, parent_path_meta, lock_type_meta, this.full_name);
                try {
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                    wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                    if (!wait_success) {
                        throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                    }
                    if (repository.TableList().size() != 0) break block20;
                    ZKHelper.recursive(zookeeper, zkpath_namespace);
                    if (this.container.DatabaseImpl.ori_tableExists(namespace, "zillion_meta_split")) {
                        this.container.DatabaseImpl.meta_manage_drop_split(namespace);
                    }
                    this.container.DatabaseImpl.meta_manage_drop_index(namespace);
                    this.container.DatabaseImpl.meta_manage_drop_data(namespace);
                    try {
                        this.container.DatabaseImpl.namespace_drop(namespace);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    result = true;
                }
                finally {
                    ZKLockRW.Finish(zookeeper, node_path_meta);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
                }
            }
            finally {
                ZKLockRW.Finish(zookeeper, node_path_me);
                LogUtil.info(" ********************************** " + method_name + " nslock:" + " finish " + node_path_me);
            }
        }
        Thread.sleep(3000L);
        return result;
    }

    public synchronized boolean DDL_AddTable(String namespace, String tableName, JSONObject content_Saga, JSONArray indexes_Saga) throws Exception {
        com.alibaba.fastjson.JSONObject content = (com.alibaba.fastjson.JSONObject)Convertor_JSON.SagaJson2FastJson(content_Saga);
        com.alibaba.fastjson.JSONArray indexes = (com.alibaba.fastjson.JSONArray)Convertor_JSON.SagaJson2FastJson(indexes_Saga);
        return this.DDL_AddTable(namespace, tableName, content, indexes);
    }

    public synchronized boolean DDL_AddTable(String namespace, String tableName, com.alibaba.fastjson.JSONObject content, com.alibaba.fastjson.JSONArray indexes) throws Exception {
        ZKWrapper zookeeper;
        int repo_version_new;
        boolean result;
        block45: {
            String table_type;
            boolean resident_memory;
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            repo_version_new = -1;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist != null) {
                throw new MyException("ZillionAgent: schema exist: " + namespace + " " + tableName);
            }
            if (content.containsKey((Object)"resident_memory") && (resident_memory = ((Boolean)content.get((Object)"resident_memory")).booleanValue()) && content.containsKey((Object)"table_type") && (table_type = (String)content.get((Object)"table_type")).startsWith("split_")) {
                throw new MyException("ZillionAgent: split table can't resident_memory: " + namespace + " " + tableName);
            }
            ZillionTableSchema schema = new ZillionTableSchema(namespace, tableName);
            schema.JSON = content;
            SchemaParser.ParseTableSchema(schema, content);
            String[] stringArray = schema.Key;
            int n = schema.Key.length;
            int n2 = 0;
            while (n2 < n) {
                String Column = stringArray[n2];
                if (!schema.ColumnMap.containsKey(Column)) {
                    throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Column " + Column + " not exist");
                }
                ZillionTableColumn columnDef = schema.ColumnMap.get(Column);
                if (columnDef.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
                    throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Column " + Column + " can't use as key or index");
                }
                ++n2;
            }
            for (ZillionTableIndex indexDef : schema.Indexes) {
                String[] stringArray2 = indexDef.Key;
                int columnDef = indexDef.Key.length;
                int n3 = 0;
                while (n3 < columnDef) {
                    String Column = stringArray2[n3];
                    if (!schema.ColumnMap.containsKey(Column)) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Column " + Column + " not exist");
                    }
                    ZillionTableColumn columnDef2 = schema.ColumnMap.get(Column);
                    if (columnDef2.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Column " + Column + " can't use as key or index");
                    }
                    ++n3;
                }
            }
            zookeeper = this.container.ZK;
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
            String lock_type_meta = "w";
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "c";
            String check_type_table = "c";
            String node_path_meta = ZKLockRW.Create(zookeeper, parent_path_meta, lock_type_meta, this.full_name);
            try {
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                }
                boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
                if (success) {
                    String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
                    try {
                        int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                        success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                        if (success) {
                            String table_type2;
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                            wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                            if (!wait_success) {
                                throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                            }
                            if (!content.containsKey((Object)"table_type")) {
                                table_type2 = "index_data";
                                content.put("table_type", (Object)table_type2);
                            } else {
                                String table_typeInner = (String)content.get((Object)"table_type");
                                if (table_typeInner != null && !table_typeInner.equals("index_data")) {
                                    if (table_typeInner.equals("all_column")) {
                                        if (!content.containsKey((Object)"delete_UsePutV")) {
                                            content.put("delete_UsePutV", (Object)false);
                                        }
                                    } else if (table_typeInner.startsWith("split_")) {
                                        if (!content.containsKey((Object)"delete_UsePutV")) {
                                            content.put("delete_UsePutV", (Object)false);
                                        }
                                        if (!content.containsKey((Object)"split_column")) {
                                            content.put("split_column", (Object)"data_time");
                                        }
                                    }
                                }
                                table_type2 = table_typeInner;
                            }
                            zookeeper.create(String.valueOf(zkpath_namespace) + "/meta_data" + "/" + tableName, ByteToObject.toBytes(JSON.toJSONString((Object)content, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})), CreateMode.PERSISTENT);
                            HashObject hashObject = new HashObject();
                            byte[] hash = hashObject.toBytes();
                            zookeeper.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName, hash, CreateMode.PERSISTENT);
                            zookeeper.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                            zookeeper.create(String.valueOf(zkpath_namespace) + "/hashlocks" + "/" + tableName, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                            this.container.DatabaseImpl.meta_query_insert_data(namespace, tableName, content, hashObject);
                            ZillionTableSchema schema2 = new ZillionTableSchema(namespace, tableName);
                            schema2.JSON = content;
                            SchemaParser.ParseTableSchema(schema2, content);
                            if (table_type2 != null && table_type2.startsWith("split_")) {
                                this.container.DatabaseImpl.meta_manage_make_sure_split(namespace);
                            } else {
                                byte[][] splitKeys = null;
                                if (content.containsKey((Object)"region_keys")) {
                                    com.alibaba.fastjson.JSONArray region_keys = (com.alibaba.fastjson.JSONArray)content.get((Object)"region_keys");
                                    splitKeys = new byte[region_keys.size()][];
                                    int index_key = 0;
                                    while (index_key < region_keys.size()) {
                                        String region_key = (String)region_keys.get(index_key);
                                        splitKeys[index_key] = HexToByte.hexToByte(region_key);
                                        ++index_key;
                                    }
                                }
                                this.container.DatabaseImpl.table_manage_create_data(namespace, schema2);
                            }
                            if (indexes != null) {
                                int i = 0;
                                while (i < indexes.size()) {
                                    com.alibaba.fastjson.JSONObject indexJSON = (com.alibaba.fastjson.JSONObject)indexes.get(i);
                                    String indexName = (String)indexJSON.get((Object)"Name");
                                    com.alibaba.fastjson.JSONArray indexColumns = (com.alibaba.fastjson.JSONArray)indexJSON.get((Object)"Columns");
                                    zookeeper.create(String.valueOf(zkpath_namespace) + "/meta_index" + "/" + tableName + "." + indexName, JSON.toJSONString((Object)indexColumns, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("UTF-8"), CreateMode.PERSISTENT);
                                    zookeeper.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, hash, CreateMode.PERSISTENT);
                                    zookeeper.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                                    this.container.DatabaseImpl.meta_query_insert_index(namespace, tableName, indexName, indexColumns, hashObject);
                                    ZillionTableIndex schema_index = SchemaParser.ParseIndexSchema(schema2, indexJSON);
                                    schema2.AddIndex(schema_index);
                                    if (table_type2 == null || !table_type2.startsWith("split_")) {
                                        this.container.DatabaseImpl.table_manage_create_index(namespace, tableName, schema_index);
                                    }
                                    ++i;
                                }
                            }
                            if (lock_type_table.equals("c") || lock_type_table.equals("e")) {
                                zookeeper.setData(parent_path_table, "c".getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            } else if (lock_type_table.equals("d")) {
                                zookeeper.setData(parent_path_table, lock_type_table.getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            }
                            Stat stat = new Stat();
                            zookeeper.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
                            repo_version_new = stat.getVersion();
                            LogUtil.info(" ********************************** " + method_name + " work success ");
                            result = true;
                        } else {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                        }
                        break block45;
                    }
                    finally {
                        ZKLockCEDU.Finish(zookeeper, node_path_table);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                    }
                }
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
            }
            finally {
                ZKLockRW.Finish(zookeeper, node_path_meta);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
            }
        }
        if (result) {
            ObserverCheck.Wait(zookeeper, namespace, repo_version_new);
        }
        return result;
    }

    public synchronized boolean DDL_AlterTable(String namespace, String tableName, String alter_type, JSONObject alter_content_Saga) throws Exception {
        com.alibaba.fastjson.JSONObject alter_content = (com.alibaba.fastjson.JSONObject)Convertor_JSON.SagaJson2FastJson(alter_content_Saga);
        return this.DDL_AlterTable(namespace, tableName, alter_type, alter_content);
    }

    public synchronized boolean DDL_AlterTable(String namespace, String tableName, String alter_type, com.alibaba.fastjson.JSONObject alter_content) throws Exception {
        ZKWrapper zookeeper;
        int repo_version_new;
        boolean result;
        block56: {
            int i;
            com.alibaba.fastjson.JSONArray Columns;
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            repo_version_new = -1;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist == null) {
                throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
            }
            if (alter_type.equals("region_keys")) {
                if (schema_exist.table_type == null || !schema_exist.table_type.startsWith("split_")) {
                    throw new MyException("ZillionAgent: " + namespace + " " + tableName + " only child_name can update region_keys");
                }
            } else if (alter_type.equals("delete_UsePutV")) {
                boolean delete_UsePutV = (Boolean)alter_content.get((Object)"delete_UsePutV");
                if (delete_UsePutV == schema_exist.delete_UsePutV) {
                    return true;
                }
            } else if (alter_type.equals("compress")) {
                boolean compression = (Boolean)alter_content.get((Object)"compress");
                if (compression == schema_exist.compress) {
                    return true;
                }
            } else if (alter_type.equals("resident_memory")) {
                if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                    throw new MyException("ZillionAgent: split table can't resident_memory: " + namespace + " " + tableName);
                }
                boolean resident_memory = (Boolean)alter_content.get((Object)"resident_memory");
                if (resident_memory == schema_exist.resident_memory) {
                    return true;
                }
            } else if (alter_type.equals("Columns_add")) {
                ArrayList<Object> bad_Columns = new ArrayList<Object>();
                Columns = (com.alibaba.fastjson.JSONArray)alter_content.get((Object)"Columns_add");
                i = 0;
                while (i < Columns.size()) {
                    com.alibaba.fastjson.JSONObject jSONObject = (com.alibaba.fastjson.JSONObject)Columns.get(i);
                    String Name = (String)jSONObject.get((Object)"Name");
                    if (schema_exist.ColumnMap.containsKey(Name)) {
                        bad_Columns.add(Name);
                    }
                    ++i;
                }
                if (bad_Columns.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String string : bad_Columns) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(string);
                    }
                    throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Columns exist:" + sb.toString());
                }
                int index_col = 0;
                while (index_col < Columns.size()) {
                    com.alibaba.fastjson.JSONObject jSONObject = (com.alibaba.fastjson.JSONObject)Columns.get(index_col);
                    ZillionTableColumn ztc = SchemaParser.ParseColumn(jSONObject);
                    if (ztc.NotNull) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Columns can't be NotNull:" + ztc.Name);
                    }
                    ++index_col;
                }
            } else if (alter_type.equals("Columns_drop")) {
                ArrayList<String> bad_Columns = new ArrayList<String>();
                Columns = (com.alibaba.fastjson.JSONArray)alter_content.get((Object)"Columns_drop");
                i = 0;
                while (i < Columns.size()) {
                    String string = (String)Columns.get(i);
                    if (!schema_exist.ColumnMap.containsKey(string)) {
                        bad_Columns.add(string);
                    } else {
                        boolean bad = false;
                        String[] stringArray = schema_exist.Key;
                        int n = schema_exist.Key.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String key = stringArray[n2];
                            if (key.equals(string)) {
                                bad = true;
                                break;
                            }
                            ++n2;
                        }
                        block15: for (ZillionTableIndex ZillionTableIndex2 : schema_exist.Indexes) {
                            String[] stringArray2 = ZillionTableIndex2.Key;
                            int n3 = ZillionTableIndex2.Key.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String key = stringArray2[n4];
                                if (key.equals(string)) {
                                    bad = true;
                                    continue block15;
                                }
                                ++n4;
                            }
                        }
                        if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_") && schema_exist.split_column.equals(string)) {
                            bad = true;
                        }
                        if (bad) {
                            bad_Columns.add(string);
                        }
                    }
                    ++i;
                }
                if (bad_Columns.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (String string : bad_Columns) {
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(string);
                    }
                    throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Columns not exist or can't drop:" + sb.toString());
                }
            }
            zookeeper = this.container.ZK;
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
            String lock_type_meta = "w";
            String string = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "e";
            String check_type_table = "d";
            if (this.container.without_lock) {
                this.DDL_AlterTable_inner(schema_exist, zookeeper, namespace, tableName, alter_type, alter_content);
                LogUtil.info(" ********************************** " + method_name + " work success ");
                result = true;
                if (result) {
                    ObserverCheck.Wait(zookeeper, namespace, repo_version_new);
                }
                return result;
            }
            String node_path_meta = ZKLockRW.Create(zookeeper, parent_path_meta, lock_type_meta, this.full_name);
            try {
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                }
                boolean success = ZKLockCEDU.PreCheck(zookeeper, string, check_type_table);
                if (success) {
                    String node_path_table = ZKLockCEDU.Create(zookeeper, string, lock_type_table, this.full_name);
                    try {
                        int sequence_id = Integer.parseInt(node_path_table.substring(string.length() + 3));
                        success = ZKLockCEDU.Check(zookeeper, string, sequence_id, check_type_table);
                        if (success) {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                            wait_success = ZKLockCEDU.WaitFor(zookeeper, string, node_path_table, ZillionConstant.WaitFor_seconds);
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                            if (!wait_success) {
                                throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                            }
                            this.DDL_AlterTable_inner(schema_exist, zookeeper, namespace, tableName, alter_type, alter_content);
                            LogUtil.info(" ********************************** " + method_name + " work success ");
                            result = true;
                        } else {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                        }
                        break block56;
                    }
                    finally {
                        ZKLockCEDU.Finish(zookeeper, node_path_table);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                    }
                }
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
            }
            finally {
                ZKLockRW.Finish(zookeeper, node_path_meta);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
            }
        }
        if (result) {
            ObserverCheck.Wait(zookeeper, namespace, repo_version_new);
        }
        return result;
    }

    private int DDL_AlterTable_inner(ZillionTableSchema schema_exist, ZKWrapper zookeeper, String namespace, String tableName, String alter_type, com.alibaba.fastjson.JSONObject alter_content) throws Exception {
        com.alibaba.fastjson.JSONArray Columns;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
        String lock_type_table = "e";
        Stat stat = new Stat();
        byte[] data_bytes = zookeeper.getData(String.valueOf(zkpath_namespace) + "/meta_data" + "/" + tableName, false, stat);
        com.alibaba.fastjson.JSONObject content = (com.alibaba.fastjson.JSONObject)FastJsonReaderUtil.Instance().parse(new String(data_bytes, "UTF-8"));
        if (alter_type.equals("region_keys")) {
            com.alibaba.fastjson.JSONArray region_keys;
            if (content.containsKey((Object)"region_keys")) {
                content.remove((Object)"region_keys");
            }
            if ((region_keys = (com.alibaba.fastjson.JSONArray)alter_content.get((Object)"region_keys")) != null) {
                content.put("region_keys", (Object)region_keys);
            }
        } else if (alter_type.equals("delete_UsePutV")) {
            boolean delete_UsePutV = (Boolean)alter_content.get((Object)"delete_UsePutV");
            if (content.containsKey((Object)"delete_UsePutV")) {
                content.remove((Object)"delete_UsePutV");
            }
            content.put("delete_UsePutV", (Object)delete_UsePutV);
        } else if (alter_type.equals("compress")) {
            String tableNameString;
            boolean compress = (Boolean)alter_content.get((Object)"compress");
            if (content.containsKey((Object)"compress")) {
                content.remove((Object)"compress");
            }
            content.put("compress", (Object)compress);
            for (ZillionTableIndex schema_index : schema_exist.Indexes) {
                String indexName = schema_index.index_name;
                if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                    List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + (String)indexName, false);
                    Collections.sort(child_nameList);
                    for (String child_name : child_nameList) {
                        String tableNameString2 = "zillion_index_" + tableName + "." + (String)indexName + "_" + child_name;
                        this.container.DatabaseImpl.table_manage_alter_compression(namespace, tableNameString2, compress);
                    }
                    continue;
                }
                tableNameString = "zillion_index_" + tableName + "." + (String)indexName;
                this.container.DatabaseImpl.table_manage_alter_compression(namespace, tableNameString, compress);
            }
            if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema_exist.table_name, false);
                Collections.sort(child_nameList);
                for (String child_name : child_nameList) {
                    tableNameString = "zillion_data_" + tableName + "_" + child_name;
                    this.container.DatabaseImpl.table_manage_alter_compression(namespace, tableNameString, compress);
                }
            } else {
                String tableNameString3 = "zillion_data_" + tableName;
                this.container.DatabaseImpl.table_manage_alter_compression(namespace, tableNameString3, compress);
            }
        } else if (alter_type.equals("resident_memory")) {
            boolean resident_memory = (Boolean)alter_content.get((Object)"resident_memory");
            content.put("resident_memory", (Object)resident_memory);
            for (ZillionTableIndex schema_index : schema_exist.Indexes) {
                String indexName = schema_index.index_name;
                String tableNameString = "zillion_index_" + tableName + "." + indexName;
                this.container.DatabaseImpl.table_manage_alter_in_memory(namespace, tableNameString, resident_memory);
            }
            String tableNameString = "zillion_data_" + tableName;
            this.container.DatabaseImpl.table_manage_alter_in_memory(namespace, tableNameString, resident_memory);
        } else if (alter_type.equals("Columns_add")) {
            Columns = (com.alibaba.fastjson.JSONArray)alter_content.get((Object)"Columns_add");
            com.alibaba.fastjson.JSONArray Columns_current = (com.alibaba.fastjson.JSONArray)content.get((Object)"Columns");
            Columns_current.addAll((Collection)Columns);
            ArrayList<ZillionTableColumn> ztcList = new ArrayList<ZillionTableColumn>();
            int index_col = 0;
            while (index_col < Columns.size()) {
                com.alibaba.fastjson.JSONObject column = (com.alibaba.fastjson.JSONObject)Columns.get(index_col);
                ZillionTableColumn ztc = SchemaParser.ParseColumn(column);
                ztcList.add(ztc);
                ++index_col;
            }
            if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema_exist.table_name, false);
                Collections.sort(child_nameList);
                for (String child_name : child_nameList) {
                    String tableNameString = "zillion_data_" + tableName + "_" + child_name;
                    this.container.DatabaseImpl.table_manage_alter_add_column(namespace, tableNameString, ztcList);
                }
            } else {
                String tableNameString = "zillion_data_" + tableName;
                this.container.DatabaseImpl.table_manage_alter_add_column(namespace, tableNameString, ztcList);
            }
        } else if (alter_type.equals("Columns_drop")) {
            Columns = (com.alibaba.fastjson.JSONArray)alter_content.get((Object)"Columns_drop");
            com.alibaba.fastjson.JSONArray Columns_current = (com.alibaba.fastjson.JSONArray)content.get((Object)"Columns");
            ArrayList<String> columnList = new ArrayList<String>();
            int i = 0;
            while (i < Columns.size()) {
                String Name = (String)Columns.get(i);
                columnList.add(Name);
                int index = -1;
                int ii = 0;
                while (ii < Columns_current.size()) {
                    com.alibaba.fastjson.JSONObject ColumnJSON = (com.alibaba.fastjson.JSONObject)Columns_current.get(ii);
                    String Name_current = (String)ColumnJSON.get((Object)"Name");
                    if (Name_current.equals(Name)) {
                        index = ii;
                        break;
                    }
                    ++ii;
                }
                if (index != -1) {
                    Columns_current.remove(index);
                }
                ++i;
            }
            if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema_exist.table_name, false);
                Collections.sort(child_nameList);
                for (String child_name : child_nameList) {
                    String tableNameString = "zillion_data_" + tableName + "_" + child_name;
                    this.container.DatabaseImpl.table_manage_alter_drop_column(namespace, tableNameString, columnList);
                }
            } else {
                String tableNameString = "zillion_data_" + tableName;
                this.container.DatabaseImpl.table_manage_alter_drop_column(namespace, tableNameString, columnList);
            }
        }
        zookeeper.setData(String.valueOf(zkpath_namespace) + "/meta_data" + "/" + tableName, ByteToObject.toBytes(JSON.toJSONString((Object)content, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})), -1);
        this.container.DatabaseImpl.meta_query_update_data(namespace, tableName, content);
        if (lock_type_table.equals("c") || lock_type_table.equals("e")) {
            zookeeper.setData(parent_path_table, "c".getBytes("UTF-8"), -1);
            zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
        } else if (lock_type_table.equals("d")) {
            zookeeper.setData(parent_path_table, lock_type_table.getBytes("UTF-8"), -1);
            zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
        }
        stat = new Stat();
        zookeeper.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
        int repo_version_new = stat.getVersion();
        return repo_version_new;
    }

    public synchronized boolean DDL_DropTable(String namespace, String tableName) throws Exception {
        ZKWrapper zookeeper;
        int repo_version_new;
        boolean result;
        block28: {
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            repo_version_new = -1;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist == null) {
                throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
            }
            zookeeper = this.container.ZK;
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
            String lock_type_meta = "w";
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "d";
            String check_type_table = "d";
            String node_path_meta = ZKLockRW.Create(zookeeper, parent_path_meta, lock_type_meta, this.full_name);
            try {
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                }
                boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
                if (success) {
                    String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
                    try {
                        int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                        success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                        if (success) {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                            wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                            if (!wait_success) {
                                throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                            }
                            for (ZillionTableIndex schema_index : schema_exist.Indexes) {
                                String indexName = schema_index.index_name;
                                if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                                    List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, false);
                                    Collections.sort(child_nameList);
                                    for (String child_name : child_nameList) {
                                        zookeeper.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName + "/" + child_name, -1);
                                        ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName + "/" + child_name);
                                        this.container.DatabaseImpl.table_manage_drop_split_index(namespace, tableName, indexName, child_name);
                                        this.container.DatabaseImpl.meta_query_delete_split(namespace, String.valueOf(tableName) + "." + indexName + "_" + child_name);
                                    }
                                } else {
                                    this.container.DatabaseImpl.table_manage_drop_index(namespace, tableName, indexName);
                                }
                                zookeeper.delete(String.valueOf(zkpath_namespace) + "/meta_index" + "/" + tableName + "." + indexName, -1);
                                zookeeper.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, -1);
                                ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName);
                                this.container.DatabaseImpl.meta_query_delete_index(namespace, tableName, indexName);
                                schema_index.close();
                            }
                            if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                                List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + schema_exist.table_name, false);
                                Collections.sort(child_nameList);
                                for (String child_name : child_nameList) {
                                    zookeeper.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "/" + child_name, -1);
                                    ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "/" + child_name);
                                    this.container.DatabaseImpl.table_manage_drop_split_data(namespace, tableName, child_name);
                                    this.container.DatabaseImpl.meta_query_delete_split(namespace, String.valueOf(tableName) + "_" + child_name);
                                }
                            } else {
                                this.container.DatabaseImpl.table_manage_drop_data(namespace, tableName);
                            }
                            zookeeper.delete(String.valueOf(zkpath_namespace) + "/meta_data" + "/" + tableName, -1);
                            ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName);
                            ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName);
                            ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hashlocks" + "/" + tableName);
                            this.container.DatabaseImpl.meta_query_delete_data(namespace, tableName);
                            schema_exist.close();
                            if (lock_type_table.equals("c") || lock_type_table.equals("e")) {
                                zookeeper.setData(parent_path_table, "c".getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            } else if (lock_type_table.equals("d")) {
                                zookeeper.setData(parent_path_table, lock_type_table.getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            }
                            Stat stat = new Stat();
                            zookeeper.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
                            repo_version_new = stat.getVersion();
                            LogUtil.info(" ********************************** " + method_name + " work success ");
                            result = true;
                        } else {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                        }
                        break block28;
                    }
                    finally {
                        ZKLockCEDU.Finish(zookeeper, node_path_table);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                    }
                }
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
            }
            finally {
                ZKLockRW.Finish(zookeeper, node_path_meta);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
            }
        }
        if (result) {
            ObserverCheck.Wait(zookeeper, namespace, repo_version_new);
        }
        return result;
    }

    public synchronized boolean DDL_AddIndex(String namespace, String tableName, JSONArray index_schemaArray_Saga) throws Exception {
        return this.DDL_AddIndex(namespace, tableName, index_schemaArray_Saga, ZillionHashUtil.thread_count_default);
    }

    public synchronized boolean DDL_AddIndex(String namespace, String tableName, JSONArray index_schemaArray_Saga, int thread_count) throws Exception {
        com.alibaba.fastjson.JSONArray index_schemaArray = (com.alibaba.fastjson.JSONArray)Convertor_JSON.SagaJson2FastJson(index_schemaArray_Saga);
        return this.DDL_AddIndex(namespace, tableName, index_schemaArray, thread_count);
    }

    public synchronized boolean DDL_AddIndex(String namespace, String tableName, com.alibaba.fastjson.JSONArray index_schemaArray) throws Exception {
        return this.DDL_AddIndex(namespace, tableName, index_schemaArray, ZillionHashUtil.thread_count_default);
    }

    public synchronized boolean DDL_AddIndex(String namespace, String tableName, com.alibaba.fastjson.JSONArray index_schemaArray, AsyncJob job) throws Exception {
        return this.DDL_AddIndex(namespace, tableName, index_schemaArray, ZillionHashUtil.thread_count_default, job);
    }

    public synchronized boolean DDL_AddIndex(String namespace, String tableName, com.alibaba.fastjson.JSONArray index_schemaArray, int thread_count) throws Exception {
        String uuid = UUID.randomUUID().toString();
        AsyncJob job = new AsyncJob(uuid, null);
        return this.DDL_AddIndex(namespace, tableName, index_schemaArray, thread_count, job);
    }

    public synchronized boolean DDL_AddIndex(String namespace, String tableName, com.alibaba.fastjson.JSONArray index_schemaArray, int thread_count, AsyncJob job) throws Exception {
        ZKWrapper zookeeper;
        int repo_version_new;
        boolean result;
        block30: {
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            repo_version_new = -1;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist == null) {
                throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
            }
            int index_index = 0;
            while (index_index < index_schemaArray.size()) {
                com.alibaba.fastjson.JSONObject index_schema = (com.alibaba.fastjson.JSONObject)index_schemaArray.get(index_index);
                String indexName = (String)index_schema.get((Object)"Name");
                ZillionTableIndex schema_index_exist = repository.GetIndex(tableName, indexName);
                if (schema_index_exist != null) {
                    throw new MyException("ZillionAgent: index exist: " + namespace + " " + tableName + " " + indexName);
                }
                com.alibaba.fastjson.JSONArray Columns = (com.alibaba.fastjson.JSONArray)index_schema.get((Object)"Columns");
                int index_col = 0;
                while (index_col < Columns.size()) {
                    String Column = (String)Columns.get(index_col);
                    if (!schema_exist.ColumnMap.containsKey(Column)) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Column " + Column + " not exist");
                    }
                    ZillionTableColumn columnDef = schema_exist.ColumnMap.get(Column);
                    if (columnDef.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
                        throw new MyException("ZillionAgent: " + namespace + " " + tableName + " Column " + Column + " can't use as key or index");
                    }
                    ++index_col;
                }
                ++index_index;
            }
            zookeeper = this.container.ZK;
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
            String lock_type_meta = "w";
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "e";
            String check_type_table = "d";
            String node_path_meta = ZKLockRW.Create(zookeeper, parent_path_meta, lock_type_meta, this.full_name);
            try {
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                }
                boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
                if (success) {
                    String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
                    try {
                        int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                        success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                        if (success) {
                            String indexName;
                            com.alibaba.fastjson.JSONObject index_schema;
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                            wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                            if (!wait_success) {
                                throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                            }
                            String table_type = schema_exist.table_type;
                            ArrayList<ZillionTableIndex> schema_indexList = new ArrayList<ZillionTableIndex>();
                            int index_index2 = 0;
                            while (index_index2 < index_schemaArray.size()) {
                                index_schema = (com.alibaba.fastjson.JSONObject)index_schemaArray.get(index_index2);
                                indexName = (String)index_schema.get((Object)"Name");
                                com.alibaba.fastjson.JSONArray indexColumns = (com.alibaba.fastjson.JSONArray)index_schema.get((Object)"Columns");
                                zookeeper.create(String.valueOf(zkpath_namespace) + "/meta_index" + "/" + tableName + "." + indexName, JSON.toJSONString((Object)indexColumns, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("UTF-8"), CreateMode.PERSISTENT);
                                ZillionTableIndex schema_index = SchemaParser.ParseIndexSchema(schema_exist, index_schema);
                                schema_indexList.add(schema_index);
                                schema_exist.AddIndex(schema_index);
                                if (table_type == null || !table_type.startsWith("split_")) {
                                    this.container.DatabaseImpl.table_manage_create_index(namespace, tableName, schema_index);
                                }
                                ++index_index2;
                            }
                            index_index2 = 0;
                            while (index_index2 < index_schemaArray.size()) {
                                index_schema = (com.alibaba.fastjson.JSONObject)index_schemaArray.get(index_index2);
                                indexName = (String)index_schema.get((Object)"Name");
                                HashObject hashObject = new HashObject();
                                byte[] hash = hashObject.toBytes();
                                zookeeper.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, hash, CreateMode.PERSISTENT);
                                zookeeper.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                                com.alibaba.fastjson.JSONArray indexColumns = (com.alibaba.fastjson.JSONArray)index_schema.get((Object)"Columns");
                                this.container.DatabaseImpl.meta_query_insert_index(namespace, tableName, indexName, indexColumns, hashObject);
                                ++index_index2;
                            }
                            if (this.database_type.equals("HBase") || this.database_type.equals("Mix") && !schema_exist.store_in_minor_db) {
                                ZillionHashUtil.AddOrRepairIndex(this.container, schema_exist, schema_indexList, true, thread_count, job);
                            }
                            if (lock_type_table.equals("c") || lock_type_table.equals("e")) {
                                zookeeper.setData(parent_path_table, "c".getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            } else if (lock_type_table.equals("d")) {
                                zookeeper.setData(parent_path_table, lock_type_table.getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            }
                            Stat stat = new Stat();
                            zookeeper.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
                            repo_version_new = stat.getVersion();
                            LogUtil.info(" ********************************** " + method_name + " work success ");
                            result = true;
                        } else {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                        }
                        break block30;
                    }
                    finally {
                        ZKLockCEDU.Finish(zookeeper, node_path_table);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                    }
                }
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
            }
            finally {
                ZKLockRW.Finish(zookeeper, node_path_meta);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
            }
        }
        if (result) {
            ObserverCheck.Wait(zookeeper, namespace, repo_version_new);
        }
        return result;
    }

    public synchronized boolean DDL_DropIndex(String namespace, String tableName, JSONArray indexNameArray_Saga) throws Exception {
        com.alibaba.fastjson.JSONArray indexNameArray = (com.alibaba.fastjson.JSONArray)Convertor_JSON.SagaJson2FastJson(indexNameArray_Saga);
        return this.DDL_DropIndex(namespace, tableName, indexNameArray);
    }

    public synchronized boolean DDL_DropIndex(String namespace, String tableName, com.alibaba.fastjson.JSONArray indexNameArray) throws Exception {
        ZKWrapper zookeeper;
        int repo_version_new;
        boolean result;
        block27: {
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            repo_version_new = -1;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist == null) {
                throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
            }
            int index_index = 0;
            while (index_index < indexNameArray.size()) {
                String indexName = (String)indexNameArray.get(index_index);
                ZillionTableIndex schema_index_exist = repository.GetIndex(tableName, indexName);
                if (schema_index_exist == null) {
                    throw new MyException("ZillionAgent: index not exist: " + namespace + " " + tableName + " " + indexName);
                }
                ++index_index;
            }
            zookeeper = this.container.ZK;
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
            String lock_type_meta = "w";
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "e";
            String check_type_table = "d";
            String node_path_meta = ZKLockRW.Create(zookeeper, parent_path_meta, lock_type_meta, this.full_name);
            try {
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                boolean wait_success = ZKLockRW.WaitFor(zookeeper, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                if (!wait_success) {
                    throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                }
                boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
                if (success) {
                    String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
                    try {
                        int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                        success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                        if (success) {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                            wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                            if (!wait_success) {
                                throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                            }
                            int index_index2 = 0;
                            while (index_index2 < indexNameArray.size()) {
                                String indexName = (String)indexNameArray.get(index_index2);
                                if (schema_exist.table_type != null && schema_exist.table_type.startsWith("split_")) {
                                    List<String> child_nameList = this.container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, false);
                                    Collections.sort(child_nameList);
                                    for (String child_name : child_nameList) {
                                        zookeeper.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName + "/" + child_name, -1);
                                        ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName + "/" + child_name);
                                        this.container.DatabaseImpl.table_manage_drop_split_index(namespace, tableName, indexName, child_name);
                                        this.container.DatabaseImpl.meta_query_delete_split(namespace, String.valueOf(tableName) + "." + indexName + "_" + child_name);
                                    }
                                } else {
                                    this.container.DatabaseImpl.table_manage_drop_index(namespace, tableName, indexName);
                                }
                                ZillionTableIndex schema_index_exist = repository.GetIndex(tableName, indexName);
                                zookeeper.delete(String.valueOf(zkpath_namespace) + "/meta_index" + "/" + tableName + "." + indexName, -1);
                                zookeeper.delete(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, -1);
                                ZKHelper.recursive(zookeeper, String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName);
                                this.container.DatabaseImpl.meta_query_delete_index(namespace, tableName, indexName);
                                schema_index_exist.close();
                                ++index_index2;
                            }
                            if (lock_type_table.equals("c") || lock_type_table.equals("e")) {
                                zookeeper.setData(parent_path_table, "c".getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            } else if (lock_type_table.equals("d")) {
                                zookeeper.setData(parent_path_table, lock_type_table.getBytes("UTF-8"), -1);
                                zookeeper.setData(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), -1);
                            }
                            Stat stat = new Stat();
                            zookeeper.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
                            repo_version_new = stat.getVersion();
                            LogUtil.info(" ********************************** " + method_name + " work success ");
                            result = true;
                        } else {
                            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                        }
                        break block27;
                    }
                    finally {
                        ZKLockCEDU.Finish(zookeeper, node_path_table);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                    }
                }
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
            }
            finally {
                ZKLockRW.Finish(zookeeper, node_path_meta);
                LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
            }
        }
        if (result) {
            ObserverCheck.Wait(zookeeper, namespace, repo_version_new);
        }
        return result;
    }

    public synchronized boolean DDL_RepairIndex(String namespace, String tableName, List<String> indexNameList) throws Exception {
        return this.DDL_RepairIndex(namespace, tableName, indexNameList, ZillionHashUtil.thread_count_default);
    }

    public synchronized boolean DDL_RepairIndex(String namespace, String tableName, List<String> indexNameList, int thread_count) throws Exception {
        String uuid = UUID.randomUUID().toString();
        AsyncJob job = new AsyncJob(uuid, null);
        return this.DDL_RepairIndex(namespace, tableName, indexNameList, thread_count, job);
    }

    public synchronized boolean DDL_RepairIndex(String namespace, String tableName, List<String> indexNameList, int thread_count, AsyncJob job) throws Exception {
        boolean result;
        block14: {
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist == null) {
                throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
            }
            if (!(this.database_type.equals("HBase") || this.database_type.equals("Mix") && !schema_exist.store_in_minor_db)) {
                return true;
            }
            ZKWrapper zookeeper = this.container.ZK;
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "e";
            String check_type_table = "d";
            boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
            if (success) {
                String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
                try {
                    int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                    success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                    if (success) {
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                        boolean wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                        if (!wait_success) {
                            throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                        }
                        ArrayList<ZillionTableIndex> schema_indexList = new ArrayList<ZillionTableIndex>();
                        int index = 0;
                        while (index < indexNameList.size()) {
                            String indexName = indexNameList.get(index);
                            ZillionTableIndex index_exist = null;
                            for (ZillionTableIndex schema_index : schema_exist.Indexes) {
                                if (!schema_index.index_name.equals(indexName)) continue;
                                index_exist = schema_index;
                                break;
                            }
                            schema_indexList.add(index_exist);
                            ++index;
                        }
                        ZillionHashUtil.AddOrRepairIndex(this.container, schema_exist, schema_indexList, false, thread_count, job);
                        result = true;
                    } else {
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                    }
                    break block14;
                }
                finally {
                    ZKLockCEDU.Finish(zookeeper, node_path_table);
                    LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                }
            }
            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
        }
        return result;
    }

    public synchronized boolean DDL_RefreshHash(String namespace, String tableName) throws Exception {
        return this.DDL_RefreshHash(namespace, tableName, ZillionHashUtil.thread_count_default);
    }

    public synchronized boolean DDL_RefreshHash(String namespace, String tableName, int thread_count) throws Exception {
        String uuid = UUID.randomUUID().toString();
        AsyncJob job = new AsyncJob(uuid, null);
        return this.DDL_RefreshHash(namespace, tableName, thread_count, job);
    }

    public synchronized boolean DDL_RefreshHash(String namespace, String tableName, int thread_count, AsyncJob job) throws Exception {
        String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
        String zkpath_namespace = "/zillion/ns/" + namespace;
        boolean result = false;
        if (!this.container.initialized) {
            throw new MyException("ZillionAgent: container not initialized");
        }
        SchemaRepository repository = this.container.repositoryMap.get(namespace);
        ZillionTableSchema schema_exist = repository.GetTable(tableName);
        if (schema_exist == null) {
            throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
        }
        if (!(this.database_type.equals("HBase") || this.database_type.equals("Mix") && !schema_exist.store_in_minor_db)) {
            return true;
        }
        ZKWrapper zookeeper = this.container.ZK;
        String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
        String lock_type_table = "e";
        String check_type_table = "d";
        boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
        if (success) {
            String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
            try {
                int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                if (success) {
                    LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                    boolean wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                    LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                    if (!wait_success) {
                        throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                    }
                    ZillionHashUtil.RefreshHash(this.container, schema_exist, thread_count, job);
                    result = true;
                }
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
            }
            finally {
                ZKLockCEDU.Finish(zookeeper, node_path_table);
                LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
            }
        } else {
            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
        }
        return result;
    }

    public synchronized boolean DDL_IndexCheck(String namespace, String tableName, JSONObject returnJSON_Saga) throws Exception {
        com.alibaba.fastjson.JSONObject returnJSON = (com.alibaba.fastjson.JSONObject)Convertor_JSON.SagaJson2FastJson(returnJSON_Saga);
        return this.DDL_IndexCheck(namespace, tableName, returnJSON);
    }

    public synchronized boolean DDL_IndexCheck(String namespace, String tableName, com.alibaba.fastjson.JSONObject returnJSON) throws Exception {
        boolean result;
        block17: {
            String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
            String zkpath_namespace = "/zillion/ns/" + namespace;
            result = false;
            if (!this.container.initialized) {
                throw new MyException("ZillionAgent: container not initialized");
            }
            SchemaRepository repository = this.container.repositoryMap.get(namespace);
            ZillionTableSchema schema_exist = repository.GetTable(tableName);
            if (schema_exist == null) {
                throw new MyException("ZillionAgent: schema not exist: " + namespace + " " + tableName);
            }
            ZKWrapper zookeeper = this.container.ZK;
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            String lock_type_table = "e";
            String check_type_table = "d";
            boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
            if (success) {
                String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, this.full_name);
                try {
                    int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
                    success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
                    if (success) {
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + node_path_table);
                        boolean wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " WaitFor " + wait_success + " " + node_path_table);
                        if (!wait_success) {
                            throw new MyException("ZillionAgent: WaitFor fail " + node_path_table);
                        }
                        if (schema_exist.Indexes.size() > 0) {
                            Stat stat = new Stat();
                            byte[] hash_table = this.container.ZK.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName, false, stat);
                            HashObject hashObject_table = HashUtil.Parse(hash_table);
                            long count_table = hashObject_table.insert_count - hashObject_table.delete_count;
                            returnJSON.put("DataCount", (Object)count_table);
                            boolean all_equal = true;
                            com.alibaba.fastjson.JSONArray content = new com.alibaba.fastjson.JSONArray();
                            for (ZillionTableIndex schema_index : schema_exist.Indexes) {
                                String indexName = schema_index.index_name;
                                byte[] hash_index = zookeeper.getData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, false, stat);
                                HashObject hashObject_index = HashUtil.Parse(hash_index);
                                long count_index = hashObject_index.insert_count - hashObject_index.delete_count;
                                com.alibaba.fastjson.JSONObject compareJSON = new com.alibaba.fastjson.JSONObject();
                                compareJSON.put("Index", (Object)indexName);
                                compareJSON.put("DataCount", (Object)count_index);
                                if (count_index != count_table) {
                                    all_equal = false;
                                }
                                content.add((Object)compareJSON);
                            }
                            returnJSON.put("Content", (Object)content);
                            if (all_equal) {
                                result = true;
                                returnJSON.put("Result", (Object)"success");
                            } else {
                                returnJSON.put("Result", (Object)"failure");
                            }
                        } else {
                            returnJSON.put("Result", (Object)"success");
                        }
                        result = true;
                    } else {
                        LogUtil.info(" ********************************** " + method_name + " tablelock:" + " Check fail " + node_path_table);
                    }
                    break block17;
                }
                finally {
                    ZKLockCEDU.Finish(zookeeper, node_path_table);
                    LogUtil.info(" ********************************** " + method_name + " tablelock:" + " finish " + node_path_table);
                }
            }
            LogUtil.info(" ********************************** " + method_name + " tablelock:" + " PreCheck fail ");
        }
        return result;
    }
}

