/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.igfs.secondary.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsException;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathAlreadyExistsException;
import org.apache.ignite.igfs.IgfsPathIsNotDirectoryException;
import org.apache.ignite.igfs.IgfsPathNotFoundException;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystemPositionedReadable;
import org.apache.ignite.internal.processors.igfs.IgfsBlockLocationImpl;
import org.apache.ignite.internal.processors.igfs.IgfsDataManager;
import org.apache.ignite.internal.processors.igfs.IgfsImpl;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemBlockKey;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemIgfsFile;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemPositionedReadable;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemSizeVisitor;
import org.apache.ignite.internal.processors.igfs.secondary.local.LocalFileSystemUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lifecycle.LifecycleAware;
import org.apache.ignite.resources.FileSystemResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class LocalIgfsSecondaryFileSystem
implements IgfsSecondaryFileSystem,
LifecycleAware {
    private String workDir;
    @LoggerResource
    private IgniteLogger log;
    @FileSystemResource
    private IgfsImpl igfs;

    private IgfsException handleSecondaryFsError(IOException e, String msg) {
        if (e instanceof FileNotFoundException) {
            return new IgfsPathNotFoundException(e);
        }
        return new IgfsException(msg, e);
    }

    @Override
    public boolean exists(IgfsPath path) {
        return this.fileForPath(path).exists();
    }

    @Override
    @Nullable
    public IgfsFile update(IgfsPath path, Map<String, String> props) {
        File f = this.fileForPath(path);
        if (!f.exists()) {
            return null;
        }
        this.updatePropertiesIfNeeded(path, props);
        return this.info(path);
    }

    @Override
    public void rename(IgfsPath src, IgfsPath dest) {
        File srcFile = this.fileForPath(src);
        File destFile = this.fileForPath(dest);
        if (!srcFile.exists()) {
            throw new IgfsPathNotFoundException("Failed to perform rename because source path not found: " + src);
        }
        if (srcFile.isDirectory() && destFile.isFile()) {
            throw new IgfsPathIsNotDirectoryException("Failed to perform rename because destination path is directory and source path is file [src=" + src + ", dest=" + dest + ']');
        }
        try {
            if (destFile.isDirectory()) {
                Files.move(srcFile.toPath(), destFile.toPath().resolve(srcFile.getName()), new CopyOption[0]);
            } else if (!srcFile.renameTo(destFile)) {
                throw new IgfsException("Failed to perform rename (underlying file system returned false) [src=" + src + ", dest=" + dest + ']');
            }
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to rename [src=" + src + ", dest=" + dest + ']');
        }
    }

    @Override
    public boolean delete(IgfsPath path, boolean recursive) {
        File f = this.fileForPath(path);
        if (!recursive) {
            return f.delete();
        }
        return this.deleteRecursive(f, false);
    }

    private boolean deleteRecursive(File f, boolean deleteIfExists) {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(f.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException ignore) {
            return deleteIfExists && !f.exists();
        }
        if (!attrs.isDirectory() || attrs.isSymbolicLink()) {
            return f.delete() || deleteIfExists && !f.exists();
        }
        File[] entries = f.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                boolean res = this.deleteRecursive(entry, true);
                if (res) continue;
                return false;
            }
        }
        return f.delete() || deleteIfExists && !f.exists();
    }

    @Override
    public void mkdirs(IgfsPath path) {
        if (!this.mkdirs0(this.fileForPath(path))) {
            throw new IgniteException("Failed to make directories (underlying file system returned false): " + path);
        }
    }

    @Override
    public void mkdirs(IgfsPath path, @Nullable Map<String, String> props) {
        this.mkdirs(path);
        this.updatePropertiesIfNeeded(path, props);
    }

    private boolean mkdirs0(@Nullable File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.exists()) {
            return dir.isDirectory();
        }
        File parentDir = dir.getParentFile();
        if (!this.mkdirs0(parentDir)) {
            return false;
        }
        boolean res = dir.mkdir();
        if (!res) {
            res = dir.exists();
        }
        return res;
    }

    @Override
    public Collection<IgfsPath> listPaths(IgfsPath path) {
        File[] entries = this.listFiles0(path);
        if (F.isEmpty(entries)) {
            return Collections.emptySet();
        }
        HashSet<IgfsPath> res = U.newHashSet(entries.length);
        for (File entry : entries) {
            res.add(this.igfsPath(entry));
        }
        return res;
    }

    @Override
    public Collection<IgfsFile> listFiles(IgfsPath path) {
        File[] entries = this.listFiles0(path);
        if (F.isEmpty(entries)) {
            return Collections.emptySet();
        }
        HashSet<IgfsFile> res = U.newHashSet(entries.length);
        for (File entry : entries) {
            IgfsFile info = this.info(this.igfsPath(entry));
            if (info == null) continue;
            res.add(info);
        }
        return res;
    }

    @Nullable
    private File[] listFiles0(IgfsPath path) {
        File f = this.fileForPath(path);
        if (!f.exists()) {
            throw new IgfsPathNotFoundException("Failed to list files (path not found): " + path);
        }
        return f.listFiles();
    }

    @Override
    public IgfsSecondaryFileSystemPositionedReadable open(IgfsPath path, int bufSize) {
        try {
            FileInputStream in = new FileInputStream(this.fileForPath(path));
            return new LocalFileSystemPositionedReadable(in, bufSize);
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to open file for read: " + path);
        }
    }

    @Override
    public OutputStream create(IgfsPath path, boolean overwrite) {
        return this.create0(path, overwrite);
    }

    @Override
    public OutputStream create(IgfsPath path, int bufSize, boolean overwrite, int replication, long blockSize, @Nullable Map<String, String> props) {
        OutputStream os = this.create0(path, overwrite);
        try {
            this.updatePropertiesIfNeeded(path, props);
            return os;
        }
        catch (Exception err) {
            try {
                os.close();
            }
            catch (IOException closeErr) {
                err.addSuppressed(closeErr);
            }
            throw err;
        }
    }

    @Override
    public OutputStream append(IgfsPath path, int bufSize, boolean create, @Nullable Map<String, String> props) {
        try {
            File file = this.fileForPath(path);
            boolean exists = file.exists();
            if (exists) {
                FileOutputStream os = new FileOutputStream(file, true);
                try {
                    this.updatePropertiesIfNeeded(path, props);
                    return os;
                }
                catch (Exception err) {
                    try {
                        ((OutputStream)os).close();
                        throw err;
                    }
                    catch (IOException closeErr) {
                        err.addSuppressed(closeErr);
                        throw err;
                    }
                }
            }
            if (create) {
                return this.create(path, bufSize, false, 0, 0L, props);
            }
            throw new IgfsPathNotFoundException("Failed to append to file because it doesn't exist: " + path);
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to append to file because it doesn't exist: " + path);
        }
    }

    @Override
    public IgfsFile info(IgfsPath path) {
        File file = this.fileForPath(path);
        if (!file.exists()) {
            return null;
        }
        boolean isDir = file.isDirectory();
        PosixFileAttributes attrs = LocalFileSystemUtils.posixAttributes(file);
        Map<String, String> props = LocalFileSystemUtils.posixAttributesToMap(attrs);
        BasicFileAttributes basicAttrs = LocalFileSystemUtils.basicAttributes(file);
        if (isDir) {
            return new LocalFileSystemIgfsFile(path, false, true, 0, basicAttrs.lastAccessTime().toMillis(), basicAttrs.lastModifiedTime().toMillis(), 0L, props);
        }
        return new LocalFileSystemIgfsFile(path, file.isFile(), false, 0, basicAttrs.lastAccessTime().toMillis(), basicAttrs.lastModifiedTime().toMillis(), file.length(), props);
    }

    @Override
    public long usedSpaceSize() {
        Path p = this.fileForPath(IgfsPath.ROOT).toPath();
        try {
            LocalFileSystemSizeVisitor visitor = new LocalFileSystemSizeVisitor();
            Files.walkFileTree(p, visitor);
            return visitor.size();
        }
        catch (IOException e) {
            throw new IgfsException("Failed to calculate used space size.", e);
        }
    }

    @Override
    public void setTimes(IgfsPath path, long modificationTime, long accessTime) throws IgniteException {
        Path p = this.fileForPath(path).toPath();
        if (!Files.exists(p, new LinkOption[0])) {
            throw new IgfsPathNotFoundException("Failed to set times (path not found): " + path);
        }
        try {
            Files.getFileAttributeView(p, BasicFileAttributeView.class, new LinkOption[0]).setTimes(modificationTime >= 0L ? FileTime.from(modificationTime, TimeUnit.MILLISECONDS) : null, accessTime >= 0L ? FileTime.from(accessTime, TimeUnit.MILLISECONDS) : null, null);
        }
        catch (IOException e) {
            throw new IgniteException("Failed to set times for path: " + path, e);
        }
    }

    @Override
    public void start() throws IgniteException {
        if (this.workDir != null) {
            this.workDir = new File(this.workDir).getAbsolutePath();
        }
    }

    @Override
    public void stop() throws IgniteException {
    }

    @Override
    public Collection<IgfsBlockLocation> affinity(IgfsPath path, long start, long len, long maxLen) throws IgniteException {
        long lenStep;
        File f = this.fileForPath(path);
        if (!f.exists()) {
            throw new IgfsPathNotFoundException("File not found: " + path);
        }
        long blockSize = this.igfs.configuration().getBlockSize();
        if (maxLen <= 0L) {
            maxLen = Long.MAX_VALUE;
        }
        assert (maxLen > 0L) : "maxLen : " + maxLen;
        long end = start + len;
        ArrayList<IgfsBlockLocation> blocks = new ArrayList<IgfsBlockLocation>((int)(len / maxLen));
        IgfsDataManager data = this.igfs.context().data();
        Collection<ClusterNode> lastNodes = null;
        long lastBlockIdx = -1L;
        IgfsBlockLocationImpl lastBlock = null;
        for (long offset = start; offset < end; offset += lenStep) {
            long blockIdx = offset / blockSize;
            lenStep = Math.min(maxLen - (lastBlock != null ? lastBlock.length() : 0L), (blockIdx + 1L) * blockSize - offset);
            lenStep = Math.min(lenStep, end - offset);
            LocalFileSystemBlockKey affKey = new LocalFileSystemBlockKey(path, blockIdx);
            if (blockIdx != lastBlockIdx) {
                Collection<ClusterNode> nodes = data.affinityNodes(affKey);
                if (!nodes.equals(lastNodes) && lastNodes != null && lastBlock != null) {
                    blocks.add(lastBlock);
                    lastBlock = null;
                }
                lastNodes = nodes;
                lastBlockIdx = blockIdx;
            }
            if (lastBlock == null) {
                lastBlock = new IgfsBlockLocationImpl(offset, lenStep, lastNodes);
            } else {
                lastBlock.increaseLength(lenStep);
            }
            if (lastBlock.length() != maxLen && lastBlock.start() + lastBlock.length() != end) continue;
            blocks.add(lastBlock);
            lastBlock = null;
        }
        return blocks;
    }

    @Nullable
    public String getWorkDirectory() {
        return this.workDir;
    }

    public void setWorkDirectory(@Nullable String workDir) {
        this.workDir = workDir;
    }

    private File fileForPath(IgfsPath path) {
        if (this.workDir == null) {
            return new File(path.toString());
        }
        if ("/".equals(path.toString())) {
            return new File(this.workDir);
        }
        return new File(this.workDir, path.toString());
    }

    private IgfsPath igfsPath(File f) throws IgfsException {
        String path = f.getAbsolutePath();
        if (this.workDir != null) {
            if (!path.startsWith(this.workDir)) {
                throw new IgfsException("Path is not located in the work directory [workDir=" + this.workDir + ", path=" + path + ']');
            }
            path = path.substring(this.workDir.length(), path.length());
        }
        return new IgfsPath(path);
    }

    private OutputStream create0(IgfsPath path, boolean overwrite) {
        File file = this.fileForPath(path);
        boolean exists = file.exists();
        if (exists) {
            if (!overwrite) {
                throw new IgfsPathAlreadyExistsException("Failed to create a file because it already exists: " + path);
            }
        } else {
            File parent = file.getParentFile();
            if (!this.mkdirs0(parent)) {
                throw new IgfsException("Failed to create parent directory for file (underlying file system returned false): " + path);
            }
        }
        try {
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to create file [path=" + path + ", overwrite=" + overwrite + ']');
        }
    }

    private void updatePropertiesIfNeeded(IgfsPath path, Map<String, String> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        File file = this.fileForPath(path);
        if (!file.exists()) {
            throw new IgfsPathNotFoundException("Failed to update properties for path: " + path);
        }
        LocalFileSystemUtils.updateProperties(file, props.get("grpName"), props.get("permission"));
    }
}

