/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.security;

import java.util.Date;

public class OAuth2Tokens {
    protected final String accessToken;
    protected final String refreshToken;
    protected Date expiry;

    public OAuth2Tokens(String accessToken, String refreshToken, Date expiry) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiry = expiry;
        if (refreshToken == null) {
            throw new IllegalArgumentException("Null refresh tokens not permitted when constructing " + this.getClass().getName());
        }
        if (accessToken == null) {
            this.expireAccessToken();
        }
    }

    public OAuth2Tokens(String accessToken, String refreshToken) {
        this(accessToken, refreshToken, null);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Date getExpiry() {
        return this.expiry;
    }

    public void expireAccessToken() {
        this.expiry = new Date(0L);
    }

    public boolean isAccessTokenExpired() {
        if (this.getExpiry() != null) {
            return this.getExpiry().before(new Date());
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + " [accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", expiry=" + this.getExpiry() + ", isExpired? " + this.isAccessTokenExpired() + "]";
    }

    public static Date calculateExpiry(Number expiresInSeconds) {
        long expiresInMsec = 0L;
        if (expiresInSeconds != null) {
            expiresInMsec = expiresInSeconds.longValue() * 1000L;
        }
        return new Date(System.currentTimeMillis() + expiresInMsec);
    }
}

