/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings;

import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.constants.PosixBracket;
import org.jcodings.exception.CharacterPropertyException;

abstract class AbstractEncoding
extends Encoding {
    private final short[] CTypeTable;
    protected static final CaseFoldCodeItem[] EMPTY_FOLD_CODES = new CaseFoldCodeItem[0];

    protected AbstractEncoding(String name, int minLength, int maxLength, short[] CTypeTable) {
        super(name, minLength, maxLength);
        this.CTypeTable = CTypeTable;
    }

    protected AbstractEncoding(String name, int minLength, int maxLength, short[] CTypeTable, boolean isDummy) {
        super(name, minLength, maxLength, isDummy);
        this.CTypeTable = CTypeTable;
    }

    private static int CTypeToBit(int ctype) {
        return 1 << ctype;
    }

    protected final boolean isCodeCTypeInternal(int code, int ctype) {
        return (this.CTypeTable[code] & AbstractEncoding.CTypeToBit(ctype)) != 0;
    }

    public boolean isNewLine(byte[] bytes, int p, int end) {
        return p < end ? bytes[p] == 10 : false;
    }

    protected final int asciiMbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] lower) {
        lower[0] = AsciiTables.ToLowerCaseTable[bytes[pp.value] & 0xFF];
        ++pp.value;
        return 1;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] lower) {
        return this.asciiMbcCaseFold(flag, bytes, pp, end, lower);
    }

    protected final void asciiApplyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg) {
        int[] code = new int[]{0};
        for (int i = 0; i < AsciiTables.LowerMap.length; ++i) {
            code[0] = AsciiTables.LowerMap[i][1];
            fun.apply(AsciiTables.LowerMap[i][0], code, 1, arg);
            code[0] = AsciiTables.LowerMap[i][0];
            fun.apply(AsciiTables.LowerMap[i][1], code, 1, arg);
        }
    }

    public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg) {
        this.asciiApplyAllCaseFold(flag, fun, arg);
    }

    protected final CaseFoldCodeItem[] asciiCaseFoldCodesByString(int flag, byte[] bytes, int p, int end) {
        int b = bytes[p] & 0xFF;
        if (65 <= b && b <= 90) {
            return new CaseFoldCodeItem[]{new CaseFoldCodeItem(1, 1, new int[]{b + 32})};
        }
        if (97 <= b && b <= 122) {
            return new CaseFoldCodeItem[]{new CaseFoldCodeItem(1, 1, new int[]{b - 32})};
        }
        return EMPTY_FOLD_CODES;
    }

    public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes, int p, int end) {
        return this.asciiCaseFoldCodesByString(flag, bytes, p, end);
    }

    public int propertyNameToCType(byte[] bytes, int p, int end) {
        Integer ctype = PosixBracket.PBSTableUpper.get(bytes, p, end);
        if (ctype != null) {
            return ctype;
        }
        throw new CharacterPropertyException("invalid character property name <%n>", new String(bytes, p, end - p));
    }
}

