/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.query.VisorQueryField;

public class VisorQueryResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private UUID resNodeId;
    private String qryId;
    private List<VisorQueryField> cols;
    private List<Object[]> rows;
    private boolean hasMore;
    private long duration;

    public VisorQueryResult() {
    }

    public VisorQueryResult(UUID resNodeId, String qryId, List<VisorQueryField> cols, List<Object[]> rows, boolean hasMore, long duration) {
        this.resNodeId = resNodeId;
        this.qryId = qryId;
        this.cols = cols;
        this.rows = rows;
        this.hasMore = hasMore;
        this.duration = duration;
    }

    public UUID getResponseNodeId() {
        return this.resNodeId;
    }

    public String getQueryId() {
        return this.qryId;
    }

    public Collection<VisorQueryField> getColumns() {
        return this.cols;
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.resNodeId);
        U.writeString(out, this.qryId);
        U.writeCollection(out, this.cols);
        U.writeCollection(out, this.rows);
        out.writeBoolean(this.hasMore);
        out.writeLong(this.duration);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.resNodeId = U.readUuid(in);
        this.qryId = U.readString(in);
        this.cols = U.readList(in);
        this.rows = U.readList(in);
        this.hasMore = in.readBoolean();
        this.duration = in.readLong();
    }

    public String toString() {
        return S.toString(VisorQueryResult.class, this);
    }
}

