/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorMemoryMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private long totalAllocatedPages;
    private float allocationRate;
    private float evictionRate;
    private float largeEntriesPagesPercentage;
    private float pagesFillFactor;
    private long dirtyPages;
    private float pagesReplaceRate;
    private long physicalMemoryPages;
    private long totalAllocatedSz;
    private long physicalMemSz;
    private long cpBufPages;
    private long cpBufSz;
    private int pageSize;

    public VisorMemoryMetrics() {
    }

    public VisorMemoryMetrics(DataRegionMetrics m) {
        this.name = m.getName();
        this.totalAllocatedPages = m.getTotalAllocatedPages();
        this.allocationRate = m.getAllocationRate();
        this.evictionRate = m.getEvictionRate();
        this.largeEntriesPagesPercentage = m.getLargeEntriesPagesPercentage();
        this.pagesFillFactor = m.getPagesFillFactor();
        this.dirtyPages = m.getDirtyPages();
        this.pagesReplaceRate = m.getPagesReplaceRate();
        this.physicalMemoryPages = m.getPhysicalMemoryPages();
        this.totalAllocatedSz = m.getTotalAllocatedSize();
        this.physicalMemSz = m.getPhysicalMemorySize();
        this.cpBufPages = m.getCheckpointBufferPages();
        this.cpBufSz = m.getCheckpointBufferSize();
        this.pageSize = m.getPageSize();
    }

    public String getName() {
        return this.name;
    }

    public long getTotalAllocatedPages() {
        return this.totalAllocatedPages;
    }

    public float getAllocationRate() {
        return this.allocationRate;
    }

    public float getEvictionRate() {
        return this.evictionRate;
    }

    public float getLargeEntriesPagesPercentage() {
        return this.largeEntriesPagesPercentage;
    }

    public float getPagesFillFactor() {
        return this.pagesFillFactor;
    }

    public long getDirtyPages() {
        return this.dirtyPages;
    }

    public float getPagesReplaceRate() {
        return this.pagesReplaceRate;
    }

    public long getPhysicalMemoryPages() {
        return this.physicalMemoryPages;
    }

    public long getTotalAllocatedSize() {
        return this.totalAllocatedSz;
    }

    public long getPhysicalMemorySize() {
        return this.physicalMemSz;
    }

    public long getCheckpointBufferPages() {
        return this.cpBufPages;
    }

    public long getCheckpointBufferSize() {
        return this.cpBufSz;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeLong(this.totalAllocatedPages);
        out.writeFloat(this.allocationRate);
        out.writeFloat(this.evictionRate);
        out.writeFloat(this.largeEntriesPagesPercentage);
        out.writeFloat(this.pagesFillFactor);
        out.writeLong(this.dirtyPages);
        out.writeFloat(this.pagesReplaceRate);
        out.writeLong(this.physicalMemoryPages);
        out.writeLong(this.totalAllocatedSz);
        out.writeLong(this.physicalMemSz);
        out.writeLong(this.cpBufPages);
        out.writeLong(this.cpBufSz);
        out.writeInt(this.pageSize);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.totalAllocatedPages = in.readLong();
        this.allocationRate = in.readFloat();
        this.evictionRate = in.readFloat();
        this.largeEntriesPagesPercentage = in.readFloat();
        this.pagesFillFactor = in.readFloat();
        this.dirtyPages = in.readLong();
        this.pagesReplaceRate = in.readFloat();
        this.physicalMemoryPages = in.readLong();
        if (protoVer > 1) {
            this.totalAllocatedSz = in.readLong();
            this.physicalMemSz = in.readLong();
            this.cpBufPages = in.readLong();
            this.cpBufSz = in.readLong();
            this.pageSize = in.readInt();
        }
    }

    public String toString() {
        return S.toString(VisorMemoryMetrics.class, this);
    }
}

