/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.entityframework;

import java.util.Arrays;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.jetbrains.annotations.NotNull;

public class PlatformDotNetEntityFrameworkCacheKey
implements Binarylizable,
Comparable<PlatformDotNetEntityFrameworkCacheKey> {
    private String query;
    private long[] versions;

    public PlatformDotNetEntityFrameworkCacheKey() {
    }

    PlatformDotNetEntityFrameworkCacheKey(String query, long[] versions) {
        assert (query != null);
        this.query = query;
        this.versions = versions;
    }

    public String query() {
        return this.query;
    }

    public long[] versions() {
        return this.versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformDotNetEntityFrameworkCacheKey key = (PlatformDotNetEntityFrameworkCacheKey)o;
        if (!this.query.equals(key.query)) {
            return false;
        }
        return Arrays.equals(this.versions, key.versions);
    }

    public int hashCode() {
        int result = this.query.hashCode();
        result = 31 * result + Arrays.hashCode(this.versions);
        return result;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter raw = writer.rawWriter();
        raw.writeString(this.query);
        if (this.versions != null) {
            raw.writeInt(this.versions.length);
            for (long ver : this.versions) {
                raw.writeLong(ver);
            }
        } else {
            raw.writeInt(-1);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader raw = reader.rawReader();
        this.query = raw.readString();
        int cnt = raw.readInt();
        if (cnt >= 0) {
            this.versions = new long[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.versions[i] = raw.readLong();
            }
        } else {
            this.versions = null;
        }
    }

    @Override
    public int compareTo(@NotNull PlatformDotNetEntityFrameworkCacheKey o) {
        int cmpQuery = this.query.compareTo(o.query);
        if (cmpQuery != 0) {
            return cmpQuery;
        }
        if (this.versions == null) {
            return o.versions == null ? 0 : -1;
        }
        if (o.versions == null) {
            return 1;
        }
        assert (this.versions.length == o.versions.length);
        for (int i = 0; i < this.versions.length; ++i) {
            if (this.versions[i] == o.versions[i]) continue;
            return this.versions[i] > o.versions[i] ? 1 : -1;
        }
        return 0;
    }
}

