/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.odbc.ClientListenerConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientMessageParser;
import org.apache.ignite.internal.processors.platform.client.ClientRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientResourceRegistry;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.plugin.security.AuthenticationContext;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecuritySubjectType;

public class ClientConnectionContext
implements ClientListenerConnectionContext {
    public static final ClientListenerProtocolVersion VER_1_0_0 = ClientListenerProtocolVersion.create(1, 0, 0);
    public static final ClientListenerProtocolVersion VER_1_1_0 = ClientListenerProtocolVersion.create(1, 1, 0);
    private static final Collection<ClientListenerProtocolVersion> SUPPORTED_VERS = Arrays.asList(VER_1_1_0, VER_1_0_0);
    private final ClientMessageParser parser;
    private ClientRequestHandler handler;
    private final ClientResourceRegistry resReg = new ClientResourceRegistry();
    private final GridKernalContext kernalCtx;
    private final int maxCursors;
    private final AtomicLong curCnt = new AtomicLong();
    private SecurityContext secCtx = null;

    public ClientConnectionContext(GridKernalContext ctx, int maxCursors) {
        assert (ctx != null);
        this.kernalCtx = ctx;
        this.parser = new ClientMessageParser(ctx);
        this.maxCursors = maxCursors;
    }

    public ClientResourceRegistry resources() {
        return this.resReg;
    }

    public GridKernalContext kernalContext() {
        return this.kernalCtx;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion currentVersion() {
        return VER_1_1_0;
    }

    @Override
    public void initializeFromHandshake(ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        String user = null;
        String pwd = null;
        AuthorizationContext authCtx = null;
        if (ver.compareTo(VER_1_1_0) >= 0) {
            boolean hasMore;
            try {
                hasMore = reader.available() > 0;
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            if (hasMore) {
                user = reader.readString();
                pwd = reader.readString();
            }
        }
        if (this.kernalCtx.security().enabled()) {
            authCtx = this.thirdPartyAuthentication(user, pwd).authorizationContext();
        } else if (this.kernalCtx.authentication().enabled()) {
            if (user == null || user.length() == 0) {
                throw new IgniteAccessControlException("Unauthenticated sessions are prohibited.");
            }
            authCtx = this.kernalCtx.authentication().authenticate(user, pwd);
            if (authCtx == null) {
                throw new IgniteAccessControlException("Unknown authentication error.");
            }
        }
        this.handler = new ClientRequestHandler(this, authCtx);
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.resReg.clean();
    }

    public void incrementCursors() {
        long curCnt0 = this.curCnt.get();
        if (curCnt0 >= (long)this.maxCursors) {
            throw new IgniteClientException(1010, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + curCnt0 + ']');
        }
        this.curCnt.incrementAndGet();
    }

    public void decrementCursors() {
        this.curCnt.decrementAndGet();
    }

    public SecurityContext securityContext() {
        return this.secCtx;
    }

    private AuthenticationContext thirdPartyAuthentication(String user, String pwd) throws IgniteCheckedException {
        SecurityCredentials cred = new SecurityCredentials(user, pwd);
        AuthenticationContext authCtx = new AuthenticationContext();
        authCtx.subjectType(SecuritySubjectType.REMOTE_CLIENT);
        authCtx.subjectId(UUID.randomUUID());
        authCtx.nodeAttributes(Collections.emptyMap());
        authCtx.credentials(cred);
        this.secCtx = this.kernalCtx.security().authenticate(authCtx);
        if (this.secCtx == null) {
            throw new IgniteAccessControlException(String.format("The user name or password is incorrect [userName=%s]", user));
        }
        return authCtx;
    }
}

