/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.affinity;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.cache.affinity.PlatformAffinityUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PlatformAffinityFunctionTarget
extends PlatformAbstractTarget {
    private static final int OP_PARTITION = 1;
    private static final int OP_REMOVE_NODE = 2;
    private static final int OP_ASSIGN_PARTITIONS = 3;
    private final AffinityFunction baseFunc;
    private static final ThreadLocal<AffinityFunctionContext> currentAffCtx = new ThreadLocal();

    protected PlatformAffinityFunctionTarget(PlatformContext platformCtx, AffinityFunction baseFunc) {
        super(platformCtx);
        assert (baseFunc != null);
        this.baseFunc = baseFunc;
        try {
            platformCtx.kernalContext().resource().injectGeneric(baseFunc);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        if (type == 1) {
            return this.baseFunc.partition(reader.readObjectDetached());
        }
        if (type == 2) {
            this.baseFunc.removeNode(reader.readUuid());
            return 0L;
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processOutStream(int type, BinaryRawWriterEx writer) throws IgniteCheckedException {
        if (type == 3) {
            AffinityFunctionContext affCtx = currentAffCtx.get();
            if (affCtx == null) {
                throw new IgniteException("Thread-local AffinityFunctionContext is null. This may indicate an unsupported call to the base AffinityFunction.");
            }
            List<List<ClusterNode>> partitions = this.baseFunc.assignPartitions(affCtx);
            PlatformAffinityUtils.writePartitionAssignment(partitions, writer, this.platformContext());
            return;
        }
        super.processOutStream(type, writer);
    }

    void setCurrentAffinityFunctionContext(AffinityFunctionContext ctx) {
        currentAffCtx.set(ctx);
    }
}

