/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsMetaFileUnlockProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private long modificationTime;
    private boolean updateSpace;
    private long space;
    private IgfsFileAffinityRange affRange;

    public IgfsMetaFileUnlockProcessor() {
    }

    public IgfsMetaFileUnlockProcessor(long modificationTime, boolean updateSpace, long space, @Nullable IgfsFileAffinityRange affRange) {
        this.modificationTime = modificationTime;
        this.updateSpace = updateSpace;
        this.space = space;
        this.affRange = affRange;
    }

    public Void process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo oldInfo = (IgfsEntryInfo)entry.getValue();
        assert (oldInfo != null);
        IgfsEntryInfo newInfo = oldInfo.unlock(this.modificationTime);
        if (this.updateSpace) {
            IgfsFileMap newMap = new IgfsFileMap(newInfo.fileMap());
            newMap.addRange(this.affRange);
            newInfo = newInfo.length(newInfo.length() + this.space).fileMap(newMap);
        }
        entry.setValue((Object)newInfo);
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.modificationTime);
        if (this.updateSpace) {
            out.writeBoolean(true);
            out.writeLong(this.space);
            out.writeObject(this.affRange);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.modificationTime = in.readLong();
        if (in.readBoolean()) {
            this.updateSpace = true;
            this.space = in.readLong();
            this.affRange = (IgfsFileAffinityRange)in.readObject();
        } else {
            this.updateSpace = false;
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeLong(this.modificationTime);
        if (this.updateSpace) {
            out.writeBoolean(true);
            out.writeLong(this.space);
            out.writeObject(this.affRange);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.modificationTime = in.readLong();
        if (in.readBoolean()) {
            this.updateSpace = true;
            this.space = in.readLong();
            this.affRange = (IgfsFileAffinityRange)in.readObject();
        } else {
            this.updateSpace = false;
        }
    }

    public String toString() {
        return S.toString(IgfsMetaFileUnlockProcessor.class, this);
    }
}

