/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.processors.igfs.IgfsCommunicationMessage;
import org.apache.ignite.internal.processors.igfs.IgfsDataManager;
import org.apache.ignite.internal.processors.igfs.IgfsEx;
import org.apache.ignite.internal.processors.igfs.IgfsFragmentizerManager;
import org.apache.ignite.internal.processors.igfs.IgfsImpl;
import org.apache.ignite.internal.processors.igfs.IgfsLocalMetrics;
import org.apache.ignite.internal.processors.igfs.IgfsManager;
import org.apache.ignite.internal.processors.igfs.IgfsMetaManager;
import org.apache.ignite.internal.processors.igfs.IgfsServerManager;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

public class IgfsContext {
    private final GridKernalContext ctx;
    private final FileSystemConfiguration cfg;
    private List<IgfsManager> mgrs = new LinkedList<IgfsManager>();
    private final IgfsMetaManager metaMgr;
    private final IgfsDataManager dataMgr;
    private final IgfsServerManager srvMgr;
    private final IgfsFragmentizerManager fragmentizerMgr;
    private final IgfsEx igfs;
    private final IgfsLocalMetrics metrics = new IgfsLocalMetrics();
    private volatile ClusterNode locNode;
    private ExecutorService igfsSvc;
    protected IgniteLogger log;

    public IgfsContext(GridKernalContext ctx, FileSystemConfiguration cfg, IgfsMetaManager metaMgr, IgfsDataManager dataMgr, IgfsServerManager srvMgr, IgfsFragmentizerManager fragmentizerMgr) throws IgniteCheckedException {
        this.ctx = ctx;
        this.cfg = cfg;
        this.metaMgr = this.add(metaMgr);
        this.dataMgr = this.add(dataMgr);
        this.srvMgr = this.add(srvMgr);
        this.fragmentizerMgr = this.add(fragmentizerMgr);
        this.log = ctx.log(IgfsContext.class);
        this.igfsSvc = ctx.getIgfsExecutorService();
        this.igfs = new IgfsImpl(this);
    }

    public IgfsEx igfs() {
        return this.igfs;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public FileSystemConfiguration configuration() {
        return this.cfg;
    }

    public List<IgfsManager> managers() {
        return this.mgrs;
    }

    public IgfsMetaManager meta() {
        return this.metaMgr;
    }

    public IgfsDataManager data() {
        return this.dataMgr;
    }

    public IgfsServerManager server() {
        return this.srvMgr;
    }

    public IgfsFragmentizerManager fragmentizer() {
        return this.fragmentizerMgr;
    }

    public void send(UUID nodeId, Object topic, IgfsCommunicationMessage msg, byte plc) throws IgniteCheckedException {
        if (!this.kernalContext().localNodeId().equals(nodeId)) {
            msg.prepareMarshal(this.kernalContext().config().getMarshaller());
        }
        if (topic instanceof GridTopic) {
            this.kernalContext().io().sendToGridTopic(nodeId, (GridTopic)((Object)topic), (Message)msg, plc);
        } else {
            this.kernalContext().io().sendToCustomTopic(nodeId, topic, (Message)msg, plc);
        }
    }

    public boolean igfsNode(ClusterNode node) {
        return IgfsUtils.isIgfsNode(node, this.cfg.getName());
    }

    public IgfsLocalMetrics metrics() {
        return this.metrics;
    }

    public ClusterNode localNode() {
        if (this.locNode == null) {
            this.locNode = this.ctx.discovery().localNode();
        }
        return this.locNode;
    }

    public void runInIgfsThreadPool(Runnable r) {
        try {
            this.igfsSvc.execute(r);
        }
        catch (RejectedExecutionException ignored) {
            try {
                r.run();
            }
            catch (Exception e) {
                this.log.warning("Failed to execute IGFS runnable: " + r, e);
            }
        }
    }

    private <T extends IgfsManager> T add(@Nullable T mgr) {
        if (mgr != null) {
            this.mgrs.add(mgr);
        }
        return mgr;
    }
}

