/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;

public class IgfsClientSession {
    private ConcurrentMap<Long, Closeable> rsrcMap = new ConcurrentHashMap<Long, Closeable>();

    public boolean registerResource(long rsrcId, Closeable rsrc) {
        Closeable old = this.rsrcMap.putIfAbsent(rsrcId, rsrc);
        return old == null;
    }

    @Nullable
    public <T> T resource(Long rsrcId) {
        return (T)this.rsrcMap.get(rsrcId);
    }

    public boolean unregisterResource(Long rsrcId, Closeable rsrc) {
        return this.rsrcMap.remove(rsrcId, rsrc);
    }

    public Iterator<Closeable> registeredResources() {
        return this.rsrcMap.values().iterator();
    }
}

