/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import org.apache.ignite.internal.processors.hadoop.HadoopClasspathUtils;

public class HadoopLocations {
    private final String home;
    private final String common;
    private final String hdfs;
    private final String mapred;
    private final boolean commonExists;
    private final boolean hdfsExists;
    private final boolean mapredExists;

    public HadoopLocations(String home, String common, String hdfs, String mapred) {
        assert (common != null && hdfs != null && mapred != null);
        this.home = home;
        this.common = common;
        this.hdfs = hdfs;
        this.mapred = mapred;
        this.commonExists = HadoopClasspathUtils.exists(common);
        this.hdfsExists = HadoopClasspathUtils.exists(hdfs);
        this.mapredExists = HadoopClasspathUtils.exists(mapred);
    }

    public String home() {
        return this.home;
    }

    public String common() {
        return this.common;
    }

    public String hdfs() {
        return this.hdfs;
    }

    public String mapred() {
        return this.mapred;
    }

    public boolean commonExists() {
        return this.commonExists;
    }

    public boolean hdfsExists() {
        return this.hdfsExists;
    }

    public boolean mapredExists() {
        return this.mapredExists;
    }

    public boolean valid() {
        return this.commonExists && this.hdfsExists && this.mapredExists;
    }
}

