/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class DataRow
extends CacheDataRowAdapter {
    protected int part;
    protected int hash;

    DataRow(CacheGroupContext grp, int hash, long link, int part, CacheDataRowAdapter.RowData rowData) {
        super(link);
        this.hash = hash;
        this.part = part;
        try {
            this.initFromLink(grp, rowData);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        if (this.key != null) {
            this.key.partition(part);
        }
    }

    public DataRow(KeyCacheObject key, CacheObject val, GridCacheVersion ver, int part, long expireTime, int cacheId) {
        super(0L);
        this.hash = key.hashCode();
        this.key = key;
        this.val = val;
        this.ver = ver;
        this.part = part;
        this.expireTime = expireTime;
        this.cacheId = cacheId;
    }

    @Override
    public int partition() {
        return this.part;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public void link(long link) {
        this.link = link;
    }

    public void cacheId(int cacheId) {
        this.cacheId = cacheId;
    }
}

