/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PagesListRemovePageRecord
extends PageDeltaRecord {
    @GridToStringExclude
    private final long rmvdPageId;

    public PagesListRemovePageRecord(int cacheId, long pageId, long rmvdPageId) {
        super(cacheId, pageId);
        this.rmvdPageId = rmvdPageId;
    }

    public long removedPageId() {
        return this.rmvdPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
        boolean rmvd = io.removePage(pageAddr, this.rmvdPageId);
        assert (rmvd);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGES_LIST_REMOVE_PAGE;
    }

    @Override
    public String toString() {
        return S.toString(PagesListRemovePageRecord.class, this, "rmvdPageId", U.hexLong(this.rmvdPageId), "pageId", (Object)U.hexLong(this.pageId()), "grpId", this.groupId(), "super", super.toString());
    }
}

