/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class FixCountRecord
extends PageDeltaRecord {
    private int cnt;

    public FixCountRecord(int grpId, long pageId, int cnt) {
        super(grpId, pageId);
        this.cnt = cnt;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        Object io = PageIO.getBPlusIO(pageAddr);
        ((BPlusIO)io).setCount(pageAddr, this.cnt);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_FIX_COUNT;
    }

    public int count() {
        return this.cnt;
    }

    @Override
    public String toString() {
        return S.toString(FixCountRecord.class, this, "super", super.toString());
    }
}

