/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.igfs.common;

import java.util.Map;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.igfs.common.IgfsMessage;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsPathControlRequest
extends IgfsMessage {
    private IgfsPath path;
    private IgfsPath destPath;
    private boolean flag;
    private boolean colocate;
    private Map<String, String> props;
    private int seqReadsBeforePrefetch;
    private long start;
    private long len;
    private int replication;
    private long blockSize;
    private long accessTime;
    private long modificationTime;
    private String userName;

    public void path(IgfsPath path) {
        this.path = path;
    }

    public void destinationPath(IgfsPath destPath) {
        this.destPath = destPath;
    }

    public void flag(boolean flag) {
        this.flag = flag;
    }

    public void colocate(boolean colocate) {
        this.colocate = colocate;
    }

    public void replication(int replication) {
        this.replication = replication;
    }

    public void blockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public void properties(@Nullable Map<String, String> props) {
        this.props = props;
    }

    public void sequentialReadsBeforePrefetch(int seqReadsBeforePrefetch) {
        this.seqReadsBeforePrefetch = seqReadsBeforePrefetch;
    }

    public void start(long start) {
        this.start = start;
    }

    public void length(long len) {
        this.len = len;
    }

    public void accessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public void modificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public IgfsPath path() {
        return this.path;
    }

    public IgfsPath destinationPath() {
        return this.destPath;
    }

    public boolean flag() {
        return this.flag;
    }

    public boolean colocate() {
        return this.colocate;
    }

    public int replication() {
        return this.replication;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public Map<String, String> properties() {
        return this.props;
    }

    public int sequentialReadsBeforePrefetch() {
        return this.seqReadsBeforePrefetch;
    }

    public long start() {
        return this.start;
    }

    public long length() {
        return this.len;
    }

    public long accessTime() {
        return this.accessTime;
    }

    public long modificationTime() {
        return this.modificationTime;
    }

    public String toString() {
        return S.toString(IgfsPathControlRequest.class, this, "cmd", (Object)this.command());
    }

    public final String userName() {
        assert (this.userName != null);
        return this.userName;
    }

    public final void userName(String userName) {
        this.userName = IgfsUtils.fixUserName(userName);
    }
}

