/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.commandline.Arguments;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.cache.CacheArguments;
import org.apache.ignite.internal.commandline.cache.CacheCommand;
import org.apache.ignite.internal.processors.cache.verify.CacheInfo;
import org.apache.ignite.internal.processors.cache.verify.ContentionInfo;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.baseline.VisorBaselineNode;
import org.apache.ignite.internal.visor.baseline.VisorBaselineOperation;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTask;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskArg;
import org.apache.ignite.internal.visor.baseline.VisorBaselineTaskResult;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorContentionTask;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskArg;
import org.apache.ignite.internal.visor.verify.VisorContentionTaskResult;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.apache.ignite.internal.visor.verify.VisorViewCacheCmd;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTask;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTaskArg;
import org.apache.ignite.internal.visor.verify.VisorViewCacheTaskResult;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;

public class CommandHandler {
    private static final Logger log = Logger.getLogger(CommandHandler.class.getName());
    static final String DFLT_HOST = "127.0.0.1";
    static final String DFLT_PORT = "11211";
    private static final String CMD_HELP = "--help";
    private static final String CMD_HOST = "--host";
    private static final String CMD_PORT = "--port";
    private static final String CMD_PASSWORD = "--password";
    private static final String CMD_USER = "--user";
    private static final String CMD_FORCE = "--force";
    private static final Set<String> AUX_COMMANDS = new HashSet<String>();
    private static final UUID BROADCAST_UUID;
    protected static final String CMD_PING_INTERVAL = "--ping-interval";
    protected static final String CMD_PING_TIMEOUT = "--ping-timeout";
    public static final String CONFIRM_MSG = "y";
    private static final String BASELINE_ADD = "add";
    private static final String BASELINE_REMOVE = "remove";
    private static final String BASELINE_COLLECT = "collect";
    private static final String BASELINE_SET = "set";
    private static final String BASELINE_SET_VERSION = "version";
    private static final String DELIM = "--------------------------------------------------------------------------------";
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 1;
    public static final int EXIT_CODE_CONNECTION_FAILED = 2;
    public static final int ERR_AUTHENTICATION_FAILED = 3;
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 4;
    private static final long DFLT_PING_INTERVAL = 5000L;
    private static final long DFLT_PING_TIMEOUT = 30000L;
    private static final Scanner IN;
    private static final String VALIDATE_INDEXES_TASK = "org.apache.ignite.internal.visor.verify.VisorValidateIndexesTask";
    private static final String TX_LIMIT = "limit";
    private static final String TX_ORDER = "order";
    private static final String TX_SERVERS = "servers";
    private static final String TX_CLIENTS = "clients";
    private static final String TX_DURATION = "minDuration";
    private static final String TX_SIZE = "minSize";
    private static final String TX_LABEL = "label";
    private static final String TX_NODES = "nodes";
    private static final String TX_XID = "xid";
    private static final String TX_KILL = "kill";
    private Iterator<String> argsIt;
    private String peekedArg;
    private Object lastOperationRes;

    private void log(String s) {
        System.out.println(s);
    }

    private String readLine(String prompt) {
        System.out.print(prompt);
        return IN.nextLine();
    }

    private void nl() {
        System.out.println("");
    }

    private int error(int errCode, String s, Throwable e) {
        String msg;
        if (!F.isEmpty(s)) {
            this.log(s);
        }
        if (F.isEmpty(msg = e.getMessage())) {
            msg = e.getClass().getName();
        }
        if (msg.startsWith("Failed to handle request")) {
            int p = msg.indexOf("err=");
            msg = msg.substring(p + 4, msg.length() - 1);
        }
        this.log("Error: " + msg);
        return errCode;
    }

    private boolean confirm(Arguments args) {
        String prompt = this.confirmationPrompt(args);
        if (prompt == null) {
            return true;
        }
        return CONFIRM_MSG.equalsIgnoreCase(this.readLine(prompt));
    }

    private String confirmationPrompt(Arguments args) {
        if (args.force()) {
            return null;
        }
        String str = null;
        switch (args.command()) {
            case DEACTIVATE: {
                str = "Warning: the command will deactivate a cluster.";
                break;
            }
            case BASELINE: {
                if (BASELINE_COLLECT.equals(args.baselineAction())) break;
                str = "Warning: the command will perform changes in baseline.";
                break;
            }
            case TX: {
                if (args.transactionArguments().getOperation() != VisorTxOperation.KILL) break;
                str = "Warning: the command will kill some transactions.";
                break;
            }
        }
        return str == null ? null : str + "\nPress '" + CONFIRM_MSG + "' to continue . . . ";
    }

    private void initArgIterator(List<String> rawArgs) {
        this.argsIt = rawArgs.iterator();
        this.peekedArg = null;
    }

    private boolean hasNextArg() {
        return this.peekedArg != null || this.argsIt.hasNext();
    }

    private void activate(GridClient client) throws Throwable {
        try {
            GridClientClusterState state = client.state();
            state.active(true);
            this.log("Cluster activated");
        }
        catch (Throwable e) {
            this.log("Failed to activate cluster.");
            throw e;
        }
    }

    private void deactivate(GridClient client) throws Throwable {
        try {
            GridClientClusterState state = client.state();
            state.active(false);
            this.log("Cluster deactivated");
        }
        catch (Throwable e) {
            this.log("Failed to deactivate cluster.");
            throw e;
        }
    }

    private void state(GridClient client) throws Throwable {
        try {
            GridClientClusterState state = client.state();
            this.log("Cluster is " + (state.active() ? "active" : "inactive"));
        }
        catch (Throwable e) {
            this.log("Failed to get cluster state.");
            throw e;
        }
    }

    private Map<UUID, VisorTxTaskResult> executeTransactionsTask(GridClient client, VisorTxTaskArg arg) throws GridClientException {
        return (Map)this.executeTask(client, VisorTxTask.class, arg);
    }

    private <R> R executeTask(GridClient client, Class<?> taskCls, Object taskArgs) throws GridClientException {
        return this.executeTaskByNameOnNode(client, taskCls.getName(), taskArgs, null);
    }

    private <R> R executeTaskByNameOnNode(GridClient client, String taskClsName, Object taskArgs, UUID nodeId) throws GridClientException {
        GridClientCompute compute = client.compute();
        if (nodeId == BROADCAST_UUID) {
            Collection<GridClientNode> nodes = compute.nodes(GridClientNode::connectable);
            if (F.isEmpty(nodes)) {
                throw new GridClientDisconnectedException("Connectable nodes not found", null);
            }
            List<UUID> nodeIds = nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList());
            return client.compute().execute(taskClsName, new VisorTaskArgument<Object>(nodeIds, taskArgs, false));
        }
        GridClientNode node = null;
        if (nodeId == null) {
            node = this.getBalancedNode(compute);
        } else {
            for (GridClientNode n : compute.nodes()) {
                if (!n.connectable() || !nodeId.equals(n.nodeId())) continue;
                node = n;
                break;
            }
            if (node == null) {
                throw new IllegalArgumentException("Node with id=" + nodeId + " not found");
            }
        }
        return compute.projection(node).execute(taskClsName, new VisorTaskArgument<Object>(node.nodeId(), taskArgs, false));
    }

    private GridClientNode getBalancedNode(GridClientCompute compute) throws GridClientException {
        Collection<GridClientNode> nodes = compute.nodes(GridClientNode::connectable);
        if (F.isEmpty(nodes)) {
            throw new GridClientDisconnectedException("Connectable node not found", null);
        }
        return compute.balancer().balancedNode(nodes);
    }

    private void cache(GridClient client, CacheArguments cacheArgs) throws Throwable {
        switch (cacheArgs.command()) {
            case HELP: {
                this.printCacheHelp();
                break;
            }
            case IDLE_VERIFY: {
                this.cacheIdleVerify(client, cacheArgs);
                break;
            }
            case VALIDATE_INDEXES: {
                this.cacheValidateIndexes(client, cacheArgs);
                break;
            }
            case CONTENTION: {
                this.cacheContention(client, cacheArgs);
                break;
            }
            default: {
                this.cacheView(client, cacheArgs);
            }
        }
    }

    private void printCacheHelp() {
        this.log("--cache subcommand allows to do the following operations:");
        this.usage("  Show information about caches, groups or sequences that match a regex:", Command.CACHE, " list regexPattern [groups|seq] [nodeId]");
        this.usage("  Show hot keys that are point of contention for multiple transactions:", Command.CACHE, " contention minQueueSize [nodeId] [maxPrint]");
        this.usage("  Verify partition counters and hashes between primary and backups on idle cluster:", Command.CACHE, " idle_verify [cache1,...,cacheN]");
        this.usage("  Validate custom indexes on idle cluster:", Command.CACHE, " validate_indexes [cache1,...,cacheN] [nodeId]");
        this.log("  If [nodeId] is not specified, cont and validate_indexes commands will be broadcasted to all server nodes.");
        this.log("  Another commands where [nodeId] is optional will run on a random server node.");
        this.nl();
    }

    private void cacheContention(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorContentionTaskArg taskArg = new VisorContentionTaskArg(cacheArgs.minQueueSize(), cacheArgs.maxPrint());
        UUID nodeId = cacheArgs.nodeId() == null ? BROADCAST_UUID : cacheArgs.nodeId();
        VisorContentionTaskResult res = (VisorContentionTaskResult)this.executeTaskByNameOnNode(client, VisorContentionTask.class.getName(), taskArg, nodeId);
        if (!F.isEmpty(res.exceptions())) {
            this.log("Contention check failed on nodes:");
            for (Map.Entry entry : res.exceptions().entrySet()) {
                this.log("Node ID = " + entry.getKey());
                this.log("Exception message:");
                this.log(((Exception)entry.getValue()).getMessage());
                this.nl();
            }
        }
        for (ContentionInfo contentionInfo : res.getInfos()) {
            contentionInfo.print();
        }
    }

    private void cacheValidateIndexes(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        UUID nodeId;
        VisorValidateIndexesTaskArg taskArg = new VisorValidateIndexesTaskArg(cacheArgs.caches());
        VisorValidateIndexesTaskResult taskRes = (VisorValidateIndexesTaskResult)this.executeTaskByNameOnNode(client, VALIDATE_INDEXES_TASK, taskArg, nodeId = cacheArgs.nodeId() == null ? BROADCAST_UUID : cacheArgs.nodeId());
        if (!F.isEmpty(taskRes.exceptions())) {
            this.log("Index validation failed on nodes:");
            for (Map.Entry<UUID, Exception> e : taskRes.exceptions().entrySet()) {
                this.log("Node ID = " + e.getKey());
                this.log("Exception message:");
                this.log(e.getValue().getMessage());
                this.nl();
            }
        }
        boolean errors = false;
        for (Map.Entry<UUID, VisorValidateIndexesJobResult> nodeEntry : taskRes.results().entrySet()) {
            Map<PartitionKey, ValidateIndexesPartitionResult> map = nodeEntry.getValue().response();
            for (Map.Entry<PartitionKey, ValidateIndexesPartitionResult> e : map.entrySet()) {
                ValidateIndexesPartitionResult res = e.getValue();
                if (res.issues().isEmpty()) continue;
                errors = true;
                this.log(e.getKey().toString() + " " + e.getValue().toString());
                for (IndexValidationIssue is : res.issues()) {
                    this.log(is.toString());
                }
            }
        }
        if (!errors) {
            this.log("validate_indexes has finished, no issues found.");
        } else {
            this.log("validate_indexes has finished with errors (listed above).");
        }
    }

    private void cacheView(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorViewCacheTaskArg taskArg = new VisorViewCacheTaskArg(cacheArgs.regex(), cacheArgs.cacheCommand());
        VisorViewCacheTaskResult res = (VisorViewCacheTaskResult)this.executeTaskByNameOnNode(client, VisorViewCacheTask.class.getName(), taskArg, cacheArgs.nodeId());
        for (CacheInfo info : res.cacheInfos()) {
            info.print(cacheArgs.cacheCommand());
        }
    }

    private void cacheIdleVerify(GridClient client, CacheArguments cacheArgs) throws GridClientException {
        VisorIdleVerifyTaskResult res = (VisorIdleVerifyTaskResult)this.executeTask(client, VisorIdleVerifyTask.class, new VisorIdleVerifyTaskArg(cacheArgs.caches()));
        Map<PartitionKey, List<PartitionHashRecord>> conflicts = res.getConflicts();
        if (conflicts.isEmpty()) {
            this.log("idle_verify check has finished, no conflicts have been found.");
            this.nl();
        } else {
            this.log("idle_verify check has finished, found " + conflicts.size() + " conflict partitions.");
            this.nl();
            for (Map.Entry<PartitionKey, List<PartitionHashRecord>> entry : conflicts.entrySet()) {
                this.log("Conflict partition: " + entry.getKey());
                this.log("Partition instances: " + entry.getValue());
            }
        }
    }

    private void baseline(GridClient client, String baselineAct, String baselineArgs) throws Throwable {
        switch (baselineAct) {
            case "add": {
                this.baselineAdd(client, baselineArgs);
                break;
            }
            case "remove": {
                this.baselineRemove(client, baselineArgs);
                break;
            }
            case "set": {
                this.baselineSet(client, baselineArgs);
                break;
            }
            case "version": {
                this.baselineVersion(client, baselineArgs);
                break;
            }
            case "collect": {
                this.baselinePrint(client);
            }
        }
    }

    private VisorBaselineTaskArg arg(VisorBaselineOperation op, String s) {
        switch (op) {
            case ADD: 
            case REMOVE: 
            case SET: {
                List<String> consistentIds = this.getConsistentIds(s);
                return new VisorBaselineTaskArg(op, -1L, consistentIds);
            }
            case VERSION: {
                try {
                    long topVer = Long.parseLong(s);
                    return new VisorBaselineTaskArg(op, topVer, null);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid topology version: " + s, e);
                }
            }
        }
        return new VisorBaselineTaskArg(op, -1L, null);
    }

    private List<String> getConsistentIds(String s) {
        if (F.isEmpty(s)) {
            throw new IllegalArgumentException("Empty list of consistent IDs");
        }
        ArrayList<String> consistentIds = new ArrayList<String>();
        for (String consistentId : s.split(",")) {
            consistentIds.add(consistentId.trim());
        }
        return consistentIds;
    }

    private void baselinePrint0(VisorBaselineTaskResult res) {
        this.log("Cluster state: " + (res.isActive() ? "active" : "inactive"));
        this.log("Current topology version: " + res.getTopologyVersion());
        this.nl();
        Map<String, VisorBaselineNode> baseline = res.getBaseline();
        Map<String, VisorBaselineNode> srvs = res.getServers();
        if (F.isEmpty(baseline)) {
            this.log("Baseline nodes not found.");
        } else {
            this.log("Baseline nodes:");
            for (VisorBaselineNode node : baseline.values()) {
                this.log("    ConsistentID=" + node.getConsistentId() + ", STATE=" + (srvs.containsKey(node.getConsistentId()) ? "ONLINE" : "OFFLINE"));
            }
            this.log(DELIM);
            this.log("Number of baseline nodes: " + baseline.size());
            this.nl();
            ArrayList<VisorBaselineNode> others = new ArrayList<VisorBaselineNode>();
            for (VisorBaselineNode node : srvs.values()) {
                if (baseline.containsKey(node.getConsistentId())) continue;
                others.add(node);
            }
            if (F.isEmpty(others)) {
                this.log("Other nodes not found.");
            } else {
                this.log("Other nodes:");
                for (VisorBaselineNode node : others) {
                    this.log("    ConsistentID=" + node.getConsistentId());
                }
                this.log("Number of other nodes: " + others.size());
            }
        }
    }

    private void baselinePrint(GridClient client) throws GridClientException {
        VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.COLLECT, ""));
        this.baselinePrint0(res);
    }

    private void baselineAdd(GridClient client, String baselineArgs) throws Throwable {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.ADD, baselineArgs));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to add nodes to baseline.");
            throw e;
        }
    }

    private void baselineRemove(GridClient client, String consistentIds) throws Throwable {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.REMOVE, consistentIds));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to remove nodes from baseline.");
            throw e;
        }
    }

    private void baselineSet(GridClient client, String consistentIds) throws Throwable {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.SET, consistentIds));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to set baseline.");
            throw e;
        }
    }

    private void baselineVersion(GridClient client, String arg) throws GridClientException {
        try {
            VisorBaselineTaskResult res = (VisorBaselineTaskResult)this.executeTask(client, VisorBaselineTask.class, this.arg(VisorBaselineOperation.VERSION, arg));
            this.baselinePrint0(res);
        }
        catch (Throwable e) {
            this.log("Failed to set baseline with specified topology version.");
            throw e;
        }
    }

    private void transactions(GridClient client, VisorTxTaskArg arg) throws GridClientException {
        try {
            Map res = (Map)this.executeTask(client, VisorTxTask.class, arg);
            this.lastOperationRes = res;
            if (res.isEmpty()) {
                this.log("Nothing found.");
            } else if (arg.getOperation() == VisorTxOperation.KILL) {
                this.log("Killed transactions:");
            } else {
                this.log("Matching transactions:");
            }
            for (Map.Entry entry : res.entrySet()) {
                if (((VisorTxTaskResult)entry.getValue()).getInfos().isEmpty()) continue;
                ClusterNode key = (ClusterNode)entry.getKey();
                this.log(key.toString());
                for (VisorTxInfo info : ((VisorTxTaskResult)entry.getValue()).getInfos()) {
                    this.log("    Tx: [xid=" + info.getXid() + ", label=" + info.getLabel() + ", state=" + (Object)((Object)info.getState()) + ", duration=" + info.getDuration() / 1000L + ", isolation=" + (Object)((Object)info.getIsolation()) + ", concurrency=" + (Object)((Object)info.getConcurrency()) + ", timeout=" + info.getTimeout() + ", size=" + info.getSize() + ", dhtNodes=" + F.transform(info.getPrimaryNodes(), new IgniteClosure<UUID, String>(){

                        @Override
                        public String apply(UUID id) {
                            return U.id8(id);
                        }
                    }) + ']');
                }
            }
        }
        catch (Throwable e) {
            this.log("Failed to perform operation.");
            throw e;
        }
    }

    private boolean isAuthError(Throwable e) {
        return X.hasCause(e, GridClientAuthenticationException.class);
    }

    private boolean isConnectionError(Throwable e) {
        return e instanceof GridClientClosedException || e instanceof GridClientConnectionResetException || e instanceof GridClientDisconnectedException || e instanceof GridClientHandshakeException || e instanceof GridServerUnreachableException;
    }

    private void usage(String desc, Command cmd, String ... args) {
        this.log(desc);
        this.log("    control.sh [--host HOST_OR_IP] [--port PORT] [--user USER] [--password PASSWORD]  [--ping-interval PING_INTERVAL] [--ping-timeout PING_TIMEOUT] " + cmd.text() + String.join((CharSequence)"", args));
        this.nl();
    }

    private String nextArg(String err) {
        if (this.peekedArg != null) {
            String res = this.peekedArg;
            this.peekedArg = null;
            return res;
        }
        if (this.argsIt.hasNext()) {
            return this.argsIt.next();
        }
        throw new IllegalArgumentException(err);
    }

    private String peekNextArg() {
        if (this.peekedArg == null && this.argsIt.hasNext()) {
            this.peekedArg = this.argsIt.next();
        }
        return this.peekedArg;
    }

    Arguments parseAndValidate(List<String> rawArgs) {
        boolean hasPwd;
        Command cmd;
        String host = DFLT_HOST;
        String port = DFLT_PORT;
        String user = null;
        String pwd = null;
        String baselineAct = "";
        String baselineArgs = "";
        Long pingInterval = 5000L;
        Long pingTimeout = 30000L;
        boolean force = false;
        CacheArguments cacheArgs = null;
        ArrayList<Command> commands = new ArrayList<Command>();
        this.initArgIterator(rawArgs);
        VisorTxTaskArg txArgs = null;
        block26: while (this.hasNextArg()) {
            String str = this.nextArg("").toLowerCase();
            cmd = Command.of(str);
            if (cmd != null) {
                switch (cmd) {
                    case DEACTIVATE: 
                    case ACTIVATE: 
                    case STATE: {
                        commands.add(cmd);
                        continue block26;
                    }
                    case TX: {
                        commands.add(Command.TX);
                        txArgs = this.parseTransactionArguments();
                        continue block26;
                    }
                    case BASELINE: {
                        commands.add(Command.BASELINE);
                        baselineAct = BASELINE_COLLECT;
                        str = this.peekNextArg();
                        if (str == null || !BASELINE_ADD.equals(str = str.toLowerCase()) && !BASELINE_REMOVE.equals(str) && !BASELINE_SET.equals(str) && !BASELINE_SET_VERSION.equals(str)) continue block26;
                        baselineAct = this.nextArg("Expected baseline action");
                        baselineArgs = this.nextArg("Expected baseline arguments");
                        continue block26;
                    }
                    case CACHE: {
                        commands.add(Command.CACHE);
                        cacheArgs = this.parseAndValidateCacheArgs();
                        continue block26;
                    }
                }
                throw new IllegalArgumentException("Unexpected command: " + str);
            }
            switch (str) {
                case "--host": {
                    host = this.nextArg("Expected host name");
                    break;
                }
                case "--port": {
                    port = this.nextArg("Expected port number");
                    try {
                        int p = Integer.parseInt(port);
                        if (p > 0 && p <= 65535) continue block26;
                        throw new IllegalArgumentException("Invalid value for port: " + port);
                    }
                    catch (NumberFormatException ignored) {
                        throw new IllegalArgumentException("Invalid value for port: " + port);
                    }
                }
                case "--ping-interval": {
                    pingInterval = this.getPingParam("Expected ping interval", "Invalid value for ping interval");
                    break;
                }
                case "--ping-timeout": {
                    pingTimeout = this.getPingParam("Expected ping timeout", "Invalid value for ping timeout");
                    break;
                }
                case "--user": {
                    user = this.nextArg("Expected user name");
                    break;
                }
                case "--password": {
                    pwd = this.nextArg("Expected password");
                    break;
                }
                case "--force": {
                    force = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected argument: " + str);
                }
            }
        }
        int sz = commands.size();
        if (sz < 1) {
            throw new IllegalArgumentException("No action was specified");
        }
        if (sz > 1) {
            throw new IllegalArgumentException("Only one action can be specified, but found: " + sz);
        }
        cmd = (Command)((Object)commands.get(0));
        boolean hasUsr = F.isEmpty(user);
        if (hasUsr != (hasPwd = F.isEmpty(pwd))) {
            throw new IllegalArgumentException("Both user and password should be specified");
        }
        return new Arguments(cmd, host, port, user, pwd, baselineAct, baselineArgs, pingTimeout, pingInterval, txArgs, force, cacheArgs);
    }

    private CacheArguments parseAndValidateCacheArgs() {
        if (!this.hasNextCacheArg()) {
            throw new IllegalArgumentException("Arguments are expected for --cache subcommand, run --cache help for more info.");
        }
        CacheArguments cacheArgs = new CacheArguments();
        String str = this.nextArg("").toLowerCase();
        CacheCommand cmd = CacheCommand.of(str);
        if (cmd == null) {
            cmd = CacheCommand.HELP;
        }
        cacheArgs.command(cmd);
        block0 : switch (cmd) {
            case HELP: {
                break;
            }
            case IDLE_VERIFY: {
                this.parseCacheNamesIfPresent(cacheArgs);
                break;
            }
            case CONTENTION: {
                cacheArgs.minQueueSize(Integer.parseInt(this.nextArg("Min queue size expected")));
                if (this.hasNextCacheArg()) {
                    cacheArgs.nodeId(UUID.fromString(this.nextArg("")));
                }
                if (this.hasNextCacheArg()) {
                    cacheArgs.maxPrint(Integer.parseInt(this.nextArg("")));
                    break;
                }
                cacheArgs.maxPrint(10);
                break;
            }
            case VALIDATE_INDEXES: {
                this.parseCacheNamesIfPresent(cacheArgs);
                if (!this.hasNextCacheArg()) break;
                cacheArgs.nodeId(UUID.fromString(this.nextArg("")));
                break;
            }
            default: {
                String tmp;
                cacheArgs.regex(this.nextArg("Regex is expected"));
                if (!this.hasNextCacheArg()) break;
                switch (tmp = this.nextArg("")) {
                    case "groups": {
                        cacheArgs.cacheCommand(VisorViewCacheCmd.GROUPS);
                        break block0;
                    }
                    case "seq": {
                        cacheArgs.cacheCommand(VisorViewCacheCmd.SEQ);
                        break block0;
                    }
                }
                cacheArgs.nodeId(UUID.fromString(tmp));
            }
        }
        if (this.hasNextCacheArg()) {
            throw new IllegalArgumentException("Unexpected argument of --cache subcommand: " + this.peekNextArg());
        }
        return cacheArgs;
    }

    private boolean hasNextCacheArg() {
        return this.hasNextArg() && Command.of(this.peekNextArg()) == null && !AUX_COMMANDS.contains(this.peekNextArg());
    }

    private void parseCacheNamesIfPresent(CacheArguments cacheArgs) {
        if (this.hasNextCacheArg()) {
            String cacheNames = this.nextArg("");
            String[] cacheNamesArr = cacheNames.split(",");
            HashSet<String> cacheNamesSet = new HashSet<String>();
            for (String cacheName : cacheNamesArr) {
                if (F.isEmpty(cacheName)) {
                    throw new IllegalArgumentException("Non-empty cache names expected.");
                }
                cacheNamesSet.add(cacheName.trim());
            }
            cacheArgs.caches(cacheNamesSet);
        }
    }

    private Long getPingParam(String nextArgErr, String invalidErr) {
        String raw = this.nextArg(nextArgErr);
        try {
            long val = Long.valueOf(raw);
            if (val <= 0L) {
                throw new IllegalArgumentException(invalidErr + ": " + val);
            }
            return val;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException(invalidErr + ": " + raw);
        }
    }

    private VisorTxTaskArg parseTransactionArguments() {
        String str;
        VisorTxProjection proj = null;
        Integer limit = null;
        VisorTxSortOrder sortOrder = null;
        Long duration = null;
        Integer size = null;
        String lbRegex = null;
        List<String> consistentIds = null;
        VisorTxOperation op = VisorTxOperation.LIST;
        String xid = null;
        boolean end = false;
        while ((str = this.peekNextArg()) != null) {
            switch (str) {
                case "limit": {
                    this.nextArg("");
                    limit = (int)this.nextLongArg(TX_LIMIT);
                    break;
                }
                case "order": {
                    this.nextArg("");
                    sortOrder = VisorTxSortOrder.fromString(this.nextArg(TX_ORDER));
                    break;
                }
                case "servers": {
                    this.nextArg("");
                    proj = VisorTxProjection.SERVER;
                    break;
                }
                case "clients": {
                    this.nextArg("");
                    proj = VisorTxProjection.CLIENT;
                    break;
                }
                case "nodes": {
                    this.nextArg("");
                    consistentIds = this.getConsistentIds(this.nextArg(TX_NODES));
                    break;
                }
                case "minDuration": {
                    this.nextArg("");
                    duration = this.nextLongArg(TX_DURATION) * 1000L;
                    break;
                }
                case "minSize": {
                    this.nextArg("");
                    size = (int)this.nextLongArg(TX_SIZE);
                    break;
                }
                case "label": {
                    this.nextArg("");
                    lbRegex = this.nextArg(TX_LABEL);
                    try {
                        Pattern.compile(lbRegex);
                        break;
                    }
                    catch (PatternSyntaxException ignored) {
                        throw new IllegalArgumentException("Illegal regex syntax");
                    }
                }
                case "xid": {
                    this.nextArg("");
                    xid = this.nextArg(TX_XID);
                    break;
                }
                case "kill": {
                    this.nextArg("");
                    op = VisorTxOperation.KILL;
                    break;
                }
                default: {
                    end = true;
                }
            }
            if (!end) continue;
        }
        if (proj != null && consistentIds != null) {
            throw new IllegalArgumentException("Projection can't be used together with list of consistent ids.");
        }
        return new VisorTxTaskArg(op, limit, duration, size, null, proj, consistentIds, xid, lbRegex, sortOrder);
    }

    private long nextLongArg(String lb) {
        String str = this.nextArg("Expecting " + lb);
        try {
            long val = Long.parseLong(str);
            if (val < 0L) {
                throw new IllegalArgumentException("Invalid value for " + lb + ": " + val);
            }
            return val;
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid value for " + lb + ": " + str);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(List<String> rawArgs) {
        this.log("Control utility [ver. " + IgniteVersionUtils.ACK_VER_STR + "]");
        this.log("2018 Copyright(C) Apache Software Foundation");
        this.log("User: " + System.getProperty("user.name"));
        this.log(DELIM);
        try {
            if (F.isEmpty(rawArgs) || rawArgs.size() == 1 && CMD_HELP.equalsIgnoreCase(rawArgs.get(0))) {
                this.log("This utility can do the following commands:");
                this.usage("  Activate cluster:", Command.ACTIVATE, new String[0]);
                this.usage("  Deactivate cluster:", Command.DEACTIVATE, " [--force]");
                this.usage("  Print current cluster state:", Command.STATE, new String[0]);
                this.usage("  Print cluster baseline topology:", Command.BASELINE, new String[0]);
                this.usage("  Add nodes into baseline topology:", Command.BASELINE, " add consistentId1[,consistentId2,....,consistentIdN] [--force]");
                this.usage("  Remove nodes from baseline topology:", Command.BASELINE, " remove consistentId1[,consistentId2,....,consistentIdN] [--force]");
                this.usage("  Set baseline topology:", Command.BASELINE, " set consistentId1[,consistentId2,....,consistentIdN] [--force]");
                this.usage("  Set baseline topology based on version:", Command.BASELINE, " version topologyVersion [--force]");
                this.usage("  List or kill transactions:", Command.TX, " [xid XID] [minDuration SECONDS] [minSize SIZE] [label PATTERN_REGEX] [servers|clients] [nodes consistentId1[,consistentId2,....,consistentIdN] [limit NUMBER] [order DURATION|SIZE] [kill] [--force]");
                this.log("The utility has --cache subcommand to view and control state of caches in cluster.");
                this.log("  More info:    control.sh --cache help");
                this.nl();
                this.log("By default commands affecting the cluster require interactive confirmation. ");
                this.log("  --force option can be used to execute commands without prompting for confirmation.");
                this.nl();
                this.log("Default values:");
                this.log("    HOST_OR_IP=127.0.0.1");
                this.log("    PORT=11211");
                this.log("    PING_INTERVAL=5000");
                this.log("    PING_TIMEOUT=30000");
                this.nl();
                this.log("Exit codes:");
                this.log("    0 - successful execution.");
                this.log("    1 - invalid arguments.");
                this.log("    2 - connection failed.");
                this.log("    3 - authentication failed.");
                this.log("    4 - unexpected error.");
                return 0;
            }
            Arguments args = this.parseAndValidate(rawArgs);
            if (!this.confirm(args)) {
                this.log("Operation cancelled.");
                return 0;
            }
            GridClientConfiguration cfg = new GridClientConfiguration();
            cfg.setPingInterval(args.pingInterval());
            cfg.setPingTimeout(args.pingTimeout());
            cfg.setServers(Collections.singletonList(args.host() + ":" + args.port()));
            if (!F.isEmpty(args.user())) {
                cfg.setSecurityCredentialsProvider(new SecurityCredentialsBasicProvider(new SecurityCredentials(args.user(), args.password())));
            }
            try (GridClient client = GridClientFactory.start(cfg);){
                switch (args.command()) {
                    case ACTIVATE: {
                        this.activate(client);
                        return 0;
                    }
                    case DEACTIVATE: {
                        this.deactivate(client);
                        return 0;
                    }
                    case STATE: {
                        this.state(client);
                        return 0;
                    }
                    case BASELINE: {
                        this.baseline(client, args.baselineAction(), args.baselineArguments());
                        return 0;
                    }
                    case TX: {
                        this.transactions(client, args.transactionArguments());
                        return 0;
                    }
                    case CACHE: {
                        this.cache(client, args.cacheArgs());
                        return 0;
                    }
                }
                return 0;
            }
        }
        catch (IllegalArgumentException e) {
            return this.error(1, "Check arguments.", e);
        }
        catch (Throwable e) {
            if (this.isAuthError(e)) {
                return this.error(3, "Authentication error.", e);
            }
            if (!this.isConnectionError(e)) return this.error(4, "", e);
            return this.error(2, "Connection to cluster failed.", e);
        }
    }

    public static void main(String[] args) {
        CommandHandler hnd = new CommandHandler();
        System.exit(hnd.execute(Arrays.asList(args)));
    }

    public <T> T getLastOperationResult() {
        return (T)this.lastOperationRes;
    }

    static {
        AUX_COMMANDS.add(CMD_HELP);
        AUX_COMMANDS.add(CMD_HOST);
        AUX_COMMANDS.add(CMD_PORT);
        AUX_COMMANDS.add(CMD_PASSWORD);
        AUX_COMMANDS.add(CMD_USER);
        AUX_COMMANDS.add(CMD_FORCE);
        BROADCAST_UUID = UUID.randomUUID();
        IN = new Scanner(System.in);
    }
}

