/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.FieldsQueryPager;
import org.apache.ignite.internal.client.thin.GenericQueryPager;
import org.apache.ignite.internal.client.thin.ReliableChannel;

class ClientFieldsQueryPager
extends GenericQueryPager<List<?>>
implements FieldsQueryPager<List<?>> {
    private final boolean keepBinary;
    private List<String> fieldNames = new ArrayList<String>();
    private final ClientUtils serDes;

    ClientFieldsQueryPager(ReliableChannel ch, ClientOperation qryOp, ClientOperation pageQryOp, Consumer<BinaryOutputStream> qryWriter, boolean keepBinary, ClientBinaryMarshaller marsh) {
        super(ch, qryOp, pageQryOp, qryWriter);
        this.keepBinary = keepBinary;
        this.serDes = new ClientUtils(marsh);
    }

    @Override
    Collection<List<?>> readEntries(BinaryInputStream in) {
        if (!this.hasFirstPage()) {
            this.fieldNames = new ArrayList<String>(ClientUtils.collection(in, ignored -> (String)this.serDes.readObject(in, this.keepBinary)));
        }
        int rowCnt = in.readInt();
        ArrayList res = new ArrayList(rowCnt);
        for (int r = 0; r < rowCnt; ++r) {
            ArrayList row = new ArrayList(this.fieldNames.size());
            for (int f = 0; f < this.fieldNames.size(); ++f) {
                row.add(this.serDes.readObject(in, this.keepBinary));
            }
            res.add(row);
        }
        return res;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }
}

