/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.CoordinatedStateManagerFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.ZNodeClearer;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.CloseRegionCoordination;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.util.HeapMemorySizeUtil;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.procedure.RegionServerProcedureManagerHost;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServerCommandLine;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperImpl;
import org.apache.hadoop.hbase.regionserver.RSDumpServlet;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RSStatusServlet;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerRunningException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReplicationService;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StorefileRefresherChore;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.handler.CloseMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.RegionReplicaFlushHandler;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationLoad;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.trace.SpanReceiverHost;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.JSONBean;
import org.apache.hadoop.hbase.util.JvmPauseMonitor;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.RecoveringRegionWatcher;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HRegionServer
extends HasThread
implements RegionServerServices,
LastSequenceId {
    private static final Log LOG = LogFactory.getLog(HRegionServer.class);
    protected static final String OPEN = "OPEN";
    protected static final String CLOSE = "CLOSE";
    protected final ConcurrentMap<byte[], Boolean> regionsInTransitionInRS = new ConcurrentSkipListMap<byte[], Boolean>(Bytes.BYTES_COMPARATOR);
    protected MemStoreFlusher cacheFlusher;
    protected HeapMemoryManager hMemManager;
    protected ClusterConnection clusterConnection;
    protected MetaTableLocator metaTableLocator;
    private RecoveringRegionWatcher recoveringRegionWatcher;
    protected TableDescriptors tableDescriptors;
    protected ReplicationSourceService replicationSourceHandler;
    protected ReplicationSinkService replicationSinkHandler;
    public CompactSplitThread compactSplitThread;
    protected final Map<String, Region> onlineRegions = new ConcurrentHashMap<String, Region>();
    protected final Map<String, InetSocketAddress[]> regionFavoredNodesMap = new ConcurrentHashMap<String, InetSocketAddress[]>();
    protected final Map<String, Region> recoveringRegions = Collections.synchronizedMap(new HashMap());
    protected Leases leases;
    protected ExecutorService service;
    protected volatile boolean fsOk = true;
    protected HFileSystem fs;
    private volatile boolean stopped = false;
    private volatile boolean abortRequested;
    ConcurrentMap<String, Integer> rowlocks = new ConcurrentHashMap<String, Integer>();
    private boolean stopping = false;
    private volatile boolean killed = false;
    protected final Configuration conf;
    private Path rootDir;
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final int numRetries;
    protected final int threadWakeFrequency;
    protected final int msgInterval;
    protected final int numRegionsToReport;
    private volatile RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rssStub;
    RpcClient rpcClient;
    private RpcRetryingCallerFactory rpcRetryingCallerFactory;
    private RpcControllerFactory rpcControllerFactory;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected InfoServer infoServer;
    private JvmPauseMonitor pauseMonitor;
    public static final String REGIONSERVER = "regionserver";
    MetricsRegionServer metricsRegionServer;
    private SpanReceiverHost spanReceiverHost;
    private final ChoreService choreService;
    ScheduledChore compactionChecker;
    ScheduledChore periodicFlusher;
    protected volatile WALFactory walFactory;
    final LogRoller walRoller;
    final AtomicReference<LogRoller> metawalRoller = new AtomicReference();
    final AtomicBoolean online = new AtomicBoolean(false);
    protected ZooKeeperWatcher zooKeeper;
    private MasterAddressTracker masterAddressTracker;
    protected ClusterStatusTracker clusterStatusTracker;
    private SplitLogWorker splitLogWorker;
    protected final Sleeper sleeper;
    private final int operationTimeout;
    private final int shortOperationTimeout;
    private final RegionServerAccounting regionServerAccounting;
    protected CacheConfig cacheConfig;
    private HealthCheckChore healthCheckChore;
    private ScheduledChore nonceManagerChore;
    private Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    protected ServerName serverName;
    protected String useThisHostnameInstead;
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    static final String RS_HOSTNAME_KEY = "hbase.regionserver.hostname";
    @InterfaceAudience.LimitedPrivate(value={"Configuration"})
    protected static final String MASTER_HOSTNAME_KEY = "hbase.master.hostname";
    protected final long startcode;
    private String clusterId;
    private ObjectName mxBean = null;
    private MovedRegionsCleaner movedRegionsCleaner;
    private StorefileRefresherChore storefileRefresher;
    private RegionServerCoprocessorHost rsHost;
    private RegionServerProcedureManagerHost rspmHost;
    private RegionServerQuotaManager rsQuotaManager;
    protected TableLockManager tableLockManager;
    final ServerNonceManager nonceManager;
    private UserProvider userProvider;
    protected final RSRpcServices rpcServices;
    protected BaseCoordinatedStateManager csm;
    private final boolean useZKForAssignment;
    protected final ConfigurationManager configurationManager;
    private static final byte[] UNSPECIFIED_REGION = new byte[0];
    protected Map<String, MovedRegionInfo> movedRegions = new ConcurrentHashMap<String, MovedRegionInfo>(3000);
    private static final int TIMEOUT_REGION_MOVED = 120000;

    public HRegionServer(Configuration conf) throws IOException, InterruptedException {
        this(conf, CoordinatedStateManagerFactory.getCoordinatedStateManager(conf));
    }

    public HRegionServer(Configuration conf, CoordinatedStateManager csm) throws IOException, InterruptedException {
        super("RegionServer");
        this.conf = conf;
        HRegionServer.checkCodecs(this.conf);
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        FSUtils.setupShortCircuitRead(this.conf);
        this.conf.setBoolean("hbase.meta.replicas.use", false);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 31);
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
        this.sleeper = new Sleeper(this.msgInterval, (Stoppable)this);
        boolean isNoncesEnabled = conf.getBoolean("hbase.regionserver.nonces.enabled", true);
        this.nonceManager = isNoncesEnabled ? new ServerNonceManager(this.conf) : null;
        this.numRegionsToReport = conf.getInt("hbase.regionserver.numregionstoreport", 10);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.shortOperationTimeout = conf.getInt("hbase.rpc.shortoperation.timeout", 10000);
        this.abortRequested = false;
        this.stopped = false;
        this.rpcServices = this.createRpcServices();
        this.startcode = System.currentTimeMillis();
        this.useThisHostnameInstead = this instanceof HMaster ? conf.get(MASTER_HOSTNAME_KEY) : conf.get(RS_HOSTNAME_KEY);
        String hostName = this.shouldUseThisHostnameInstead() ? this.useThisHostnameInstead : this.rpcServices.isa.getHostName();
        this.serverName = ServerName.valueOf((String)hostName, (int)this.rpcServices.isa.getPort(), (long)this.startcode);
        this.rpcControllerFactory = RpcControllerFactory.instantiate((Configuration)this.conf);
        this.rpcRetryingCallerFactory = RpcRetryingCallerFactory.instantiate((Configuration)this.conf);
        ZKUtil.loginClient((Configuration)this.conf, (String)"hbase.zookeeper.client.keytab.file", (String)"hbase.zookeeper.client.kerberos.principal", (String)hostName);
        this.login(this.userProvider, hostName);
        Superusers.initialize((Configuration)conf);
        this.regionServerAccounting = new RegionServerAccounting();
        this.uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HRegionServer.this.abort("Uncaught exception in service thread " + t.getName(), e);
            }
        };
        this.useZKForAssignment = ConfigUtil.useZKForAssignment(conf);
        this.initializeFileSystem();
        this.service = new ExecutorService(this.getServerName().toShortString());
        this.spanReceiverHost = SpanReceiverHost.getInstance((Configuration)this.getConfiguration());
        if (!conf.getBoolean("hbase.testing.nocluster", false)) {
            this.zooKeeper = new ZooKeeperWatcher(conf, this.getProcessName() + ":" + this.rpcServices.isa.getPort(), (Abortable)this, this.canCreateBaseZNode());
            this.csm = (BaseCoordinatedStateManager)csm;
            this.csm.initialize(this);
            this.csm.start();
            this.tableLockManager = TableLockManager.createTableLockManager(conf, this.zooKeeper, this.serverName);
            this.masterAddressTracker = new MasterAddressTracker(this.getZooKeeper(), (Abortable)this);
            this.masterAddressTracker.start();
            this.clusterStatusTracker = new ClusterStatusTracker(this.zooKeeper, this);
            this.clusterStatusTracker.start();
        }
        this.configurationManager = new ConfigurationManager();
        this.rpcServices.start();
        this.putUpWebUI();
        this.walRoller = new LogRoller(this, this);
        this.choreService = new ChoreService(this.getServerName().toString(), true);
        if (!SystemUtils.IS_OS_WINDOWS) {
            Signal.handle(new Signal("HUP"), new SignalHandler(){

                @Override
                public void handle(Signal signal) {
                    HRegionServer.this.getConfiguration().reloadConfiguration();
                    HRegionServer.this.configurationManager.notifyAllObservers(HRegionServer.this.getConfiguration());
                }
            });
        }
    }

    private void initializeFileSystem() throws IOException {
        FSUtils.setFsDefault(this.conf, FSUtils.getRootDir(this.conf));
        boolean useHBaseChecksum = this.conf.getBoolean("hbase.regionserver.checksum.verify", true);
        this.fs = new HFileSystem(this.conf, useHBaseChecksum);
        this.rootDir = FSUtils.getRootDir(this.conf);
        this.tableDescriptors = new FSTableDescriptors(this.conf, (FileSystem)this.fs, this.rootDir, !this.canUpdateTableDescriptor(), false);
    }

    protected boolean shouldUseThisHostnameInstead() {
        return this.useThisHostnameInstead != null && !this.useThisHostnameInstead.isEmpty();
    }

    protected void login(UserProvider user, String host) throws IOException {
        user.login("hbase.regionserver.keytab.file", "hbase.regionserver.kerberos.principal", host);
    }

    protected void waitForMasterActive() {
    }

    protected String getProcessName() {
        return REGIONSERVER;
    }

    protected boolean canCreateBaseZNode() {
        return false;
    }

    protected boolean canUpdateTableDescriptor() {
        return false;
    }

    protected RSRpcServices createRpcServices() throws IOException {
        return new RSRpcServices(this);
    }

    protected void configureInfoServer() {
        this.infoServer.addServlet("rs-status", "/rs-status", RSStatusServlet.class);
        this.infoServer.setAttribute(REGIONSERVER, this);
    }

    protected Class<? extends HttpServlet> getDumpServlet() {
        return RSDumpServlet.class;
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        if (this.coprocessorServiceHandlers.containsKey(serviceDesc.getFullName())) {
            LOG.error((Object)("Coprocessor service " + serviceDesc.getFullName() + " already registered, rejecting request from " + instance));
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceDesc.getFullName(), instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered regionserver coprocessor service: service=" + serviceDesc.getFullName()));
        }
        return true;
    }

    @VisibleForTesting
    protected ClusterConnection createClusterConnection() throws IOException {
        return ConnectionUtils.createShortCircuitConnection((Configuration)this.conf, null, (User)this.userProvider.getCurrent(), (ServerName)this.serverName, (AdminProtos.AdminService.BlockingInterface)this.rpcServices, (ClientProtos.ClientService.BlockingInterface)this.rpcServices);
    }

    private static void checkCodecs(Configuration c) throws IOException {
        String[] codecs = c.getStrings("hbase.regionserver.codecs", (String[])null);
        if (codecs == null) {
            return;
        }
        for (String codec : codecs) {
            if (CompressionTest.testCompression(codec)) continue;
            throw new IOException("Compression codec " + codec + " not supported, aborting RS construction");
        }
    }

    public String getClusterId() {
        return this.clusterId;
    }

    protected synchronized void setupClusterConnection() throws IOException {
        if (this.clusterConnection == null) {
            this.clusterConnection = this.createClusterConnection();
            this.metaTableLocator = new MetaTableLocator();
        }
    }

    private void preRegistrationInitialization() {
        try {
            this.setupClusterConnection();
            if (this.isHealthCheckerConfigured()) {
                int sleepTime = this.conf.getInt("hbase.node.health.script.frequency", 10000);
                this.healthCheckChore = new HealthCheckChore(sleepTime, this, this.getConfiguration());
            }
            this.pauseMonitor = new JvmPauseMonitor(this.conf);
            this.pauseMonitor.start();
            this.initializeZooKeeper();
            if (!this.isStopped() && !this.isAborted()) {
                this.initializeThreads();
            }
        }
        catch (Throwable t) {
            this.rpcServices.stop();
            this.abort("Initialization of RS failed.  Hence aborting RS.", t);
        }
    }

    private void initializeZooKeeper() throws IOException, InterruptedException {
        this.blockAndCheckIfStopped((ZooKeeperNodeTracker)this.masterAddressTracker);
        this.blockAndCheckIfStopped(this.clusterStatusTracker);
        try {
            this.clusterId = ZKClusterId.readClusterIdZNode((ZooKeeperWatcher)this.zooKeeper);
            if (this.clusterId == null) {
                this.abort("Cluster ID has not been set");
            }
            LOG.info((Object)("ClusterId : " + this.clusterId));
        }
        catch (KeeperException e) {
            this.abort("Failed to retrieve Cluster ID", e);
        }
        this.waitForMasterActive();
        if (this.isStopped() || this.isAborted()) {
            return;
        }
        try {
            this.rspmHost = new RegionServerProcedureManagerHost();
            this.rspmHost.loadProcedures(this.conf);
            this.rspmHost.initialize(this);
        }
        catch (KeeperException e) {
            this.abort("Failed to reach zk cluster when creating procedure handler.", e);
        }
        this.recoveringRegionWatcher = new RecoveringRegionWatcher(this.zooKeeper, this);
    }

    private void blockAndCheckIfStopped(ZooKeeperNodeTracker tracker) throws IOException, InterruptedException {
        while (tracker.blockUntilAvailable((long)this.msgInterval, false) == null) {
            if (!this.stopped) continue;
            throw new IOException("Received the shutdown message while waiting.");
        }
    }

    private boolean isClusterUp() {
        return this.clusterStatusTracker != null && this.clusterStatusTracker.isClusterUp();
    }

    private void initializeThreads() throws IOException {
        this.cacheFlusher = new MemStoreFlusher(this.conf, this);
        this.compactSplitThread = new CompactSplitThread(this);
        this.compactionChecker = new CompactionChecker(this, this.threadWakeFrequency, this);
        this.periodicFlusher = new PeriodicMemstoreFlusher(this.threadWakeFrequency, this);
        this.leases = new Leases(this.threadWakeFrequency);
        this.movedRegionsCleaner = MovedRegionsCleaner.create(this);
        if (this.nonceManager != null) {
            this.nonceManagerChore = this.nonceManager.createCleanupScheduledChore(this);
        }
        this.rsQuotaManager = new RegionServerQuotaManager(this);
        this.rpcClient = RpcClientFactory.createClient((Configuration)this.conf, (String)this.clusterId, (SocketAddress)new InetSocketAddress(this.rpcServices.isa.getAddress(), 0), (MetricsConnection)this.clusterConnection.getConnectionMetrics());
        boolean onlyMetaRefresh = false;
        int storefileRefreshPeriod = this.conf.getInt("hbase.regionserver.storefile.refresh.period", 0);
        if (storefileRefreshPeriod == 0) {
            storefileRefreshPeriod = this.conf.getInt("hbase.regionserver.meta.storefile.refresh.period", 0);
            onlyMetaRefresh = true;
        }
        if (storefileRefreshPeriod > 0) {
            this.storefileRefresher = new StorefileRefresherChore(storefileRefreshPeriod, onlyMetaRefresh, this, this);
        }
        this.registerConfigurationObservers();
    }

    private void registerConfigurationObservers() {
        this.configurationManager.registerObserver(this.compactSplitThread);
        this.configurationManager.registerObserver(this.rpcServices);
    }

    public void run() {
        block59: {
            try {
                this.preRegistrationInitialization();
            }
            catch (Throwable e) {
                this.abort("Fatal exception during initialization", e);
            }
            try {
                if (!this.isStopped() && !this.isAborted()) {
                    ShutdownHook.install(this.conf, (FileSystem)this.fs, this, Thread.currentThread());
                    this.createMyEphemeralNode();
                    this.rsHost = new RegionServerCoprocessorHost(this, this.conf);
                }
                while (this.keepLooping()) {
                    RegionServerStatusProtos.RegionServerStartupResponse w = this.reportForDuty();
                    if (w == null) {
                        LOG.warn((Object)"reportForDuty failed; sleeping and then retrying.");
                        this.sleeper.sleep();
                        continue;
                    }
                    this.handleReportForDutyResponse(w);
                    break;
                }
                if (!this.isStopped() && this.isHealthy()) {
                    this.rspmHost.start();
                }
                if (this.rsQuotaManager != null) {
                    this.rsQuotaManager.start(this.getRpcServer().getScheduler());
                }
                long lastMsg = System.currentTimeMillis();
                long oldRequestCount = -1L;
                while (!this.isStopped() && this.isHealthy()) {
                    long now;
                    if (!this.isClusterUp()) {
                        if (this.isOnlineRegionsEmpty()) {
                            this.stop("Exiting; cluster shutdown set and not carrying any regions");
                        } else if (!this.stopping) {
                            this.stopping = true;
                            LOG.info((Object)"Closing user regions");
                            this.closeUserRegions(this.abortRequested);
                        } else if (this.stopping) {
                            boolean allUserRegionsOffline = this.areAllUserRegionsOffline();
                            if (allUserRegionsOffline) {
                                if (oldRequestCount == this.getWriteRequestCount()) {
                                    this.stop("Stopped; only catalog regions remaining online");
                                    break;
                                }
                                oldRequestCount = this.getWriteRequestCount();
                            } else {
                                this.closeUserRegions(this.abortRequested);
                            }
                            LOG.debug((Object)("Waiting on " + this.getOnlineRegionsAsPrintableString()));
                        }
                    }
                    if ((now = System.currentTimeMillis()) - lastMsg >= (long)this.msgInterval) {
                        this.tryRegionServerReport(lastMsg, now);
                        lastMsg = System.currentTimeMillis();
                    }
                    if (this.isStopped() || this.isAborted()) continue;
                    this.sleeper.sleep();
                }
            }
            catch (Throwable t) {
                if (this.rpcServices.checkOOME(t)) break block59;
                String prefix = t instanceof YouAreDeadException ? "" : "Unhandled: ";
                this.abort(prefix + t.getMessage(), t);
            }
        }
        if (this.mxBean != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mxBean);
            this.mxBean = null;
        }
        if (this.leases != null) {
            this.leases.closeAfterLeasesExpire();
        }
        if (this.splitLogWorker != null) {
            this.splitLogWorker.stop();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to stop infoServer", (Throwable)e);
            }
        }
        if (this.cacheConfig != null && this.cacheConfig.isBlockCacheEnabled()) {
            this.cacheConfig.getBlockCache().shutdown();
        }
        if (this.movedRegionsCleaner != null) {
            this.movedRegionsCleaner.stop("Region Server stopping");
        }
        if (this.hMemManager != null) {
            this.hMemManager.stop();
        }
        if (this.cacheFlusher != null) {
            this.cacheFlusher.interruptIfNecessary();
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.interruptIfNecessary();
        }
        if (this.compactionChecker != null) {
            this.compactionChecker.cancel(true);
        }
        if (this.healthCheckChore != null) {
            this.healthCheckChore.cancel(true);
        }
        if (this.nonceManagerChore != null) {
            this.nonceManagerChore.cancel(true);
        }
        if (this.storefileRefresher != null) {
            this.storefileRefresher.cancel(true);
        }
        this.sendShutdownInterrupt();
        if (this.rsQuotaManager != null) {
            this.rsQuotaManager.stop();
        }
        if (this.rspmHost != null) {
            this.rspmHost.stop(this.abortRequested || this.killed);
        }
        if (!this.killed) {
            if (this.abortRequested) {
                if (this.fsOk) {
                    this.closeUserRegions(this.abortRequested);
                }
                LOG.info((Object)("aborting server " + this.serverName));
            } else {
                this.closeUserRegions(this.abortRequested);
                LOG.info((Object)("stopping server " + this.serverName));
            }
        }
        if (this.metaTableLocator != null) {
            this.metaTableLocator.stop();
        }
        if (this.clusterConnection != null && !this.clusterConnection.isClosed()) {
            try {
                this.clusterConnection.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Attempt to close server's short circuit HConnection failed.", (Throwable)e);
            }
        }
        if (!this.killed && this.containsMetaTableRegions() && (!this.abortRequested || this.fsOk)) {
            if (this.compactSplitThread != null) {
                this.compactSplitThread.join();
                this.compactSplitThread = null;
            }
            this.closeMetaTableRegions(this.abortRequested);
        }
        if (!this.killed && this.fsOk) {
            this.waitOnAllRegionsToClose(this.abortRequested);
            LOG.info((Object)("stopping server " + this.serverName + "; all regions closed."));
        }
        if (this.fsOk) {
            this.shutdownWAL(!this.abortRequested);
        }
        if (this.rssStub != null) {
            this.rssStub = null;
        }
        if (this.rpcClient != null) {
            this.rpcClient.close();
        }
        if (this.leases != null) {
            this.leases.close();
        }
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        if (!this.killed) {
            this.stopServiceThreads();
        }
        if (this.rpcServices != null) {
            this.rpcServices.stop();
        }
        try {
            this.deleteMyEphemeralNode();
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed deleting my ephemeral node", (Throwable)e);
        }
        ZNodeClearer.deleteMyEphemeralNodeOnDisk();
        if (this.zooKeeper != null) {
            this.zooKeeper.close();
        }
        LOG.info((Object)("stopping server " + this.serverName + "; zookeeper connection closed."));
        LOG.info((Object)(Thread.currentThread().getName() + " exiting"));
    }

    private boolean containsMetaTableRegions() {
        return this.onlineRegions.containsKey(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
    }

    private boolean areAllUserRegionsOffline() {
        if (this.getNumberOfOnlineRegions() > 2) {
            return false;
        }
        boolean allUserRegionsOffline = true;
        for (Map.Entry<String, Region> e : this.onlineRegions.entrySet()) {
            if (e.getValue().getRegionInfo().isMetaTable()) continue;
            allUserRegionsOffline = false;
            break;
        }
        return allUserRegionsOffline;
    }

    private long getWriteRequestCount() {
        long writeCount = 0L;
        for (Map.Entry<String, Region> e : this.onlineRegions.entrySet()) {
            writeCount += e.getValue().getWriteRequestsCount();
        }
        return writeCount;
    }

    @VisibleForTesting
    protected void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
        RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
        if (rss == null) {
            return;
        }
        ClusterStatusProtos.ServerLoad sl = this.buildServerLoad(reportStartTime, reportEndTime);
        try {
            RegionServerStatusProtos.RegionServerReportRequest.Builder request = RegionServerStatusProtos.RegionServerReportRequest.newBuilder();
            ServerName sn = ServerName.parseVersionedServerName((byte[])this.serverName.getVersionedBytes());
            request.setServer(ProtobufUtil.toServerName((ServerName)sn));
            request.setLoad(sl);
            rss.regionServerReport(null, request.build());
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof YouAreDeadException) {
                throw ioe;
            }
            if (this.rssStub == rss) {
                this.rssStub = null;
            }
            this.createRegionServerStatusStub(true);
        }
    }

    ClusterStatusProtos.ServerLoad buildServerLoad(long reportStartTime, long reportEndTime) throws IOException {
        ReplicationLoad rLoad;
        MetricsRegionServerWrapper regionServerWrapper = this.metricsRegionServer.getRegionServerWrapper();
        Collection<Region> regions = this.getOnlineRegionsLocalContext();
        long usedMemory = -1L;
        long maxMemory = -1L;
        MemoryUsage usage = HeapMemorySizeUtil.safeGetHeapMemoryUsage();
        if (usage != null) {
            usedMemory = usage.getUsed();
            maxMemory = usage.getMax();
        }
        ClusterStatusProtos.ServerLoad.Builder serverLoad = ClusterStatusProtos.ServerLoad.newBuilder();
        serverLoad.setNumberOfRequests((long)((int)regionServerWrapper.getRequestsPerSecond()));
        serverLoad.setTotalNumberOfRequests((long)((int)regionServerWrapper.getTotalRequestCount()));
        serverLoad.setUsedHeapMB((int)(usedMemory / 1024L / 1024L));
        serverLoad.setMaxHeapMB((int)(maxMemory / 1024L / 1024L));
        Set<String> coprocessors = this.getWAL(null).getCoprocessorHost().getCoprocessors();
        HBaseProtos.Coprocessor.Builder coprocessorBuilder = HBaseProtos.Coprocessor.newBuilder();
        for (String coprocessor : coprocessors) {
            serverLoad.addCoprocessors(coprocessorBuilder.setName(coprocessor).build());
        }
        ClusterStatusProtos.RegionLoad.Builder regionLoadBldr = ClusterStatusProtos.RegionLoad.newBuilder();
        HBaseProtos.RegionSpecifier.Builder regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        for (Region region : regions) {
            if (region.getCoprocessorHost() != null) {
                Set<String> regionCoprocessors = region.getCoprocessorHost().getCoprocessors();
                Iterator<String> iterator = regionCoprocessors.iterator();
                while (iterator.hasNext()) {
                    serverLoad.addCoprocessors(coprocessorBuilder.setName(iterator.next()).build());
                }
            }
            serverLoad.addRegionLoads(this.createRegionLoad(region, regionLoadBldr, regionSpecifier));
            for (String coprocessor : this.getWAL(region.getRegionInfo()).getCoprocessorHost().getCoprocessors()) {
                serverLoad.addCoprocessors(coprocessorBuilder.setName(coprocessor).build());
            }
        }
        serverLoad.setReportStartTime(reportStartTime);
        serverLoad.setReportEndTime(reportEndTime);
        if (this.infoServer != null) {
            serverLoad.setInfoServerPort(this.infoServer.getPort());
        } else {
            serverLoad.setInfoServerPort(-1);
        }
        ReplicationSourceService rsources = this.getReplicationSourceService();
        if (rsources != null && (rLoad = rsources.refreshAndGetReplicationLoad()) != null) {
            serverLoad.setReplLoadSink(rLoad.getReplicationLoadSink());
            for (ClusterStatusProtos.ReplicationLoadSource rLS : rLoad.getReplicationLoadSourceList()) {
                serverLoad.addReplLoadSource(rLS);
            }
        }
        return serverLoad.build();
    }

    String getOnlineRegionsAsPrintableString() {
        StringBuilder sb = new StringBuilder();
        for (Region r : this.onlineRegions.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(r.getRegionInfo().getEncodedName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnAllRegionsToClose(boolean abort) {
        int lastCount = -1;
        long previousLogTime = 0L;
        HashSet<String> closedRegions = new HashSet<String>();
        boolean interrupted = false;
        try {
            while (!this.isOnlineRegionsEmpty()) {
                int count = this.getNumberOfOnlineRegions();
                if (count != lastCount && System.currentTimeMillis() > previousLogTime + 1000L) {
                    previousLogTime = System.currentTimeMillis();
                    lastCount = count;
                    LOG.info((Object)("Waiting on " + count + " regions to close"));
                    if (count < 10 && LOG.isDebugEnabled()) {
                        LOG.debug(this.onlineRegions);
                    }
                }
                for (Map.Entry<String, Region> e : this.onlineRegions.entrySet()) {
                    HRegionInfo hri = e.getValue().getRegionInfo();
                    if (this.regionsInTransitionInRS.containsKey(hri.getEncodedNameAsBytes()) || closedRegions.contains(hri.getEncodedName())) continue;
                    closedRegions.add(hri.getEncodedName());
                    this.closeRegionIgnoreErrors(hri, abort);
                }
                if (this.regionsInTransitionInRS.isEmpty()) {
                    if (!this.isOnlineRegionsEmpty()) {
                        LOG.info((Object)"We were exiting though online regions are not empty, because some regions failed closing");
                    }
                    break;
                }
                if (!this.sleep(200L)) continue;
                interrupted = true;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean sleep(long millis) {
        boolean interrupted = false;
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Interrupted while sleeping");
            interrupted = true;
        }
        return interrupted;
    }

    private void shutdownWAL(boolean close) {
        if (this.walFactory != null) {
            try {
                if (close) {
                    this.walFactory.close();
                } else {
                    this.walFactory.shutdown();
                }
            }
            catch (Throwable e) {
                e = RemoteExceptionHandler.checkThrowable((Throwable)e);
                LOG.error((Object)("Shutdown / close of WAL failed: " + e));
                LOG.debug((Object)"Shutdown / close exception details:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleReportForDutyResponse(RegionServerStatusProtos.RegionServerStartupResponse c) throws IOException {
        try {
            boolean updateRootDir = false;
            for (HBaseProtos.NameStringPair e : c.getMapEntriesList()) {
                String key = e.getName();
                if (key.equals("hbase.regionserver.hostname.seen.by.master")) {
                    String msg;
                    String hostnameFromMasterPOV = e.getValue();
                    this.serverName = ServerName.valueOf((String)hostnameFromMasterPOV, (int)this.rpcServices.isa.getPort(), (long)this.startcode);
                    if (this.shouldUseThisHostnameInstead() && !hostnameFromMasterPOV.equals(this.useThisHostnameInstead)) {
                        msg = "Master passed us a different hostname to use; was=" + this.useThisHostnameInstead + ", but now=" + hostnameFromMasterPOV;
                        LOG.error((Object)msg);
                        throw new IOException(msg);
                    }
                    if (this.shouldUseThisHostnameInstead() || hostnameFromMasterPOV.equals(this.rpcServices.isa.getHostName())) continue;
                    msg = "Master passed us a different hostname to use; was=" + this.rpcServices.isa.getHostName() + ", but now=" + hostnameFromMasterPOV;
                    LOG.error((Object)msg);
                    continue;
                }
                String value = e.getValue();
                if (key.equals("hbase.rootdir") && value != null && !value.equals(this.conf.get("hbase.rootdir"))) {
                    updateRootDir = true;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Config from master: " + key + "=" + value));
                }
                this.conf.set(key, value);
            }
            if (updateRootDir) {
                this.initializeFileSystem();
            }
            if (this.conf.get("mapreduce.task.attempt.id") == null) {
                this.conf.set("mapreduce.task.attempt.id", "hb_rs_" + this.serverName.toString());
            }
            ZNodeClearer.writeMyEphemeralNodeOnDisk(this.getMyEphemeralNodePath());
            this.cacheConfig = new CacheConfig(this.conf);
            this.walFactory = this.setupWALAndReplication();
            this.metricsRegionServer = new MetricsRegionServer(new MetricsRegionServerWrapperImpl(this));
            this.startServiceThreads();
            this.startHeapMemoryManager();
            LOG.info((Object)("Serving as " + this.serverName + ", RpcServer on " + this.rpcServices.isa + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId())));
            AtomicBoolean atomicBoolean = this.online;
            synchronized (atomicBoolean) {
                this.online.set(true);
                this.online.notifyAll();
            }
        }
        catch (Throwable e) {
            this.stop("Failed initialization");
            throw this.convertThrowableToIOE(this.cleanup(e, "Failed init"), "Region server startup failed");
        }
        finally {
            this.sleeper.skipSleepCycle();
        }
    }

    private void startHeapMemoryManager() {
        this.hMemManager = HeapMemoryManager.create(this.conf, this.cacheFlusher, this, this.regionServerAccounting);
        if (this.hMemManager != null) {
            this.hMemManager.start(this.getChoreService());
        }
    }

    private void createMyEphemeralNode() throws KeeperException, IOException {
        HBaseProtos.RegionServerInfo.Builder rsInfo = HBaseProtos.RegionServerInfo.newBuilder();
        rsInfo.setInfoPort(this.infoServer != null ? this.infoServer.getPort() : -1);
        rsInfo.setVersionInfo(ProtobufUtil.getVersionInfo());
        byte[] data = ProtobufUtil.prependPBMagic((byte[])rsInfo.build().toByteArray());
        ZKUtil.createEphemeralNodeAndWatch((ZooKeeperWatcher)this.zooKeeper, (String)this.getMyEphemeralNodePath(), (byte[])data);
    }

    private void deleteMyEphemeralNode() throws KeeperException {
        ZKUtil.deleteNode((ZooKeeperWatcher)this.zooKeeper, (String)this.getMyEphemeralNodePath());
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return this.regionServerAccounting;
    }

    @Override
    public TableLockManager getTableLockManager() {
        return this.tableLockManager;
    }

    private ClusterStatusProtos.RegionLoad createRegionLoad(Region r, ClusterStatusProtos.RegionLoad.Builder regionLoadBldr, HBaseProtos.RegionSpecifier.Builder regionSpecifier) throws IOException {
        byte[] name = r.getRegionInfo().getRegionName();
        int stores = 0;
        int storefiles = 0;
        int storeUncompressedSizeMB = 0;
        int storefileSizeMB = 0;
        int memstoreSizeMB = (int)(r.getMemstoreSize() / 1024L / 1024L);
        int storefileIndexSizeMB = 0;
        int rootIndexSizeKB = 0;
        int totalStaticIndexSizeKB = 0;
        int totalStaticBloomSizeKB = 0;
        long totalCompactingKVs = 0L;
        long currentCompactedKVs = 0L;
        List<Store> storeList = r.getStores();
        stores += storeList.size();
        for (Store store : storeList) {
            storefiles += store.getStorefilesCount();
            storeUncompressedSizeMB += (int)(store.getStoreSizeUncompressed() / 1024L / 1024L);
            storefileSizeMB += (int)(store.getStorefilesSize() / 1024L / 1024L);
            storefileIndexSizeMB += (int)(store.getStorefilesIndexSize() / 1024L / 1024L);
            CompactionProgress progress = store.getCompactionProgress();
            if (progress != null) {
                totalCompactingKVs += progress.totalCompactingKVs;
                currentCompactedKVs += progress.currentCompactedKVs;
            }
            rootIndexSizeKB += (int)(store.getStorefilesIndexSize() / 1024L);
            totalStaticIndexSizeKB += (int)(store.getTotalStaticIndexSize() / 1024L);
            totalStaticBloomSizeKB += (int)(store.getTotalStaticBloomSize() / 1024L);
        }
        float dataLocality = r.getHDFSBlocksDistribution().getBlockLocalityIndex(this.serverName.getHostname());
        if (regionLoadBldr == null) {
            regionLoadBldr = ClusterStatusProtos.RegionLoad.newBuilder();
        }
        if (regionSpecifier == null) {
            regionSpecifier = HBaseProtos.RegionSpecifier.newBuilder();
        }
        regionSpecifier.setType(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME);
        regionSpecifier.setValue(ByteStringer.wrap((byte[])name));
        regionLoadBldr.setRegionSpecifier(regionSpecifier.build()).setStores(stores).setStorefiles(storefiles).setStoreUncompressedSizeMB(storeUncompressedSizeMB).setStorefileSizeMB(storefileSizeMB).setMemstoreSizeMB(memstoreSizeMB).setStorefileIndexSizeMB(storefileIndexSizeMB).setRootIndexSizeKB(rootIndexSizeKB).setTotalStaticIndexSizeKB(totalStaticIndexSizeKB).setTotalStaticBloomSizeKB(totalStaticBloomSizeKB).setReadRequestsCount(r.getReadRequestsCount()).setWriteRequestsCount(r.getWriteRequestsCount()).setTotalCompactingKVs(totalCompactingKVs).setCurrentCompactedKVs(currentCompactedKVs).setDataLocality(dataLocality).setLastMajorCompactionTs(r.getOldestHfileTs(true));
        ((HRegion)r).setCompleteSequenceId(regionLoadBldr);
        return regionLoadBldr.build();
    }

    public ClusterStatusProtos.RegionLoad createRegionLoad(String encodedRegionName) throws IOException {
        Region r = this.onlineRegions.get(encodedRegionName);
        return r != null ? this.createRegionLoad(r, null, null) : null;
    }

    public boolean isOnline() {
        return this.online.get();
    }

    private WALFactory setupWALAndReplication() throws IOException {
        Path oldLogDir = new Path(this.rootDir, "oldWALs");
        String logName = DefaultWALProvider.getWALDirectoryName(this.serverName.toString());
        Path logdir = new Path(this.rootDir, logName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logdir=" + logdir));
        }
        if (this.fs.exists(logdir)) {
            throw new RegionServerRunningException("Region server has already created directory at " + this.serverName.toString());
        }
        HRegionServer.createNewReplicationInstance(this.conf, this, (FileSystem)this.fs, logdir, oldLogDir);
        ArrayList<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
        listeners.add(new MetricsWAL());
        if (this.replicationSourceHandler != null && this.replicationSourceHandler.getWALActionsListener() != null) {
            listeners.add(this.replicationSourceHandler.getWALActionsListener());
        }
        return new WALFactory(this.conf, listeners, this.serverName.toString());
    }

    protected LogRoller ensureMetaWALRoller() {
        LogRoller roller = this.metawalRoller.get();
        if (null == roller) {
            LogRoller tmpLogRoller = new LogRoller(this, this);
            String n = Thread.currentThread().getName();
            Threads.setDaemonThreadRunning((Thread)tmpLogRoller.getThread(), (String)(n + "-MetaLogRoller"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
            if (this.metawalRoller.compareAndSet(null, tmpLogRoller)) {
                roller = tmpLogRoller;
            } else {
                Threads.shutdown((Thread)tmpLogRoller.getThread());
                roller = this.metawalRoller.get();
            }
        }
        return roller;
    }

    public MetricsRegionServer getRegionServerMetrics() {
        return this.metricsRegionServer;
    }

    public MasterAddressTracker getMasterAddressTracker() {
        return this.masterAddressTracker;
    }

    private void startServiceThreads() throws IOException {
        this.service.startExecutorService(ExecutorType.RS_OPEN_REGION, this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3));
        this.service.startExecutorService(ExecutorType.RS_OPEN_META, this.conf.getInt("hbase.regionserver.executor.openmeta.threads", 1));
        this.service.startExecutorService(ExecutorType.RS_CLOSE_REGION, this.conf.getInt("hbase.regionserver.executor.closeregion.threads", 3));
        this.service.startExecutorService(ExecutorType.RS_CLOSE_META, this.conf.getInt("hbase.regionserver.executor.closemeta.threads", 1));
        if (this.conf.getBoolean("hbase.storescanner.parallel.seek.enable", false)) {
            this.service.startExecutorService(ExecutorType.RS_PARALLEL_SEEK, this.conf.getInt("hbase.storescanner.parallel.seek.threads", 10));
        }
        this.service.startExecutorService(ExecutorType.RS_LOG_REPLAY_OPS, this.conf.getInt("hbase.regionserver.wal.max.splitters", 2));
        if (ServerRegionReplicaUtil.isRegionReplicaWaitForPrimaryFlushEnabled(this.conf)) {
            this.service.startExecutorService(ExecutorType.RS_REGION_REPLICA_FLUSH_OPS, this.conf.getInt("hbase.regionserver.region.replica.flusher.threads", this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3)));
        }
        Threads.setDaemonThreadRunning((Thread)this.walRoller.getThread(), (String)(this.getName() + ".logRoller"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        this.cacheFlusher.start(this.uncaughtExceptionHandler);
        if (this.compactionChecker != null) {
            this.choreService.scheduleChore(this.compactionChecker);
        }
        if (this.periodicFlusher != null) {
            this.choreService.scheduleChore(this.periodicFlusher);
        }
        if (this.healthCheckChore != null) {
            this.choreService.scheduleChore((ScheduledChore)this.healthCheckChore);
        }
        if (this.nonceManagerChore != null) {
            this.choreService.scheduleChore(this.nonceManagerChore);
        }
        if (this.storefileRefresher != null) {
            this.choreService.scheduleChore((ScheduledChore)this.storefileRefresher);
        }
        if (this.movedRegionsCleaner != null) {
            this.choreService.scheduleChore((ScheduledChore)this.movedRegionsCleaner);
        }
        Threads.setDaemonThreadRunning((Thread)this.leases.getThread(), (String)(this.getName() + ".leaseChecker"), (Thread.UncaughtExceptionHandler)this.uncaughtExceptionHandler);
        if (this.replicationSourceHandler == this.replicationSinkHandler && this.replicationSourceHandler != null) {
            this.replicationSourceHandler.startReplicationService();
        } else {
            if (this.replicationSourceHandler != null) {
                this.replicationSourceHandler.startReplicationService();
            }
            if (this.replicationSinkHandler != null) {
                this.replicationSinkHandler.startReplicationService();
            }
        }
        Configuration sinkConf = HBaseConfiguration.create((Configuration)this.conf);
        sinkConf.setInt("hbase.client.retries.number", this.conf.getInt("hbase.log.replay.retries.number", 8));
        sinkConf.setInt("hbase.rpc.timeout", this.conf.getInt("hbase.log.replay.rpc.timeout", 30000));
        sinkConf.setInt("hbase.client.serverside.retries.multiplier", 1);
        this.splitLogWorker = new SplitLogWorker(this, sinkConf, this, this, this.walFactory);
        this.splitLogWorker.start();
    }

    private int putUpWebUI() throws IOException {
        int port = this.conf.getInt("hbase.regionserver.info.port", 16030);
        String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
        if (this instanceof HMaster) {
            port = this.conf.getInt("hbase.master.info.port", 16010);
            addr = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
        }
        if (port < 0) {
            return port;
        }
        if (!Addressing.isLocalAddress((InetAddress)InetAddress.getByName(addr))) {
            String msg = "Failed to start http info server. Address " + addr + " does not belong to this host. Correct configuration parameter: " + "hbase.regionserver.info.bindAddress";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
        while (true) {
            try {
                this.infoServer = new InfoServer(this.getProcessName(), addr, port, false, this.conf);
                this.infoServer.addServlet("dump", "/dump", this.getDumpServlet());
                this.configureInfoServer();
                this.infoServer.start();
            }
            catch (BindException e) {
                if (!auto) {
                    LOG.error((Object)("Failed binding http info server to port: " + port));
                    throw e;
                }
                LOG.info((Object)("Failed binding http info server to port: " + port));
                ++port;
                continue;
            }
            break;
        }
        port = this.infoServer.getPort();
        this.conf.setInt("hbase.regionserver.info.port", port);
        int masterInfoPort = this.conf.getInt("hbase.master.info.port", 16010);
        this.conf.setInt("hbase.master.info.port.orig", masterInfoPort);
        this.conf.setInt("hbase.master.info.port", port);
        return port;
    }

    private boolean isHealthy() {
        if (!this.fsOk) {
            return false;
        }
        if (!(this.leases.isAlive() && this.cacheFlusher.isAlive() && this.walRoller.isAlive() && this.compactionChecker.isScheduled() && this.periodicFlusher.isScheduled())) {
            this.stop("One or more threads are no longer alive -- stop");
            return false;
        }
        LogRoller metawalRoller = this.metawalRoller.get();
        if (metawalRoller != null && !metawalRoller.isAlive()) {
            this.stop("Meta WAL roller thread is no longer alive -- stop");
            return false;
        }
        return true;
    }

    @Override
    public WAL getWAL(HRegionInfo regionInfo) throws IOException {
        WAL wal;
        LogRoller roller = this.walRoller;
        if (regionInfo != null && regionInfo.isMetaTable() && regionInfo.getReplicaId() == 0) {
            roller = this.ensureMetaWALRoller();
            wal = this.walFactory.getMetaWAL(regionInfo.getEncodedNameAsBytes());
        } else {
            wal = regionInfo == null ? this.walFactory.getWAL(UNSPECIFIED_REGION) : this.walFactory.getWAL(regionInfo.getEncodedNameAsBytes());
        }
        roller.addWAL(wal);
        return wal;
    }

    @Override
    public ClusterConnection getConnection() {
        return this.clusterConnection;
    }

    @Override
    public MetaTableLocator getMetaTableLocator() {
        return this.metaTableLocator;
    }

    public void stop(String msg) {
        if (!this.stopped) {
            try {
                if (this.rsHost != null) {
                    this.rsHost.preStop(msg);
                }
                this.stopped = true;
                LOG.info((Object)("STOPPED: " + msg));
                this.sleeper.skipSleepCycle();
            }
            catch (IOException exp) {
                LOG.warn((Object)"The region server did not stop", (Throwable)exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServerOnline() {
        while (!this.isStopped() && !this.isOnline()) {
            AtomicBoolean atomicBoolean = this.online;
            synchronized (atomicBoolean) {
                try {
                    this.online.wait(this.msgInterval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    @Override
    public void postOpenDeployTasks(Region r) throws KeeperException, IOException {
        this.postOpenDeployTasks(new RegionServerServices.PostOpenDeployContext(r, -1L));
    }

    @Override
    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws KeeperException, IOException {
        Region r = context.getRegion();
        long masterSystemTime = context.getMasterSystemTime();
        Preconditions.checkArgument((boolean)(r instanceof HRegion), (Object)"r must be an HRegion");
        this.rpcServices.checkOpen();
        LOG.info((Object)("Post open deploy tasks for " + r.getRegionInfo().getRegionNameAsString()));
        for (Store s : r.getStores()) {
            if (!s.hasReferences() && !s.needsCompaction()) continue;
            this.compactSplitThread.requestSystemCompaction(r, s, "Opening Region");
        }
        long openSeqNum = r.getOpenSeqNum();
        if (openSeqNum == -1L) {
            LOG.error((Object)("No sequence number found when opening " + r.getRegionInfo().getRegionNameAsString()));
            openSeqNum = 0L;
        }
        this.updateRecoveringRegionLastFlushedSequenceId(r);
        if (r.getRegionInfo().isMetaRegion()) {
            MetaTableLocator.setMetaLocation((ZooKeeperWatcher)this.getZooKeeper(), (ServerName)this.serverName, (int)r.getRegionInfo().getReplicaId(), (RegionState.State)RegionState.State.OPEN);
        } else if (this.useZKForAssignment) {
            MetaTableAccessor.updateRegionLocation((Connection)this.getConnection(), (HRegionInfo)r.getRegionInfo(), (ServerName)this.serverName, (long)openSeqNum, (long)masterSystemTime);
        }
        if (!this.useZKForAssignment && !this.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, openSeqNum, masterSystemTime, r.getRegionInfo()))) {
            throw new IOException("Failed to report opened region to master: " + r.getRegionInfo().getRegionNameAsString());
        }
        this.triggerFlushInPrimaryRegion((HRegion)r);
        LOG.debug((Object)("Finished post open deploy task for " + r.getRegionInfo().getRegionNameAsString()));
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo ... hris) {
        return this.reportRegionStateTransition(code, -1L, hris);
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
        return this.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(code, -1L, -1L, hris));
    }

    @Override
    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        RegionServerStatusProtos.RegionStateTransition.TransitionCode code = context.getCode();
        long openSeqNum = context.getOpenSeqNum();
        HRegionInfo[] hris = context.getHris();
        RegionServerStatusProtos.ReportRegionStateTransitionRequest.Builder builder = RegionServerStatusProtos.ReportRegionStateTransitionRequest.newBuilder();
        builder.setServer(ProtobufUtil.toServerName((ServerName)this.serverName));
        RegionServerStatusProtos.RegionStateTransition.Builder transition = builder.addTransitionBuilder();
        transition.setTransitionCode(code);
        if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED && openSeqNum >= 0L) {
            transition.setOpenSeqNum(openSeqNum);
        }
        for (HRegionInfo hri : hris) {
            transition.addRegionInfo(HRegionInfo.convert((HRegionInfo)hri));
        }
        RegionServerStatusProtos.ReportRegionStateTransitionRequest request = builder.build();
        while (this.keepLooping()) {
            RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
            try {
                if (rss == null) {
                    this.createRegionServerStatusStub();
                    continue;
                }
                RegionServerStatusProtos.ReportRegionStateTransitionResponse response = rss.reportRegionStateTransition(null, request);
                if (response.hasErrorMessage()) {
                    LOG.info((Object)("Failed to transition " + hris[0] + " to " + code + ": " + response.getErrorMessage()));
                    return false;
                }
                return true;
            }
            catch (ServiceException se) {
                IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
                LOG.info((Object)"Failed to report region transition, will retry", (Throwable)ioe);
                if (this.rssStub != rss) continue;
                this.rssStub = null;
            }
        }
        return false;
    }

    void triggerFlushInPrimaryRegion(HRegion region) {
        if (ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)region.getRegionInfo())) {
            return;
        }
        if (!ServerRegionReplicaUtil.isRegionReplicaReplicationEnabled(region.conf) || !ServerRegionReplicaUtil.isRegionReplicaWaitForPrimaryFlushEnabled(region.conf)) {
            region.setReadsEnabled(true);
            return;
        }
        region.setReadsEnabled(false);
        this.service.submit(new RegionReplicaFlushHandler(this, this.clusterConnection, this.rpcRetryingCallerFactory, this.rpcControllerFactory, this.operationTimeout, region));
    }

    @Override
    public RpcServerInterface getRpcServer() {
        return this.rpcServices.rpcServer;
    }

    @VisibleForTesting
    public RSRpcServices getRSRpcServices() {
        return this.rpcServices;
    }

    public void abort(String reason, Throwable cause) {
        String msg = "ABORTING region server " + this + ": " + reason;
        if (cause != null) {
            LOG.fatal((Object)msg, cause);
        } else {
            LOG.fatal((Object)msg);
        }
        this.abortRequested = true;
        LOG.fatal((Object)("RegionServer abort: loaded coprocessors are: " + CoprocessorHost.getLoadedCoprocessors()));
        try {
            LOG.info((Object)("Dump of metrics as JSON on abort: " + JSONBean.dumpRegionServerMetrics()));
        }
        catch (IOException | MalformedObjectNameException e) {
            LOG.warn((Object)"Failed dumping metrics", (Throwable)e);
        }
        try {
            if (cause != null) {
                msg = msg + "\nCause:\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)cause);
            }
            if (this.rssStub != null && this.serverName != null) {
                RegionServerStatusProtos.ReportRSFatalErrorRequest.Builder builder = RegionServerStatusProtos.ReportRSFatalErrorRequest.newBuilder();
                ServerName sn = ServerName.parseVersionedServerName((byte[])this.serverName.getVersionedBytes());
                builder.setServer(ProtobufUtil.toServerName((ServerName)sn));
                builder.setErrorMessage(msg);
                this.rssStub.reportRSFatalError(null, builder.build());
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)"Unable to report fatal error to master", t);
        }
        this.stop(reason);
    }

    public void abort(String reason) {
        this.abort(reason, null);
    }

    public boolean isAborted() {
        return this.abortRequested;
    }

    protected void kill() {
        this.killed = true;
        this.abort("Simulated kill");
    }

    protected void sendShutdownInterrupt() {
    }

    protected void stopServiceThreads() {
        LogRoller metawalRoller;
        if (this.choreService != null) {
            this.choreService.shutdown();
        }
        if (this.nonceManagerChore != null) {
            this.nonceManagerChore.cancel(true);
        }
        if (this.compactionChecker != null) {
            this.compactionChecker.cancel(true);
        }
        if (this.periodicFlusher != null) {
            this.periodicFlusher.cancel(true);
        }
        if (this.healthCheckChore != null) {
            this.healthCheckChore.cancel(true);
        }
        if (this.storefileRefresher != null) {
            this.storefileRefresher.cancel(true);
        }
        if (this.movedRegionsCleaner != null) {
            this.movedRegionsCleaner.cancel(true);
        }
        if (this.cacheFlusher != null) {
            this.cacheFlusher.join();
        }
        if (this.spanReceiverHost != null) {
            this.spanReceiverHost.closeReceivers();
        }
        if (this.walRoller != null) {
            Threads.shutdown((Thread)this.walRoller.getThread());
        }
        if ((metawalRoller = this.metawalRoller.get()) != null) {
            Threads.shutdown((Thread)metawalRoller.getThread());
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.join();
        }
        if (this.service != null) {
            this.service.shutdown();
        }
        if (this.replicationSourceHandler != null && this.replicationSourceHandler == this.replicationSinkHandler) {
            this.replicationSourceHandler.stopReplicationService();
        } else {
            if (this.replicationSourceHandler != null) {
                this.replicationSourceHandler.stopReplicationService();
            }
            if (this.replicationSinkHandler != null) {
                this.replicationSinkHandler.stopReplicationService();
            }
        }
    }

    ReplicationSourceService getReplicationSourceService() {
        return this.replicationSourceHandler;
    }

    ReplicationSinkService getReplicationSinkService() {
        return this.replicationSinkHandler;
    }

    @VisibleForTesting
    protected synchronized ServerName createRegionServerStatusStub() {
        return this.createRegionServerStatusStub(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected synchronized ServerName createRegionServerStatusStub(boolean refresh) {
        if (this.rssStub != null) {
            return this.masterAddressTracker.getMasterAddress();
        }
        ServerName sn = null;
        long previousLogTime = 0L;
        MasterRpcServices intf = null;
        boolean interrupted = false;
        try {
            while (this.keepLooping()) {
                sn = this.masterAddressTracker.getMasterAddress(refresh);
                if (sn == null) {
                    if (!this.keepLooping()) {
                        LOG.debug((Object)"No master found and cluster is stopped; bailing out");
                        ServerName serverName = null;
                        return serverName;
                    }
                    if (System.currentTimeMillis() > previousLogTime + 1000L) {
                        LOG.debug((Object)"No master found; retry");
                        previousLogTime = System.currentTimeMillis();
                    }
                    refresh = true;
                    if (!this.sleep(200L)) continue;
                    interrupted = true;
                    continue;
                }
                if (this instanceof HMaster && sn.equals((Object)this.getServerName())) {
                    intf = ((HMaster)this).getMasterRpcServices();
                    break;
                }
                try {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, this.userProvider.getCurrent(), this.shortOperationTimeout);
                    intf = RegionServerStatusProtos.RegionServerStatusService.newBlockingStub((BlockingRpcChannel)channel);
                    break;
                }
                catch (IOException e) {
                    if (System.currentTimeMillis() > previousLogTime + 1000L) {
                        IOException iOException = e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
                        if (e instanceof ServerNotRunningYetException) {
                            LOG.info((Object)"Master isn't available yet, retrying");
                        } else {
                            LOG.warn((Object)"Unable to connect to master. Retrying. Error was:", (Throwable)e);
                        }
                        previousLogTime = System.currentTimeMillis();
                    }
                    if (!this.sleep(200L)) continue;
                    interrupted = true;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.rssStub = intf;
        return sn;
    }

    private boolean keepLooping() {
        return !this.stopped && this.isClusterUp();
    }

    private RegionServerStatusProtos.RegionServerStartupResponse reportForDuty() throws IOException {
        ServerName masterServerName = this.createRegionServerStatusStub(true);
        if (masterServerName == null) {
            return null;
        }
        RegionServerStatusProtos.RegionServerStartupResponse result = null;
        try {
            this.rpcServices.requestCount.set(0L);
            LOG.info((Object)("reportForDuty to master=" + masterServerName + " with port=" + this.rpcServices.isa.getPort() + ", startcode=" + this.startcode));
            long now = EnvironmentEdgeManager.currentTime();
            int port = this.rpcServices.isa.getPort();
            RegionServerStatusProtos.RegionServerStartupRequest.Builder request = RegionServerStatusProtos.RegionServerStartupRequest.newBuilder();
            if (this.shouldUseThisHostnameInstead()) {
                request.setUseThisHostnameInstead(this.useThisHostnameInstead);
            }
            request.setPort(port);
            request.setServerStartCode(this.startcode);
            request.setServerCurrentTime(now);
            result = this.rssStub.regionServerStartup(null, request.build());
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException((ServiceException)se);
            if (ioe instanceof ClockOutOfSyncException) {
                LOG.fatal((Object)"Master rejected startup because clock is out of sync", (Throwable)ioe);
                throw ioe;
            }
            if (ioe instanceof ServerNotRunningYetException) {
                LOG.debug((Object)"Master is not running yet");
            } else {
                LOG.warn((Object)"error telling master we are up", (Throwable)se);
            }
            this.rssStub = null;
        }
        return result;
    }

    @Override
    public ClusterStatusProtos.RegionStoreSequenceIds getLastSequenceId(byte[] encodedRegionName) {
        try {
            RegionServerStatusProtos.GetLastFlushedSequenceIdRequest req = RequestConverter.buildGetLastFlushedSequenceIdRequest((byte[])encodedRegionName);
            RegionServerStatusProtos.RegionServerStatusService.BlockingInterface rss = this.rssStub;
            if (rss == null) {
                this.createRegionServerStatusStub();
                rss = this.rssStub;
                if (rss == null) {
                    LOG.warn((Object)"Unable to connect to the master to check the last flushed sequence id");
                    return ClusterStatusProtos.RegionStoreSequenceIds.newBuilder().setLastFlushedSequenceId(-1L).build();
                }
            }
            RegionServerStatusProtos.GetLastFlushedSequenceIdResponse resp = rss.getLastFlushedSequenceId(null, req);
            return ClusterStatusProtos.RegionStoreSequenceIds.newBuilder().setLastFlushedSequenceId(resp.getLastFlushedSequenceId()).addAllStoreSequenceId((Iterable)resp.getStoreLastFlushedSequenceIdList()).build();
        }
        catch (ServiceException e) {
            LOG.warn((Object)"Unable to connect to the master to check the last flushed sequence id", (Throwable)e);
            return ClusterStatusProtos.RegionStoreSequenceIds.newBuilder().setLastFlushedSequenceId(-1L).build();
        }
    }

    protected void closeAllRegions(boolean abort) {
        this.closeUserRegions(abort);
        this.closeMetaTableRegions(abort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeMetaTableRegions(boolean abort) {
        Region meta = null;
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Region> e : this.onlineRegions.entrySet()) {
                HRegionInfo hri = e.getValue().getRegionInfo();
                if (hri.isMetaRegion()) {
                    meta = e.getValue();
                }
                if (meta == null) continue;
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (meta != null) {
            this.closeRegionIgnoreErrors(meta.getRegionInfo(), abort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUserRegions(boolean abort) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, Region> e : this.onlineRegions.entrySet()) {
                Region r = e.getValue();
                if (r.getRegionInfo().isMetaTable() || !r.isAvailable()) continue;
                this.closeRegionIgnoreErrors(r.getRegionInfo(), abort);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public Map<String, Region> getRecoveringRegions() {
        return this.recoveringRegions;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.lock.writeLock();
    }

    public int getNumberOfOnlineRegions() {
        return this.onlineRegions.size();
    }

    boolean isOnlineRegionsEmpty() {
        return this.onlineRegions.isEmpty();
    }

    public Collection<Region> getOnlineRegionsLocalContext() {
        Collection<Region> regions = this.onlineRegions.values();
        return Collections.unmodifiableCollection(regions);
    }

    @Override
    public void addToOnlineRegions(Region region) {
        this.onlineRegions.put(region.getRegionInfo().getEncodedName(), region);
        this.configurationManager.registerObserver(region);
    }

    SortedMap<Long, Region> getCopyOfOnlineRegionsSortedBySize() {
        TreeMap<Long, Region> sortedRegions = new TreeMap<Long, Region>(new Comparator<Long>(){

            @Override
            public int compare(Long a, Long b) {
                return -1 * a.compareTo(b);
            }
        });
        for (Region region : this.onlineRegions.values()) {
            sortedRegions.put(region.getMemstoreSize(), region);
        }
        return sortedRegions;
    }

    public long getStartcode() {
        return this.startcode;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return this.cacheFlusher;
    }

    protected HRegionInfo[] getMostLoadedRegions() {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        for (Region r : this.onlineRegions.values()) {
            if (!r.isAvailable()) continue;
            if (regions.size() >= this.numRegionsToReport) break;
            regions.add(r.getRegionInfo());
        }
        return regions.toArray(new HRegionInfo[regions.size()]);
    }

    @Override
    public Leases getLeases() {
        return this.leases;
    }

    protected Path getRootDir() {
        return this.rootDir;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    public String toString() {
        return this.getServerName().toString();
    }

    public int getThreadWakeFrequency() {
        return this.threadWakeFrequency;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public BaseCoordinatedStateManager getCoordinatedStateManager() {
        return this.csm;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return this.compactSplitThread;
    }

    public RegionServerCoprocessorHost getRegionServerCoprocessorHost() {
        return this.rsHost;
    }

    @Override
    public ConcurrentMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return this.regionsInTransitionInRS;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.service;
    }

    @Override
    public ChoreService getChoreService() {
        return this.choreService;
    }

    @Override
    public RegionServerQuotaManager getRegionServerQuotaManager() {
        return this.rsQuotaManager;
    }

    private static void createNewReplicationInstance(Configuration conf, HRegionServer server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        String sinkClassname;
        if (!conf.getBoolean("hbase.replication", true)) {
            return;
        }
        String sourceClassname = conf.get("hbase.replication.source.service", "org.apache.hadoop.hbase.replication.regionserver.Replication");
        if (sourceClassname.equals(sinkClassname = conf.get("hbase.replication.sink.service", "org.apache.hadoop.hbase.replication.regionserver.Replication"))) {
            server.replicationSourceHandler = (ReplicationSourceService)HRegionServer.newReplicationInstance(sourceClassname, conf, server, fs, logDir, oldLogDir);
            server.replicationSinkHandler = (ReplicationSinkService)((Object)server.replicationSourceHandler);
        } else {
            server.replicationSourceHandler = (ReplicationSourceService)HRegionServer.newReplicationInstance(sourceClassname, conf, server, fs, logDir, oldLogDir);
            server.replicationSinkHandler = (ReplicationSinkService)HRegionServer.newReplicationInstance(sinkClassname, conf, server, fs, logDir, oldLogDir);
        }
    }

    private static ReplicationService newReplicationInstance(String classname, Configuration conf, HRegionServer server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(classname, true, classLoader);
        }
        catch (ClassNotFoundException nfe) {
            throw new IOException("Could not find class for " + classname);
        }
        ReplicationService service = (ReplicationService)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        service.initialize(server, fs, logDir, oldLogDir);
        return service;
    }

    public static HRegionServer constructRegionServer(Class<? extends HRegionServer> regionServerClass, Configuration conf2, CoordinatedStateManager cp) {
        try {
            Constructor<? extends HRegionServer> c = regionServerClass.getConstructor(Configuration.class, CoordinatedStateManager.class);
            return c.newInstance(conf2, cp);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Regionserver: " + regionServerClass.toString(), e);
        }
    }

    public static void main(String[] args) throws Exception {
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        Class regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        new HRegionServerCommandLine(regionServerClass).doMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Region> getOnlineRegions(TableName tableName) {
        ArrayList<Region> tableRegions = new ArrayList<Region>();
        Map<String, Region> map = this.onlineRegions;
        synchronized (map) {
            for (Region region : this.onlineRegions.values()) {
                HRegionInfo regionInfo = region.getRegionInfo();
                if (!regionInfo.getTable().equals((Object)tableName)) continue;
                tableRegions.add(region);
            }
        }
        return tableRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TableName> getOnlineTables() {
        HashSet<TableName> tables = new HashSet<TableName>();
        Map<String, Region> map = this.onlineRegions;
        synchronized (map) {
            for (Region region : this.onlineRegions.values()) {
                tables.add(region.getTableDesc().getTableName());
            }
        }
        return tables;
    }

    public String[] getRegionServerCoprocessors() {
        TreeSet<String> coprocessors = new TreeSet<String>();
        try {
            coprocessors.addAll(this.getWAL(null).getCoprocessorHost().getCoprocessors());
        }
        catch (IOException exception) {
            LOG.warn((Object)"Exception attempting to fetch wal coprocessor information for the common wal; skipping.");
            LOG.debug((Object)"Exception details for failure to fetch wal coprocessor information.", (Throwable)exception);
        }
        Collection<Region> regions = this.getOnlineRegionsLocalContext();
        for (Region region : regions) {
            coprocessors.addAll(region.getCoprocessorHost().getCoprocessors());
            try {
                coprocessors.addAll(this.getWAL(region.getRegionInfo()).getCoprocessorHost().getCoprocessors());
            }
            catch (IOException exception) {
                LOG.warn((Object)("Exception attempting to fetch wal coprocessor information for region " + region + "; skipping."));
                LOG.debug((Object)"Exception details for failure to fetch wal coprocessor information.", (Throwable)exception);
            }
        }
        return coprocessors.toArray(new String[coprocessors.size()]);
    }

    private void closeRegionIgnoreErrors(HRegionInfo region, boolean abort) {
        try {
            CloseRegionCoordination.CloseRegionDetails details = this.csm.getCloseRegionCoordination().getDetaultDetails();
            if (!this.closeRegion(region.getEncodedName(), abort, details, null)) {
                LOG.warn((Object)("Failed to close " + region.getRegionNameAsString() + " - ignoring and continuing"));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to close " + region.getRegionNameAsString() + " - ignoring and continuing"), (Throwable)e);
        }
    }

    protected boolean closeRegion(String encodedName, boolean abort, CloseRegionCoordination.CloseRegionDetails crd, ServerName sn) throws NotServingRegionException, RegionAlreadyInTransitionException {
        Boolean previous;
        Region actualRegion = this.getFromOnlineRegions(encodedName);
        if (actualRegion != null && actualRegion.getCoprocessorHost() != null) {
            try {
                actualRegion.getCoprocessorHost().preClose(false);
            }
            catch (IOException exp) {
                LOG.warn((Object)"Unable to close region: the coprocessor launched an error ", (Throwable)exp);
                return false;
            }
        }
        if (Boolean.TRUE.equals(previous = this.regionsInTransitionInRS.putIfAbsent(encodedName.getBytes(), Boolean.FALSE))) {
            LOG.info((Object)("Received CLOSE for the region:" + encodedName + " , which we are already " + "trying to OPEN. Cancelling OPENING."));
            if (!this.regionsInTransitionInRS.replace(encodedName.getBytes(), previous, Boolean.FALSE)) {
                LOG.warn((Object)("The opening for region " + encodedName + " was done before we could cancel it." + " Doing a standard close now"));
                return this.closeRegion(encodedName, abort, crd, sn);
            }
            actualRegion = this.getFromOnlineRegions(encodedName);
            if (actualRegion == null) {
                LOG.info((Object)"The opening previously in progress has been cancelled by a CLOSE request.");
                throw new RegionAlreadyInTransitionException("The region " + encodedName + " was opening but not yet served. Opening is cancelled.");
            }
        } else if (Boolean.FALSE.equals(previous)) {
            LOG.info((Object)("Received CLOSE for the region: " + encodedName + ", which we are already trying to CLOSE, but not completed yet"));
            throw new RegionAlreadyInTransitionException("The region " + encodedName + " was already closing. New CLOSE request is ignored.");
        }
        if (actualRegion == null) {
            LOG.error((Object)"Received CLOSE for a region which is not online, and we're not opening.");
            this.regionsInTransitionInRS.remove(encodedName.getBytes());
            throw new NotServingRegionException("The region " + encodedName + " is not online, and is not opening.");
        }
        HRegionInfo hri = actualRegion.getRegionInfo();
        CloseRegionHandler crh = hri.isMetaRegion() ? new CloseMetaHandler(this, this, hri, abort, this.csm.getCloseRegionCoordination(), crd) : new CloseRegionHandler((Server)this, (RegionServerServices)this, hri, abort, this.csm.getCloseRegionCoordination(), crd, sn);
        this.service.submit(crh);
        return true;
    }

    public Region getOnlineRegion(byte[] regionName) {
        String encodedRegionName = HRegionInfo.encodeRegionName((byte[])regionName);
        return this.onlineRegions.get(encodedRegionName);
    }

    public InetSocketAddress[] getRegionBlockLocations(String encodedRegionName) {
        return this.regionFavoredNodesMap.get(encodedRegionName);
    }

    @Override
    public Region getFromOnlineRegions(String encodedRegionName) {
        return this.onlineRegions.get(encodedRegionName);
    }

    @Override
    public boolean removeFromOnlineRegions(Region r, ServerName destination) {
        Region toReturn = this.onlineRegions.remove(r.getRegionInfo().getEncodedName());
        if (destination != null) {
            long closeSeqNum = r.getMaxFlushedSeqId();
            if (closeSeqNum == -1L && (closeSeqNum = r.getOpenSeqNum()) == -1L) {
                closeSeqNum = 0L;
            }
            this.addToMovedRegions(r.getRegionInfo().getEncodedName(), destination, closeSeqNum);
        }
        this.regionFavoredNodesMap.remove(r.getRegionInfo().getEncodedName());
        return toReturn != null;
    }

    protected Region getRegion(byte[] regionName) throws NotServingRegionException {
        String encodedRegionName = HRegionInfo.encodeRegionName((byte[])regionName);
        return this.getRegionByEncodedName(regionName, encodedRegionName);
    }

    public Region getRegionByEncodedName(String encodedRegionName) throws NotServingRegionException {
        return this.getRegionByEncodedName(null, encodedRegionName);
    }

    protected Region getRegionByEncodedName(byte[] regionName, String encodedRegionName) throws NotServingRegionException {
        Region region = this.onlineRegions.get(encodedRegionName);
        if (region == null) {
            String regionNameStr;
            MovedRegionInfo moveInfo = this.getMovedRegion(encodedRegionName);
            if (moveInfo != null) {
                throw new RegionMovedException(moveInfo.getServerName(), moveInfo.getSeqNum());
            }
            Boolean isOpening = (Boolean)this.regionsInTransitionInRS.get(Bytes.toBytes((String)encodedRegionName));
            String string = regionNameStr = regionName == null ? encodedRegionName : Bytes.toStringBinary((byte[])regionName);
            if (isOpening != null && isOpening.booleanValue()) {
                throw new RegionOpeningException("Region " + regionNameStr + " is opening on " + this.serverName);
            }
            throw new NotServingRegionException("Region " + regionNameStr + " is not online on " + this.serverName);
        }
        return region;
    }

    private Throwable cleanup(Throwable t, String msg) {
        if (t instanceof NotServingRegionException) {
            LOG.debug((Object)("NotServingRegionException; " + t.getMessage()));
            return t;
        }
        if (msg == null) {
            LOG.error((Object)"", RemoteExceptionHandler.checkThrowable((Throwable)t));
        } else {
            LOG.error((Object)msg, RemoteExceptionHandler.checkThrowable((Throwable)t));
        }
        if (!this.rpcServices.checkOOME(t)) {
            this.checkFileSystem();
        }
        return t;
    }

    protected IOException convertThrowableToIOE(Throwable t, String msg) {
        return t instanceof IOException ? (IOException)t : (msg == null || msg.length() == 0 ? new IOException(t) : new IOException(msg, t));
    }

    public boolean checkFileSystem() {
        if (this.fsOk && this.fs != null) {
            try {
                FSUtils.checkFileSystemAvailable((FileSystem)this.fs);
            }
            catch (IOException e) {
                this.abort("File System not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    @Override
    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
        InetSocketAddress[] addr = new InetSocketAddress[favoredNodes.size()];
        for (int i = 0; i < favoredNodes.size(); ++i) {
            addr[i] = InetSocketAddress.createUnresolved(favoredNodes.get(i).getHostName(), favoredNodes.get(i).getPort());
        }
        this.regionFavoredNodesMap.put(encodedRegionName, addr);
    }

    @Override
    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return this.regionFavoredNodesMap.get(encodedRegionName);
    }

    @Override
    public ServerNonceManager getNonceManager() {
        return this.nonceManager;
    }

    protected void addToMovedRegions(String encodedName, ServerName destination, long closeSeqNum) {
        if (ServerName.isSameHostnameAndPort((ServerName)destination, (ServerName)this.getServerName())) {
            LOG.warn((Object)("Not adding moved region record: " + encodedName + " to self."));
            return;
        }
        LOG.info((Object)("Adding moved region record: " + encodedName + " to " + destination + " as of " + closeSeqNum));
        this.movedRegions.put(encodedName, new MovedRegionInfo(destination, closeSeqNum));
    }

    void removeFromMovedRegions(String encodedName) {
        this.movedRegions.remove(encodedName);
    }

    private MovedRegionInfo getMovedRegion(String encodedRegionName) {
        MovedRegionInfo dest = this.movedRegions.get(encodedRegionName);
        long now = EnvironmentEdgeManager.currentTime();
        if (dest != null) {
            if (dest.getMoveTime() > now - 120000L) {
                return dest;
            }
            this.movedRegions.remove(encodedRegionName);
        }
        return null;
    }

    protected void cleanMovedRegions() {
        long cutOff = System.currentTimeMillis() - 120000L;
        Iterator<Map.Entry<String, MovedRegionInfo>> it = this.movedRegions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, MovedRegionInfo> e = it.next();
            if (e.getValue().getMoveTime() >= cutOff) continue;
            it.remove();
        }
    }

    protected int movedRegionCleanerPeriod() {
        return 120000;
    }

    private String getMyEphemeralNodePath() {
        return ZKUtil.joinZNode((String)this.zooKeeper.rsZNode, (String)this.getServerName().toString());
    }

    private boolean isHealthCheckerConfigured() {
        String healthScriptLocation = this.conf.get("hbase.node.health.script.location");
        return StringUtils.isNotBlank((String)healthScriptLocation);
    }

    public CompactSplitThread getCompactSplitThread() {
        return this.compactSplitThread;
    }

    private void updateRecoveringRegionLastFlushedSequenceId(Region r) throws KeeperException, IOException {
        if (!r.isRecovering()) {
            return;
        }
        HRegionInfo regionInfo = r.getRegionInfo();
        ZooKeeperWatcher zkw = this.getZooKeeper();
        String previousRSName = this.getLastFailedRSFromZK(regionInfo.getEncodedName());
        Map<byte[], Long> maxSeqIdInStores = r.getMaxStoreSeqId();
        long minSeqIdForLogReplay = -1L;
        for (Long storeSeqIdForReplay : maxSeqIdInStores.values()) {
            if (minSeqIdForLogReplay != -1L && storeSeqIdForReplay >= minSeqIdForLogReplay) continue;
            minSeqIdForLogReplay = storeSeqIdForReplay;
        }
        try {
            byte[] data;
            long lastRecordedFlushedSequenceId = -1L;
            String nodePath = ZKUtil.joinZNode((String)this.zooKeeper.recoveringRegionsZNode, (String)regionInfo.getEncodedName());
            try {
                data = ZKUtil.getData((ZooKeeperWatcher)zkw, (String)nodePath);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            if (data != null) {
                lastRecordedFlushedSequenceId = ZKSplitLog.parseLastFlushedSequenceIdFrom(data);
            }
            if (data == null || lastRecordedFlushedSequenceId < minSeqIdForLogReplay) {
                ZKUtil.setData((ZooKeeperWatcher)zkw, (String)nodePath, (byte[])ZKUtil.positionToByteArray((long)minSeqIdForLogReplay));
            }
            if (previousRSName != null) {
                nodePath = ZKUtil.joinZNode((String)nodePath, (String)previousRSName);
                ZKUtil.setData((ZooKeeperWatcher)zkw, (String)nodePath, (byte[])ZKUtil.regionSequenceIdsToByteArray((Long)minSeqIdForLogReplay, maxSeqIdInStores));
                LOG.debug((Object)("Update last flushed sequence id of region " + regionInfo.getEncodedName() + " for " + previousRSName));
            } else {
                LOG.warn((Object)("Can't find failed region server for recovering region " + regionInfo.getEncodedName()));
            }
        }
        catch (KeeperException.NoNodeException ignore) {
            LOG.debug((Object)("Region " + regionInfo.getEncodedName() + " must have completed recovery because its recovery znode has been removed"), (Throwable)ignore);
        }
    }

    private String getLastFailedRSFromZK(String encodedRegionName) throws KeeperException {
        String nodePath;
        String result = null;
        long maxZxid = 0L;
        ZooKeeperWatcher zkw = this.getZooKeeper();
        List failedServers = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)zkw, (String)(nodePath = ZKUtil.joinZNode((String)zkw.recoveringRegionsZNode, (String)encodedRegionName)));
        if (failedServers == null || failedServers.isEmpty()) {
            return result;
        }
        for (String failedServer : failedServers) {
            String rsPath = ZKUtil.joinZNode((String)nodePath, (String)failedServer);
            Stat stat = new Stat();
            ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)rsPath, (Stat)stat);
            if (maxZxid >= stat.getCzxid()) continue;
            maxZxid = stat.getCzxid();
            result = failedServer;
        }
        return result;
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest serviceRequest) throws ServiceException {
        try {
            ServerRpcController serviceController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = serviceRequest.getCall();
            String serviceName = call.getServiceName();
            String methodName = call.getMethodName();
            if (!this.coprocessorServiceHandlers.containsKey(serviceName)) {
                throw new UnknownProtocolException(null, "No registered coprocessor service found for name " + serviceName);
            }
            Service service = this.coprocessorServiceHandlers.get(serviceName);
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName);
            if (methodDesc == null) {
                throw new UnknownProtocolException(service.getClass(), "Unknown method " + methodName + " called on service " + serviceName);
            }
            Message.Builder builderForType = service.getRequestPrototype(methodDesc).newBuilderForType();
            ProtobufUtil.mergeFrom((Message.Builder)builderForType, (ByteString)call.getRequest());
            Message request = builderForType.build();
            final Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, (RpcController)serviceController, request, (RpcCallback)new RpcCallback<Message>(){

                public void run(Message message) {
                    if (message != null) {
                        responseBuilder.mergeFrom(message);
                    }
                }
            });
            IOException exception = ResponseConverter.getControllerException((RpcController)serviceController);
            if (exception != null) {
                throw exception;
            }
            Message execResult = responseBuilder.build();
            ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
            builder.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])HConstants.EMPTY_BYTE_ARRAY));
            builder.setValue(builder.getValueBuilder().setName(execResult.getClass().getName()).setValue(execResult.toByteString()));
            return builder.build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    protected ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public TableDescriptors getTableDescriptors() {
        return this.tableDescriptors;
    }

    public void updateConfiguration() {
        LOG.info((Object)"Reloading the configuration from disk.");
        this.conf.reloadConfiguration();
        this.configurationManager.notifyAllObservers(this.conf);
    }

    @Override
    public HeapMemoryManager getHeapMemoryManager() {
        return this.hMemManager;
    }

    @Override
    public double getCompactionPressure() {
        double max = 0.0;
        for (Region region : this.onlineRegions.values()) {
            for (Store store : region.getStores()) {
                double normCount = store.getCompactionPressure();
                if (!(normCount > max)) continue;
                max = normCount;
            }
        }
        return max;
    }

    @VisibleForTesting
    public boolean walRollRequestFinished() {
        return this.walRoller.walRollFinished();
    }

    protected static final class MovedRegionsCleaner
    extends ScheduledChore
    implements Stoppable {
        private HRegionServer regionServer;
        Stoppable stoppable;

        private MovedRegionsCleaner(HRegionServer regionServer, Stoppable stoppable) {
            super("MovedRegionsCleaner for region " + regionServer, stoppable, regionServer.movedRegionCleanerPeriod());
            this.regionServer = regionServer;
            this.stoppable = stoppable;
        }

        static MovedRegionsCleaner create(HRegionServer rs) {
            Stoppable stoppable = new Stoppable(){
                private volatile boolean isStopped = false;

                public void stop(String why) {
                    this.isStopped = true;
                }

                public boolean isStopped() {
                    return this.isStopped;
                }
            };
            return new MovedRegionsCleaner(rs, stoppable);
        }

        protected void chore() {
            this.regionServer.cleanMovedRegions();
        }

        public void stop(String why) {
            this.stoppable.stop(why);
        }

        public boolean isStopped() {
            return this.stoppable.isStopped();
        }
    }

    private static class MovedRegionInfo {
        private final ServerName serverName;
        private final long seqNum;
        private final long ts;

        public MovedRegionInfo(ServerName serverName, long closeSeqNum) {
            this.serverName = serverName;
            this.seqNum = closeSeqNum;
            this.ts = EnvironmentEdgeManager.currentTime();
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public long getSeqNum() {
            return this.seqNum;
        }

        public long getMoveTime() {
            return this.ts;
        }
    }

    static class PeriodicMemstoreFlusher
    extends ScheduledChore {
        final HRegionServer server;
        static final int RANGE_OF_DELAY = 300000;
        static final int MIN_DELAY_TIME = 0;

        public PeriodicMemstoreFlusher(int cacheFlushInterval, HRegionServer server) {
            super(server.getServerName() + "-MemstoreFlusherChore", (Stoppable)server, cacheFlushInterval);
            this.server = server;
        }

        protected void chore() {
            StringBuffer whyFlush = new StringBuffer();
            for (Region r : this.server.onlineRegions.values()) {
                FlushRequester requester;
                if (r == null || !((HRegion)r).shouldFlush(whyFlush) || (requester = this.server.getFlushRequester()) == null) continue;
                long randomDelay = RandomUtils.nextInt((int)300000) + 0;
                LOG.info((Object)(this.getName() + " requesting flush of " + r.getRegionInfo().getRegionNameAsString() + " because " + whyFlush.toString() + " after random delay " + randomDelay + "ms"));
                requester.requestDelayedFlush(r, randomDelay, false);
            }
        }
    }

    private static class CompactionChecker
    extends ScheduledChore {
        private final HRegionServer instance;
        private final int majorCompactPriority;
        private static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;
        private long iteration = 0L;

        CompactionChecker(HRegionServer h, int sleepTime, Stoppable stopper) {
            super("CompactionChecker", stopper, sleepTime);
            this.instance = h;
            LOG.info((Object)(this.getName() + " runs every " + org.apache.hadoop.util.StringUtils.formatTime((long)sleepTime)));
            this.majorCompactPriority = this.instance.conf.getInt("hbase.regionserver.compactionChecker.majorCompactPriority", Integer.MAX_VALUE);
        }

        protected void chore() {
            for (Region r : this.instance.onlineRegions.values()) {
                if (r == null) continue;
                for (Store s : r.getStores()) {
                    try {
                        long multiplier = s.getCompactionCheckMultiplier();
                        assert (multiplier > 0L);
                        if (this.iteration % multiplier != 0L) continue;
                        if (s.needsCompaction()) {
                            this.instance.compactSplitThread.requestSystemCompaction(r, s, this.getName() + " requests compaction");
                            continue;
                        }
                        if (!s.isMajorCompaction()) continue;
                        if (this.majorCompactPriority == Integer.MAX_VALUE || this.majorCompactPriority > ((HRegion)r).getCompactPriority()) {
                            this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests major compaction; use default priority", null);
                            continue;
                        }
                        this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests major compaction; use configured priority", this.majorCompactPriority, null, null);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed major compaction check on " + r), (Throwable)e);
                    }
                }
            }
            this.iteration = this.iteration == Long.MAX_VALUE ? 0L : this.iteration + 1L;
        }
    }
}

