/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authorize.ProxyServers;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
public class JspHelper {
    public static final String CURRENT_CONF = "current.conf";
    public static final String DELEGATION_PARAMETER_NAME = "delegation";
    public static final String NAMENODE_ADDRESS = "nnaddr";
    static final String SET_DELEGATION = "&delegation=";
    private static final Log LOG = LogFactory.getLog(JspHelper.class);

    private JspHelper() {
    }

    public static String canonicalize(String addr) {
        return NetUtils.createSocketAddr((String)addr, (int)1).getAddress().getCanonicalHostName();
    }

    public static DatanodeInfo bestNode(LocatedBlocks blks, Configuration conf) throws IOException {
        HashMap<DatanodeInfo, NodeRecord> map = new HashMap<DatanodeInfo, NodeRecord>();
        for (LocatedBlock block : blks.getLocatedBlocks()) {
            DatanodeInfo[] nodes;
            for (DatanodeInfo node : nodes = block.getLocations()) {
                NodeRecord record = (NodeRecord)map.get(node);
                if (record == null) {
                    map.put(node, new NodeRecord(node, 1));
                    continue;
                }
                ++record.frequency;
            }
        }
        DatanodeInfo[] nodes = map.values().toArray(new NodeRecord[map.size()]);
        Arrays.sort(nodes, new NodeRecordComparator());
        return JspHelper.bestNode(nodes, false);
    }

    public static DatanodeInfo bestNode(LocatedBlock blk, Configuration conf) throws IOException {
        DatanodeInfo[] nodes = blk.getLocations();
        return JspHelper.bestNode(nodes, true);
    }

    private static DatanodeInfo bestNode(DatanodeInfo[] nodes, boolean doRandom) throws IOException {
        int l;
        if (nodes == null || nodes.length == 0) {
            throw new IOException("No nodes contain this block");
        }
        for (l = 0; l < nodes.length && !nodes[l].isDecommissioned(); ++l) {
        }
        if (l == 0) {
            throw new IOException("No active nodes contain this block");
        }
        int index = doRandom ? DFSUtil.getRandom().nextInt(l) : 0;
        return nodes[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamBlockInAscii(InetSocketAddress addr, String poolId, long blockId, Token<BlockTokenIdentifier> blockToken, long genStamp, long blockSize, long offsetIntoBlock, long chunkSizeToView, JspWriter out, final Configuration conf, DFSClient.Conf dfsConf, final DataEncryptionKey encryptionKey) throws IOException {
        if (chunkSizeToView == 0L) {
            return;
        }
        int amtToRead = (int)Math.min(chunkSizeToView, blockSize - offsetIntoBlock);
        BlockReader blockReader = new BlockReaderFactory(dfsConf).setInetSocketAddress(addr).setBlock(new ExtendedBlock(poolId, blockId, 0L, genStamp)).setFileName(BlockReaderFactory.getFileName(addr, poolId, blockId)).setBlockToken(blockToken).setStartOffset(offsetIntoBlock).setLength(amtToRead).setVerifyChecksum(true).setClientName("JspHelper").setClientCacheContext(ClientContext.getFromConf(conf)).setDatanodeInfo(new DatanodeInfo(new DatanodeID(addr.getAddress().getHostAddress(), addr.getHostName(), poolId, addr.getPort(), 0, 0, 0))).setCachingStrategy(CachingStrategy.newDefaultStrategy()).setConfiguration(conf).setRemotePeerFactory(new RemotePeerFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Peer newConnectedPeer(InetSocketAddress addr) throws IOException {
                Peer peer = null;
                Socket sock = NetUtils.getDefaultSocketFactory((Configuration)conf).createSocket();
                try {
                    sock.connect(addr, 60000);
                    sock.setSoTimeout(60000);
                    peer = TcpPeerServer.peerFromSocketAndKey(sock, encryptionKey);
                }
                finally {
                    if (peer == null) {
                        IOUtils.closeSocket((Socket)sock);
                    }
                }
                return peer;
            }
        }).build();
        byte[] buf = new byte[amtToRead];
        try {
            int readOffset = 0;
            int retries = 2;
            while (amtToRead > 0) {
                int numRead = amtToRead;
                try {
                    blockReader.readFully(buf, readOffset, amtToRead);
                }
                catch (IOException e) {
                    if (--retries != 0) continue;
                    throw new IOException("Could not read data from datanode");
                }
                amtToRead -= numRead;
                readOffset += numRead;
            }
        }
        finally {
            blockReader.close();
        }
        out.print(HtmlQuoting.quoteHtmlChars((String)new String(buf, Charsets.UTF_8)));
    }

    public static void addTableHeader(JspWriter out) throws IOException {
        out.print("<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\">");
        out.print("<tbody>");
    }

    public static void addTableRow(JspWriter out, String[] columns) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            out.print("<td style=\"vertical-align: top;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public static void addTableRow(JspWriter out, String[] columns, int row) throws IOException {
        out.print("<tr>");
        for (int i = 0; i < columns.length; ++i) {
            if (row / 2 * 2 == row) {
                out.print("<td style=\"vertical-align: top;background-color:LightGrey;\"><B>" + columns[i] + "</B><br></td>");
                continue;
            }
            out.print("<td style=\"vertical-align: top;background-color:LightBlue;\"><B>" + columns[i] + "</B><br></td>");
        }
        out.print("</tr>");
    }

    public static void addTableFooter(JspWriter out) throws IOException {
        out.print("</tbody></table>");
    }

    public static void sortNodeList(List<DatanodeDescriptor> nodes, String field, String order) {
        class NodeComapare
        implements Comparator<DatanodeDescriptor> {
            static final int FIELD_NAME = 1;
            static final int FIELD_LAST_CONTACT = 2;
            static final int FIELD_BLOCKS = 3;
            static final int FIELD_CAPACITY = 4;
            static final int FIELD_USED = 5;
            static final int FIELD_PERCENT_USED = 6;
            static final int FIELD_NONDFS_USED = 7;
            static final int FIELD_REMAINING = 8;
            static final int FIELD_PERCENT_REMAINING = 9;
            static final int FIELD_ADMIN_STATE = 10;
            static final int FIELD_DECOMMISSIONED = 11;
            static final int SORT_ORDER_ASC = 1;
            static final int SORT_ORDER_DSC = 2;
            int sortField = 1;
            int sortOrder = 1;

            public NodeComapare(String field, String order) {
                this.sortField = field.equals("lastcontact") ? 2 : (field.equals("capacity") ? 4 : (field.equals("used") ? 5 : (field.equals("nondfsused") ? 7 : (field.equals("remaining") ? 8 : (field.equals("pcused") ? 6 : (field.equals("pcremaining") ? 9 : (field.equals("blocks") ? 3 : (field.equals("adminstate") ? 10 : (field.equals("decommissioned") ? 11 : 1)))))))));
                this.sortOrder = order.equals("DSC") ? 2 : 1;
            }

            @Override
            public int compare(DatanodeDescriptor d1, DatanodeDescriptor d2) {
                int ret = 0;
                switch (this.sortField) {
                    case 2: {
                        ret = (int)(d2.getLastUpdate() - d1.getLastUpdate());
                        break;
                    }
                    case 4: {
                        long dlong = d1.getCapacity() - d2.getCapacity();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 5: {
                        long dlong = d1.getDfsUsed() - d2.getDfsUsed();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 7: {
                        long dlong = d1.getNonDfsUsed() - d2.getNonDfsUsed();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 8: {
                        long dlong = d1.getRemaining() - d2.getRemaining();
                        ret = dlong < 0L ? -1 : (dlong > 0L ? 1 : 0);
                        break;
                    }
                    case 6: {
                        double ddbl = d1.getDfsUsedPercent() - d2.getDfsUsedPercent();
                        ret = ddbl < 0.0 ? -1 : (ddbl > 0.0 ? 1 : 0);
                        break;
                    }
                    case 9: {
                        double ddbl = d1.getRemainingPercent() - d2.getRemainingPercent();
                        ret = ddbl < 0.0 ? -1 : (ddbl > 0.0 ? 1 : 0);
                        break;
                    }
                    case 3: {
                        ret = d1.numBlocks() - d2.numBlocks();
                        break;
                    }
                    case 10: {
                        ret = d1.getAdminState().toString().compareTo(d2.getAdminState().toString());
                        break;
                    }
                    case 11: {
                        ret = DFSUtil.DECOM_COMPARATOR.compare(d1, d2);
                        break;
                    }
                    case 1: {
                        ret = d1.getHostName().compareTo(d2.getHostName());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid sortField");
                    }
                }
                return this.sortOrder == 2 ? -ret : ret;
            }
        }
        Collections.sort(nodes, new NodeComapare(field, order));
    }

    public static void printPathWithLinks(String dir, JspWriter out, int namenodeInfoPort, String tokenString, String nnAddress) throws IOException {
        try {
            String[] parts = dir.split("/");
            StringBuilder tempPath = new StringBuilder(dir.length());
            out.print("<a href=\"browseDirectory.jsp?dir=/&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam(NAMENODE_ADDRESS, nnAddress) + "\">" + "/" + "</a>");
            tempPath.append("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                if (parts[i].equals("")) continue;
                tempPath.append(parts[i]);
                out.print("<a href=\"browseDirectory.jsp?dir=" + HtmlQuoting.quoteHtmlChars((String)tempPath.toString()) + "&namenodeInfoPort=" + namenodeInfoPort + JspHelper.getDelegationTokenUrlParam(tokenString) + JspHelper.getUrlParam(NAMENODE_ADDRESS, nnAddress));
                out.print("\">" + HtmlQuoting.quoteHtmlChars((String)parts[i]) + "</a>" + "/");
                tempPath.append("/");
            }
            if (parts.length > 0) {
                out.print(HtmlQuoting.quoteHtmlChars((String)parts[parts.length - 1]));
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    public static void printGotoForm(JspWriter out, int namenodeInfoPort, String tokenString, String file, String nnAddress) throws IOException {
        out.print("<form action=\"browseDirectory.jsp\" method=\"get\" name=\"goto\">");
        out.print("Goto : ");
        out.print("<input name=\"dir\" type=\"text\" width=\"50\" id=\"dir\" value=\"" + HtmlQuoting.quoteHtmlChars((String)file) + "\"/>");
        out.print("<input name=\"go\" type=\"submit\" value=\"go\"/>");
        out.print("<input name=\"namenodeInfoPort\" type=\"hidden\" value=\"" + namenodeInfoPort + "\"/>");
        if (UserGroupInformation.isSecurityEnabled()) {
            out.print("<input name=\"delegation\" type=\"hidden\" value=\"" + tokenString + "\"/>");
        }
        out.print("<input name=\"nnaddr\" type=\"hidden\" value=\"" + nnAddress + "\"/>");
        out.print("</form>");
    }

    public static void createTitle(JspWriter out, HttpServletRequest req, String file) throws IOException {
        int start;
        if (file == null) {
            file = "";
        }
        if ((start = Math.max(0, file.length() - 100)) != 0) {
            file = "..." + file.substring(start, file.length());
        }
        out.print("<title>HDFS:" + file + "</title>");
    }

    public static int string2ChunkSizeToView(String s, int defaultValue) {
        int n = s == null ? 0 : Integer.parseInt(s);
        return n > 0 ? n : defaultValue;
    }

    public static String getVersionTable() {
        return "<div class='dfstable'><table>\n  <tr><td class='col1'>Version:</td><td>" + VersionInfo.getVersion() + ", " + VersionInfo.getRevision() + "</td></tr>" + "\n  <tr><td class='col1'>Compiled:</td><td>" + VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch() + "</td></tr>" + "\n</table></div>";
    }

    public static String validatePath(String p) {
        return p == null || p.length() == 0 ? null : new Path(p).toUri().getPath();
    }

    public static Long validateLong(String value) {
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public static String validateURL(String value) {
        try {
            return URLEncoder.encode(new URL(value).toString(), "UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    public static UserGroupInformation getDefaultWebUser(Configuration conf) throws IOException {
        return UserGroupInformation.createRemoteUser((String)JspHelper.getDefaultWebUserName(conf));
    }

    private static String getDefaultWebUserName(Configuration conf) throws IOException {
        String user = conf.get("hadoop.http.staticuser.user", "dr.who");
        if (user == null || user.length() == 0) {
            throw new IOException("Cannot determine UGI from request or conf");
        }
        return user;
    }

    private static InetSocketAddress getNNServiceAddress(ServletContext context, HttpServletRequest request) {
        String namenodeAddressInUrl = request.getParameter(NAMENODE_ADDRESS);
        InetSocketAddress namenodeAddress = null;
        if (namenodeAddressInUrl != null) {
            namenodeAddress = NetUtils.createSocketAddr((String)namenodeAddressInUrl);
        } else if (context != null) {
            namenodeAddress = NameNodeHttpServer.getNameNodeAddressFromContext(context);
        }
        if (namenodeAddress != null) {
            return namenodeAddress;
        }
        return null;
    }

    public static UserGroupInformation getUGI(HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(null, request, conf);
    }

    public static UserGroupInformation getUGI(ServletContext context, HttpServletRequest request, Configuration conf) throws IOException {
        return JspHelper.getUGI(context, request, conf, UserGroupInformation.AuthenticationMethod.KERBEROS_SSL, true);
    }

    public static UserGroupInformation getUGI(ServletContext context, HttpServletRequest request, Configuration conf, UserGroupInformation.AuthenticationMethod secureAuthMethod, boolean tryUgiParameter) throws IOException {
        String remoteUser;
        UserGroupInformation ugi = null;
        String usernameFromQuery = JspHelper.getUsernameFromQuery(request, tryUgiParameter);
        String doAsUserFromQuery = request.getParameter("doas");
        if (UserGroupInformation.isSecurityEnabled()) {
            remoteUser = request.getRemoteUser();
            String tokenString = request.getParameter(DELEGATION_PARAMETER_NAME);
            if (tokenString != null) {
                ugi = JspHelper.getTokenUGI(context, request, tokenString, conf);
                JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
                JspHelper.checkUsername(ugi.getShortUserName(), doAsUserFromQuery);
            } else if (remoteUser == null) {
                throw new IOException("Security enabled but user not authenticated by filter");
            }
        } else {
            String string = remoteUser = usernameFromQuery == null ? JspHelper.getDefaultWebUserName(conf) : usernameFromQuery;
        }
        if (ugi == null) {
            ugi = UserGroupInformation.createRemoteUser((String)remoteUser);
            JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
            if (UserGroupInformation.isSecurityEnabled()) {
                ugi.setAuthenticationMethod(secureAuthMethod);
            }
            if (doAsUserFromQuery != null) {
                ugi = UserGroupInformation.createProxyUser((String)doAsUserFromQuery, (UserGroupInformation)ugi);
                ProxyUsers.authorize((UserGroupInformation)ugi, (String)JspHelper.getRemoteAddr(request));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getUGI is returning: " + ugi.getShortUserName()));
        }
        return ugi;
    }

    private static UserGroupInformation getTokenUGI(ServletContext context, HttpServletRequest request, String tokenString, Configuration conf) throws IOException {
        NameNode nn;
        Token token = new Token();
        token.decodeFromUrlString(tokenString);
        InetSocketAddress serviceAddress = JspHelper.getNNServiceAddress(context, request);
        if (serviceAddress != null) {
            SecurityUtil.setTokenService((Token)token, (InetSocketAddress)serviceAddress);
            token.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        id.readFields(in);
        if (context != null && (nn = NameNodeHttpServer.getNameNodeFromContext(context)) != null) {
            nn.getNamesystem().verifyToken(id, token.getPassword());
        }
        UserGroupInformation ugi = id.getUser();
        ugi.addToken(token);
        return ugi;
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String clientAddr;
        String remoteAddr = request.getRemoteAddr();
        String proxyHeader = request.getHeader("X-Forwarded-For");
        if (proxyHeader != null && ProxyServers.isProxyServer((String)remoteAddr) && !(clientAddr = proxyHeader.split(",")[0].trim()).isEmpty()) {
            remoteAddr = clientAddr;
        }
        return remoteAddr;
    }

    private static void checkUsername(String expected, String name) throws IOException {
        if (expected == null && name != null) {
            throw new IOException("Usernames not matched: expecting null but name=" + name);
        }
        if (name == null) {
            return;
        }
        KerberosName u = new KerberosName(name);
        String shortName = u.getShortName();
        if (!shortName.equals(expected)) {
            throw new IOException("Usernames not matched: name=" + shortName + " != expected=" + expected);
        }
    }

    private static String getUsernameFromQuery(HttpServletRequest request, boolean tryUgiParameter) {
        String ugiStr;
        String username = request.getParameter("user.name");
        if (username == null && tryUgiParameter && (ugiStr = request.getParameter("ugi")) != null) {
            username = ugiStr.split(",")[0];
        }
        return username;
    }

    public static String getDelegationTokenUrlParam(String tokenString) {
        if (tokenString == null) {
            return "";
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            return SET_DELEGATION + tokenString;
        }
        return "";
    }

    public static String getUrlParam(String name, String val, String paramSeparator) {
        return val == null ? "" : paramSeparator + name + "=" + val;
    }

    public static String getUrlParam(String name, String val, boolean firstParam) {
        return JspHelper.getUrlParam(name, val, firstParam ? "?" : "&");
    }

    public static String getUrlParam(String name, String val) {
        return JspHelper.getUrlParam(name, val, false);
    }

    public static final class Url {
        public static String authority(String scheme, DatanodeID d) {
            String fqdn;
            String string = fqdn = d.getIpAddr() != null && !d.getIpAddr().isEmpty() ? JspHelper.canonicalize(d.getIpAddr()) : d.getHostName();
            if (scheme.equals("http")) {
                return fqdn + ":" + d.getInfoPort();
            }
            if (scheme.equals("https")) {
                return fqdn + ":" + d.getInfoSecurePort();
            }
            throw new IllegalArgumentException("Unknown scheme:" + scheme);
        }

        public static String url(String scheme, DatanodeID d) {
            return scheme + "://" + Url.authority(scheme, d);
        }
    }

    private static class NodeRecordComparator
    implements Comparator<NodeRecord> {
        private NodeRecordComparator() {
        }

        @Override
        public int compare(NodeRecord o1, NodeRecord o2) {
            if (o1.frequency < o2.frequency) {
                return -1;
            }
            if (o1.frequency > o2.frequency) {
                return 1;
            }
            return 0;
        }
    }

    private static class NodeRecord
    extends DatanodeInfo {
        int frequency;

        public NodeRecord(DatanodeInfo info, int count) {
            super(info);
            this.frequency = count;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

